/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Transport;

import com.MT.triggersUtility.ChatInput;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Transport.LogisticBot;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class RequesterChest
extends Device {
    private int channel = 0;
    private static final long serialVersionUID = -3129401797254451315L;
    private transient HashMap<ItemStack, Integer> requests = new HashMap();
    private transient HashMap<LogisticBot, ItemStack> incoming = new HashMap();

    public RequesterChest(Location loc) {
        super(loc);
        this.setMaterial("CHEST");
        this.deviceName = "Requester Chest";
        this.setActionTimer(1);
        this.setActionPower(0);
        this.setIdlePower(3);
        this.setOpenable(true);
        this.setGridRange(0);
        this.setUseUI(true);
        this.useAutoSlots();
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- This device can request items from the logistic network.");
        return lore;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
    }

    @Override
    public void onUIClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.getSlot() == 13) {
            class ChatInput
            extends com.MT.triggersUtility.ChatInput {
                private final /* synthetic */ Player val$player;

                public ChatInput(String startMessage, boolean numbersonly, Player player) {
                    this.val$player = player;
                    super(startMessage, numbersonly);
                }

                @Override
                public void inputAction(String message) {
                    RequesterChest.this.setChannel(Integer.valueOf(message));
                    RequesterChest.this.updateUI();
                    this.val$player.openInventory(RequesterChest.this.getInventory());
                }
            }
            ChatInput input = new ChatInput("Enter the new channel number in chat now!", true, player);
            input.start(player);
            player.closeInventory();
            player.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        }
    }

    @Override
    public void postCreate(boolean isFirstTime) {
        this.requests = new HashMap();
        this.incoming = new HashMap();
    }

    @Override
    public void action() {
        this.buildRequests();
    }

    public void buildRequests() {
        this.requests.clear();
        HashMap<ItemStack, Integer> inputTotaled = RequesterChest.getTotalItems(this.getInputItems());
        for (ItemStack input : new ArrayList<ItemStack>(inputTotaled.keySet())) {
            int neededAmount = inputTotaled.get(input);
            int outCount = this.outCount(input);
            if ((neededAmount -= outCount) > 0) {
                for (LogisticBot bot : new ArrayList<LogisticBot>(this.incoming.keySet())) {
                    if (!this.incoming.get(bot).isSimilar(input)) continue;
                    neededAmount -= this.incoming.get(bot).getAmount();
                }
                if (neededAmount <= 0) continue;
                this.requests.put(input, neededAmount);
                continue;
            }
            this.requests.remove(input);
        }
    }

    private int outCount(ItemStack stack) {
        int count = 0;
        for (ItemStack output : this.getOutputItems()) {
            if (!stack.isSimilar(output)) continue;
            count += output.getAmount();
        }
        return count;
    }

    public void addIncomingItem(LogisticBot bot, ItemStack incoming) {
        this.incoming.put(bot, incoming);
        this.updateRequest(this.incoming.get(bot).clone());
    }

    public void removeIncomingItem(LogisticBot bot, boolean delivered) {
        if (delivered) {
            this.updateRequest(this.incoming.get(bot).clone());
        }
        this.incoming.remove(bot);
    }

    private void updateRequest(ItemStack stack) {
        int amount = stack.getAmount();
        stack.setAmount(1);
        if (this.requests.containsKey(stack)) {
            this.requests.put(stack, this.requests.get(stack) - amount);
            if (this.requests.get(stack) <= 0) {
                this.requests.remove(stack);
            }
        }
    }

    public HashMap<ItemStack, Integer> getOpenRequests() {
        return this.requests;
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.BLUE_DYE, 1.0);
    }

    public static void addRecipe() {
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(MineItems.getIndustrialItem("Advanced Circuit"));
        ings.add(new ItemStack(Material.CHEST));
        RecipeUtils.addDefaultRecipe(new RequesterChest(null).getDeviceStack(), ings, MTRecipe.RecipeType.ADVANCED, true);
    }

    public static HashMap<ItemStack, Integer> getTotalItems(ArrayList<ItemStack> itemStacks) {
        HashMap<ItemStack, Integer> itemMap = new HashMap<ItemStack, Integer>();
        for (ItemStack itemStack : itemStacks) {
            boolean found = false;
            for (Map.Entry<ItemStack, Integer> entry : itemMap.entrySet()) {
                if (!entry.getKey().isSimilar(itemStack)) continue;
                itemMap.put(entry.getKey(), entry.getValue() + itemStack.getAmount());
                found = true;
                break;
            }
            if (found) continue;
            ItemStack keyStack = itemStack.clone();
            keyStack.setAmount(1);
            itemMap.put(keyStack, itemStack.getAmount());
        }
        return itemMap;
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int channel) {
        this.channel = channel;
    }
}

