/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Transport;

import com.MT.triggersUtility.ChatInput;
import com.MT.triggersUtility.TUItems;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Transport.LogisticBot;
import com.MT.xxxtrigger50xxx.Devices.Transport.ProviderChest;
import com.MT.xxxtrigger50xxx.Devices.Transport.RequesterChest;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class Roboport
extends Device {
    private static final long serialVersionUID = -3129401797212251315L;
    private int channel = 0;
    private transient int usedDrones = 0;

    public Roboport(Location loc) {
        super(loc);
        this.setMaterial("FLETCHING_TABLE");
        this.deviceName = "Roboport";
        this.setActionTimer(1);
        this.setActionPower(0);
        this.setIdlePower(3);
        this.setOpenable(true);
        this.setGridRange(0);
        this.setUseUI(true);
        this.useAutoSlots();
    }

    @Override
    public int getGridScore() {
        return 5;
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- This device supplies logistic bots to the network.");
        lore.add("- These bots can move items around the network.");
        return lore;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
    }

    @Override
    public ArrayList<String> extraInfoLore() {
        ArrayList<String> lore = TUItems.basicLore(MineUtil.colon(" Channel", "" + this.getChannel()));
        lore.add(" ");
        lore.addAll(MineUtil.wrapText("Roboports will only use provider chests and requester chests on the same power grid if they have the same channel number!", 45, ChatColor.WHITE, 1));
        lore.add(" ");
        lore.add(String.valueOf(ChatColor.YELLOW) + "  -> Click to change channel");
        return lore;
    }

    @Override
    public void onUIClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.getSlot() == 13) {
            class ChatInput
            extends com.MT.triggersUtility.ChatInput {
                private final /* synthetic */ Player val$player;

                public ChatInput(String startMessage, boolean numbersonly, Player player) {
                    this.val$player = player;
                    super(startMessage, numbersonly);
                }

                @Override
                public void inputAction(String message) {
                    Roboport.this.setChannel(Integer.valueOf(message));
                    Roboport.this.updateUI();
                    this.val$player.openInventory(Roboport.this.getInventory());
                }
            }
            ChatInput input = new ChatInput("Enter the new channel number in chat now!", true, player);
            input.start(player);
            player.closeInventory();
            player.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        }
    }

    public void dockDrone() {
        --this.usedDrones;
    }

    @Override
    public void action() {
        if (this.getGrid() != null) {
            int storedDrones = this.getDrones() - this.usedDrones;
            if (storedDrones <= 0) {
                return;
            }
            for (RequesterChest rc : this.getGrid().getRequesterChests()) {
                HashMap<ItemStack, Integer> requests;
                if (rc.getChannel() != this.getChannel() || (requests = rc.getOpenRequests()).size() <= 0) continue;
                for (ItemStack requestStack : new ArrayList<ItemStack>(requests.keySet())) {
                    int amountNeeded = requests.get(requestStack);
                    for (ProviderChest pc : this.getGrid().getProviderChests()) {
                        if (pc.getChannel() != this.getChannel()) continue;
                        if (storedDrones <= 0) {
                            return;
                        }
                        if (pc.getOutputSlot() == -1) continue;
                        ArrayList<ItemStack> simStacks = pc.getStoredStacks(requestStack);
                        ItemStack reserveStack = requestStack.clone();
                        reserveStack.setAmount(0);
                        for (ItemStack stored : simStacks) {
                            if (stored.getAmount() >= amountNeeded) {
                                reserveStack.setAmount(reserveStack.getAmount() + amountNeeded);
                                amountNeeded = 0;
                                break;
                            }
                            amountNeeded -= stored.getAmount();
                            reserveStack.setAmount(reserveStack.getAmount() + stored.getAmount());
                        }
                        if (reserveStack.getAmount() > 0) {
                            int targetSlot = pc.getOutputSlot();
                            if (reserveStack.getAmount() > 8) {
                                reserveStack.setAmount(8);
                            }
                            pc.getInventory().setItem(targetSlot, reserveStack);
                            pc.removeInputAmount(reserveStack.clone());
                            LogisticBot bot = new LogisticBot(this);
                            rc.addIncomingItem(bot, reserveStack);
                            bot.giveLogisticMoveOrder(rc, pc, targetSlot, reserveStack);
                            --storedDrones;
                            ++this.usedDrones;
                        }
                        if (amountNeeded > 0) continue;
                        return;
                    }
                }
            }
        }
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.GREEN_DYE, 1.0);
    }

    public static void addRecipe() {
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(MineItems.getIndustrialItem("Advanced Circuit", 3));
        ings.add(new ItemStack(Material.CHEST));
        RecipeUtils.addDefaultRecipe(new Roboport(null).getDeviceStack(), ings, MTRecipe.RecipeType.ADVANCED, true);
    }

    public int getDrones() {
        int count = 0;
        ItemStack drone = MineItems.getIndustrialItem("Logistic Robot");
        for (ItemStack stack : this.getInputItems()) {
            if (!drone.isSimilar(stack)) continue;
            count += stack.getAmount();
        }
        return count;
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int channel) {
        this.channel = channel;
    }
}

