/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Transport;

import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Transport.TrainStation;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class StationFinder {
    private static final Set<Material> RAIL_MATERIALS = new HashSet<Material>();
    private static final BlockFace[] ADJACENT_FACES;

    static {
        RAIL_MATERIALS.add(Material.RAIL);
        RAIL_MATERIALS.add(Material.POWERED_RAIL);
        RAIL_MATERIALS.add(Material.DETECTOR_RAIL);
        RAIL_MATERIALS.add(Material.CARTOGRAPHY_TABLE);
        ADJACENT_FACES = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};
    }

    public Set<TrainStation> findConnectedCartographyTables(Location startLocation) {
        HashSet<TrainStation> connectedCartographyTables = new HashSet<TrainStation>();
        HashSet<Location> visited = new HashSet<Location>();
        this.dfs(startLocation, connectedCartographyTables, visited);
        return connectedCartographyTables;
    }

    private void dfs(Location location, Set<TrainStation> connectedCartographyTables, Set<Location> visited) {
        if (visited.contains(location)) {
            return;
        }
        visited.add(location);
        Block block = location.getBlock();
        Device device = Device.getDevice(block.getLocation());
        if (device != null && device instanceof TrainStation) {
            connectedCartographyTables.add((TrainStation)device);
        }
        BlockFace[] blockFaceArray = ADJACENT_FACES;
        int n = ADJACENT_FACES.length;
        int n2 = 0;
        while (n2 < n) {
            BlockFace face = blockFaceArray[n2];
            Block adjacentBlock = block.getRelative(face);
            if (!RAIL_MATERIALS.contains(adjacentBlock.getType())) {
                adjacentBlock = adjacentBlock.getRelative(BlockFace.UP);
            }
            if (!RAIL_MATERIALS.contains(adjacentBlock.getType())) {
                adjacentBlock = adjacentBlock.getRelative(0, -2, 0);
            }
            if (RAIL_MATERIALS.contains(adjacentBlock.getType())) {
                Location adjacentLocation = adjacentBlock.getLocation();
                this.dfs(adjacentLocation, connectedCartographyTables, visited);
            }
            ++n2;
        }
    }
}

