/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices;

import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Enemy;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.util.Vector;

public class Turret
extends Device {
    private static final long serialVersionUID = 7571974070728037027L;
    private Material turretMat = Material.BOW;
    public int cooldown = 3;
    public int cooldownTimer = 0;
    public int range = 16;
    private transient Item item = null;

    public Turret(Location loc) {
        super(loc);
        this.setMaterial("BLACKSTONE_SLAB");
        this.deviceName = "Turret";
        this.setActionTimer(1);
        this.setGridRange(0);
        this.setUseUI(true);
        this.setRefreshInv(false);
        this.setIdlePower(1);
        this.useAutoSlots();
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        return lore;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, this.turretMat, 0.5);
    }

    @Override
    public void cleanup() {
        if (this.item != null) {
            this.item.remove();
        }
    }

    @Override
    public void action() {
        if (this.getGrid() == null) {
            return;
        }
        if (this.isPowered()) {
            if (this.getActionPower() > 0 && !this.getGrid().hasPower(this.getActionPower())) {
                this.setFailReason("Not enough power to shoot.");
                return;
            }
            if (this.cooldownTimer > 0) {
                --this.cooldownTimer;
                this.setFailReason("On cooldown");
                return;
            }
            if (!this.hasAmmo()) {
                this.setFailReason("Missing ammo");
                return;
            }
            if (!TUMaths.isPlayerNearby(this.getLocation(), 96.0)) {
                return;
            }
            if (!this.allowedToShoot()) {
                return;
            }
            boolean playSound = false;
            boolean hasTarget = false;
            for (Entity entity : this.getLocation().getWorld().getNearbyEntities(this.getLocation(), (double)this.range, (double)this.range, (double)this.range)) {
                if (!this.getGrid().hasPower(this.getActionPower())) break;
                if (!(entity instanceof Enemy) || entity.isDead()) continue;
                Enemy monster = (Enemy)entity;
                if (!this.hasAmmo()) {
                    this.setFailReason("Missing ammo");
                    break;
                }
                for (Location shootPoint : this.getShootingPoints()) {
                    ArrayList<Location> line;
                    Location shootSource = this.getProjectileSpawnLocation(shootPoint, monster.getEyeLocation());
                    if (!this.hasLOS(shootSource, entity, line = MineUtil.getLocationLine(shootSource, monster.getEyeLocation(), 0.25))) continue;
                    if (this.getAmmo() != null) {
                        TUMaths.removeStackAmount(this.getInventory(), this.getAmmo(), 1);
                    }
                    if (this.getCartidge() != null) {
                        if (this.getOutputSlot() != -1) {
                            this.getInventory().setItem(this.getOutputSlot(), this.getCartidge());
                        } else {
                            this.getLocation().getWorld().dropItemNaturally(TUMaths.centerLocation(this.getLocation(), 1.0), this.getCartidge());
                        }
                    }
                    this.shootTarget(shootSource, entity, monster.getEyeLocation(), line);
                    this.cooldownTimer = this.cooldown;
                    hasTarget = true;
                    this.postShoot();
                    this.getGrid().consumePower(this, this.getActionPower());
                    this.setConsumingPower(true);
                    break;
                }
                if (hasTarget) break;
            }
            if (!hasTarget) {
                this.setFailReason("No Target");
            }
        }
    }

    public void postShoot() {
    }

    public boolean allowedToShoot() {
        return true;
    }

    public boolean hasLOS(Location projSource, Entity target, ArrayList<Location> line) {
        for (Location loc : line) {
            if (!loc.getBlock().getType().isSolid() || !(projSource.distanceSquared(loc) >= 1.0)) continue;
            return false;
        }
        return true;
    }

    public boolean hasAmmo() {
        if (this.getAmmo() != null) {
            for (ItemStack inStack : this.getInputItemsAsClones()) {
                if (!inStack.isSimilar(this.getAmmo())) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    public ItemStack getAmmo() {
        return null;
    }

    public ItemStack getCartidge() {
        return null;
    }

    public void shootTarget(Location shootSource, Entity target, Location targetLocation, ArrayList<Location> line) {
    }

    public void shootArrow(Location shootPoint, Location targetLocation, double speed) {
        Location sourceLocation = this.getProjectileSpawnLocation(shootPoint, targetLocation);
        World world = sourceLocation.getWorld();
        Arrow arrow = (Arrow)world.spawnEntity(sourceLocation, EntityType.ARROW);
        Vector direction = targetLocation.toVector().subtract(sourceLocation.toVector());
        arrow.setVelocity(direction.normalize().multiply(speed));
        arrow.setMetadata("MT Turret", (MetadataValue)new FixedMetadataValue(MineMain.getPlugin(), (Object)"MT Turret"));
    }

    public Location getProjectileSpawnLocation(Location shootPoint, Location target) {
        Location endLocation = target;
        Location startLocation = shootPoint;
        Vector directionFlat = endLocation.toVector().subtract(startLocation.toVector()).setY(0).normalize();
        startLocation = startLocation.clone().add(directionFlat);
        Vector direction = endLocation.toVector().subtract(startLocation.toVector()).normalize();
        Vector offset = direction.clone().multiply(1);
        return startLocation.clone().add(offset);
    }

    public ArrayList<Location> getShootingPoints() {
        ArrayList<Location> locs = new ArrayList<Location>();
        Block block = this.getLocation().getBlock();
        locs.add(block.getRelative(BlockFace.NORTH).getLocation().add(0.5, 0.5, 0.5));
        locs.add(block.getRelative(BlockFace.EAST).getLocation().add(0.5, 0.5, 0.5));
        locs.add(block.getRelative(BlockFace.SOUTH).getLocation().add(0.5, 0.5, 0.5));
        locs.add(block.getRelative(BlockFace.WEST).getLocation().add(0.5, 0.5, 0.5));
        return locs;
    }
}

