/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Utility;

import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Generators.SolarPanel;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import java.util.HashSet;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;

public class AutoDuster
extends Device {
    private static final long serialVersionUID = -3929101797254229915L;
    private static String classSpacedNamed = "Auto Duster";
    private transient HashSet<SolarPanel> panels = new HashSet();
    private int storedDebris = 0;

    public AutoDuster(Location loc) {
        super(loc);
        this.setMaterial("CUT_SANDSTONE_SLAB");
        this.deviceName = classSpacedNamed;
        this.setActionTimer(10);
        this.setActionPower(5);
        this.setIdlePower(0);
        this.setGridRange(0);
        this.setUseUI(true);
        this.setOpenable(true);
        this.useAutoSlots();
        this.useAutoUI();
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Cleans the debris off solar panels.");
        lore.add("- Outputs sand after sometime.");
        lore.add("- Range is a 3x3x1 area");
        return lore;
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.BRUSH, 0.5);
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
    }

    @Override
    public ArrayList<String> extraInfoLore() {
        ArrayList<String> lore = new ArrayList<String>();
        int panels = 0;
        if (this.panels != null) {
            panels = this.panels.size();
        }
        lore.add(String.valueOf(ChatColor.GOLD) + " Adjacent Panels: " + String.valueOf(ChatColor.WHITE) + panels);
        lore.add(String.valueOf(ChatColor.GOLD) + " Stored Debris: " + String.valueOf(ChatColor.WHITE) + this.storedDebris + "%");
        return lore;
    }

    @Override
    public void action() {
        if (this.panels == null) {
            this.panels = new HashSet();
            this.builSolarPanels();
        }
        if (this.getGrid() != null && this.getGrid().hasPower(this.getActionPower())) {
            boolean playerNear = TUMaths.isPlayerNearby(this.getLocation(), 8.0);
            if (playerNear) {
                this.builSolarPanels();
            }
            ItemStack brush = null;
            for (ItemStack stack : this.getInputItems()) {
                if (!TUItems.isValid(stack) || !stack.getType().toString().contains("BRUSH")) continue;
                brush = stack;
                break;
            }
            if (brush == null) {
                if (playerNear) {
                    this.spawnInactiveParticles();
                }
                this.setFailReason("Missing Brush");
                return;
            }
            if (this.storedDebris < 100) {
                if (this.panels.size() > 0) {
                    boolean cleaned = false;
                    for (SolarPanel panel : this.panels) {
                        if (panel.isRemoved() || panel.getDebris() < 10) continue;
                        panel.setDebris(panel.getDebris() - 10);
                        this.storedDebris += 10;
                        MineUtil.damageItemStack(brush, this.getLocation(), this.getInventory());
                        this.getGrid().consumePower(this, this.getActionPower());
                        this.setConsumingPower(true);
                        if (playerNear) {
                            this.getLocation().getWorld().playSound(this.getLocation(), Sound.ITEM_BRUSH_BRUSHING_SAND, 1.0f, 1.0f);
                        }
                        cleaned = true;
                        break;
                    }
                    if (!cleaned) {
                        this.setFailReason("Not enough debris to clean");
                    }
                } else {
                    this.setFailReason("No nearby solar panels");
                }
            } else if (this.getOutputSlot() != -1) {
                this.getInventory().setItem(this.getOutputSlot(), new ItemStack(Material.SAND));
                this.getLocation().getWorld().playSound(this.getLocation(), Sound.ITEM_BRUSH_BRUSHING_SAND_COMPLETE, 1.0f, 1.0f);
                this.storedDebris = 0;
            } else {
                this.setFailReason("No space for debris output");
            }
        }
    }

    private void builSolarPanels() {
        this.panels.clear();
        for (Block block : TUMaths.getNearbyBlocks(this.getLocation().getBlock(), 1)) {
            Device device;
            if (!block.getType().equals((Object)Material.DAYLIGHT_DETECTOR) || (device = Device.getDevice(block.getLocation())) == null || !(device instanceof SolarPanel)) continue;
            SolarPanel sp = (SolarPanel)device;
            this.panels.add(sp);
        }
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, AutoDuster.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.AUTOMATION, new AutoDuster(null).getDeviceStack(), true);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(MineItems.getIndustrialItem("Electronic Circuit"));
        ings.add(MineItems.getIndustrialItem("Iron Plate", 2));
        ings.add(MineItems.getIndustrialItem("Iron Gear Wheel", 2));
        ings.add(new ItemStack(Material.BRUSH));
        RecipeUtils.addDefaultRecipe(new AutoDuster(null).getDeviceStack(), ings, MTRecipe.RecipeType.BASIC, false);
    }
}

