/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Utility;

import com.MT.triggersUtility.RightClickBlockInput;
import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.LocaleUtil;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class PowerMeter
extends Device {
    private static final long serialVersionUID = -1122209111254171315L;
    private static String classSpacedNamed = "Power Meter";
    private long usedPower = 0L;
    private String linkedDevice = null;

    public PowerMeter(Location loc) {
        super(loc);
        this.setMaterial("NOTE_BLOCK");
        this.deviceName = classSpacedNamed;
        this.setActionTimer(1);
        this.setOpenable(true);
        this.setStoreForm(false);
        this.setIdlePower(0);
        this.setActionPower(0);
        this.setUseUI(true);
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- This device is linked to another device.");
        lore.add("- It tracks the power the target uses or produces.");
        return lore;
    }

    @Override
    public void updateUI() {
        ArrayList<String> lore = new ArrayList<String>();
        if (this.usedPower > 0L) {
            lore.add(MineUtil.colon(" Power Generated", PowerMeter.formatLong(this.usedPower)));
        } else {
            lore.add(MineUtil.colon(" Power Used", PowerMeter.formatLong(this.usedPower)));
        }
        if (this.getFailReason() != null && !this.getFailReason().equals("None")) {
            lore.add(" ");
            lore.add(" " + String.valueOf(ChatColor.RED) + this.getFailReason());
        }
        ItemStack powerStack = TUItems.createItem(Material.OBSERVER, String.valueOf(MineItems.goldBold()) + "Power Info", lore);
        powerStack = TUItems.setModelData(powerStack, 9531);
        Inventory inv = this.getInventory();
        inv.setItem(13, powerStack);
        lore.clear();
        if (this.linkedDevice == null) {
            lore.add(MineUtil.colon(" " + LocaleUtil.uiText("General_Click"), "Create Connection"));
        } else {
            lore.add(MineUtil.colon(" " + LocaleUtil.uiText("General_Click"), "Change Connection"));
            lore.add(" ");
            lore.add(String.valueOf(ChatColor.GRAY) + "  > Connected @ " + TUMaths.locationStringBasic(TUMaths.getStringLocation(this.linkedDevice)));
        }
        ItemStack connectionStack = TUItems.createItem(Material.GRAY_CONCRETE, String.valueOf(MineItems.goldBold()) + "Device Connection", lore);
        inv.setItem(11, connectionStack);
        lore.clear();
        lore.add(MineUtil.colon(" " + LocaleUtil.uiText("General_Click"), "Clear Reading"));
        lore.add(" ");
        ItemStack transmissionStack = TUItems.createItem(Material.GREEN_CONCRETE, String.valueOf(MineItems.goldBold()) + "Power Reading", lore);
        inv.setItem(15, transmissionStack);
        ItemStack gPane = MainMenu.createGoldPane();
        int i = 0;
        while (i <= 26) {
            if (i != 13 && i != 11 && i != 15) {
                inv.setItem(i, gPane);
            }
            ++i;
        }
    }

    private Location getLinkedDevice() {
        return TUMaths.getStringLocation(this.linkedDevice);
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.COMPASS, 1.0);
    }

    @Override
    public void action() {
        if (this.getGrid() != null && this.linkedDevice != null) {
            Location linked = this.getLinkedDevice();
            Device device = Device.getDevice(linked);
            if (device != null) {
                if (this.getGrid().generatorSources.containsKey(device)) {
                    this.usedPower += (long)this.getGrid().generatorSources.get(device).intValue();
                    return;
                }
                if (this.getGrid().consumerSources.containsKey(device)) {
                    this.usedPower -= (long)this.getGrid().consumerSources.get(device).intValue();
                }
            } else {
                this.linkedDevice = null;
            }
        }
    }

    @Override
    public void onUIClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.getSlot() == 11) {
            player.closeInventory();
            class BlockInput
            extends RightClickBlockInput {
                private final /* synthetic */ Player val$player;

                public BlockInput(String startMessage, Player player) {
                    this.val$player = player;
                    super(startMessage);
                }

                @Override
                public void inputAction(Block block) {
                    String strLoc = TUMaths.locationString(block);
                    Device device = Device.getDevice(block);
                    if (device != null) {
                        PowerMeter.this.linkedDevice = strLoc;
                        MineUtil.sendMessage(this.val$player, LocaleUtil.messageText("PM_Connected"));
                    } else if (PowerMeter.this.linkedDevice == null) {
                        MineUtil.sendWarning(this.val$player, LocaleUtil.messageText("PM_Aborted"));
                    } else {
                        MineUtil.sendWarning(this.val$player, LocaleUtil.messageText("PM_Removed"));
                        PowerMeter.this.linkedDevice = null;
                    }
                }
            }
            BlockInput input = new BlockInput(String.valueOf(ChatColor.GREEN) + LocaleUtil.messageText("PM_Right_Click"), player);
            input.start(player);
        }
        if (event.getSlot() == 15) {
            MineUtil.sendMessage(player, LocaleUtil.messageText("PM_Cleared").replace("%usedPower%", "" + this.usedPower));
            this.usedPower = 0L;
            this.updateUI();
        }
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, PowerMeter.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.POWER, new PowerMeter(null).getDeviceStack(), false);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(new ItemStack(Material.REDSTONE_BLOCK));
        ings.add(MineItems.getIndustrialItem("Iron Plate", 4));
        ings.add(MineItems.getIndustrialItem("Electronic Circuit"));
        RecipeUtils.addDefaultRecipe(new PowerMeter(null).getDeviceStack(), ings, MTRecipe.RecipeType.BASIC, false);
    }

    public static String formatLong(long value) {
        if (value < 1000L) {
            return String.valueOf(value);
        }
        int exp = (int)(Math.log(value) / Math.log(1000.0));
        char suffix = "kMBTPE".charAt(exp - 1);
        return String.format("%.2f%c", (double)value / Math.pow(1000.0, exp), Character.valueOf(suffix));
    }
}

