/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Utility;

import com.MT.triggersUtility.ChatInput;
import com.MT.triggersUtility.TUInterface.TUIComponent;
import com.MT.triggersUtility.TUInterface.TUInterfaceScrolling;
import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Utility.PowerProvider;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.LocaleUtil;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.PowerGrid;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class PowerReceiver
extends Device {
    private static final long serialVersionUID = -3929309766254451315L;
    private static String classSpacedNamed = "Power Receiver";
    private int storedPower = 0;
    private double loadedFunds = 0.0;
    private boolean providerSlowdown = false;
    private boolean providerFailure = false;
    private boolean providerTransmissionFailure = false;
    private int lastStored = this.storedPower;
    private String provider;

    public PowerReceiver(Location loc) {
        super(loc);
        this.setMaterial("NOTE_BLOCK");
        this.deviceName = classSpacedNamed;
        this.setActionTimer(1);
        this.setOpenable(true);
        this.setGridRange(10);
        this.setStoreForm(false);
        this.setUseUI(true);
        this.setAllowPowerIndicator(true);
        this.updateDeviceHeadItem();
        this.displayLockedHorizontal = true;
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Works like a battery device.");
        lore.add("- Can only be charged from Power Transmitters.");
        return lore;
    }

    @Override
    public void updateUI() {
        ArrayList<String> lore = TUItems.basicLore(MineUtil.colon(" Stored Power", this.storedPower + "/1000"));
        if (MineMain.getEconomy() != null) {
            lore.add(MineUtil.colon(" " + LocaleUtil.uiText("General_Left_Click"), "Find Provider"));
            lore.add(MineUtil.colon(" " + LocaleUtil.uiText("General_Right_Click"), "Deposit Funds"));
            lore.add(MineUtil.colon(" Funds", "" + TUMaths.roundDouble(this.loadedFunds, 2)));
            if (this.provider != null && this.getProvider() != null) {
                PowerProvider provider = this.getProvider();
                int kwPrice = (int)(provider.getWattPrice() * 1000.0);
                lore.add(MineUtil.colon(" Watt Price", provider.getWattPrice() + " (" + kwPrice + " kw)"));
                PowerGrid grid = provider.getGrid();
                lore.add(MineUtil.colon(" Provider Power", TUMaths.simplifyNumber(grid.batteryPower()) + "/" + TUMaths.simplifyNumber(grid.batteryMaxCapacity())));
                lore.add(MineUtil.colon(" Power Generation", TUMaths.simplifyNumber(grid.getLastGenerate()) + "/" + TUMaths.simplifyNumber(grid.getPotentialGeneration())));
                lore.add(" ");
                if (this.providerSlowdown && !this.providerFailure) {
                    if (grid.getLastConsume() <= grid.getPower() + grid.batteryPower()) {
                        lore.add(MineItems.greenBold() + " !! Using Grid Power");
                    } else {
                        lore.add(MineItems.yellowBold() + " !! Provider Not Meeting Power Demand");
                    }
                }
                if (this.providerTransmissionFailure) {
                    lore.add(MineItems.redBold() + " !! Provider Cannot Transmit Power Needed");
                }
                if (this.providerFailure) {
                    lore.add(MineItems.redBold() + " !! No Power From Provider");
                }
            }
            lore.add(" ");
        }
        for (String str : MineUtil.wrapText("This can only be charged from power transmitters and power providers. It will only use its power if the grid is not making any power and the batteries on the grid are drained.", 45)) {
            lore.add(" " + String.valueOf(ChatColor.GRAY) + str);
        }
        ItemStack powerStack = TUItems.createItem(Material.OBSERVER, String.valueOf(MineItems.whiteBold()) + "Devince Information", lore);
        powerStack = TUItems.setModelData(powerStack, 9531);
        Inventory inv = this.getInventory();
        inv.setItem(13, powerStack);
        ItemStack gPane = MainMenu.createGoldPane();
        int i = 0;
        while (i <= 26) {
            if (i != 13) {
                inv.setItem(i, gPane);
            }
            ++i;
        }
    }

    @Override
    public void action() {
        PowerProvider pp;
        int needed;
        this.providerSlowdown = false;
        this.providerFailure = false;
        this.providerTransmissionFailure = false;
        if (this.lastStored > this.storedPower) {
            this.providerSlowdown = true;
        }
        this.lastStored = this.storedPower;
        if (this.getGrid() != null && this.provider != null && this.storedPower < 1000 && (needed = 1000 - this.storedPower) > 0 && (pp = this.getProvider()) != null && pp.getGrid() != null) {
            double price;
            needed = (int)(this.loadedFunds / pp.getWattPrice());
            if (needed > 1000) {
                needed = 1000 - this.storedPower;
            }
            if (this.loadedFunds >= (price = pp.getWattPrice() * (double)needed)) {
                if (!pp.getGrid().hasPower(needed)) {
                    needed = pp.getGrid().batteryPower() + pp.getGrid().getPower();
                    if ((needed -= pp.getTransmissionCost(this)) <= 0) {
                        this.providerTransmissionFailure = true;
                        return;
                    }
                    price = pp.getWattPrice() * (double)needed;
                }
                if (!pp.providePower(this, needed)) {
                    this.providerFailure = true;
                } else {
                    this.loadedFunds -= price;
                    pp.addFunds(price);
                }
            } else {
                this.setFailReason(" Insufficient funds");
            }
        }
    }

    @Override
    public void onDeviceRemove() {
        if (MineMain.getEconomy() != null && this.getPlacerUUID() != null) {
            OfflinePlayer op = Bukkit.getOfflinePlayer((UUID)this.getPlacerUUID());
            if (!op.isOnline()) {
                MineMain.getEconomy().depositPlayer(op, this.loadedFunds);
            } else {
                MineMain.getEconomy().depositPlayer((OfflinePlayer)op.getPlayer(), this.loadedFunds);
            }
        }
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        Material mat = Material.RED_CONCRETE;
        if (this.getStoredPower() > 0) {
            mat = Material.ORANGE_CONCRETE;
        }
        if (this.getStoredPower() >= 250) {
            mat = Material.YELLOW_CONCRETE;
        }
        if (this.getStoredPower() >= 500) {
            mat = Material.GREEN_CONCRETE;
        }
        if (this.getStoredPower() >= 1000) {
            mat = Material.LIME_CONCRETE;
        }
        this.visualIconUpdate(nearbyPlayer, mat, 1.0);
    }

    @Override
    public void onUIClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.getSlot() == 13) {
            if (MineMain.getEconomy() == null) {
                return;
            }
            if (event.isLeftClick()) {
                this.openProviderSelect(player);
            }
            if (event.isRightClick()) {
                class ChatInput
                extends com.MT.triggersUtility.ChatInput {
                    private final /* synthetic */ Player val$player;

                    public ChatInput(String startMessage, boolean numbersonly, Player player) {
                        this.val$player = player;
                        super(startMessage, numbersonly);
                    }

                    @Override
                    public void inputAction(String message) {
                        int amount = Integer.valueOf(message);
                        if (MineMain.getEconomy().getBalance((OfflinePlayer)this.val$player) >= (double)amount) {
                            MineMain.getEconomy().withdrawPlayer((OfflinePlayer)this.val$player, (double)amount);
                            MineUtil.sendMessage(this.val$player, LocaleUtil.messageText("PR_Input").replace("%amount%", "" + amount));
                            PowerReceiver.this.loadedFunds += (double)amount;
                        } else {
                            MineUtil.sendWarning(this.val$player, LocaleUtil.messageText("PR_No_Money"));
                        }
                        PowerReceiver.this.updateUI();
                        this.val$player.openInventory(PowerReceiver.this.getInventory());
                    }
                }
                ChatInput input = new ChatInput(LocaleUtil.messageText("PR_Input"), true, player);
                input.start(player);
            }
        }
    }

    public ArrayList<PowerProvider> getPossibleProviders() {
        ArrayList<PowerProvider> providers = new ArrayList<PowerProvider>();
        for (Device device : Device.getNearbyDevicesByType(this.getLocation(), 100000000, "Power Provider")) {
            providers.add((PowerProvider)device);
        }
        return providers;
    }

    public PowerProvider getProvider() {
        Device device;
        Location loc;
        if (this.provider != null && (loc = this.getProviderLocation()) != null && (device = Device.getDevice(loc)) != null && device instanceof PowerProvider) {
            return (PowerProvider)device;
        }
        return null;
    }

    private Location getProviderLocation() {
        return TUMaths.getStringLocation(this.provider);
    }

    public int getNeededPower() {
        return 1000 - this.storedPower;
    }

    public int getStoredPower() {
        return this.storedPower;
    }

    public void addPower(int amount) {
        this.storedPower += amount;
        if (this.storedPower > 1000) {
            this.storedPower = 1000;
        }
    }

    public void consumePower(int amount) {
        this.storedPower -= amount;
        if (amount < 0) {
            amount = 0;
        }
    }

    public boolean hasPower(int amount) {
        return this.storedPower >= amount;
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, PowerReceiver.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.POWER, new PowerReceiver(null).getDeviceStack(), false);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(new ItemStack(Material.REDSTONE_TORCH));
        ings.add(MineItems.getIndustrialItem("Iron Plate", 7));
        ings.add(MineItems.getIndustrialItem("Electronic Circuit"));
        RecipeUtils.addDefaultRecipe(new PowerReceiver(null).getDeviceStack(), ings, MTRecipe.RecipeType.ADVANCED, true);
    }

    public void openProviderSelect(Player player) {
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        ItemStack pane = MainMenu.createGoldPane();
        ArrayList<PowerProvider> providers = new ArrayList<PowerProvider>(this.getPossibleProviders());
        HashMap stacks = new HashMap();
        class LeaderScroller
        extends TUInterfaceScrolling {
            private final /* synthetic */ ArrayList val$providers;
            private final /* synthetic */ HashMap val$stacks;

            public LeaderScroller(String name, int rows, ArrayList arrayList, HashMap hashMap) {
                this.val$providers = arrayList;
                this.val$stacks = hashMap;
                super(name, rows);
            }

            @Override
            public ItemStack defineScrolling(int i) {
                if (this.val$providers.size() > i) {
                    PowerProvider provider = (PowerProvider)this.val$providers.get(i);
                    ArrayList<String> lore = new ArrayList<String>();
                    int kwPrice = (int)(provider.getWattPrice() * 1000.0);
                    lore.add(MineUtil.colon(" Watt Price", provider.getWattPrice() + " (" + kwPrice + " per kw)"));
                    PowerGrid grid = provider.getGrid();
                    lore.add(MineUtil.colon(" Stored Power", TUMaths.simplifyNumber(grid.batteryPower()) + "/" + TUMaths.simplifyNumber(grid.batteryMaxCapacity())));
                    lore.add(MineUtil.colon(" Available Power", TUMaths.simplifyNumber(grid.getPower())));
                    lore.add(MineUtil.colon(" Power Generation", TUMaths.simplifyNumber(grid.getGenerationRate()) + "/" + TUMaths.simplifyNumber(grid.getPotentialGeneration())));
                    lore.add(" ");
                    lore.add(String.valueOf(ChatColor.WHITE) + "  -> Click to select provider");
                    ItemStack stack = TUItems.createItem(Material.PAPER, MineItems.whiteBold() + "Provider - " + provider.getPlacerName(), lore);
                    this.val$stacks.put(stack, provider);
                    return stack;
                }
                return null;
            }

            @Override
            public void scrollingActionClick(Player player, ItemStack item, InventoryClickEvent event) {
                PowerProvider provider = (PowerProvider)this.val$stacks.get(item);
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                PowerReceiver.this.updateUI();
                PowerReceiver.this.provider = TUMaths.locationString(provider.getLocation());
                player.openInventory(PowerReceiver.this.getInventory());
            }
        }
        LeaderScroller face = new LeaderScroller(ChatColor.GOLD + ChatColor.BOLD + "Power Provider Selector", 6, providers, stacks);
        int i = 45;
        while (i <= 53) {
            if (i != 47 && i != 51 && i != 49) {
                face.addComponent(new TUIComponent(i, pane));
            }
            ++i;
        }
        ArrayList<Integer> scrollingSlots = new ArrayList<Integer>();
        int j = 0;
        while (j <= 44) {
            scrollingSlots.add(j);
            ++j;
        }
        face.setScrollingSlots(scrollingSlots);
        TUIComponent leftScroller = MineUtil.createLeftScroll(47);
        TUIComponent rightScroller = MineUtil.createRightScroll(51);
        class ReturnButton
        extends TUIComponent {
            public ReturnButton(int slot, ItemStack linkStack) {
                super(slot, linkStack);
            }

            @Override
            public void onLeftClick(Player player) {
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                player.openInventory(PowerReceiver.this.getInventory());
            }
        }
        ReturnButton returnButt = new ReturnButton(49, MainMenu.createReturnArrow());
        face.addComponent(returnButt);
        face.addComponent(leftScroller);
        face.addComponent(rightScroller);
        face.setLeftComp(leftScroller);
        face.setRightComp(rightScroller);
        face.updateScrolling();
        face.openInterface(player);
    }
}

