/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Utility;

import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Utility.TradeBeaconRecipe;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.LocaleUtil;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.PlayerData;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.MerchantRecipe;

public class TradeBeacon
extends Device {
    private static final long serialVersionUID = 4991610198705429712L;
    private static String classSpacedNamed = "Trade Beacon";
    private transient Merchant merchant;
    private int nextTrade = TUMaths.rollRange(1800, 2700);
    private int orbitTime = 0;
    private transient TradeBeaconRecipe.ShipType orbitingShip;
    private int timeCooldown = 0;

    public TradeBeacon(Location loc) {
        super(loc);
        this.setMaterial("CARTOGRAPHY_TABLE");
        this.deviceName = classSpacedNamed;
        this.setIdlePower(2);
        this.setActionTimer(1);
        this.setActionPower(2);
        this.setPollutionGen(2);
        this.setUseUI(false);
        this.setOpenable(false);
        this.useAutoSlots();
        this.useAutoUI();
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.GOLD_INGOT, 1.0);
    }

    @Override
    public void action() {
        if (this.merchant == null) {
            this.merchant = Bukkit.createMerchant((String)(String.valueOf(ChatColor.DARK_GRAY) + String.valueOf(ChatColor.BOLD) + "Trade Beacon"));
        }
        if (this.timeCooldown > 0) {
            --this.timeCooldown;
        }
        if (this.isPowered() && this.getGrid().hasPower(this.getActionPower())) {
            if (this.orbitTime > 0) {
                --this.orbitTime;
            } else if (this.orbitingShip != null) {
                PlayerData pd = PlayerData.getPlayerData(this.getPlacerUUID().toString());
                String shipName = this.orbitingShip.toString().toLowerCase().substring(0, 1).toUpperCase() + this.orbitingShip.toString().toLowerCase().substring(1);
                TradeBeacon.tradeBeaconMessage(pd.getPlayer(), String.valueOf(ChatColor.YELLOW) + "The " + shipName + " trade ship has left orbit.", Sound.UI_TOAST_OUT);
                if (pd.getPlayer() != null && pd.getPlayer().getOpenInventory() != null && pd.getPlayer().getOpenInventory().getType().equals((Object)InventoryType.MERCHANT)) {
                    pd.getPlayer().closeInventory();
                }
                this.orbitingShip = null;
            }
            --this.nextTrade;
            if (this.nextTrade <= 0) {
                this.refreshTrader();
            }
        }
    }

    public void refreshTrader() {
        TradeBeaconRecipe.ShipType ship;
        ArrayList<MerchantRecipe> recipes = new ArrayList<MerchantRecipe>();
        this.orbitingShip = ship = TradeBeaconRecipe.ShipType.values()[TUMaths.rollRange(1, TradeBeaconRecipe.ShipType.values().length - 1)];
        PlayerData pd = PlayerData.getPlayerData(this.getPlacerUUID().toString());
        if (pd == null) {
            return;
        }
        int gridScore = this.getGrid().getGridScore();
        for (TradeBeaconRecipe tbr : TradeBeaconRecipe.getTradeRecipes(ship)) {
            if (gridScore < tbr.getMinScore() || !pd.hasTech(tbr.getTechNeeded())) continue;
            recipes.add(tbr.getRecipe());
        }
        String shipName = ship.toString().toLowerCase().substring(0, 1).toUpperCase() + ship.toString().toLowerCase().substring(1);
        TradeBeacon.tradeBeaconMessage(pd.getPlayer(), String.valueOf(ChatColor.GREEN) + "A " + shipName + " trade ship has entered orbit. They wont be around for long though. " + String.valueOf(ChatColor.GRAY) + "(" + gridScore + ")", Sound.UI_TOAST_IN);
        this.merchant.setRecipes(recipes);
        this.nextTrade = TUMaths.rollRange(1800, 2700);
        this.orbitTime = TUMaths.rollRange(300, 600);
    }

    @Override
    public boolean onRightClick(PlayerInteractEvent event) {
        if (this.orbitTime > 0) {
            event.getPlayer().openMerchant(this.merchant, true);
        } else {
            int minutes = this.nextTrade / 60;
            minutes = (int)((double)minutes + TUMaths.rollRange((double)(-minutes) * 0.25, (double)minutes * 0.25));
            if (this.timeCooldown > 0) {
                MineUtil.sendMessage(event.getPlayer(), String.valueOf(ChatColor.YELLOW) + LocaleUtil.messageText("Trade_Beacon_NoShip1"));
            } else {
                this.timeCooldown = 180;
                MineUtil.sendMessage(event.getPlayer(), String.valueOf(ChatColor.YELLOW) + LocaleUtil.messageText("Trade_Beacon_NoShip2").replace("%minutes%", "" + minutes));
            }
        }
        event.setCancelled(true);
        return true;
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, TradeBeacon.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.LOGISTICS, new TradeBeacon(null).getDeviceStack(), false);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(MineItems.getIndustrialItem("Electronic Circuit"));
        ings.add(new ItemStack(Material.COPPER_INGOT, 3));
        ings.add(new ItemStack(Material.IRON_INGOT, 5));
        RecipeUtils.addDefaultRecipe(new TradeBeacon(null).getDeviceStack(), ings, MTRecipe.RecipeType.CRUDE, true);
    }

    @Override
    public void updateUI() {
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- You can only place one of these devices.");
        lore.add("- This device can detect trade ships in orbit.");
        lore.add("- Which you can trade with once detected.");
        lore.add("- Detections take 30-45 minutes.");
        lore.add("- The stay in orbit for 5-10 minutes.");
        return lore;
    }

    private static void tradeBeaconMessage(Player player, String message, Sound sound) {
        if (player == null || player != null && !player.isOnline()) {
            return;
        }
        player.playSound((Entity)player, sound, 1.0f, 0.5f);
        player.sendMessage(message);
    }
}

