/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Guide;

import com.MT.triggersUtility.TUInterface.TUIComponent;
import com.MT.triggersUtility.TUInterface.TUInterfaceScrolling;
import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Guide.GuideMenu;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineUtil;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class TablesMenu {
    public static HashMap<Category, ArrayList<String>> tables = new HashMap();

    public static void openTablesMenu(Player player) {
        TUInterfaceScrolling face = new TUInterfaceScrolling(MineItems.goldBold() + "Minetorio Tables", 6){

            @Override
            public ItemStack defineScrolling(int i) {
                ArrayList<String> strStacks = this.getCatStacks(this.currentCategory());
                if (strStacks.size() - 1 >= i) {
                    return TUItems.createStackFromString(strStacks.get(i), false);
                }
                return null;
            }

            @Override
            public void scrollingActionClick(Player player, ItemStack item, InventoryClickEvent event) {
                if (event.isRightClick() && event.isShiftClick()) {
                    player.playSound((Entity)player, Sound.ENTITY_GENERIC_BURN, 1.0f, 1.0f);
                    tables.get((Object)this.currentCategory()).remove(TUItems.createStackString(item));
                    this.updateScrolling();
                }
                if (event.isLeftClick()) {
                    player.getInventory().addItem(new ItemStack[]{event.getCurrentItem().clone()});
                }
            }

            @Override
            public void playerInventoryClick(Player player, ItemStack item, InventoryClickEvent event) {
                if (this.hasTag("SELECTING")) {
                    this.removeTag("SELECTING");
                    tables.get((Object)this.currentCategory()).add(TUItems.createStackString(event.getCurrentItem()));
                    MineUtil.sendMessage(player, "Item has been added to the " + String.valueOf((Object)this.currentCategory()) + " table!");
                    this.updateScrolling();
                    event.setCancelled(true);
                }
            }

            public Category currentCategory() {
                Category[] categoryArray = Category.values();
                int n = categoryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Category cat = categoryArray[n2];
                    if (this.hasTag("CAT:" + cat.toString())) {
                        return cat;
                    }
                    ++n2;
                }
                return Category.SIFTER;
            }

            public ArrayList<String> getCatStacks(Category cat) {
                ArrayList<String> stacks = new ArrayList<String>();
                stacks.addAll(tables.getOrDefault((Object)cat, stacks));
                return stacks;
            }
        };
        TUIComponent leftScroll = MineUtil.createLeftScroll(47);
        TUIComponent rightScroll = MineUtil.createRightScroll(51);
        face.addComponent(leftScroll);
        face.addComponent(rightScroll);
        face.setLeftComp(leftScroll);
        face.setRightComp(rightScroll);
        int i = 9;
        while (i < 18) {
            if (i != 13) {
                face.addComponent(GuideMenu.pane(Material.WHITE_STAINED_GLASS_PANE, i));
            }
            ++i;
        }
        face.addComponent(GuideMenu.pane(Material.ORANGE_STAINED_GLASS_PANE, 45));
        face.addComponent(GuideMenu.pane(Material.ORANGE_STAINED_GLASS_PANE, 46));
        face.addComponent(GuideMenu.pane(Material.ORANGE_STAINED_GLASS_PANE, 48));
        face.addComponent(GuideMenu.pane(Material.ORANGE_STAINED_GLASS_PANE, 50));
        face.addComponent(GuideMenu.pane(Material.ORANGE_STAINED_GLASS_PANE, 52));
        face.addComponent(GuideMenu.pane(Material.ORANGE_STAINED_GLASS_PANE, 53));
        face.addComponent(TablesMenu.createButton(Category.SIFTER, 3));
        face.addComponent(TablesMenu.createButton(Category.CRUSHER, 4));
        face.addComponent(TablesMenu.createButton(Category.RESOURCE_ZONE, 5));
        face.addComponent(MineUtil.createReturnArrow());
        face.addComponent(MineUtil.createInfoComponent(13, "This menu allows you to modify tables for things in Minetorio. This could be for devices or even resource zones. Use shift right click at anytime to remove an item from the table. Note that each category has vastly different options, make sure to check the add buton for each category. And use the default entries here as a reference to better understand this section!"));
        face.setScrollingSlots(TablesMenu.getScrollingSlots());
        face.updateScrolling();
        face.addComponent(TablesMenu.addButton(18));
        face.getComponent(3).onLeftClick(player);
        face.openInterface(player);
    }

    private static ArrayList<Integer> getScrollingSlots() {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        int i = 19;
        while (i <= 26) {
            slots.add(i);
            ++i;
        }
        i = 18;
        while (i <= 26) {
            slots.add(i + 9);
            ++i;
        }
        i = 18;
        while (i <= 26) {
            slots.add(i + 18);
            ++i;
        }
        return slots;
    }

    private static TUIComponent createButton(final Category cat, int slot) {
        String desc = "";
        Material mat = Material.GRASS_BLOCK;
        if (cat.equals((Object)Category.SIFTER)) {
            desc = "Recipes for the Sifter device.";
            mat = Material.SAND;
        }
        if (cat.equals((Object)Category.CRUSHER)) {
            desc = "Recipes for the Crusher device.";
            mat = Material.GRINDSTONE;
        }
        if (cat.equals((Object)Category.RESOURCE_ZONE)) {
            desc = "Resources that can be deep drill mined.";
        }
        ItemStack itemStack = TUItems.createItem(mat, MineItems.goldBold() + cat.toString());
        if (cat.equals((Object)Category.SIFTER)) {
            itemStack = TUItems.setModelData(itemStack, 9561);
        }
        if (cat.equals((Object)Category.CRUSHER)) {
            itemStack = TUItems.setModelData(itemStack, 9562);
        }
        if (cat.equals((Object)Category.RESOURCE_ZONE)) {
            itemStack = TUItems.setModelData(itemStack, 9563);
        }
        ArrayList<String> lore = new ArrayList<String>();
        for (String str : MineUtil.wrapText(desc, 60)) {
            lore.add(String.valueOf(ChatColor.WHITE) + str);
        }
        TUItems.addLore(itemStack, lore);
        return new TUIComponent(slot, itemStack){

            @Override
            public void onLeftClick(Player player) {
                this.getTuface().removeTag("CAT");
                this.getTuface().addTag("CAT:" + cat.toString());
                this.setLinkedStack(TUMaths.addGlow(this.getLinkedStack()));
                this.createItemStack();
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                ArrayList<String> addLore = new ArrayList<String>();
                ArrayList<Object> addLore2 = new ArrayList<Object>();
                String addDesc = "";
                if (cat.equals((Object)Category.SIFTER)) {
                    addDesc = "Add *key lore* to the item you want to add before adding it here. For example, adding Min: 1, Max: 3, will make the sifted item if chosen have an amount of 1-3. Default is used if nothing is rolled when that material is sifted, if there is no default and nothing is rolled then the sifted item is simply destroyed. Material: SAND, means that if sand is sifted this item will be created or have a chance to be created when the sifter sifts sand. This can be any MATERIAL.";
                    addLore2.add(" ");
                    addLore2.add(MineItems.whiteBold() + "--OPTIONS--");
                    addLore2.add(MineUtil.colon("Min", "1"));
                    addLore2.add(MineUtil.colon("Max", "3"));
                    addLore2.add(MineUtil.colon("Chance", "15"));
                    addLore2.add(MineUtil.colon("Default", "true/false"));
                    addLore2.add(MineUtil.colon("Material", "SAND/RED_SAND/DIRT/ETC"));
                }
                if (cat.equals((Object)Category.CRUSHER)) {
                    addDesc = "Add *key lore* to the item you want to add before adding it here. For example, adding Amount Needed: 8 will make the crushed item need 8 of them to create the item added. Material: GRAVEL, means that if gravel is crushed this item will be created when the crusher crushes gravel. This can be any MATERIAL";
                    addLore2.add(" ");
                    addLore2.add(MineItems.whiteBold() + "--OPTIONS--");
                    addLore2.add(MineUtil.colon("Amount Needed", "1"));
                    addLore2.add(MineUtil.colon("Material", "GRAVEL/COBBLESTONE/OAK_LOG"));
                }
                if (cat.equals((Object)Category.RESOURCE_ZONE)) {
                    addDesc = "Add *key lore* to the item you want to add before adding it here. For example adding Chance: 10, will make this have a 10% chance to show up when a user is using seismic charges to find resource zones. Most options are cumulative here! So having two entries of Y Level Low Bonus, will add both of their chance bonuses if their y level is lower then the set amount.";
                    addLore2.add(" ");
                    addLore2.add(MineItems.whiteBold() + "--OPTIONS--");
                    addLore2.add(MineUtil.colon("Min", "1"));
                    addLore2.add(MineUtil.colon("Max", "100000"));
                    addLore2.add(MineUtil.colon("Chance", "15"));
                    addLore2.add(MineUtil.colon("General Biome", "FOREST/10"));
                    addLore2.add(MineUtil.colon("Temp Low Bonus", "0.25/2"));
                    addLore2.add(MineUtil.colon("Temp High Bonus", "1.25/2"));
                    addLore2.add(MineUtil.colon("Y Level Low Bonus", "-32/1"));
                    addLore2.add(MineUtil.colon("Not Biome General", "OCEAN"));
                    addLore2.add(MineUtil.colon("Warmer Then", "0.2"));
                    addLore2.add(MineUtil.colon("Colder Then", "0.0"));
                    addLore2.add(String.valueOf(ChatColor.WHITE) + "IS OIL");
                }
                for (String str : MineUtil.wrapText(addDesc, 60)) {
                    addLore.add(String.valueOf(ChatColor.WHITE) + str);
                }
                addLore.addAll(addLore2);
                ItemStack tableStack = TUItems.createItem(Material.LIME_CONCRETE, MineItems.greenBold() + "ADD TABLE ITEM", addLore);
                this.getTuface().getComponent(18).setLinkedStack(tableStack);
                this.getTuface().getComponent(18).createItemStack();
                ((TUInterfaceScrolling)this.getTuface()).updateScrolling();
            }

            @Override
            public void onUpdate() {
                if (!this.getTuface().hasTag("CAT:" + cat.toString()) && this.getLinkedStack().getItemMeta().hasEnchant(Enchantment.KNOCKBACK)) {
                    ItemStack stack = this.getLinkedStack();
                    stack.removeEnchantments();
                    this.setLinkedStack(stack);
                    this.createItemStack();
                }
            }
        };
    }

    private static TUIComponent addButton(int slot) {
        String desc = "Click this to add an item to this table! ";
        ItemStack itemStack = TUItems.createItem(Material.LIME_CONCRETE, MineItems.greenBold() + "ADD TABLE ITEM");
        ArrayList<String> lore = new ArrayList<String>();
        for (String str : MineUtil.wrapText(desc, 60)) {
            lore.add(String.valueOf(ChatColor.DARK_GRAY) + str);
        }
        TUItems.addLore(itemStack, lore);
        return new TUIComponent(slot, itemStack){

            @Override
            public void onLeftClick(Player player) {
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                ((TUInterfaceScrolling)this.getTuface()).updateScrolling();
                if (!this.getTuface().hasTag("SELECTING")) {
                    this.getTuface().addTag("SELECTING");
                }
                MineUtil.sendMessage(player, "Select the item from your inventory now!");
            }
        };
    }

    public static enum Category {
        SIFTER,
        CRUSHER,
        RESOURCE_ZONE;

    }
}

