/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx;

import com.MT.triggersUtility.Metrics;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Mover;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.PlayerData;
import com.MT.xxxtrigger50xxx.Pollution.SuperChunk;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MetricsHandler {
    public static Metrics metrics = null;

    public static void addMetrics() {
        metrics = new Metrics((Plugin)((JavaPlugin)MineMain.getPlugin()), 21879);
        metrics.addCustomChart(new Metrics.AdvancedPie("placed_devices", new Callable<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() throws Exception {
                HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
                for (Device device : Device.getDevices()) {
                    if (device.getName().equals("Biter Nest")) continue;
                    if (!valueMap.containsKey(device.getName())) {
                        valueMap.put(device.getName(), 0);
                    }
                    valueMap.put(device.getName(), (Integer)valueMap.get(device.getName()) + 1);
                }
                valueMap.put("Mover", Mover.getMovers().size());
                return valueMap;
            }
        }));
        metrics.addCustomChart(new Metrics.AdvancedPie("unlocked_tech", new Callable<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() throws Exception {
                HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
                for (PlayerData pd : PlayerData.getAllData()) {
                    for (String tech : pd.getUnlockedTechs()) {
                        if (!valueMap.containsKey(tech)) {
                            valueMap.put(tech, 0);
                        }
                        valueMap.put(tech, (Integer)valueMap.get(tech) + 1);
                    }
                }
                return valueMap;
            }
        }));
        metrics.addCustomChart(new Metrics.AdvancedPie("premium", new Callable<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() throws Exception {
                HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
                if (MineMain.isFree) {
                    valueMap.put("Free", 1);
                } else {
                    valueMap.put("Premium", 1);
                }
                return valueMap;
            }
        }));
        metrics.addCustomChart(new Metrics.AdvancedPie("miner_mode", new Callable<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() throws Exception {
                HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
                String name = "Virtual - Mode 0";
                int mode = MineMain.getPlugin().getConfig().getInt("Miner Mode");
                if (mode == 1) {
                    name = "Physical - Mode 1";
                }
                if (mode == 2) {
                    name = "Hybrid - Mode 2";
                }
                valueMap.put(name, 1);
                return valueMap;
            }
        }));
        metrics.addCustomChart(new Metrics.AdvancedPie("using_technology", new Callable<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() throws Exception {
                HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
                if (MineMain.useTechnology) {
                    valueMap.put("true", 1);
                } else {
                    valueMap.put("false", 1);
                }
                return valueMap;
            }
        }));
        metrics.addCustomChart(new Metrics.AdvancedPie("plugins", new Callable<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() throws Exception {
                HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
                Plugin[] pluginArray = Bukkit.getPluginManager().getPlugins();
                int n = pluginArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Plugin plugin = pluginArray[n2];
                    if (!plugin.getName().equals("Minetorio")) {
                        valueMap.put(plugin.getName(), 1);
                    }
                    ++n2;
                }
                return valueMap;
            }
        }));
        metrics.addCustomChart(new Metrics.SingleLineChart("biter_nests", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Device.getDevices("Biter Nest").size();
            }
        }));
        metrics.addCustomChart(new Metrics.SingleLineChart("global_pollution", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int amount = 0;
                for (SuperChunk sc : SuperChunk.getAllSuperChunks()) {
                    amount += sc.getPollution();
                }
                return amount;
            }
        }));
    }
}

