/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Planets;

import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.util.Vector;

public class MeteorManager {
    private final Map<World, Integer> secondsUntilNextMeteor = new HashMap<World, Integer>();
    private final Random random = new Random();
    private static MeteorManager manager;
    public static MeteorBlockDamage damageType;

    static {
        damageType = MeteorBlockDamage.NONE;
    }

    public void tick(World world, double meteorIntensity) {
        if (meteorIntensity <= 0.0 || world.getPlayers().isEmpty()) {
            return;
        }
        int secondsLeft = this.secondsUntilNextMeteor.getOrDefault(world, -1);
        if (secondsLeft < 0) {
            int intervalSeconds = (int)(3600.0 / meteorIntensity);
            this.secondsUntilNextMeteor.put(world, intervalSeconds);
            return;
        }
        if (secondsLeft <= 0) {
            List players = world.getPlayers();
            if (!players.isEmpty()) {
                Player target = (Player)players.get(this.random.nextInt(players.size()));
                int amount = TUMaths.rollRange(6, 16);
                this.spawnMeteorsNear(target, amount, 64, (int)((double)MineMain.chunkViewDistance * 0.4), 60);
            }
            int intervalSeconds = (int)(3600.0 / meteorIntensity);
            this.secondsUntilNextMeteor.put(world, intervalSeconds);
        } else {
            this.secondsUntilNextMeteor.put(world, secondsLeft - 1);
        }
    }

    public void spawnMeteorsNear(final Player player, int numMeteors, int targetRadius, int spawnDistance, int heightAboveGround) {
        if (targetRadius < 1) {
            targetRadius = 1;
        }
        if (numMeteors < 1) {
            return;
        }
        Location playerLoc = player.getLocation();
        double baseAngle = this.random.nextDouble() * 2.0 * Math.PI;
        double targetDistance = this.random.nextDouble() * (double)targetRadius;
        double targetX = playerLoc.getX() + Math.cos(baseAngle) * targetDistance;
        double targetZ = playerLoc.getZ() + Math.sin(baseAngle) * targetDistance;
        Location target = new Location(playerLoc.getWorld(), targetX, 0.0, targetZ);
        target.setY((double)(target.getWorld().getHighestBlockYAt(target) + 1));
        int i = 0;
        while (i < numMeteors) {
            double angleOffset = (this.random.nextDouble() - 0.5) * Math.toRadians(20.0);
            double spawnAngle = baseAngle + Math.toRadians(180.0) + angleOffset;
            double distanceOffset = (this.random.nextDouble() - 0.5) * 10.0;
            double actualDistance = (double)spawnDistance + distanceOffset;
            double spawnX = target.getX() + Math.cos(spawnAngle) * actualDistance;
            double spawnZ = target.getZ() + Math.sin(spawnAngle) * actualDistance;
            final Location spawnLoc = new Location(playerLoc.getWorld(), spawnX, 0.0, spawnZ);
            spawnLoc.setY((double)(spawnLoc.getWorld().getHighestBlockYAt(spawnLoc) + heightAboveGround));
            final Vector direction = target.toVector().subtract(spawnLoc.toVector()).normalize();
            direction.add(new Vector((this.random.nextDouble() - 0.5) * 0.2, (this.random.nextDouble() - 0.5) * 0.2, (this.random.nextDouble() - 0.5) * 0.2)).normalize();
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    player.getWorld().spawn(spawnLoc, Fireball.class, fb -> {
                        fb.setDirection(direction);
                        fb.setIsIncendiary(false);
                        fb.setYield((float)(1.0 + TUMaths.rollRange(1.0, 2.0)));
                        fb.setShooter(null);
                        fb.getPersistentDataContainer().set(new NamespacedKey(MineMain.getPlugin(), "MT-METEOR"), PersistentDataType.BOOLEAN, (Object)true);
                        MineUtil.setDisposableEntity((Entity)fb);
                    });
                }
            }, 0L + (long)TUMaths.rollRange(0, 160));
            ++i;
        }
    }

    public static MeteorManager getManager() {
        if (manager == null) {
            manager = new MeteorManager();
        }
        return manager;
    }

    public static enum MeteorBlockDamage {
        FULL,
        DEVICES,
        VANILLA,
        NONE;

    }
}

