/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Planets;

import com.MT.triggersUtility.SkullCreator;
import com.MT.xxxtrigger50xxx.Planets.WeatherController;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class Planet {
    private String planetName;
    private String boundWorld;
    public WeatherController weatherController;
    private double dayTimeSpeed = 1.0;
    private double gravityLevel = 1.0;
    private double tempature = 1.0;
    private double cropGrowth = 1.0;
    private double stormLevel = 1.0;
    private double tidalLevels = 1.0;
    private double windLevels = 1.0;
    private double moonBonus = 1.0;
    private double sunBonus = 1.0;
    private double meteorIntensity = 0.0;
    private double lightningIntensity = 0.0;
    private double startPlanetDistance = 0.0;
    private double solarAngle = 0.0;
    private double solarHeight = 0.0;
    private double solarRotation = 0.0;
    private double solarScale = 1.0;
    private int rotationSpeed = 10;
    private int rotation = 0;
    private String atlasMaterial;
    private String atlastHeadCode;
    private HashMap<Gas, Double> atmosphereComposition = new HashMap();
    private static ArrayList<Planet> allPlanets = new ArrayList();

    public Planet(String name, String world) {
        this.planetName = name;
        this.boundWorld = world;
        this.atmosphereComposition.put(Gas.OXYGEN, 0.25);
        this.atmosphereComposition.put(Gas.HYDROGEN, 0.1);
        allPlanets.add(this);
    }

    public String getPlanetName() {
        return this.planetName;
    }

    public void rotate() {
        this.rotation = (int)((double)this.rotation + this.getSolarRotation());
        if (this.rotation > 360) {
            this.rotation -= 360;
        }
    }

    public void setGasLevel(Gas gas, double level) {
        this.atmosphereComposition.put(gas, level);
    }

    public double getGasLevel(Gas gas) {
        return this.atmosphereComposition.getOrDefault((Object)gas, 0.0);
    }

    public double getStormLevel() {
        return this.stormLevel;
    }

    public void setStormLevel(double stormLevel) {
        this.stormLevel = stormLevel;
        if (this.weatherController == null) {
            this.weatherController = new WeatherController(this.getBoundWorld(), stormLevel);
        } else {
            this.weatherController.changeStormLevel(stormLevel);
        }
    }

    public double getGravityLevel() {
        return this.gravityLevel;
    }

    public void setGravityLevel(double gravityLevel) {
        this.gravityLevel = gravityLevel;
    }

    public double getTidalLevels() {
        return this.tidalLevels;
    }

    public void setTidalLevels(double tidalLevels) {
        this.tidalLevels = tidalLevels;
    }

    public double getWindLevels() {
        return this.windLevels;
    }

    public void setWindLevels(double windLevels) {
        this.windLevels = windLevels;
    }

    public double getMoonDistance() {
        return this.moonBonus;
    }

    public void setMoonDistance(double moonDistance) {
        this.moonBonus = moonDistance;
    }

    public double getSunDistance() {
        return this.sunBonus;
    }

    public void setSunDistance(double sunDistance) {
        this.sunBonus = sunDistance;
    }

    public double getMeteorIntensity() {
        return this.meteorIntensity;
    }

    public void setMeteorIntensity(double meteorIntensity) {
        this.meteorIntensity = meteorIntensity;
    }

    public double getCropGrowth() {
        return this.cropGrowth;
    }

    public void setCropGrowth(double cropGrowth) {
        this.cropGrowth = cropGrowth;
    }

    public double getTempature() {
        return this.tempature;
    }

    public void setTempature(double tempature) {
        this.tempature = tempature;
    }

    public String getBoundWorld() {
        return this.boundWorld;
    }

    public void setBoundWorld(String boundWorld) {
        this.boundWorld = boundWorld;
    }

    public double getDayTimeSpeed() {
        return this.dayTimeSpeed;
    }

    public void setDayTimeSpeed(double dayLightHours) {
        this.dayTimeSpeed = dayLightHours;
    }

    public double getLightningIntensity() {
        return this.lightningIntensity;
    }

    public void setLightningIntensity(double lightningIntensity) {
        this.lightningIntensity = lightningIntensity;
    }

    public String getAtlasMaterial() {
        return this.atlasMaterial;
    }

    public void setAtlasMaterial(String atlasMaterial) {
        this.atlasMaterial = atlasMaterial;
    }

    public String getAtlastHeadCode() {
        return this.atlastHeadCode;
    }

    public void setAtlastHeadCode(String atlastHeadCode) {
        this.atlastHeadCode = atlastHeadCode;
    }

    public static ArrayList<Planet> getPlanets() {
        return new ArrayList<Planet>(allPlanets);
    }

    public static Planet getByPlanetName(String name) {
        for (Planet planet : allPlanets) {
            if (!planet.getPlanetName().equals(name)) continue;
            return planet;
        }
        return null;
    }

    public double getStartPlanetDistance() {
        return this.startPlanetDistance;
    }

    public void setStartPlanetDistance(double startPlanetDistance) {
        this.startPlanetDistance = startPlanetDistance;
    }

    public double getSolarAngle() {
        return this.solarAngle;
    }

    public void setSolarAngle(double solarAngle) {
        this.solarAngle = solarAngle;
    }

    public ItemStack getPlanetStack() {
        if (this.getAtlastHeadCode().equals("NONE")) {
            return new ItemStack(Material.valueOf((String)this.atlasMaterial));
        }
        return SkullCreator.getHead(this.getAtlastHeadCode());
    }

    public int getRotationSpeed() {
        return this.rotationSpeed;
    }

    public void setRotationSpeed(int rotationSpeed) {
        this.rotationSpeed = rotationSpeed;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public double getSolarHeight() {
        return this.solarHeight;
    }

    public void setSolarHeight(double solarHeight) {
        this.solarHeight = solarHeight;
    }

    public double getSolarRotation() {
        return this.solarRotation;
    }

    public void setSolarRotation(double solarRotation) {
        this.solarRotation = solarRotation;
    }

    public double getSolarScale() {
        return this.solarScale;
    }

    public void setSolarScale(double solarScale) {
        this.solarScale = solarScale;
    }

    public static enum Gas {
        OXYGEN,
        HYDROGEN;

    }
}

