/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Planets.SpaceObjects;

import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Spaceship.ShipCore;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.Planets.SpaceObjects.DisplayGroup;
import com.MT.xxxtrigger50xxx.Planets.SpaceObjects.SpaceObject;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.util.Transformation;
import org.bukkit.util.Vector;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Asteroid
extends SpaceObject {
    private ShipCore spawner;
    private int pieces = 0;
    private int scale = 3;
    private int centerPieces = 3;
    private Material mainMat = Material.ANDESITE;
    private Material peiceMat = Material.STONE;
    public DisplayGroup group;
    private static int[] pitches = new int[]{10, 20, 30, 40, 50, 60, 70, 80};
    private boolean danger = false;
    private float pitchSpeed = 5.0f;
    private float yawSpeed = 5.0f;
    private double lastPosition = -1.0;
    private boolean isCollectorLocked = false;

    public Asteroid(Location location, ShipCore core) {
        super(location);
        this.spawner = core;
        this.setDisplayMoveSpeed(3);
        this.pieces = 18;
        this.setYawSpeed((float)TUMaths.rollRange(1.0, 5.0));
        this.setPitchSpeed(5.0f);
    }

    @Override
    public HashSet<Entity> createRender() {
        HashSet<Entity> ents = new HashSet<Entity>();
        double halfScale = this.getScale() / 2;
        int i2 = 0;
        while (i2 < this.centerPieces) {
            Display center = this.spawnCenter(this.getScale(), this.getLocation().add((double)TUMaths.rollRange(-this.getScale() / 3, this.getScale() / 3), TUMaths.rollRange(-halfScale, halfScale), TUMaths.rollRange(-halfScale, halfScale)));
            ents.add((Entity)center);
            int side = 0;
            int i = 0;
            while (i < this.pieces) {
                ents.add((Entity)this.spawnPiece(center.getLocation(), this.getScale(), side));
                if (++side > 5) {
                    side = 0;
                }
                ++i;
            }
            ++i2;
        }
        HashSet<Display> ents2 = new HashSet<Display>();
        for (Entity entity : ents) {
            ents2.add((Display)entity);
        }
        this.group = new DisplayGroup(this.getGroupCenter(ents), ents2);
        this.group.rotate(TUMaths.rollRange(0, 90), TUMaths.choose(pitches));
        return ents;
    }

    private Display spawnCenter(double scale, Location location) {
        float scaleOffset = (float)(scale / 2.0 * -1.0);
        scaleOffset = (float)((double)scaleOffset + TUMaths.rollRange(0.0, 1.0E-8));
        BlockDisplay display = (BlockDisplay)this.getLocation().getWorld().spawn(location, BlockDisplay.class);
        Transformation form = display.getTransformation();
        form.getTranslation().set((Vector3fc)new Vector3f(scaleOffset, scaleOffset, scaleOffset));
        form.getScale().set(scale);
        display.setTransformation(form);
        display.setTeleportDuration(20);
        display.setBlock(this.getMainMat().createBlockData());
        return display;
    }

    private Display spawnPiece(Location location, double centerScale, int side) {
        double scaleMax = centerScale * 0.3;
        double scaleMin = centerScale * 0.2;
        double scale = TUMaths.rollRange(scaleMin, scaleMax) + TUMaths.rollRange(0.0, 1.0E-6);
        Location spawn = location;
        double maxPertrustion = 0.15;
        double xPos = TUMaths.rollRange(-maxPertrustion - centerScale, maxPertrustion);
        double yPos = TUMaths.rollRange(-maxPertrustion - centerScale, maxPertrustion);
        double zPos = TUMaths.rollRange(-maxPertrustion - centerScale, maxPertrustion);
        double flipped = -centerScale - maxPertrustion;
        if (side == 0) {
            spawn.add(xPos, yPos, 0.0);
        }
        if (side == 1) {
            spawn.add(xPos, yPos, flipped);
        }
        if (side == 2) {
            spawn.add(0.0, yPos, zPos);
        }
        if (side == 3) {
            spawn.add(flipped, yPos, zPos);
        }
        if (side == 4) {
            spawn.add(xPos, 0.0, zPos);
        }
        if (side == 5) {
            spawn.add(xPos, flipped, zPos);
        }
        float scaleOffset = (float)(scale / 2.0 * -1.0);
        BlockDisplay display = (BlockDisplay)this.getLocation().getWorld().spawn(spawn.add(centerScale / 2.0, centerScale / 2.0, centerScale / 2.0), BlockDisplay.class);
        Transformation form = display.getTransformation();
        form.getTranslation().set((Vector3fc)new Vector3f(scaleOffset, scaleOffset, scaleOffset));
        form.getScale().set(scale);
        display.setTeleportDuration(20);
        display.setTransformation(form);
        display.setBlock(this.getPeiceMat().createBlockData());
        return display;
    }

    public Material getMainMat() {
        return this.mainMat;
    }

    public void setMainMat(Material mainMat) {
        this.mainMat = mainMat;
    }

    public Material getPeiceMat() {
        return this.peiceMat;
    }

    public void setPeiceMat(Material peiceMat) {
        this.peiceMat = peiceMat;
    }

    @Override
    public void postTick(boolean forced) {
        if (this.getLocation().getZ() > 200.0) {
            this.removeObject();
            return;
        }
        double speed = this.adjustSpeed();
        if (this.isCollectorLocked()) {
            speed = 10.0;
        }
        final double fSpeed = speed;
        if (this.group == null) {
            this.setLocation(this.moveTowards(this.getLocation(), this.getTargetLocation(), fSpeed));
            return;
        }
        if (!this.danger) {
            Location newLoc;
            this.group.center = newLoc = this.moveTowards(this.group.center.clone(), this.getTargetLocation(), fSpeed);
            this.danger = this.group.rotate(this.yawSpeed, this.pitchSpeed);
        } else {
            Location newLoc;
            this.group.center = newLoc = this.moveTowards(this.group.center.clone(), this.getTargetLocation(), fSpeed * (double)1.0E-13f);
            float adjustYawSpeed = 0.0f;
            if (this.yawSpeed > 0.0f) {
                adjustYawSpeed = 0.001f;
            }
            this.group.rotateViaTeleport(adjustYawSpeed, 0.001f);
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    Location newLoc;
                    Asteroid.this.group.center = newLoc = Asteroid.this.moveTowards(Asteroid.this.group.center.clone(), Asteroid.this.getTargetLocation(), fSpeed * 1.0);
                    float adjustYawSpeed = 0.0f;
                    if (Asteroid.this.yawSpeed > 0.0f) {
                        adjustYawSpeed = Asteroid.this.yawSpeed - 0.001f;
                    }
                    Asteroid.this.group.rotate(adjustYawSpeed, Asteroid.this.pitchSpeed - 0.001f);
                }
            }, 1L);
            this.danger = false;
        }
        this.setLocation(this.group.center);
    }

    public Location getGroupCenter(Set<Entity> entities) {
        if (entities.isEmpty()) {
            return null;
        }
        Vector sum = new Vector(0, 0, 0);
        for (Entity entity : entities) {
            sum.add(entity.getLocation().toVector());
        }
        Vector average = sum.multiply(1.0 / (double)entities.size());
        return new Location(entities.iterator().next().getWorld(), average.getX(), average.getY(), average.getZ());
    }

    public float getPitchSpeed() {
        return this.pitchSpeed;
    }

    public void setPitchSpeed(float speed) {
        this.pitchSpeed = speed;
    }

    public float getYawSpeed() {
        return this.yawSpeed;
    }

    public void setYawSpeed(float speed) {
        this.yawSpeed = speed;
    }

    public ShipCore getShipCore() {
        return this.spawner;
    }

    @Override
    public void derender() {
        if (this.group == null) {
            return;
        }
        this.setLocation(this.group.center);
        this.group = null;
    }

    public double adjustSpeed() {
        if (this.lastPosition == -1.0) {
            this.lastPosition = this.getShipCore().getSpacePosition();
            return this.getDisplayMoveSpeed();
        }
        double distanceTraveled = Math.abs(this.lastPosition - this.getShipCore().getSpacePosition());
        this.lastPosition = this.getShipCore().getSpacePosition();
        if (distanceTraveled > 0.0) {
            double mod = 1.0 + distanceTraveled;
            if (mod > 3.0) {
                mod = 3.0;
            }
            return (double)this.getDisplayMoveSpeed() * mod;
        }
        return this.getDisplayMoveSpeed();
    }

    @Override
    public void onRemove() {
        if (this.getShipCore() != null) {
            this.getShipCore().decorRoids.remove(this);
            this.getShipCore().incomingRoids.remove(this);
        }
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public int getCenterPieces() {
        return this.centerPieces;
    }

    public void setCenterPieces(int centerPieces) {
        this.centerPieces = centerPieces;
    }

    public boolean isCollectorLocked() {
        return this.isCollectorLocked;
    }

    public void setCollectorLocked(boolean isCollectorLocked) {
        this.isCollectorLocked = isCollectorLocked;
    }
}

