/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Planets.SpaceObjects;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.entity.Display;
import org.bukkit.util.Vector;

public class DisplayGroup {
    public Location center;
    private final Map<Display, Vector> offsets = new HashMap<Display, Vector>();
    private final Map<Display, Vector> baseDirections = new HashMap<Display, Vector>();
    private float totalYaw = 0.0f;
    private float totalPitch = 0.0f;

    public DisplayGroup(Location center, Collection<Display> entities) {
        this.center = center.clone();
        for (Display entity : entities) {
            Vector offset = entity.getLocation().toVector().subtract(center.toVector());
            this.offsets.put(entity, offset);
            this.baseDirections.put(entity, entity.getLocation().getDirection());
        }
    }

    public boolean rotate(float yawDelta, float pitchDelta) {
        this.totalYaw += yawDelta;
        this.totalPitch += pitchDelta;
        double yawRad = Math.toRadians(this.totalYaw);
        double pitchRad = Math.toRadians(this.totalPitch);
        double cosYaw = Math.cos(yawRad);
        double sinYaw = Math.sin(yawRad);
        double cosPitch = Math.cos(pitchRad);
        double sinPitch = Math.sin(pitchRad);
        boolean max = false;
        for (Map.Entry<Display, Vector> entry : this.offsets.entrySet()) {
            Display entity = entry.getKey();
            Vector originalOffset = entry.getValue();
            Vector baseDirection = this.baseDirections.get(entity);
            Vector rotatedOffset = this.rotateVector(originalOffset, cosYaw, sinYaw, cosPitch, sinPitch);
            Vector rotatedDirection = this.rotateVector(baseDirection, cosYaw, sinYaw, cosPitch, sinPitch).normalize();
            Location newLoc = this.center.clone().add(rotatedOffset);
            newLoc.setDirection(rotatedDirection);
            if (Math.abs(newLoc.getPitch()) == 90.0f) {
                entity.setTeleportDuration(0);
            } else {
                entity.setTeleportDuration(20);
            }
            entity.teleport(newLoc);
            if (max || Math.abs(newLoc.getPitch()) != 90.0f) continue;
            max = true;
        }
        return max;
    }

    public void rotateViaTeleport(float yawDelta, float pitchDelta) {
        this.totalYaw += yawDelta;
        this.totalPitch += pitchDelta;
        double yawRad = Math.toRadians(this.totalYaw);
        double pitchRad = Math.toRadians(this.totalPitch);
        double cosYaw = Math.cos(yawRad);
        double sinYaw = Math.sin(yawRad);
        double cosPitch = Math.cos(pitchRad);
        double sinPitch = Math.sin(pitchRad);
        for (Map.Entry<Display, Vector> entry : this.offsets.entrySet()) {
            Display entity = entry.getKey();
            Vector originalOffset = entry.getValue();
            Vector baseDirection = this.baseDirections.get(entity);
            Vector rotatedOffset = this.rotateVector(originalOffset, cosYaw, sinYaw, cosPitch, sinPitch);
            Vector rotatedDirection = this.rotateVector(baseDirection, cosYaw, sinYaw, cosPitch, sinPitch).normalize();
            Location newLoc = this.center.clone().add(rotatedOffset);
            newLoc.setDirection(rotatedDirection);
            entity.teleport(newLoc);
            entity.setTeleportDuration(20);
        }
    }

    private Vector rotateVector(Vector vec, double cosYaw, double sinYaw, double cosPitch, double sinPitch) {
        double x = vec.getX();
        double y = vec.getY();
        double z = vec.getZ();
        double y1 = y * cosPitch - z * sinPitch;
        double z1 = y * sinPitch + z * cosPitch;
        double x2 = x * cosYaw - z1 * sinYaw;
        double z2 = x * sinYaw + z1 * cosYaw;
        return new Vector(x2, y1, z2);
    }
}

