/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Planets.SpaceObjects;

import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import java.util.HashSet;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public abstract class SpaceObject {
    private Location currentLocation;
    private Location targetLocation;
    private int displayMoveSpeed = 0;
    public boolean removed = false;
    public HashSet<Entity> ents = new HashSet();

    public SpaceObject(Location location) {
        this.currentLocation = location;
        new BukkitRunnable(){

            public void run() {
                if (SpaceObject.this.removed) {
                    this.cancel();
                    return;
                }
                SpaceObject.this.tick();
            }
        }.runTaskTimer(MineMain.getPlugin(), 0L, 20L);
    }

    public Location getLocation() {
        return this.currentLocation.clone();
    }

    public void setLocation(Location location) {
        this.currentLocation = location;
    }

    public void tick() {
        this.render(false);
        this.postTick(false);
    }

    public abstract void postTick(boolean var1);

    public Location getTargetLocation() {
        return this.targetLocation.clone();
    }

    public void setTargetLocation(Location targetLocation) {
        this.targetLocation = targetLocation;
    }

    public void render(boolean forceRender) {
        if (MinetorioListener.isPlayerNearby2DOPTDEBUG(this.getLocation(), (double)MineMain.chunkViewDistance * 0.95) || forceRender) {
            if (this.ents.size() == 0) {
                this.ents = this.createRender();
                for (Entity entity : this.ents) {
                    MineUtil.setDisposableEntity(entity);
                    if (!(entity instanceof Display)) continue;
                    Display display = (Display)entity;
                    display.setViewRange((float)(MineMain.chunkViewDistance / 16));
                    if (forceRender) continue;
                    final BlockDisplay bd = (BlockDisplay)display;
                    final BlockData bdO = bd.getBlock().clone();
                    bd.setBlock(Material.AIR.createBlockData());
                    Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                        @Override
                        public void run() {
                            if (bd == null || bd.isDead()) {
                                return;
                            }
                            bd.setBlock(bdO);
                        }
                    }, 20L);
                }
            }
        } else if (this.ents.size() > 0) {
            this.removeEnts();
        }
    }

    public abstract void derender();

    public void removeObject() {
        this.removeEnts();
        this.removed = true;
    }

    public abstract void onRemove();

    public void removeEnts() {
        for (Entity entity : this.ents) {
            entity.remove();
        }
        this.ents.clear();
    }

    public abstract HashSet<Entity> createRender();

    public Location moveTowards(Location from, Location to, double maxDistance) {
        if (!from.getWorld().equals(to.getWorld())) {
            throw new IllegalArgumentException("Locations must be in the same world.");
        }
        Vector direction = to.toVector().subtract(from.toVector());
        double distance = direction.length();
        if (distance <= maxDistance || distance == 0.0) {
            return to.clone();
        }
        direction.normalize().multiply(maxDistance);
        return from.clone().add(direction);
    }

    public int getDisplayMoveSpeed() {
        return this.displayMoveSpeed;
    }

    public void setDisplayMoveSpeed(int displayMoveSpeed) {
        this.displayMoveSpeed = displayMoveSpeed;
    }
}

