/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Planets;

import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.World;

public class WeatherController {
    private final String worldName;
    private long ticksUntilNextRain = 0L;
    private final Random random = new Random();
    private double stormLevel = 1.0;

    public WeatherController(String world, double stormLvl) {
        this.worldName = world;
        this.stormLevel = stormLvl;
        this.scheduleNextRain();
    }

    public void changeStormLevel(double level) {
        this.stormLevel = level;
    }

    public void tick() {
        if (this.stormLevel == 1.0) {
            return;
        }
        if (this.stormLevel == 0.0) {
            World world = Bukkit.getWorld((String)this.worldName);
            if (world == null) {
                return;
            }
            if (world.hasStorm()) {
                world.setStorm(false);
            }
        }
        this.ticksUntilNextRain -= 20L;
        if (this.ticksUntilNextRain <= 0L) {
            this.startRain();
            this.scheduleNextRain();
        }
    }

    private void startRain() {
        if (Bukkit.getWorld((String)this.worldName) == null) {
            return;
        }
        Bukkit.getWorld((String)this.worldName).setStorm(true);
        int rainDuration = 12000 + this.random.nextInt(24000);
        Bukkit.getWorld((String)this.worldName).setWeatherDuration(rainDuration);
    }

    private void scheduleNextRain() {
        double stormModifier = 1.0 / this.stormLevel;
        long baseDelay = 12000 + this.random.nextInt(168000);
        this.ticksUntilNextRain = (long)((double)baseDelay * stormModifier);
    }
}

