/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Pollution;

import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Mover;
import com.MT.xxxtrigger50xxx.Devices.VanillaDevice;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.Pollution.PollutionListener;
import com.MT.xxxtrigger50xxx.Pollution.SuperChunk;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.LlamaSpit;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.Vector;

public class BiterAttack {
    private static HashSet<BiterAttack> allAttacks = new HashSet();
    public ArrayList<String> biters = new ArrayList();
    public Location gatherLocation = null;
    public Location attackLocation = null;
    public Location convoyLocation = null;
    public AttackStage currentStage = AttackStage.GATHERING;
    private int gatherTime = MineMain.attackGatherTime;
    private UUID uuid;
    private HashSet<UUID> spitCooldown = new HashSet();
    private int attackTargetTimeout = 180;
    public boolean onlyTargetsPolluting = true;
    private HashMap<Location, Material> pendingRegens = new HashMap();
    private HashSet<Location> attackWebs = new HashSet();
    private LivingEntity attackTargetEntity = null;
    private Device targetDevice = null;
    private ArrayList<LivingEntity> spawnedBiters = new ArrayList();
    private ArrayList<Device> nearbyDevices = new ArrayList();
    private static HashMap<Location, Integer> locationHP = new HashMap();
    private static HashSet<Location> allWebs = new HashSet();
    private static HashMap<Material, Integer> bakedBaseHPS = new HashMap();
    private static HashMap<Chunk, Integer> attackChunks = new HashMap();

    public BiterAttack(Location gatherSpot) {
        this.gatherLocation = gatherSpot;
        allAttacks.add(this);
        this.setUuid(UUID.randomUUID());
    }

    public Location getGatherLocation() {
        return this.gatherLocation;
    }

    public static HashSet<BiterAttack> getAllAttacks() {
        return new HashSet<BiterAttack>(allAttacks);
    }

    public void setGatherTime(int time) {
        this.gatherTime = time;
    }

    public static void joinAttack(Location from, String biterType) {
        if (!MineMain.useBiterAttacks) {
            return;
        }
        BiterAttack ba = BiterAttack.getNearestAttack(from);
        if (ba == null) {
            if (allAttacks.size() >= MineMain.maxConcurrentBiterAttacks) {
                return;
            }
            int xR = TUMaths.rollRange(16, 32);
            int yR = TUMaths.rollRange(16, 32);
            if (TUMaths.rollRange(0, 1) == 0) {
                xR *= -1;
            }
            if (TUMaths.rollRange(0, 1) == 0) {
                yR *= -1;
            }
            Location loc = from.getWorld().getHighestBlockAt(from.add((double)xR, 0.0, (double)yR)).getLocation().add(0.0, 1.0, 0.0);
            ba = new BiterAttack(loc);
        }
        ba.addBiter(biterType);
    }

    public static BiterAttack getNearestAttack(Location loc) {
        BiterAttack attack = null;
        for (BiterAttack ba : BiterAttack.getAllAttacks()) {
            int distance;
            if (!ba.getCurrentStage().equals((Object)AttackStage.GATHERING) || ba.biters.size() >= MineMain.attackBitersMax || (distance = TUMaths.get2DManhattanDistance(ba.getGatherLocation(), loc)) > 96) continue;
            if (attack == null) {
                attack = ba;
                continue;
            }
            if (distance >= TUMaths.get2DManhattanDistance(attack.getGatherLocation(), loc)) continue;
            attack = ba;
        }
        return attack;
    }

    public AttackStage getCurrentStage() {
        return this.currentStage;
    }

    public void setCurrentStage(AttackStage currentStage) {
        this.currentStage = currentStage;
    }

    public void addBiter(String biterType) {
        this.biters.add(biterType);
    }

    public void setAttackLocation(Location loc) {
        this.attackLocation = loc;
    }

    public void tickAttack() {
        block61: {
            if (this.currentStage.equals((Object)AttackStage.GATHERING)) {
                if (this.gatherTime > 0) {
                    --this.gatherTime;
                    return;
                }
                this.currentStage = AttackStage.FIND_TARGET;
            }
            if (this.currentStage.equals((Object)AttackStage.FIND_TARGET)) {
                if (this.attackLocation == null) {
                    this.findTarget();
                }
                if (this.attackLocation != null) {
                    this.currentStage = AttackStage.MOVING;
                    if (this.convoyLocation == null) {
                        this.convoyLocation = this.getGatherLocation();
                    }
                } else {
                    --this.attackTargetTimeout;
                    if (this.attackTargetTimeout <= 0) {
                        this.endAttack();
                        return;
                    }
                }
            }
            if (this.currentStage.equals((Object)AttackStage.MOVING)) {
                if (this.convoyLocation == null) {
                    this.convoyLocation = this.getGatherLocation();
                }
                Vector direction = this.attackLocation.toVector().subtract(this.convoyLocation.toVector()).normalize();
                Vector scaledDirection = direction.multiply(1);
                this.convoyLocation = this.convoyLocation.add(scaledDirection);
                ArrayList<Device> trailNearby = Device.getNearbyDevices(this.convoyLocation, 50, true, null);
                if (trailNearby.size() > 0) {
                    if (this.onlyTargetsPolluting) {
                        this.findTarget();
                    } else {
                        this.attackLocation = trailNearby.get(0).getLocation();
                    }
                }
                if (TUMaths.getManhattanDistance(this.convoyLocation, this.attackLocation) <= 100) {
                    this.currentStage = AttackStage.ATTACKING;
                    Location spawnLocation = this.convoyLocation.getWorld().getHighestBlockAt(this.convoyLocation.getChunk().getBlock(7, 0, 7).getLocation()).getLocation().add(0.0, 1.0, 0.0);
                    for (String biter : this.biters) {
                        this.spawnBiter(spawnLocation, biter);
                    }
                    this.nearbyDevices = Device.getNearbyDevices(this.attackLocation, 100, true, null);
                    for (Chunk chunk : TUMaths.getAreaChunks(spawnLocation.clone().add(-8.0, 0.0, -8.0), spawnLocation.clone().add(8.0, 0.0, 8.0))) {
                        BiterAttack.addAttackChunk(chunk, 60);
                    }
                }
            }
            if (!this.currentStage.equals((Object)AttackStage.ATTACKING)) break block61;
            this.createAttackEntity();
            for (LivingEntity lent : new ArrayList<LivingEntity>(this.spawnedBiters)) {
                boolean canSpit;
                String biterType;
                boolean attackedDevice;
                block62: {
                    if (lent.isDead()) {
                        this.spawnedBiters.remove(lent);
                        continue;
                    }
                    if (this.targetDevice != null) {
                        for (Chunk chunk : TUMaths.getAreaChunks(lent.getLocation(), this.targetDevice.getLocation())) {
                            BiterAttack.addAttackChunk(chunk, 60);
                        }
                    } else {
                        BiterAttack.addAttackChunk(lent.getLocation().getChunk(), 60);
                    }
                    if (TUMaths.get2DManhattanDistance(lent.getLocation(), this.convoyLocation) <= this.biters.size() / 2 + 1 && !attackChunks.containsKey(lent.getLocation().getChunk())) continue;
                    attackedDevice = false;
                    biterType = ((MetadataValue)lent.getMetadata("MT-Biter").get(0)).asString();
                    if (this.targetDevice == null || this.targetDevice.isRemoved()) break block62;
                    boolean damageTargetLocation = false;
                    if (lent.getLocation().distanceSquared(this.attackTargetEntity.getLocation()) <= 3.0) {
                        damageTargetLocation = true;
                    } else if (biterType.contains("Spitter") && !this.spitCooldown.contains(lent.getUniqueId())) {
                        Location eyeLoc = lent.getEyeLocation();
                        if (TUMaths.getManhattanDistance(eyeLoc, this.targetDevice.getLocation()) > 8) continue;
                        canSpit = true;
                        for (Location loc : MineUtil.getBlockLine(eyeLoc, this.targetDevice.getLocation(), 0.25)) {
                            if (!loc.getBlock().getType().isSolid() || !(eyeLoc.distanceSquared(loc) >= 1.0)) continue;
                            canSpit = false;
                            break;
                        }
                        if (canSpit) {
                            damageTargetLocation = true;
                            this.shootSpit(lent, this.targetDevice.getLocation().add(0.5, 0.0, 0.5));
                        }
                    }
                    if (!damageTargetLocation) break block62;
                    int damage = 1;
                    switch (biterType) {
                        case "Medium Biter": {
                            damage = 2;
                            break;
                        }
                        case "Big Biter": {
                            damage = 3;
                            break;
                        }
                        case "Behemoth Biter": {
                            damage = 4;
                            break;
                        }
                        case "Big Spitter": {
                            damage = 2;
                            break;
                        }
                        case "Behemoth Spitter": {
                            damage = 3;
                            break;
                        }
                        default: {
                            damage = 1;
                        }
                    }
                    int hp = this.damageLocation(this.targetDevice.getLocation(), damage);
                    attackedDevice = true;
                    if (hp > 0) continue;
                    this.nearbyDevices.remove(this.targetDevice);
                    this.targetDevice = null;
                    continue;
                }
                if (lent.getVelocity().length() <= 0.12 && !attackedDevice) {
                    this.damageLocation(BiterAttack.getClosestSolidBlockInFront(lent, 2), 1);
                }
                if (!attackedDevice) {
                    this.createWebLadder(lent);
                }
                if (!biterType.contains("Spitter") || this.spitCooldown.contains(lent.getUniqueId())) continue;
                for (Entity entity : lent.getNearbyEntities(8.0, 8.0, 8.0)) {
                    if (!entity.getType().equals((Object)EntityType.PLAYER)) continue;
                    canSpit = true;
                    for (Location loc : MineUtil.getBlockLine(lent.getEyeLocation(), entity.getLocation().add(0.0, 0.5, 0.0), 0.25)) {
                        if (!loc.getBlock().getType().isSolid() || !(lent.getEyeLocation().distanceSquared(loc) >= 1.0)) continue;
                        canSpit = false;
                        break;
                    }
                    if (!canSpit) continue;
                    Player player = (Player)entity;
                    this.shootSpit(lent, player.getEyeLocation());
                    player.damage(lent.getAttribute(MineMain.version.getAttackAttribute()).getValue());
                }
            }
            if (this.spawnedBiters.size() > 0) {
                if (this.targetDevice != null && this.targetDevice.isRemoved()) {
                    this.nearbyDevices.remove(this.targetDevice);
                    this.targetDevice = null;
                }
                if (this.targetDevice != null) {
                    for (LivingEntity lent : this.spawnedBiters) {
                        Monster mons = (Monster)lent;
                        if (mons.getTarget() != null) {
                            if (!mons.getTarget().getType().equals((Object)EntityType.PLAYER)) {
                                mons.setTarget(this.attackTargetEntity);
                            }
                        } else {
                            mons.setTarget(this.attackTargetEntity);
                        }
                        this.webLadderTeleport(lent);
                    }
                } else if (this.nearbyDevices.size() > 0) {
                    this.targetDevice = this.getNextDevice();
                    this.attackTargetEntity.teleport(this.targetDevice.getLocation().add(0.5, 0.0, 0.5));
                } else {
                    if (MineMain.victoryNests) {
                        SuperChunk sc = SuperChunk.getSuperChunk(this.attackTargetEntity.getLocation());
                        sc.spawnNest(this.attackTargetEntity.getLocation());
                    }
                    this.endAttack();
                }
            } else {
                this.endAttack();
            }
        }
        this.applySlowness();
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

            @Override
            public void run() {
                BiterAttack.this.applySlowness();
            }
        }, 10L);
    }

    private void shootSpit(LivingEntity lent, Location target) {
        Location eyeLoc = lent.getEyeLocation();
        if (TUMaths.isPlayerNearby(eyeLoc, 64.0)) {
            BiterAttack.llamaSpitAt(eyeLoc, target);
        }
        final UUID id = lent.getUniqueId();
        this.spitCooldown.add(id);
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

            @Override
            public void run() {
                BiterAttack.this.spitCooldown.remove(id);
            }
        }, 40L);
    }

    public void addRegenBlock(Block block) {
        if (MineMain.regenAllVanillaFromBiters || BiterAttack.getRegenTypes().contains(block.getType()) && !this.pendingRegens.containsKey(block.getLocation())) {
            this.pendingRegens.put(block.getLocation(), block.getType());
        }
    }

    private static ArrayList<Material> getRegenTypes() {
        ArrayList<Material> types = new ArrayList<Material>();
        types.add(Material.GRASS_BLOCK);
        types.add(Material.DIRT);
        types.add(Material.STONE);
        types.add(Material.SAND);
        types.add(Material.GRAVEL);
        types.add(Material.CLAY);
        types.add(Material.SANDSTONE);
        Material[] materialArray = Material.values();
        int n = materialArray.length;
        int n2 = 0;
        while (n2 < n) {
            Material mat = materialArray[n2];
            if (mat.toString().contains("LEAVES")) {
                types.add(mat);
            }
            ++n2;
        }
        return types;
    }

    public void endAttack() {
        allAttacks.remove(this);
        if (this.attackTargetEntity != null) {
            this.attackTargetEntity.remove();
        }
        ArrayList<Location> removeWebs = new ArrayList<Location>();
        for (Location loc : this.attackWebs) {
            if (loc.getBlock().getType().equals((Object)Material.COBWEB) || loc.getBlock().getType().equals((Object)Material.WHITE_WOOL)) {
                loc.getBlock().setType(Material.AIR);
            }
            allWebs.remove(loc);
            removeWebs.add(loc);
        }
        for (Location loc : removeWebs) {
            this.attackWebs.remove(loc);
        }
        for (LivingEntity lent : new ArrayList<LivingEntity>(this.spawnedBiters)) {
            lent.remove();
        }
        for (Location loc : new ArrayList<Location>(this.pendingRegens.keySet())) {
            loc.getBlock().setType(this.pendingRegens.get(loc));
        }
    }

    private void spawnBiter(Location spawnLocation, String biterType) {
        int radius = this.biters.size() / 2;
        if (radius <= 0) {
            radius = 1;
        }
        if (radius > 8) {
            radius = 8;
        }
        Location spawnLoc = TUMaths.getRandomLocationAroundLocation(spawnLocation, radius);
        spawnLoc = spawnLoc.getWorld().getHighestBlockAt(spawnLoc).getLocation().add(0.0, 2.0, 0.0);
        LivingEntity lent = PollutionListener.spawnBiter(spawnLocation, biterType);
        this.spawnedBiters.add(lent);
    }

    private void createWebLadder(LivingEntity lent) {
        Iterator<Block> iterator;
        if (TUMaths.get2DManhattanDistance(lent.getLocation(), this.attackTargetEntity.getLocation()) <= 1 && lent.getLocation().getY() < this.attackTargetEntity.getLocation().getY() && (iterator = TUMaths.getNearbyBlocks(lent.getLocation().getBlock(), Material.AIR, 1).iterator()).hasNext()) {
            final Block block = iterator.next();
            block.setType(Material.WHITE_WOOL);
            allWebs.add(block.getLocation());
            this.attackWebs.add(block.getLocation());
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    if (allWebs.contains(block.getLocation())) {
                        Location loc = block.getLocation();
                        if (loc.getBlock().getType().equals((Object)Material.COBWEB) || loc.getBlock().getType().equals((Object)Material.WHITE_WOOL)) {
                            loc.getBlock().setType(Material.AIR);
                        }
                        allWebs.remove(loc);
                        BiterAttack.this.attackWebs.remove(loc);
                    }
                }
            }, 600L);
        }
    }

    private void webLadderTeleport(LivingEntity lent) {
        if (lent.getLocation().getBlock().getType().equals((Object)Material.WHITE_WOOL)) {
            lent.teleport(lent.getLocation().add(0.0, 1.0, 0.0));
        }
        if (lent.getLocation().add(0.0, 1.0, 0.0).getBlock().getType().equals((Object)Material.WHITE_WOOL) && lent.getLocation().add(0.0, 1.0, 0.0).getBlock().getType().isAir()) {
            lent.teleport(lent.getLocation().add(0.0, 2.0, 0.0));
        }
    }

    private void applySlowness() {
        for (LivingEntity lent : new ArrayList<LivingEntity>(this.spawnedBiters)) {
            if (lent.isDead()) {
                this.spawnedBiters.remove(lent);
                continue;
            }
            if (!lent.isClimbing()) continue;
            if (lent.hasPotionEffect(MineMain.version.getSlownessEffect())) {
                lent.removePotionEffect(MineMain.version.getSlownessEffect());
            }
            lent.addPotionEffect(new PotionEffect(MineMain.version.getSlownessEffect(), 21, 10));
        }
    }

    private Device getNextDevice() {
        Device next = null;
        for (Device device : this.nearbyDevices) {
            if (next == null) {
                next = device;
                continue;
            }
            if (!(device.getLocation().distanceSquared(this.attackTargetEntity.getLocation()) < next.getLocation().distanceSquared(this.attackTargetEntity.getLocation()))) continue;
            next = device;
        }
        return next;
    }

    private void createAttackEntity() {
        if (this.attackTargetEntity == null) {
            this.attackTargetEntity = (LivingEntity)this.convoyLocation.getWorld().spawnEntity(this.convoyLocation, EntityType.VILLAGER);
            this.attackTargetEntity.setInvulnerable(true);
            this.attackTargetEntity.setAI(false);
            this.attackTargetEntity.setCollidable(false);
            this.attackTargetEntity.setSilent(true);
            this.attackTargetEntity.setInvisible(true);
        }
    }

    public ArrayList<LivingEntity> getSpawnedBiters() {
        return new ArrayList<LivingEntity>(this.spawnedBiters);
    }

    private void findTarget() {
        SuperChunk sc = SuperChunk.getSuperChunk(this.gatherLocation);
        if (sc.hasPollutionSource()) {
            this.findAttackable(sc);
        } else {
            int scX = sc.x;
            int scZ = sc.z;
            String world = this.gatherLocation.getWorld().getName();
            int radius = 1;
            while (radius <= 10) {
                int x = radius * -1;
                while (x <= radius) {
                    int z = radius * -1;
                    while (z <= radius) {
                        if (SuperChunk.superChunkExists(scX + x, scZ + z) && (sc = SuperChunk.getSuperChunk(scX + x, scZ + z, world)).hasPollutionSource() && this.findAttackable(sc)) {
                            return;
                        }
                        ++z;
                    }
                    ++x;
                }
                ++radius;
            }
        }
    }

    private boolean findAttackable(SuperChunk sc) {
        if (MineMain.attackOnlyOnline) {
            for (Location loc : sc.getPollutionSources()) {
                UUID uuid;
                Device device = Device.getDevice(loc);
                if (device == null || device.getPlacerUUIDString() == null || Bukkit.getPlayer((UUID)(uuid = UUID.fromString(device.getPlacerUUIDString()))) == null || !Bukkit.getPlayer((UUID)uuid).isOnline()) continue;
                this.attackLocation = sc.getPollutionSources().get(0);
                return true;
            }
        } else {
            this.attackLocation = sc.getPollutionSources().get(0);
            return true;
        }
        return false;
    }

    public static boolean healBlock(Block block) {
        if (locationHP.containsKey(block.getLocation())) {
            locationHP.remove(block.getLocation());
            return true;
        }
        return false;
    }

    public int damageLocation(Location loc, int damage) {
        int newHP;
        if (loc == null || loc.getBlock().getType().isAir() || allWebs.contains(loc)) {
            return 0;
        }
        if (!locationHP.containsKey(loc)) {
            locationHP.put(loc, BiterAttack.getBaseHP(loc.getBlock().getType()));
        }
        if ((newHP = locationHP.get(loc) - damage) <= 0) {
            VanillaDevice vd;
            Mover mover;
            boolean handled = false;
            Device device = Device.getDevice(loc);
            if (device != null) {
                handled = true;
                device.removeDevice();
            }
            if (!handled && (mover = Mover.getMover(loc)) != null) {
                handled = true;
                mover.removeMover();
            }
            if (!handled && VanillaDevice.isVanillaDevice(loc) && (vd = VanillaDevice.getVanillaDevice(loc)) != null) {
                handled = true;
                vd.removeVanillaDevice();
            }
            if (!handled) {
                this.addRegenBlock(loc.getBlock());
            }
            locationHP.remove(loc);
            loc.getBlock().setType(Material.AIR);
            for (Block block : TUMaths.getNearbyBlocks6Sided(loc.getBlock())) {
                Mover mover2 = Mover.getMover(block.getLocation());
                if (mover2 == null) continue;
                mover2.buildMoverInfo();
            }
            if (TUMaths.isPlayerNearby(loc, MineMain.nearDistance)) {
                loc.getWorld().playSound(loc, Sound.ENTITY_ZOMBIE_BREAK_WOODEN_DOOR, 0.5f, 1.0f);
            }
        } else {
            locationHP.put(loc, locationHP.get(loc) - damage);
            if (TUMaths.isPlayerNearby(loc, MineMain.nearDistance)) {
                loc.getWorld().playSound(loc, Sound.ENTITY_ZOMBIE_ATTACK_WOODEN_DOOR, 0.5f, 1.0f);
            }
        }
        return newHP;
    }

    private static int getBaseHP(Material type) {
        if (bakedBaseHPS.size() == 0) {
            bakedBaseHPS.put(Material.DIRT, 3);
            bakedBaseHPS.put(Material.GRASS_BLOCK, 3);
            bakedBaseHPS.put(Material.SMOOTH_STONE, 10);
            bakedBaseHPS.put(Material.SMOOTH_STONE_SLAB, 5);
            BiterAttack.bakeBaseBlock(Material.END_STONE, 8);
            BiterAttack.bakeBaseBlock(Material.RED_SANDSTONE, 8);
            BiterAttack.bakeBaseBlock(Material.SANDSTONE, 8);
            BiterAttack.bakeBaseBlock(Material.COBBLED_DEEPSLATE, 8);
            BiterAttack.bakeBaseBlock(Material.COBBLESTONE, 6);
            BiterAttack.bakeBaseBlock(Material.STONE_BRICKS, 15);
            BiterAttack.bakeBaseBlock(Material.BRICKS, "BRICK", 15);
            BiterAttack.bakeBaseBlock(Material.MUD_BRICKS, "MUD_BRICK", 8);
            Material[] materialArray = Material.values();
            int n = materialArray.length;
            int n2 = 0;
            while (n2 < n) {
                Material mat = materialArray[n2];
                if (mat.toString().contains("CONCRETE") && !mat.toString().contains("POWDER")) {
                    bakedBaseHPS.put(mat, 20);
                }
                if (mat.toString().contains("LOG")) {
                    bakedBaseHPS.put(mat, 8);
                }
                if (mat.toString().contains("LEAVES") || mat.toString().contains("WOOL") || mat.toString().contains("GLASS")) {
                    bakedBaseHPS.put(mat, 1);
                }
                ++n2;
            }
        }
        return bakedBaseHPS.getOrDefault(type, 5);
    }

    private static void bakeBaseBlock(Material baseBlock, int hp) {
        bakedBaseHPS.put(baseBlock, hp);
        Material mat = Material.matchMaterial((String)(baseBlock.toString() + "_STAIRS"));
        if (mat != null) {
            bakedBaseHPS.put(baseBlock, (int)Math.ceil((double)hp * 0.75));
        }
        if ((mat = Material.matchMaterial((String)(baseBlock.toString() + "_SLAB"))) != null) {
            bakedBaseHPS.put(baseBlock, (int)Math.ceil((double)hp * 0.5));
        }
        if ((mat = Material.matchMaterial((String)(baseBlock.toString() + "_WALL"))) != null) {
            bakedBaseHPS.put(baseBlock, hp);
        }
    }

    private static void bakeBaseBlock(Material baseBlock, String altMat, int hp) {
        bakedBaseHPS.put(baseBlock, hp);
        Material mat = Material.matchMaterial((String)(altMat + "_STAIRS"));
        if (mat != null) {
            bakedBaseHPS.put(mat, (int)Math.ceil((double)hp * 0.75));
        }
        if ((mat = Material.matchMaterial((String)(altMat + "_SLAB"))) != null) {
            bakedBaseHPS.put(mat, (int)Math.ceil((double)hp * 0.5));
        }
        if ((mat = Material.matchMaterial((String)(altMat + "_WALL"))) != null) {
            bakedBaseHPS.put(mat, hp);
        }
    }

    public static Location getClosestSolidBlockInFront(LivingEntity entity, int distance) {
        Location eyeLocation = entity.getEyeLocation();
        Vector direction = eyeLocation.getDirection().normalize();
        BlockFace facing = BiterAttack.getCardinalDirection(entity);
        int i = 1;
        while (i <= distance) {
            Location checkLocation = eyeLocation.clone().add(direction.clone().multiply(i));
            Block block = checkLocation.getBlock();
            Location loc = null;
            loc = BiterAttack.getSolidLocation(block);
            if (loc != null) {
                return loc;
            }
            loc = BiterAttack.getSolidLocation(block.getRelative(TUMaths.rotateBlockFace(facing, 90)));
            if (loc != null) {
                return loc;
            }
            loc = BiterAttack.getSolidLocation(block.getRelative(TUMaths.rotateBlockFace(facing, -90)));
            if (loc != null) {
                return loc;
            }
            ++i;
        }
        for (Block block : TUMaths.getNearbyBlocks(entity.getLocation().getBlock(), 1)) {
            if (!block.getType().isSolid() || allWebs.contains(block.getLocation())) continue;
            return block.getLocation();
        }
        for (Block block : TUMaths.getNearbyBlocks(entity.getLocation().add(0.0, 1.0, 0.0).getBlock(), 1)) {
            if (!block.getType().isSolid() || allWebs.contains(block.getLocation())) continue;
            return block.getLocation();
        }
        for (Block block : TUMaths.getNearbyBlocks(entity.getLocation().add(0.0, -1.0, 0.0).getBlock(), 1)) {
            if (!block.getType().isSolid() || allWebs.contains(block.getLocation())) continue;
            return block.getLocation();
        }
        return null;
    }

    private static Location getSolidLocation(Block block) {
        if (block.getType().isSolid() && !allWebs.contains(block.getLocation())) {
            return block.getLocation();
        }
        if (block.getRelative(BlockFace.UP).getType().isSolid() && !allWebs.contains(block.getLocation())) {
            return block.getRelative(BlockFace.UP).getLocation();
        }
        if (block.getRelative(BlockFace.DOWN).getType().isSolid() && !allWebs.contains(block.getLocation())) {
            return block.getRelative(BlockFace.DOWN).getLocation();
        }
        return null;
    }

    public static BlockFace getCardinalDirection(LivingEntity entity) {
        float yaw = entity.getLocation().getYaw();
        return BiterAttack.getCardinalDirectionFromYaw(yaw);
    }

    private static BlockFace getCardinalDirectionFromYaw(float yaw) {
        if ((yaw %= 360.0f) < 0.0f) {
            yaw += 360.0f;
        }
        if (yaw >= 315.0f || yaw < 45.0f) {
            return BlockFace.SOUTH;
        }
        if (yaw >= 45.0f && yaw < 135.0f) {
            return BlockFace.WEST;
        }
        if (yaw >= 135.0f && yaw < 225.0f) {
            return BlockFace.NORTH;
        }
        if (yaw >= 225.0f && yaw < 315.0f) {
            return BlockFace.EAST;
        }
        return BlockFace.SOUTH;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    private static void addAttackChunk(Chunk chunk, int seconds) {
        attackChunks.put(chunk, seconds);
        chunk.addPluginChunkTicket(MineMain.getPlugin());
    }

    public static void tickAttackChunks() {
        for (Chunk chunk : new ArrayList<Chunk>(attackChunks.keySet())) {
            attackChunks.put(chunk, attackChunks.get(chunk) - 1);
            if (attackChunks.get(chunk) > 0) continue;
            chunk.removePluginChunkTicket(MineMain.getPlugin());
            attackChunks.remove(chunk);
        }
    }

    public static void llamaSpitAt(Location from, Location to) {
        World world = from.getWorld();
        if (world == null) {
            return;
        }
        LlamaSpit spit = (LlamaSpit)world.spawn(from, LlamaSpit.class);
        spit.setPersistent(false);
        Vector direction = to.toVector().subtract(from.toVector()).normalize().multiply(1.2);
        spit.setVelocity(direction);
        from.getWorld().playSound(from, Sound.ENTITY_SPIDER_AMBIENT, 1.0f, 1.2f);
        from.getWorld().playSound(from, Sound.ENTITY_LLAMA_SPIT, 1.0f, 0.8f);
    }

    public static enum AttackStage {
        GATHERING,
        FIND_TARGET,
        MOVING,
        ATTACKING;

    }
}

