/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Pollution;

import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.Pollution.BiterAttack;
import com.MT.xxxtrigger50xxx.Pollution.PollutionListener;
import com.MT.xxxtrigger50xxx.Pollution.SuperChunk;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class BiterNest
extends Device {
    private static final long serialVersionUID = -5552409797254451315L;
    public static ArrayList<BiterNest> allNests = new ArrayList();
    private int storedPollution = 0;
    private int expansionPollution = 0;
    private int damage = 0;
    private HashMap<String, Integer> nestBiters = new HashMap();
    private String nestType = "Biter";
    private ArrayList<String> nestLocs = new ArrayList();
    private transient SuperChunk sc;
    private int spawnCoolDown = 0;
    private transient HashSet<LivingEntity> spawnedBiters = new HashSet();
    private boolean localExpansionLocked = false;
    private boolean nearbyExpansionLocked = false;

    public BiterNest(Location loc, boolean spawnBlock) {
        super(loc);
        this.setMaterial("SPAWNER");
        this.deviceName = "Biter Nest";
        this.setActionTimer(1);
        this.setOpenable(false);
        this.setStoreForm(false);
        this.setPollutionGen(100);
        PollutionListener.spawnNest(this, this.getLocation());
        if (spawnBlock) {
            this.getLocation().getBlock().setType(Material.SPAWNER);
        }
        SuperChunk sc = SuperChunk.getSuperChunk(this.getLocation());
        this.nestBiters.put("Small Biter", TUMaths.rollRange(3, 6));
        if (sc.getEvolutionPercent() >= 15 && TUMaths.rollRange(0, 99) <= 25) {
            this.nestType = "Spitter";
            this.nestBiters.put("Small Spitter", TUMaths.rollRange(2, 5));
            this.nestBiters.remove("Small Biter");
        }
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- This creates and spawns biters!");
        return lore;
    }

    @Override
    public void updateUI() {
    }

    public void addNestBlock(Block loc) {
        this.nestLocs.add(TUMaths.locationString(loc));
    }

    public ArrayList<Block> getNestBlocks() {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (String strLoc : this.nestLocs) {
            blocks.add(TUMaths.getStringLocation(strLoc).getBlock());
        }
        return blocks;
    }

    @Override
    public void action() {
        boolean bitersRendered;
        block24: {
            int expansionPrice;
            block25: {
                int pollToAdd;
                if (this.spawnedBiters == null) {
                    this.spawnedBiters = new HashSet();
                    allNests.add(this);
                }
                if (TUMaths.isPlayerNearby(this.getLocation(), MineMain.farDistance)) {
                    BiterNest.spawnRandomParticles(this.getLocation(), 7, 50);
                }
                if (bitersRendered = TUMaths.isPlayerNearby(this.getLocation(), MineMain.distantDistance * 2)) {
                    World world = this.getLocation().getWorld();
                    for (String biterType : new ArrayList<String>(this.nestBiters.keySet())) {
                        int needSpawning = this.nestBiters.get(biterType) - this.getSpawnedCount(biterType);
                        if (needSpawning <= 0) continue;
                        int i = 0;
                        while (i < needSpawning) {
                            Location spawnLoc = world.getHighestBlockAt(TUMaths.getRandomLocationAroundLocation(this.getLocation(), 7.0)).getLocation().add(0.0, 2.0, 0.0);
                            spawnLoc = TUMaths.centerLocation(spawnLoc, 0.0);
                            LivingEntity lent = PollutionListener.spawnBiter(spawnLoc, biterType);
                            this.spawnedBiters.add(lent);
                            lent.setMetadata("BITER-NEST", (MetadataValue)new FixedMetadataValue(MineMain.getPlugin(), (Object)this));
                            ++i;
                        }
                    }
                    this.bitersTargetPlayers();
                    for (Player player : this.getLocation().getWorld().getPlayers()) {
                        if (TUMaths.getManhattanDistance(player.getLocation(), this.getLocation()) > 16) continue;
                        PollutionListener.applyNestDebuff(player);
                    }
                } else {
                    this.derenderBiters(false);
                }
                if (this.sc == null) {
                    this.sc = SuperChunk.getSuperChunk(this.getLocation());
                }
                if ((pollToAdd = (int)((double)this.sc.getPollution() * 0.02)) > 0) {
                    this.sc.setPollution(this.sc.getPollution() - pollToAdd);
                    this.storedPollution += pollToAdd;
                }
                if (this.nearbyExpansionLocked || (expansionPrice = MineMain.nestExpansionPrice) == -1) break block24;
                if (this.expansionPollution >= expansionPrice) break block25;
                pollToAdd = (int)((double)this.sc.getPollution() * 0.02);
                if (pollToAdd <= 0) break block24;
                this.sc.setPollution(this.sc.getPollution() - pollToAdd);
                this.expansionPollution += pollToAdd;
                break block24;
            }
            if (!this.localExpansionLocked) {
                Location possible = this.sc.getPossibleNestLocation(true);
                if (possible != null) {
                    this.sc.attemptNestSpawn(true, true);
                    this.expansionPollution -= expansionPrice;
                } else {
                    this.localExpansionLocked = true;
                }
            }
            if (this.localExpansionLocked) {
                this.nearbyExpansionLocked = true;
                for (SuperChunk nearbySC : this.sc.getNeibors(false)) {
                    Location possible;
                    if (nearbySC.hasPollutionSource() || (possible = nearbySC.getPossibleNestLocation(true)) == null) continue;
                    nearbySC.attemptNestSpawn(true, true);
                    this.expansionPollution -= expansionPrice;
                    this.nearbyExpansionLocked = false;
                    break;
                }
            }
        }
        ++this.spawnCoolDown;
        if (!(this.spawnCoolDown >= 60 || bitersRendered && this.spawnCoolDown >= 15)) {
            return;
        }
        this.spawnCoolDown = 0;
        int nestAmount = 0;
        for (String type : new ArrayList<String>(this.nestBiters.keySet())) {
            nestAmount += this.nestBiters.get(type).intValue();
        }
        if (nestAmount <= MineMain.defenderBiters) {
            String spawnedType = this.getSpawnedType();
            if (spawnedType != null) {
                if (!this.nestBiters.containsKey(spawnedType)) {
                    this.nestBiters.put(spawnedType, 0);
                }
                this.nestBiters.put(spawnedType, this.nestBiters.get(spawnedType) + 1);
            } else if (nestAmount < 3) {
                spawnedType = this.nestType.equals("Spitter") ? "Small Spitter" : "Small Biter";
                if (!this.nestBiters.containsKey(spawnedType)) {
                    this.nestBiters.put(spawnedType, 0);
                }
                this.nestBiters.put(spawnedType, this.nestBiters.get(spawnedType) + 1);
            }
        } else {
            ArrayList<String> types = new ArrayList<String>(this.nestBiters.keySet());
            Collections.shuffle(types);
            String sent = types.get(0);
            this.nestBiters.put(sent, this.nestBiters.get(sent) - 1);
            if (this.nestBiters.get(sent) <= 0) {
                this.nestBiters.remove(sent);
            }
            BiterAttack.joinAttack(this.getLocation(), sent);
        }
    }

    public void killSpawnedBiter(LivingEntity lent) {
        if (this.spawnedBiters.contains(lent)) {
            this.spawnedBiters.remove(lent);
            String type = ((MetadataValue)lent.getMetadata("MT-Biter").get(0)).asString();
            this.nestBiters.put(type, this.nestBiters.get(type) - 1);
        }
    }

    private int getSpawnedCount(String type) {
        int amount = 0;
        for (LivingEntity lent : new HashSet<LivingEntity>(this.spawnedBiters)) {
            if (!lent.hasMetadata("MT-Biter") || !((MetadataValue)lent.getMetadata("MT-Biter").get(0)).asString().contains(type)) continue;
            ++amount;
        }
        return amount;
    }

    @Override
    public void cleanup() {
        this.derenderBiters(true);
    }

    @Override
    public void onDeviceRemove() {
        this.releaseBiters();
        if (this.nestLocs != null && this.nestLocs.size() > 0) {
            PollutionListener.removeNest(this, this.getLocation());
        } else {
            PollutionListener.removeNestOld(this.getLocation());
        }
        SuperChunk sc = SuperChunk.getSuperChunk(this.getLocation());
        sc.removeNestLocation(this.getLocation());
    }

    private void bitersTargetPlayers() {
        if (this.spawnedBiters == null) {
            this.spawnedBiters = new HashSet();
        }
        block0: for (LivingEntity lent : new HashSet<LivingEntity>(this.spawnedBiters)) {
            Monster monster;
            if (!TUMaths.isPlayerNearby(lent.getLocation(), 48.0) || !(lent instanceof Monster) || (monster = (Monster)lent).getTarget() != null) continue;
            for (Entity entity : lent.getNearbyEntities(30.0, 30.0, 30.0)) {
                Player player;
                if (!(entity instanceof Player) || !(player = (Player)entity).getGameMode().equals((Object)GameMode.SURVIVAL)) continue;
                monster.setTarget((LivingEntity)player);
                continue block0;
            }
        }
    }

    private void releaseBiters() {
        if (this.spawnedBiters == null) {
            this.spawnedBiters = new HashSet();
        }
        Plugin plugin = MineMain.getPlugin();
        for (LivingEntity lent : new HashSet<LivingEntity>(this.spawnedBiters)) {
            lent.removeMetadata("BITER-NEST", plugin);
            this.spawnedBiters.remove(lent);
            lent.damage(lent.getHealth() / 2.0);
        }
    }

    private void derenderBiters(boolean forced) {
        if (this.spawnedBiters == null) {
            this.spawnedBiters = new HashSet();
        }
        for (LivingEntity lent : new HashSet<LivingEntity>(this.spawnedBiters)) {
            if (TUMaths.isPlayerNearby(lent.getLocation(), 48.0) && !forced) continue;
            lent.remove();
            this.spawnedBiters.remove(lent);
        }
    }

    private static void spawnRandomParticles(final Location center, final int radius, int amount) {
        final World world = center.getWorld();
        if (world == null) {
            return;
        }
        int count = 0;
        long delay = 0L;
        final Random random = new Random();
        int i = 0;
        while (i < amount) {
            if (++count >= 5) {
                count = 0;
                ++delay;
            }
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    double offsetX = (random.nextDouble() * 2.0 - 1.0) * (double)radius;
                    double offsetY = (random.nextDouble() * 2.0 - 1.0) * (double)radius;
                    double offsetZ = (random.nextDouble() * 2.0 - 1.0) * (double)radius;
                    Location particleLocation = center.clone().add(offsetX, offsetY + 2.0, offsetZ);
                    world.spawnParticle(MineMain.version.getSmokeParticle(), particleLocation, 1, 0.0, 0.0, 0.0, 1.0E-5);
                }
            }, 0L + delay);
            ++i;
        }
    }

    private String getSpawnedType() {
        String type = null;
        int poll = this.storedPollution;
        int price = 0;
        SuperChunk sc = SuperChunk.getSuperChunk(this.getLocation());
        if (this.nestType.equals("Spitter")) {
            if ((double)poll >= 280.0 * MineMain.biterPriceMP && sc.getEvolutionPercent() >= 15) {
                type = "Small Spitter";
                price = (int)(280.0 * MineMain.biterPriceMP);
            }
            if ((double)poll >= 460.0 * MineMain.biterPriceMP && sc.getEvolutionPercent() >= 20) {
                type = "Medium Spitter";
                price = (int)(460.0 * MineMain.biterPriceMP);
            }
            if ((double)poll >= 820.0 * MineMain.biterPriceMP && sc.getEvolutionPercent() >= 40) {
                type = "Big Spitter";
                price = (int)(820.0 * MineMain.biterPriceMP);
            }
            if ((double)poll >= 1540.0 * MineMain.biterPriceMP && sc.getEvolutionPercent() >= 70) {
                type = "Behemoth Spitter";
                price = (int)(1540.0 * MineMain.biterPriceMP);
            }
        } else {
            if ((double)poll >= 180.0 * MineMain.biterPriceMP) {
                type = "Small Biter";
                price = (int)(180.0 * MineMain.biterPriceMP);
            }
            if ((double)poll >= 360.0 * MineMain.biterPriceMP && sc.getEvolutionPercent() >= 10) {
                type = "Medium Biter";
                price = (int)(360.0 * MineMain.biterPriceMP);
            }
            if ((double)poll >= 720.0 * MineMain.biterPriceMP && sc.getEvolutionPercent() >= 30) {
                type = "Big Biter";
                price = (int)(720.0 * MineMain.biterPriceMP);
            }
            if ((double)poll >= 1440.0 * MineMain.biterPriceMP && sc.getEvolutionPercent() >= 60) {
                type = "Behemoth Biter";
                price = (int)(1440.0 * MineMain.biterPriceMP);
            }
        }
        this.storedPollution -= price;
        return type;
    }

    public int getDamage() {
        return this.damage;
    }

    public void setDamage(int damage) {
        this.damage = damage;
        if (this.getDamage() >= 100) {
            this.getLocationREADONLY().getBlock().setType(Material.AIR);
        }
    }
}

