/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Recipes;

import com.MT.triggersUtility.Saveable;
import com.MT.triggersUtility.TUItems;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.Technology.TechTree;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class MTRecipe
extends Saveable {
    private static final long serialVersionUID = 7854376160787400151L;
    public static HashMap<String, MTRecipe> allRecipes = new HashMap();
    private boolean premiumRecipe = false;
    private boolean defaultRecipe = false;
    private String resultSTR;
    private ArrayList<String> ingsSTR = new ArrayList();
    private RecipeType type;
    private Device.LiquidType recipeLiquid;
    private int liquidAmount;
    private String recipeID;
    private transient ItemStack cachedResult;
    private transient ArrayList<ItemStack> cacheIngs;
    private transient int bucketCount = 0;
    private transient boolean checkedBuckets = false;
    private transient ArrayList<ItemStack> cacheIngsLiquids;
    private transient String cachedTech;

    public MTRecipe(ItemStack craft, ArrayList<ItemStack> ingredients, RecipeType type, boolean premiumRecipe, String recipeID) {
        super("Device Recipe Data", recipeID);
        this.setCraft(craft);
        this.setIngredients(ingredients);
        this.setType(type);
        this.premiumRecipe = premiumRecipe;
        this.setRecipeID(recipeID);
        this.save();
        allRecipes.put(this.getRecipeID(), this);
    }

    public void setCraft(ItemStack craft) {
        this.resultSTR = TUItems.createStackString(craft);
        this.cachedResult = null;
    }

    public void setIngredients(ArrayList<ItemStack> ingredients) {
        this.ingsSTR.clear();
        for (ItemStack stack : ingredients) {
            this.ingsSTR.add(TUItems.createStackString(stack));
        }
        this.cacheIngs = null;
        this.getIngredients();
        this.checkedBuckets = false;
        this.getBucketIngredientCount();
        this.save();
    }

    @Override
    public void onCreate(boolean isFirstTime) {
        if (!isFirstTime) {
            allRecipes.put(this.getRecipeID(), this);
        }
    }

    public boolean isPremiumRecipe() {
        return this.premiumRecipe;
    }

    public String getRecipeID() {
        return this.recipeID;
    }

    public ItemStack getResult() {
        if (this.cachedResult == null) {
            ItemStack stack;
            this.cachedResult = stack = TUItems.createStackFromString(this.resultSTR);
        }
        return this.cachedResult.clone();
    }

    public ArrayList<ItemStack> getIngredients() {
        if (this.cacheIngs == null) {
            this.cacheIngs = new ArrayList();
            for (String ingSTR : this.ingsSTR) {
                this.cacheIngs.add(TUItems.createStackFromString(ingSTR));
            }
        }
        return new ArrayList<ItemStack>(this.cacheIngs);
    }

    public RecipeType getType() {
        return this.type;
    }

    public void setType(RecipeType type) {
        this.type = type;
        this.save();
    }

    public int getBucketIngredientCount() {
        if (this.checkedBuckets) {
            return this.bucketCount;
        }
        for (ItemStack ing : this.getIngredientsRemoveLiquids()) {
            if (!ing.getType().toString().contains("BUCKET") || ing.getType().equals((Object)Material.BUCKET)) continue;
            ++this.bucketCount;
        }
        return this.bucketCount;
    }

    public ArrayList<ItemStack> getIngredientsRemoveLiquids() {
        if (this.cacheIngsLiquids == null) {
            ArrayList<ItemStack> stacks = this.getIngredients();
            for (ItemStack stack : this.getIngredients()) {
                if (!stack.getType().equals((Object)Material.WATER_BUCKET) || !stack.getItemMeta().hasDisplayName() || !stack.getItemMeta().getDisplayName().contains("LIQUID:")) continue;
                String[] parts = stack.getItemMeta().getDisplayName().split(":");
                this.setRecipeLiquid(Device.LiquidType.valueOf(parts[1]));
                this.setLiquidAmount(Integer.valueOf(parts[2]));
                stacks.remove(stack);
            }
            this.cacheIngsLiquids = stacks;
        }
        return this.cacheIngsLiquids;
    }

    public Device.LiquidType getRecipeLiquid() {
        return this.recipeLiquid;
    }

    public void setRecipeLiquid(Device.LiquidType recipeLiquid) {
        this.recipeLiquid = recipeLiquid;
    }

    public int getLiquidAmount() {
        return this.liquidAmount;
    }

    public void setLiquidAmount(int liquidAmount) {
        this.liquidAmount = liquidAmount;
    }

    public void setRecipeID(String recipeID) {
        if (this.getRecipeID() != null) {
            allRecipes.remove(this.getRecipeID());
            allRecipes.put(this.getRecipeID(), this);
        }
        this.recipeID = recipeID;
    }

    public void removeRecipeData() {
        allRecipes.remove(this.getRecipeID());
        this.setDelete(true);
        this.save();
        this.remove();
        this.getFile().delete();
    }

    public void disableRecipe() {
        allRecipes.remove(this.getRecipeID());
    }

    public boolean isDefaultRecipe() {
        return this.defaultRecipe;
    }

    public void setDefaultRecipe(boolean defaultRecipe) {
        this.defaultRecipe = defaultRecipe;
    }

    public String getRequiredTech() {
        if (this.cachedTech == null) {
            this.cachedTech = TechTree.getNeededTech(this.getResultsInternalName());
            if (this.cachedTech == null) {
                if (this.getRecipeID().equals("default_GUNPOWDER_ADVANCED")) {
                    this.cachedTech = "Flint Powder";
                }
                if (this.getRecipeID().equals("default_SF-1") || this.getRecipeID().equals("default_SF-2") || this.getRecipeID().equals("default_SF-3")) {
                    this.cachedTech = "Oil Technology";
                }
            }
        }
        return this.cachedTech;
    }

    public String getResultsInternalName() {
        String str = this.getRecipeID();
        str = str.replace("default_", "").replace("_BASIC", "").replace("_CRUDE", "").replace("_ADVANCED", "").replace("_", " ");
        return str;
    }

    public void updateCraftingIngredients() {
        for (ItemStack stack : this.getIngredients()) {
            MineItems.isIndustrialItem(stack);
        }
    }

    public static enum RecipeType {
        NONE,
        CRAFTING,
        CRUDE,
        BASIC,
        ADVANCED;

    }
}

