/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx;

import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.MineMain;

public class StoryTeller {
    private CloudCoverage currentCoverage = CloudCoverage.CLEAR;
    private int currentCloudLevel = 0;
    private int coverageTimer = 0;
    private int windTimer = 0;
    private double windLevel = 0.5;

    public CloudCoverage getCloudCoverage() {
        return this.currentCoverage;
    }

    public double getWindMod() {
        return this.windLevel;
    }

    public void rollWind() {
        this.windTimer = 0;
    }

    public void tickStoryTeller() {
        int rolled;
        --this.windTimer;
        if (this.windTimer <= 0) {
            this.windTimer = 900;
            rolled = TUMaths.rollRange(0, 99);
            if (rolled <= 10) {
                this.setWindLevel(TUMaths.rollRange(0.0, 0.2));
            }
            if (rolled > 10 && rolled < 40) {
                this.setWindLevel(TUMaths.rollRange(0.3, 0.5));
            }
            if (rolled >= 40 && rolled < 80) {
                this.setWindLevel(TUMaths.rollRange(0.6, 0.8));
            }
            if (rolled >= 80) {
                this.setWindLevel(TUMaths.rollRange(0.8, 1.0));
            }
            this.setWindLevel(TUMaths.roundDouble(this.getWindLevel(), 2));
        }
        --this.coverageTimer;
        if (this.coverageTimer <= 0) {
            this.coverageTimer = 600;
            rolled = TUMaths.rollRange(0, 99);
            if (rolled <= 5) {
                this.currentCoverage = CloudCoverage.CLEAR;
            }
            if (rolled > 5 && rolled <= 10) {
                this.currentCoverage = CloudCoverage.OVERCAST;
            }
            if (rolled > 10 && rolled <= 20) {
                this.currentCoverage = CloudCoverage.MOSTLY_CLEAR;
            }
            if (rolled > 20 && rolled <= 40) {
                this.currentCoverage = CloudCoverage.PARTLY_CLOUDY;
            }
            if (rolled > 40 && rolled <= 50) {
                this.currentCoverage = CloudCoverage.MOSTLY_CLOUDLY;
            }
            if (rolled > 50 && rolled <= 60) {
                this.currentCoverage = CloudCoverage.SCATTERED_CLOUDS;
            }
            if (rolled > 60 && rolled <= 70) {
                this.currentCoverage = CloudCoverage.BROKEN_CLOUDS;
            }
            if (rolled > 70) {
                this.currentCoverage = CloudCoverage.values()[TUMaths.rollRange(0, 6)];
            }
        }
        if (this.coverageTimer == 600 || TUMaths.isMultipleOf(this.coverageTimer, 30)) {
            switch (this.getCloudCoverage()) {
                case CLEAR: {
                    this.currentCloudLevel = 0;
                    break;
                }
                case MOSTLY_CLEAR: {
                    this.currentCloudLevel = 0;
                    if (TUMaths.rollRange(0, 99) > 10) break;
                    this.currentCloudLevel = 1;
                    break;
                }
                case PARTLY_CLOUDY: {
                    this.currentCloudLevel = 0;
                    if (TUMaths.rollRange(0, 99) > 33) break;
                    this.currentCloudLevel = 1;
                    break;
                }
                case MOSTLY_CLOUDLY: {
                    this.currentCloudLevel = 1;
                    if (TUMaths.rollRange(0, 99) > 10) break;
                    this.currentCloudLevel = 2;
                    break;
                }
                case SCATTERED_CLOUDS: {
                    this.currentCloudLevel = 0;
                    if (TUMaths.rollRange(0, 99) <= 25) {
                        this.currentCloudLevel = 2;
                    }
                }
                case BROKEN_CLOUDS: {
                    this.currentCloudLevel = 3;
                    if (TUMaths.rollRange(0, 99) > 25) break;
                    this.currentCloudLevel = 0;
                    break;
                }
                case OVERCAST: {
                    this.currentCloudLevel = 3;
                }
            }
        }
    }

    public int getCurrentCloudLevel(CloudEnviroment env) {
        if (!MineMain.useCloudCoverage) {
            return 0;
        }
        int cloudLevel = this.currentCloudLevel;
        if (env.equals((Object)CloudEnviroment.COLD)) {
            ++cloudLevel;
        }
        if (env.equals((Object)CloudEnviroment.HOT)) {
            --cloudLevel;
        }
        if (cloudLevel < 0) {
            cloudLevel = 0;
        }
        if (cloudLevel > 3) {
            cloudLevel = 3;
        }
        return cloudLevel;
    }

    public double getWindLevel() {
        return this.windLevel;
    }

    public void setWindLevel(double windLevel) {
        this.windLevel = windLevel;
    }

    public static enum CloudCoverage {
        CLEAR,
        MOSTLY_CLEAR,
        PARTLY_CLOUDY,
        MOSTLY_CLOUDLY,
        OVERCAST,
        SCATTERED_CLOUDS,
        BROKEN_CLOUDS;

    }

    public static enum CloudEnviroment {
        COLD,
        TEMPERATE,
        HOT;

    }
}

