/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Technology;

import com.MT.triggersUtility.TUInterface.TUIComponent;
import com.MT.triggersUtility.TUInterface.TUInterfaceScrolling;
import com.MT.triggersUtility.TUInterface.TUInventory;
import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.LocaleUtil;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.PlayerData;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import com.MT.xxxtrigger50xxx.Technology.TechTree;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class ResearchLab
extends Device {
    private static final long serialVersionUID = 7571974070728037028L;
    private static String checkMark = "\u2714";
    private static String xMark = "\u274c";
    private int researchProgress = 0;
    private String lastTech = null;
    private static String classSpacedNamed = "Research Lab";

    public ResearchLab(Location loc) {
        super(loc);
        this.setMaterial("BREWING_STAND");
        this.deviceName = "Research Lab";
        this.setActionTimer(3);
        this.setGridRange(5);
        this.setUseUI(true);
        this.setRefreshInv(false);
        this.setIdlePower(1);
        this.setActionPower(5);
        this.setPollutionGen(3);
        this.chainingMoverBehavior = true;
        ArrayList<Integer> inputs = new ArrayList<Integer>();
        int i = 9;
        while (i <= 53) {
            inputs.add(i);
            ++i;
        }
        this.setClickableSlots(inputs);
        this.setOutputSlots(inputs);
        this.setInputSlots(inputs);
        this.updateDeviceHeadItem();
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Converts science packs into technology.");
        lore.add("- Inputs and output slots are the top row.");
        return lore;
    }

    @Override
    public void recreateInv() {
        this.inv = TUInventory.createInventory(ChatColor.GOLD + ChatColor.BOLD + this.deviceName, 6, this.deviceName);
    }

    @Override
    public void updateUI() {
        int i = 0;
        while (i <= 8) {
            this.getInventory().setItem(i, MainMenu.createWhitePane());
            ++i;
        }
        ArrayList<String> lore = new ArrayList<String>();
        String research = "None";
        int progress = 0;
        PlayerData pd = PlayerData.getPlayerData(this.getPlacerUUIDString());
        if (pd != null && (research = pd.getCurrentResearch()) != null) {
            progress = pd.getTechProgression(pd.getCurrentResearch());
        }
        if (research == null) {
            research = "None";
        }
        lore.add(MineUtil.colon(" Action Time", this.getCurrentTimer() + "s/" + this.getActionTimer() + "s"));
        if (!research.equals("None")) {
            lore.add(MineUtil.colon(" Researching", research));
            lore.add(MineUtil.colon(" Progress", progress + "%"));
            lore.add(MineUtil.colon(" Lab Progress", this.researchProgress + "%"));
            lore.add(" ");
            lore.add(MineItems.whiteBold() + " Requirements");
            String tech = research;
            for (String req : TechTree.getTechRequirements(tech)) {
                if (pd.hasTech(req)) {
                    lore.add(String.valueOf(ChatColor.GREEN) + "  " + checkMark + " " + req);
                    continue;
                }
                lore.add(String.valueOf(ChatColor.RED) + "  " + xMark + " " + req);
            }
            ArrayList<ItemStack> sciencePacks = TechTree.getRequirementStacks(tech);
            int basePackPrice = sciencePacks.get(0).getAmount();
            int packAmountNeeded = basePackPrice - pd.getTechConsumedItems(tech);
            ChatColor packColor = ChatColor.WHITE;
            if (basePackPrice != packAmountNeeded) {
                packColor = ChatColor.YELLOW;
                if (packAmountNeeded == 0) {
                    packColor = ChatColor.GREEN;
                    packAmountNeeded = basePackPrice;
                }
            }
            for (ItemStack stack : sciencePacks) {
                String name = ChatColor.stripColor((String)stack.getItemMeta().getDisplayName());
                if (name.length() == 0) {
                    name = MineItems.formatMaterialName(stack.getItemMeta().getItemName());
                }
                if (name.length() == 0) {
                    name = MineItems.formatMaterialName(stack.getType().toString());
                }
                String packLine = String.valueOf(packColor) + "  - " + name + " x" + packAmountNeeded;
                if (packAmountNeeded != basePackPrice) {
                    packLine = packLine + " " + String.valueOf(ChatColor.GRAY) + "(" + basePackPrice + ")";
                }
                lore.add(packLine);
            }
        }
        lore.add(" ");
        if (!this.getFailReason().equals("None")) {
            lore.add(String.valueOf(ChatColor.RED) + "  - " + this.getFailReason());
        }
        lore.add(String.valueOf(ChatColor.WHITE) + "  -> Click to select research");
        ItemStack stack = TUItems.setModelData(TUItems.createItem(Material.REDSTONE_LAMP, ChatColor.WHITE + ChatColor.BOLD + "Device Information", lore), 9523);
        this.getInventory().setItem(4, stack);
    }

    @Override
    public void onUIClick(InventoryClickEvent event) {
        if (event.getSlot() == 4) {
            ResearchLab.openResearchSelect((Player)event.getWhoClicked(), this);
            ((Player)event.getWhoClicked()).playSound((Entity)((Player)event.getWhoClicked()), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        }
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void action() {
        if (this.isPowered()) {
            boolean spawnParticles = false;
            if (this.getGrid().hasPower(this.getActionPower())) {
                PlayerData pd = PlayerData.getPlayerData(this.getPlacerUUIDString());
                if (pd != null) {
                    if (pd.getCurrentResearch() != null) {
                        if (this.lastTech == null) {
                            this.lastTech = pd.getCurrentResearch();
                        }
                        if (!this.lastTech.equals(pd.getCurrentResearch())) {
                            this.researchProgress = 0;
                        }
                        this.lastTech = pd.getCurrentResearch();
                        ArrayList<ItemStack> requiredStacks = new ArrayList<ItemStack>(TechTree.getRequirementStacks(pd.getCurrentResearch()));
                        ArrayList<ItemStack> remainingNeeded = new ArrayList<ItemStack>(requiredStacks);
                        boolean haveRequirements = true;
                        for (ItemStack remaining : new ArrayList<ItemStack>(remainingNeeded)) {
                            int amount = 0;
                            for (ItemStack input : this.getInputItems()) {
                                if (!input.isSimilar(remaining)) continue;
                                amount += input.getAmount();
                            }
                            if (amount > 0) continue;
                            String name = ChatColor.stripColor((String)remaining.getItemMeta().getDisplayName());
                            if (name.length() == 0) {
                                name = MineItems.formatMaterialName(remaining.getItemMeta().getItemName());
                            }
                            if (name.length() == 0) {
                                name = MineItems.formatMaterialName(remaining.getType().toString());
                            }
                            this.setFailReason("Missing " + name);
                            haveRequirements = false;
                            break;
                        }
                        if (haveRequirements) {
                            if (TUMaths.isPlayerNearby(this.getLocation(), MineMain.nearDistance)) {
                                this.getLocation().getWorld().playSound(this.getLocation(), Sound.BLOCK_BREWING_STAND_BREW, 0.5f, 1.0f);
                            }
                            this.setConsumingPower(true);
                            this.getGrid().consumePower(this, this.getActionPower());
                            int base = 17 + pd.researchLevel() * 6;
                            this.researchProgress += base;
                            if (this.researchProgress >= 100) {
                                this.researchProgress = 0;
                                block2: for (ItemStack remaining : new ArrayList<ItemStack>(remainingNeeded)) {
                                    for (ItemStack input : this.getInputItems()) {
                                        if (!input.isSimilar(remaining)) continue;
                                        this.logItem(input, -1);
                                        input.setAmount(input.getAmount() - 1);
                                        continue block2;
                                    }
                                }
                                String tech = pd.getCurrentResearch();
                                pd.progressTech(tech);
                                if (MineMain.sharTechProgression) {
                                    for (String string : pd.getSharedUsers()) {
                                        PlayerData sharedPD = PlayerData.getPlayerData(string);
                                        if (sharedPD == null) continue;
                                        sharedPD.progressTech(tech);
                                    }
                                }
                            }
                        } else {
                            this.researchProgress = 0;
                        }
                    } else {
                        this.setFailReason("No research set");
                        spawnParticles = true;
                        this.researchProgress = 0;
                    }
                } else {
                    this.setFailReason("Player does not own this device.");
                    spawnParticles = true;
                    this.researchProgress = 0;
                }
            } else {
                this.setFailReason("Not enough power");
                spawnParticles = true;
            }
            if (spawnParticles && TUMaths.isPlayerNearby(this.getLocation(), MineMain.farDistance)) {
                this.spawnInactiveParticles();
            }
        }
    }

    private static int getTotalAmount(String techName) {
        ArrayList<ItemStack> stacks = TechTree.getRequirementStacks(techName);
        if (stacks == null || stacks.isEmpty()) {
            return 0;
        }
        int total = 0;
        for (ItemStack stack : stacks) {
            if (stack == null) continue;
            total += stack.getAmount();
        }
        return total;
    }

    public static void openResearchSelect(Player player, Device from) {
        MainMenu.lastMenu.put(player.getUniqueId(), "Research");
        ItemStack pane = MainMenu.createGoldPane();
        PlayerData pd = PlayerData.getPlayerData(player.getUniqueId().toString());
        ArrayList<String> techs = new ArrayList<String>(TechTree.getAllTechs());
        ArrayList<String> unlockedTechs = new ArrayList<String>();
        ArrayList<String> unlockableTechs = new ArrayList<String>();
        ArrayList<String> lockedTechs = new ArrayList<String>();
        for (String tech : techs) {
            if (pd.hasTech(tech)) {
                unlockedTechs.add(tech);
                continue;
            }
            if (TechTree.hasRequirements(player, tech)) {
                unlockableTechs.add(tech);
                continue;
            }
            lockedTechs.add(tech);
        }
        unlockedTechs.sort((a, b) -> {
            int amountA = ResearchLab.getTotalAmount(a);
            int amountB = ResearchLab.getTotalAmount(b);
            return Integer.compare(amountA, amountB);
        });
        unlockableTechs.sort((a, b) -> {
            int amountA = ResearchLab.getTotalAmount(a);
            int amountB = ResearchLab.getTotalAmount(b);
            return Integer.compare(amountA, amountB);
        });
        lockedTechs.sort((a, b) -> {
            int amountA = ResearchLab.getTotalAmount(a);
            int amountB = ResearchLab.getTotalAmount(b);
            return Integer.compare(amountA, amountB);
        });
        ArrayList<String> lTechs = new ArrayList<String>();
        lTechs.addAll(unlockedTechs);
        lTechs.addAll(unlockableTechs);
        lTechs.addAll(lockedTechs);
        String currentTech = pd.getCurrentResearch();
        if (currentTech != null) {
            lTechs.remove(currentTech);
            lTechs.add(0, currentTech);
        }
        HashMap stacks = new HashMap();
        class LeaderScroller
        extends TUInterfaceScrolling {
            private final /* synthetic */ ArrayList val$lTechs;
            private final /* synthetic */ String val$currentTech;
            private final /* synthetic */ ArrayList val$unlockedTechs;
            private final /* synthetic */ ArrayList val$unlockableTechs;
            private final /* synthetic */ PlayerData val$pd;
            private final /* synthetic */ ArrayList val$lockedTechs;
            private final /* synthetic */ Player val$player;
            private final /* synthetic */ HashMap val$stacks;
            private final /* synthetic */ Device val$from;

            public LeaderScroller(String name, int rows, ArrayList arrayList, String string, ArrayList arrayList2, ArrayList arrayList3, PlayerData playerData, ArrayList arrayList4, Player player, HashMap hashMap, Device device) {
                this.val$lTechs = arrayList;
                this.val$currentTech = string;
                this.val$unlockedTechs = arrayList2;
                this.val$unlockableTechs = arrayList3;
                this.val$pd = playerData;
                this.val$lockedTechs = arrayList4;
                this.val$player = player;
                this.val$stacks = hashMap;
                this.val$from = device;
                super(name, rows);
            }

            @Override
            public ItemStack defineScrolling(int i) {
                if (this.val$lTechs.size() > i) {
                    ItemStack stack;
                    String tech = (String)this.val$lTechs.get(i);
                    ArrayList<String> lore = new ArrayList<String>();
                    Material mat = Material.BLACK_CONCRETE;
                    boolean isActive = this.val$currentTech != null && this.val$currentTech.equals(tech);
                    String checkMark = "\u2714";
                    String xMark = "\u274c";
                    boolean unlocked = this.val$unlockedTechs.contains(tech);
                    if (this.val$unlockableTechs.contains(tech)) {
                        mat = Material.YELLOW_CONCRETE;
                        if (!isActive) {
                            lore.add(String.valueOf(ChatColor.WHITE) + " -> Click to start research.");
                        } else {
                            lore.add(String.valueOf(ChatColor.WHITE) + " -> Click to stop research.");
                        }
                        if (this.val$pd.getTechProgression(tech) != 0) {
                            lore.add(" ");
                            lore.add(MineUtil.colon(" Progress", this.val$pd.getTechProgression(tech) + "%"));
                        }
                    }
                    if (unlocked) {
                        mat = Material.GREEN_CONCRETE;
                        lore.add(" " + String.valueOf(ChatColor.GREEN) + checkMark + " Unlocked");
                    }
                    if (this.val$lockedTechs.contains(tech)) {
                        lore.add(" " + String.valueOf(ChatColor.RED) + xMark + " Locked");
                    }
                    lore.add(" ");
                    for (String str : MineUtil.wrapText(TechTree.getTechDesc(tech), 40)) {
                        lore.add(String.valueOf(ChatColor.GRAY) + " " + str);
                    }
                    lore.add(" ");
                    lore.add(String.valueOf(ChatColor.GOLD) + " Requirements");
                    String neededPerm = TechTree.techPermission.getOrDefault(tech, "None");
                    if (neededPerm != null && !neededPerm.equals("None")) {
                        if (this.val$player.hasPermission(neededPerm)) {
                            lore.add(String.valueOf(ChatColor.GREEN) + "  " + checkMark + " " + TechTree.techPermMissing.getOrDefault(tech, neededPerm));
                        } else {
                            lore.add(String.valueOf(ChatColor.RED) + "  " + xMark + " " + TechTree.techPermMissing.getOrDefault(tech, neededPerm));
                        }
                    }
                    for (String req : TechTree.getTechRequirements(tech)) {
                        if (this.val$pd.hasTech(req)) {
                            lore.add(String.valueOf(ChatColor.GREEN) + "  " + checkMark + " " + req);
                            continue;
                        }
                        lore.add(String.valueOf(ChatColor.RED) + "  " + xMark + " " + req);
                    }
                    ArrayList<ItemStack> sciencePacks = TechTree.getRequirementStacks(tech);
                    int basePackPrice = sciencePacks.get(0).getAmount();
                    int packAmountNeeded = basePackPrice - this.val$pd.getTechConsumedItems(tech);
                    ChatColor packColor = ChatColor.WHITE;
                    if (basePackPrice != packAmountNeeded || unlocked) {
                        packColor = ChatColor.YELLOW;
                        if (packAmountNeeded == 0 || unlocked) {
                            packColor = ChatColor.GREEN;
                            packAmountNeeded = basePackPrice;
                        }
                    }
                    for (ItemStack stack2 : sciencePacks) {
                        String name = ChatColor.stripColor((String)stack2.getItemMeta().getDisplayName());
                        if (name.length() == 0) {
                            name = MineItems.formatMaterialName(stack2.getItemMeta().getItemName());
                        }
                        if (name.length() == 0) {
                            name = MineItems.formatMaterialName(stack2.getType().toString());
                        }
                        String packLine = String.valueOf(packColor) + "  - " + name + " x" + packAmountNeeded;
                        if (packAmountNeeded != basePackPrice) {
                            packLine = packLine + " " + String.valueOf(ChatColor.GRAY) + "(" + basePackPrice + ")";
                        }
                        lore.add(packLine);
                    }
                    ArrayList<String> devicesUnlocked = TechTree.getTechDevices(tech);
                    if (devicesUnlocked.size() > 0) {
                        lore.add(" ");
                        lore.add(String.valueOf(ChatColor.GOLD) + " Unlocks");
                        for (String unlockedDevice : devicesUnlocked) {
                            lore.add(String.valueOf(ChatColor.WHITE) + "  - " + unlockedDevice);
                        }
                    }
                    if (isActive) {
                        mat = Material.WHITE_CONCRETE;
                    }
                    if ((stack = TUItems.createItem(mat, MineItems.goldBold() + tech, lore)).getType().equals((Object)Material.GREEN_CONCRETE)) {
                        stack = TUItems.setModelData(stack, 9512);
                    }
                    if (stack.getType().equals((Object)Material.YELLOW_CONCRETE)) {
                        stack = TUItems.setModelData(stack, 9513);
                    }
                    if (stack.getType().equals((Object)Material.BLACK_CONCRETE)) {
                        stack = TUItems.setModelData(stack, 9514);
                    }
                    if (stack.getType().equals((Object)Material.WHITE_CONCRETE)) {
                        stack = TUItems.setModelData(stack, 9515);
                    }
                    this.val$stacks.put(stack, tech);
                    return stack;
                }
                return null;
            }

            @Override
            public void scrollingActionClick(Player player, ItemStack item, InventoryClickEvent event) {
                if (player.isOp() && event.isShiftClick()) {
                    ItemStack techCard = MineItems.getTechCard((String)this.val$stacks.get(item));
                    player.getInventory().addItem(new ItemStack[]{techCard});
                    MineUtil.sendMessage(player, "Given tech card");
                    return;
                }
                boolean open = false;
                if (!item.getType().equals((Object)Material.BLACK_CONCRETE) && !item.getType().equals((Object)Material.GREEN_CONCRETE)) {
                    this.val$pd.setCurrentResearch((String)this.val$stacks.get(item));
                    open = true;
                }
                if (item.getType().equals((Object)Material.WHITE_CONCRETE)) {
                    this.val$pd.setCurrentResearch(null);
                    open = true;
                }
                if (open) {
                    if (this.val$from != null) {
                        player.openInventory(this.val$from.getInventory());
                    } else {
                        ResearchLab.openResearchSelect(player, this.val$from);
                    }
                    player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                }
            }
        }
        LeaderScroller face = new LeaderScroller(MineItems.uiTitle() + LocaleUtil.uiText("TM_Title"), 6, lTechs, currentTech, unlockedTechs, unlockableTechs, pd, lockedTechs, player, stacks, from);
        if (player.isOp()) {
            face.addComponent(MineUtil.createInfoComponent(53, LocaleUtil.uiText("TM_Info_Desc_Admin")));
        } else {
            face.addComponent(MineUtil.createInfoComponent(53, LocaleUtil.uiText("TM_Info_Desc_User")));
        }
        int i = 45;
        while (i <= 53) {
            if (i != 47 && i != 51 && i != 49 && i != 53) {
                face.addComponent(new TUIComponent(i, pane));
            }
            ++i;
        }
        ArrayList<Integer> scrollingSlots = new ArrayList<Integer>();
        int j = 0;
        while (j <= 44) {
            scrollingSlots.add(j);
            ++j;
        }
        face.setScrollingSlots(scrollingSlots);
        class ReturnButton
        extends TUIComponent {
            private final /* synthetic */ Device val$from;

            public ReturnButton(int slot, ItemStack linkStack, Device device) {
                this.val$from = device;
                super(slot, linkStack);
            }

            @Override
            public void onLeftClick(Player player) {
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                if (this.val$from != null) {
                    player.openInventory(this.val$from.getInventory());
                } else {
                    MainMenu.openGuideMenu(player, null);
                }
            }
        }
        ReturnButton returnButt = new ReturnButton(49, MainMenu.createReturnArrow(), from);
        TUIComponent leftScroller = MineUtil.createLeftScroll(47);
        TUIComponent rightScroller = MineUtil.createRightScroll(51);
        face.addComponent(returnButt);
        face.addComponent(leftScroller);
        face.addComponent(rightScroller);
        face.setLeftComp(leftScroller);
        face.setRightComp(rightScroller);
        face.updateScrolling();
        face.openInterface(player);
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, ResearchLab.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.POWER, new ResearchLab(null).getDeviceStack(), false);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(MineItems.getIndustrialItem("Electronic Circuit", 1));
        ings.add(new ItemStack(Material.GLASS, 3));
        ings.add(new ItemStack(Material.COPPER_INGOT, 5));
        RecipeUtils.addDefaultRecipe(new ResearchLab(null).getDeviceStack(), ings, MTRecipe.RecipeType.CRUDE, true);
    }
}

