/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Technology;

import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.PlayerData;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class TechTree {
    private static HashMap<String, ArrayList<ItemStack>> techPrice = new HashMap();
    public static HashMap<String, ArrayList<String>> techRequirements = new HashMap();
    private static HashMap<String, String> techDescription = new HashMap();
    public static HashMap<String, String> techPermission = new HashMap();
    public static HashMap<String, String> techPermMissing = new HashMap();
    private static HashMap<String, ArrayList<String>> techPermRewards = new HashMap();
    private static HashMap<String, ArrayList<String>> techCommandRewards = new HashMap();
    private static HashMap<String, String> deviceRequirement = new HashMap();
    private static boolean disableHardCodedTechs = true;

    public static void addTechnologyNew(String name, ArrayList<ItemStack> stacks, ArrayList<String> requirements, String desc, ArrayList<String> unlocks, String reqPerm, String missingPermText, ArrayList<String> permRewards, ArrayList<String> commandRewards) {
        if (!techPrice.containsKey(name)) {
            techPrice.put(name, stacks);
            techRequirements.put(name, requirements);
            techDescription.put(name, desc);
            techPermission.put(name, reqPerm);
            techPermMissing.put(name, missingPermText);
            techPermRewards.put(name, permRewards);
            techCommandRewards.put(name, commandRewards);
            for (String unlock : unlocks) {
                deviceRequirement.put(unlock, name);
            }
        }
    }

    public static void grantTechPermissions(PlayerData pd) {
        Player player = pd.getPlayer();
        if (player == null) {
            return;
        }
        for (String tech : pd.getUnlockedTechs()) {
            for (String perm : techPermRewards.getOrDefault(tech, new ArrayList())) {
                if (player.hasPermission(perm)) continue;
                player.addAttachment(MineMain.getPlugin(), perm, true);
            }
        }
    }

    public static void addPendingTechCommands(String tech, PlayerData pd) {
        for (String command : techCommandRewards.getOrDefault(tech, new ArrayList())) {
            pd.addPendingCommand(command);
        }
    }

    private static void populateTechFromConfig() {
        File file = new File(MineMain.getPlugin().getDataFolder(), "tech.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        ConfigurationSection entriesSection = config.getConfigurationSection("Technologies");
        if (entriesSection == null) {
            return;
        }
        for (String entryKey : entriesSection.getKeys(false)) {
            String techName;
            ConfigurationSection entry = entriesSection.getConfigurationSection(entryKey);
            if (entry == null || (techName = entryKey).equals("Example")) continue;
            String permName = entry.getString("Required Permission");
            String missingPermText = entry.getString("Perm Text");
            String desc = entry.getString("Description");
            boolean disabled = entry.getBoolean("Disable");
            if (disabled) continue;
            ArrayList<String> requiredTechs = new ArrayList<String>(entry.getStringList("Required Tech"));
            ArrayList<String> permRewards = new ArrayList<String>(entry.getStringList("Permission Rewards"));
            ArrayList<String> commandRewards = new ArrayList<String>(entry.getStringList("Command Rewards"));
            int cost = entry.getInt("Tech Cost");
            ArrayList<ItemStack> techStacks = new ArrayList<ItemStack>();
            for (String techItem : entry.getStringList("Tech Items")) {
                if (techItem.contains("MT:")) {
                    String mtItemName = techItem.split(":")[1];
                    ItemStack mtStack = MineItems.getIndustrialItem(mtItemName);
                    if (mtStack == null && (mtStack = MineItems.getIndustrialItemByPDC(mtItemName)) == null) {
                        TUMaths.dm("MT item: " + mtItemName + " could not be found. Replaced with bedrock for now.", ChatColor.YELLOW);
                        mtStack = new ItemStack(Material.BEDROCK);
                    }
                    mtStack.setAmount(cost);
                    techStacks.add(mtStack);
                    continue;
                }
                if (techItem.contains("MT:")) continue;
                Material material = Material.matchMaterial((String)techItem);
                if (material != null) {
                    ItemStack vanillaStack = new ItemStack(material);
                    vanillaStack.setAmount(cost);
                    techStacks.add(vanillaStack);
                    continue;
                }
                TUMaths.dm(String.valueOf(ChatColor.YELLOW) + "Tried to add " + techItem + " as a research item but the material is not a valid material.");
            }
            ArrayList<String> unlockTexts = new ArrayList<String>(entry.getStringList("Unlocked Devices"));
            unlockTexts.addAll(entry.getStringList("Unlock Text"));
            TechTree.addTechnologyNew(techName, techStacks, requiredTechs, desc, unlockTexts, permName, missingPermText, permRewards, commandRewards);
        }
    }

    public static void populateTechTree() {
        TechTree.populateTechFromConfig();
        if (disableHardCodedTechs) {
            return;
        }
    }

    public static ArrayList<String> getTechDevices(String tech) {
        ArrayList<String> devices = new ArrayList<String>();
        for (String devUnlock : new ArrayList<String>(deviceRequirement.keySet())) {
            if (!deviceRequirement.get(devUnlock).equals(tech)) continue;
            devices.add(devUnlock);
        }
        return devices;
    }

    public static ArrayList<ItemStack> getScienceStacks(int red, int green, int black, int blue, int purple, int yellow, int white) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (red != 0) {
            stacks.add(TechTree.getScienceStack("Automation Science Pack", red));
        }
        if (green != 0) {
            stacks.add(TechTree.getScienceStack("Logistic Science Pack", green));
        }
        if (black != 0) {
            stacks.add(TechTree.getScienceStack("Military Science Pack", black));
        }
        if (blue != 0) {
            stacks.add(TechTree.getScienceStack("Chemical Science Pack", blue));
        }
        if (purple != 0) {
            stacks.add(TechTree.getScienceStack("Production Science Pack", purple));
        }
        if (yellow != 0) {
            stacks.add(TechTree.getScienceStack("Utility Science Pack", yellow));
        }
        if (white != 0) {
            stacks.add(TechTree.getScienceStack("Space Science Pack", white));
        }
        return stacks;
    }

    public static ArrayList<String> createRequirementList(String req1, String req2, String req3) {
        ArrayList<String> reqs = new ArrayList<String>();
        if (req1 != null) {
            reqs.add(req1);
        }
        if (req2 != null) {
            reqs.add(req2);
        }
        if (req3 != null) {
            reqs.add(req3);
        }
        return reqs;
    }

    private static ItemStack getScienceStack(String name, int amount) {
        ItemStack stack = MineItems.getIndustrialItem(name).clone();
        stack.setAmount((int)((double)amount * MineMain.techScale));
        if (stack.getAmount() <= 0) {
            stack.setAmount(1);
        }
        return stack;
    }

    public static ArrayList<ItemStack> getRequirementStacks(String tech) {
        if (techPrice.containsKey(tech)) {
            return new ArrayList<ItemStack>((Collection)techPrice.get(tech));
        }
        return new ArrayList<ItemStack>();
    }

    public static ArrayList<String> getAllTechs() {
        return new ArrayList<String>(techPrice.keySet());
    }

    public static String getTechDesc(String tech) {
        return techDescription.get(tech);
    }

    public static ArrayList<String> getTechRequirements(String tech) {
        return new ArrayList<String>((Collection)techRequirements.get(tech));
    }

    public static boolean hasRequirements(Player player, String tech) {
        if (techRequirements.containsKey(tech)) {
            PlayerData pd = PlayerData.getPlayerData(player.getUniqueId().toString());
            String neededPerm = techPermission.getOrDefault(tech, "None");
            if (neededPerm != null && !neededPerm.equals("None") && !player.hasPermission(neededPerm)) {
                return false;
            }
            for (String req : techRequirements.get(tech)) {
                if (pd.hasTech(req)) continue;
                return false;
            }
        }
        return true;
    }

    public static String getNeededTech(String deviceName) {
        return deviceRequirement.getOrDefault(deviceName, null);
    }

    public static String getDevicesTech(String deviceName) {
        return null;
    }
}

