/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Defense;

import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.Pollution.SuperChunk;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Directional;
import org.bukkit.inventory.ItemStack;

public class MineLayer
extends Device {
    private static final long serialVersionUID = 8881974022228037011L;
    private String face;

    public MineLayer(Location loc) {
        super(loc);
        this.setMaterial("DISPENSER");
        this.deviceName = "Mine Layer";
        this.setActionTimer(5);
        this.setGridRange(5);
        this.setUseUI(true);
        this.setRefreshInv(false);
        this.setIdlePower(1);
        this.setActionPower(5);
        this.useAutoSlots();
        if (loc != null) {
            Block block = this.getLocation().getBlock();
            Directional dis = (Directional)block.getBlockData();
            this.face = dis.getFacing().toString();
        }
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Scatters land mines in front of it.");
        lore.add("- Uses land mines from the input slots.");
        lore.add("- Scatters landmines evenly 16 blocks in front of it.");
        lore.add("- Spaces them out in a 9x9 area");
        lore.add("- Direction is based on facing direction.");
        return lore;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.STONE_PRESSURE_PLATE, 1.0);
    }

    @Override
    public void action() {
        if (this.getGrid() == null) {
            return;
        }
        if (this.getGrid().hasPower(this.getActionPower())) {
            ItemStack mine = null;
            for (ItemStack stack : this.getInputItems()) {
                if (!TUItems.isValid(stack) || !MineItems.isIndustrialItem(stack, "Land Mine")) continue;
                mine = stack;
                break;
            }
            if (mine != null) {
                Location loc = this.getOpenMineLocation();
                if (loc != null) {
                    SuperChunk sc = SuperChunk.getSuperChunk(loc);
                    sc.addLandMine(loc, UUID.fromString(this.getPlacerUUIDString()));
                    this.logItem(mine, -1);
                    mine.setAmount(mine.getAmount() - 1);
                    if (TUMaths.isPlayerNearby(this.getLocation(), MineMain.closeDistance)) {
                        this.getLocation().getWorld().playSound(this.getLocation(), Sound.BLOCK_STONE_PRESSURE_PLATE_CLICK_ON, 0.5f, 0.8f);
                    }
                } else {
                    this.setFailReason("No open mine spot");
                }
            } else {
                this.setFailReason("Missing landmines");
            }
        }
    }

    private Location getOpenMineLocation() {
        BlockFace facing = BlockFace.valueOf((String)this.face);
        Block block = this.getLocation().getBlock();
        int i = 0;
        while (i < 16) {
            block = block.getRelative(facing);
            ++i;
        }
        int x = block.getX() - 9;
        while (x < block.getX() + 9) {
            int z = block.getZ() - 9;
            while (z < block.getZ() + 9) {
                Location mineLoc = new Location(block.getWorld(), (double)x, 0.0, (double)z);
                Location topLoc = mineLoc.getWorld().getHighestBlockAt(mineLoc).getLocation().add(0.0, 1.0, 0.0);
                if (Math.abs((double)block.getY() - topLoc.getY()) <= 6.0 && !SuperChunk.getSuperChunk(topLoc).hasLandMine(topLoc)) {
                    return topLoc;
                }
                z += 4;
            }
            x += 4;
        }
        return null;
    }

    @Override
    public int getGridScore() {
        return 2;
    }
}

