/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Generators;

import com.MT.triggersUtility.TUItems;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Planets.Planet;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.inventory.ItemStack;

public class HydrogenEngine
extends Device {
    private static final long serialVersionUID = -6494301590854362498L;
    private static String classSpacedNamed = "Hydrogen Engine";
    private int hydrogen = 0;

    public HydrogenEngine(Location loc) {
        super(loc);
        this.setMaterial("BLAST_FURNACE");
        this.deviceName = classSpacedNamed;
        this.setActionTimer(1);
        this.setUseUI(true);
        this.setRefreshInv(false);
        this.setPowerGen(30);
        this.useAutoSlots();
        this.setIdlePower(0);
        this.setPollutionGen(0);
        this.updateDeviceHeadItem();
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        return lore;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
        TUItems.removeLoreNoColor(this.getInventory().getItem(13), "Power Usage");
    }

    @Override
    public ArrayList<String> extraInfoLore() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(MineUtil.colon(" Fuel", "" + this.hydrogen));
        return lore;
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.ICE, 1.0);
    }

    @Override
    public void action() {
        if (this.getGrid() != null) {
            ItemStack stack;
            if (this.hydrogen <= 900 && this.getOutputSlot() != -1 && (stack = this.getInputStack(MineItems.getGasCanister(Planet.Gas.HYDROGEN))) != null) {
                this.hydrogen += 100;
                stack.setAmount(stack.getAmount() - 1);
                this.getInventory().setItem(this.getOutputSlot(), MineItems.getIndustrialItem("Empty Gas Canister"));
                if (MinetorioListener.isPlayerNearbyOPT(this.getLocation(), 6.0)) {
                    this.getLocationREADONLY().getWorld().playSound(this.getLocationREADONLY(), Sound.ENTITY_BREEZE_IDLE_AIR, 0.5f, 0.5f);
                }
            }
            if (this.hydrogen >= 20) {
                if (MinetorioListener.isPlayerNearby2DOPT(this.getLocation(), 4.0)) {
                    this.getLocation().getWorld().playSound(this.getLocation(), Sound.BLOCK_FURNACE_FIRE_CRACKLE, 0.5f, 1.0f);
                }
                this.getGrid().addPower(this, this.getPowerGen());
                this.setProducingPower(true);
                this.hydrogen -= 20;
            } else {
                this.setFailReason("Need 20 Hydrogen");
            }
        }
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, HydrogenEngine.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.POWER, new HydrogenEngine(null).getDeviceStack(), false);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(MineItems.getIndustrialItem("Iron Plate", 4));
        ings.add(MineItems.getIndustrialItem("Iron Gear Wheel"));
        ings.add(MineItems.getIndustrialItem("Electronic Circuit"));
        RecipeUtils.addDefaultRecipe(new HydrogenEngine(null).getDeviceStack(), ings, MTRecipe.RecipeType.ADVANCED, true);
    }
}

