/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Liquids;

import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Liquids.LiquidUtil;
import com.MT.xxxtrigger50xxx.Devices.Liquids.Pipe;
import com.MT.xxxtrigger50xxx.Devices.Liquids.PipeLine;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.LocaleUtil;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import java.util.HashSet;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;

public class LiquidSilo
extends Device {
    private static final long serialVersionUID = -3929101797254221315L;
    private static String classSpacedNamed = "Liquid Silo";
    private Device.LiquidType targetLiquid = Device.LiquidType.WATER;

    public LiquidSilo(Location loc) {
        super(loc);
        this.setMaterial("CAULDRON");
        this.deviceName = classSpacedNamed;
        this.setActionTimer(1);
        this.setActionPower(0);
        this.setIdlePower(0);
        this.setOpenable(true);
        this.setGridRange(0);
        this.setUseUI(true);
        this.setStoreForm(true);
        this.changeLiquid();
        this.updateDeviceHeadItem();
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Does not require power to output liquids.");
        lore.add("- Can only store one liquid at a time.");
        return lore;
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.WATER_BUCKET, 1.0);
    }

    @Override
    public void updateUI() {
        ItemStack stack = TUItems.setModelData(TUItems.createItem(Material.HOPPER, MineItems.whiteBold() + "Device Information"), 9527);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(MineUtil.colon(" Target Liquid", String.valueOf((Object)this.targetLiquid)));
        lore.add(MineUtil.colon(" Stored", this.getStoredLiquid(this.targetLiquid) + " / 10000"));
        lore.add(" ");
        lore.add(MineUtil.colon(" " + LocaleUtil.uiText("General_Click"), "Change Liquid"));
        TUItems.addLore(stack, lore);
        this.getInventory().setItem(13, stack);
        ItemStack gPane = MainMenu.createGoldPane();
        int i = 0;
        while (i <= 26) {
            if (i != 13) {
                this.inv.setItem(i, gPane);
            }
            ++i;
        }
    }

    public Device.LiquidType getTargetLiquidType() {
        return this.targetLiquid;
    }

    @Override
    public void onUIClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.getSlot() == 13) {
            if (this.targetLiquid == null) {
                this.targetLiquid = Device.LiquidType.WATER;
                player.playSound((Entity)player, Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                return;
            }
            boolean next = false;
            Device.LiquidType[] liquidTypeArray = Device.LiquidType.values();
            int n = liquidTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Device.LiquidType type = liquidTypeArray[n2];
                if (next) {
                    this.targetLiquid = type;
                    next = false;
                    this.changeLiquid();
                    break;
                }
                if (type.equals((Object)this.targetLiquid)) {
                    next = true;
                }
                ++n2;
            }
            if (next) {
                this.targetLiquid = Device.LiquidType.values()[0];
            }
            this.changeLiquid();
            player.playSound((Entity)player, Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        }
    }

    private void changeLiquid() {
        this.updateUI();
        Device.LiquidType[] liquidTypeArray = Device.LiquidType.values();
        int n = liquidTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Device.LiquidType type = liquidTypeArray[n2];
            if (type.equals((Object)this.targetLiquid)) {
                this.addLiquidType(type, 10000);
            } else {
                this.removeLiquidType(type);
            }
            ++n2;
        }
    }

    @Override
    public void action() {
        for (Block block : TUMaths.getNearbyBlocks6Sided(this.getLocation().getBlock())) {
            PipeLine.pipeLineCheck(block);
        }
        if (this.getGrid() != null && this.getGrid().hasPower(this.getActionPower())) {
            boolean playerNear = TUMaths.isPlayerNearby(this.getLocation(), 8.0);
            HashSet<Device> connectedDevice = LiquidUtil.getConnectedDevices(this.getLocation().getBlock(), this.targetLiquid);
            this.moveLiquids(connectedDevice, this.targetLiquid, playerNear);
            if (playerNear) {
                this.updateUI();
            }
        }
    }

    private void moveLiquids(HashSet<Device> devices, Device.LiquidType liquidType, boolean playerNear) {
        if (devices.size() > 0) {
            boolean liquidGiven = false;
            int baseLiquidEach = this.getStoredLiquid(liquidType) / devices.size();
            if (baseLiquidEach == 0) {
                return;
            }
            for (Device device2 : devices) {
                if (device2.getStoredLiquid(liquidType) >= device2.getMaxLiquid(liquidType)) continue;
                liquidGiven = true;
                int liquidNeeded = device2.getMaxLiquid(liquidType) - device2.getStoredLiquid(liquidType);
                if (liquidNeeded > baseLiquidEach) {
                    device2.addLiquid(liquidType, baseLiquidEach);
                    this.removeLiquid(liquidType, baseLiquidEach);
                    continue;
                }
                device2.addLiquid(liquidType, liquidNeeded);
                this.removeLiquid(liquidType, liquidNeeded);
            }
            if (playerNear && liquidGiven) {
                this.getLocation().getBlock().getWorld().playSound(this.getLocation(), Sound.ITEM_BOTTLE_FILL, 0.5f, 0.8f);
            }
            if (liquidGiven) {
                for (Block block : TUMaths.getNearbyBlocks6Sided(this.getLocation().getBlock())) {
                    if (!Pipe.isPipe(block)) continue;
                    Pipe pipe = (Pipe)((MetadataValue)block.getMetadata("MT-Pipe").get(0)).value();
                    pipe.getLine().addLiquidType(Device.LiquidType.STEAM);
                    pipe.getLine().decorTickPipeLine();
                }
            }
        }
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, LiquidSilo.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.LOGISTICS, new LiquidSilo(null).getDeviceStack(), false);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(MineItems.getIndustrialItem("Electronic Circuit"));
        ings.add(MineItems.getIndustrialItem("Iron Plate", 6));
        RecipeUtils.addDefaultRecipe(new LiquidSilo(null).getDeviceStack(), ings, MTRecipe.RecipeType.BASIC, true);
    }
}

