/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Manufactoring;

import com.MT.triggersUtility.TUInterface.TUInventory;
import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.PlayerData;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import com.MT.xxxtrigger50xxx.Technology.TechTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;

public class Crafter2
extends Device {
    private static final long serialVersionUID = -3929401797254451315L;
    private static HashMap<ItemStack, ArrayList<Recipe>> cachedRecipesPerStack = new HashMap();
    private transient HashMap<ItemStack, Integer> lastIngredients = new HashMap();
    private transient HashMap<ItemStack, Integer> lastStored = new HashMap();
    private int recipeCount = 1;
    private static String classSpacedNamed = "Crafter";
    private transient Recipe lastRecipe = null;
    private transient ArrayList<ItemStack> lastIngs = null;

    public Crafter2(Location loc) {
        super(loc);
        this.setMaterial("CRAFTER");
        this.deviceName = "Crafter";
        this.setActionTimer(3);
        this.setGridRange(0);
        this.setUseUI(true);
        this.setRefreshInv(false);
        this.setIdlePower(1);
        this.setActionPower(2);
        ArrayList<Integer> inputSlots = new ArrayList<Integer>();
        inputSlots.add(0);
        inputSlots.add(1);
        inputSlots.add(2);
        inputSlots.add(9);
        inputSlots.add(10);
        inputSlots.add(11);
        inputSlots.add(18);
        inputSlots.add(19);
        inputSlots.add(20);
        this.setInputSlots(inputSlots);
        ArrayList<Integer> outputSlots = new ArrayList<Integer>();
        outputSlots.add(15);
        outputSlots.add(16);
        outputSlots.add(17);
        this.setOutputSlots(outputSlots);
        ArrayList<Integer> allSlots = new ArrayList<Integer>();
        allSlots.addAll(inputSlots);
        allSlots.addAll(outputSlots);
        allSlots.add(22);
        this.setClickableSlots(allSlots);
        this.setPollutionGen(5);
        this.updateDeviceHeadItem();
    }

    @Override
    public int getGridScore() {
        return 2;
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(String.valueOf(MineItems.descColor) + "- Attempts to craft the item in the craft slot.");
        lore.add(String.valueOf(MineItems.descColor) + "- Uses resources from in its input slots to craft.");
        lore.add(String.valueOf(MineItems.descColor) + "- Outputs crafted item into output slots.");
        return lore;
    }

    @Override
    public void updateUI() {
        Inventory inv = null;
        if (this.inv == null) {
            this.inv = TUInventory.createInventory(String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + "Crafter", 3, "Crafter");
        }
        inv = this.inv;
        ItemStack pane = MainMenu.createWhitePane();
        inv.setItem(3, pane);
        inv.setItem(5, pane);
        inv.setItem(12, pane);
        inv.setItem(13, pane);
        inv.setItem(14, pane);
        inv.setItem(21, pane);
        inv.setItem(23, pane);
        pane = MainMenu.createYellowPane();
        inv.setItem(6, pane);
        inv.setItem(7, pane);
        inv.setItem(8, pane);
        inv.setItem(24, pane);
        inv.setItem(25, pane);
        inv.setItem(26, pane);
        ItemStack infoStack = TUItems.createItem(Material.CRAFTING_TABLE, String.valueOf(MineItems.whiteBold()) + "Device Information", new ArrayList<String>());
        infoStack = TUItems.setModelData(infoStack, 9525);
        ArrayList<String> lore = Crafter2.crafterLore(this, this.getTargetCraft(), this.lastIngredients, this.lastStored, null, null, null);
        if (this.recipeCount != 1) {
            lore.add(String.valueOf(ChatColor.YELLOW) + "  " + MineItems.yellowBold() + "!! " + String.valueOf(ChatColor.YELLOW) + this.recipeCount + " Recipes Detected");
        }
        TUItems.addLore(infoStack, lore);
        inv.setItem(4, infoStack);
    }

    @Override
    public void action() {
        if (this.isPowered()) {
            if (this.getGrid().hasPower(5)) {
                this.produceCraft();
            } else {
                this.setFailReason("Not Enough Power");
            }
        } else {
            this.setFailReason("Not Enough Power");
        }
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdateAssembler(nearbyPlayer, this.getTargetCraft());
    }

    public ItemStack getTargetCraft() {
        if (TUItems.isValid(this.getInventory().getItem(22))) {
            ItemStack target = this.getInventory().getItem(22).clone();
            target.setAmount(1);
            return target;
        }
        return null;
    }

    public String produceCraft() {
        this.recipeCount = 1;
        ItemStack targetCraft = this.getTargetCraft();
        if (targetCraft != null) {
            if (this.getOutputSlot() != -1) {
                HashMap<ItemStack, Integer> storedTotalStacks = Crafter2.getTotaledStacks(this.getInputItemsAsClones());
                this.lastStored = storedTotalStacks;
                ArrayList<Object> ings = new ArrayList();
                boolean canCraft = false;
                int amount = 1;
                this.setFailReason("No Recipe Available");
                ArrayList<Recipe> recipes = Crafter2.getRecipesFor(targetCraft);
                boolean oneRecipe = recipes.size() == 1;
                this.recipeCount = recipes.size();
                if (this.lastIngredients != null) {
                    this.lastIngredients.clear();
                }
                for (Recipe recipe : recipes) {
                    String name;
                    String neededTech;
                    canCraft = true;
                    this.setFailReason("Missing Ingredients");
                    ings = this.getIngrediants(recipe);
                    if (ings.size() == 0) {
                        canCraft = false;
                        continue;
                    }
                    this.updateCraftingMaterialChoices(ings);
                    HashMap<ItemStack, Integer> recipeTotalledStacks = Crafter2.getTotaledStacks(ings);
                    this.lastIngredients = recipeTotalledStacks;
                    for (ItemStack needed : new ArrayList<ItemStack>(recipeTotalledStacks.keySet())) {
                        if (!storedTotalStacks.containsKey(needed)) {
                            canCraft = false;
                            if (!oneRecipe) break;
                            this.updateMissing(needed);
                            break;
                        }
                        if (recipeTotalledStacks.get(needed) <= storedTotalStacks.get(needed)) continue;
                        canCraft = false;
                        if (!oneRecipe) break;
                        this.updateMissing(needed);
                        break;
                    }
                    if (canCraft && TUMaths.hasName(targetCraft) && MineMain.useTechnology && (neededTech = TechTree.getNeededTech(name = ChatColor.stripColor((String)targetCraft.getItemMeta().getDisplayName()))) != null) {
                        if (this.getPlacerUUIDString() != null) {
                            PlayerData pd = PlayerData.getPlayerData(this.getPlacerUUIDString().toString());
                            if (!pd.hasTech(neededTech)) {
                                canCraft = false;
                                this.setFailReason("Missing tech - " + neededTech);
                            }
                        } else {
                            canCraft = false;
                            this.setFailReason("No device owner cannot craft until replaced.");
                        }
                    }
                    if (canCraft && MineMain.autocrafterDisableCustomCrafts && !this.isVanillaRecipe(recipe)) {
                        canCraft = false;
                        this.setFailReason("Cannot craft this");
                    }
                    if (canCraft) {
                        Object neededPerm = null;
                        neededPerm = TUMaths.hasName(targetCraft) ? ChatColor.stripColor((String)targetCraft.getItemMeta().getDisplayName()).replace(" ", "") : targetCraft.getType().toString();
                        if (MineMain.autoCrafterPermissions.contains(neededPerm) && this.getPlacerUUIDString() != null) {
                            neededPerm = "MT.AutoCrafter." + (String)neededPerm;
                            PlayerData pd = PlayerData.getPlayerData(this.getPlacerUUIDString().toString());
                            if (!pd.hasAutoCraftPermission((String)neededPerm)) {
                                canCraft = false;
                                this.setFailReason(MineMain.permissionMask + " (" + MineUtil.getPermissionMask((String)neededPerm) + ")");
                            }
                        }
                    }
                    if (!canCraft) continue;
                    amount = recipe.getResult().getAmount();
                    break;
                }
                if (canCraft) {
                    int filledBuckets = 0;
                    for (ItemStack itemStack : ings) {
                        if (!itemStack.getType().toString().contains("BUCKET") || itemStack.getType().equals((Object)Material.BUCKET)) continue;
                        ++filledBuckets;
                    }
                    if (filledBuckets > 0 && this.openSlotCount() <= 1) {
                        canCraft = false;
                        this.setFailReason("No ouput space for buckets");
                    }
                    if (canCraft) {
                        for (ItemStack itemStack : ings) {
                            if (itemStack == null) continue;
                            TUMaths.removeStackAmount(this.getInventory(), itemStack, itemStack.getAmount());
                            this.logItem(itemStack, -itemStack.getAmount());
                        }
                        ItemStack itemStack = targetCraft.clone();
                        itemStack.setAmount(amount);
                        this.logItem(itemStack, itemStack.getAmount());
                        this.getInventory().setItem(this.getOutputSlot(), itemStack);
                        if (filledBuckets > 0) {
                            this.getInventory().setItem(this.getOutputSlot(), new ItemStack(Material.BUCKET, filledBuckets));
                        }
                        this.getLocation().getWorld().playSound(this.getLocation(), Sound.ENTITY_SHEEP_SHEAR, 0.2f, 1.0f);
                        this.setFailReason("None");
                        this.getGrid().consumePower(this, this.getActionPower());
                        this.setConsumingPower(true);
                    }
                }
            } else {
                this.setFailReason("No output space");
            }
        } else {
            this.setFailReason("No Target Craft Found");
        }
        return "Failed";
    }

    private void updateMissing(ItemStack needed) {
        String missing = ChatColor.stripColor((String)needed.getType().toString().replace("_", " "));
        if (needed.hasItemMeta() && needed.getItemMeta().hasDisplayName()) {
            missing = ChatColor.stripColor((String)needed.getItemMeta().getDisplayName());
            this.setFailReason("Missing Ingredient - " + missing);
        } else {
            this.setFailReason("Missing Ingredient - " + missing);
        }
    }

    private static ArrayList<Recipe> getRecipesFor(ItemStack stack) {
        if (cachedRecipesPerStack.containsKey(stack)) {
            return new ArrayList<Recipe>((Collection)cachedRecipesPerStack.get(stack));
        }
        ArrayList recipes = new ArrayList();
        recipes = new ArrayList(Bukkit.getServer().getRecipesFor(stack));
        for (Recipe recipe : new ArrayList(recipes)) {
            boolean properRecipe = false;
            if (recipe instanceof ShapelessRecipe) {
                properRecipe = true;
            }
            if (recipe instanceof ShapedRecipe) {
                properRecipe = true;
            }
            if (!properRecipe) {
                recipes.remove(recipe);
                continue;
            }
            if (recipe.getResult().isSimilar(stack)) continue;
            recipes.remove(recipe);
        }
        cachedRecipesPerStack.put(stack, recipes);
        return new ArrayList<Recipe>((Collection)cachedRecipesPerStack.get(stack));
    }

    public boolean isVanillaRecipe(Recipe recipe) {
        if (recipe instanceof Keyed) {
            NamespacedKey key = ((Keyed)recipe).getKey();
            return "minecraft".equals(key.getNamespace());
        }
        return false;
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, Crafter2.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.MANUFACTORING, new Crafter2(null).getDeviceStack(), false);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(new ItemStack(Material.IRON_INGOT, 3));
        ings.add(new ItemStack(Material.GOLD_INGOT, 3));
        ings.add(new ItemStack(Material.COPPER_INGOT, 3));
        RecipeUtils.addDefaultRecipe(new Crafter2(null).getDeviceStack(), ings, MTRecipe.RecipeType.BASIC, false);
    }

    public ArrayList<ItemStack> getLastIngredients() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (this.lastIngredients != null) {
            for (ItemStack ing : new ArrayList<ItemStack>(this.lastIngredients.keySet())) {
                ItemStack newStack = ing.clone();
                newStack.setAmount(this.lastIngredients.get(ing).intValue());
                stacks.add(newStack);
            }
        }
        return stacks;
    }

    public void updateLastIngredients() {
        ItemStack targetCraft = this.getTargetCraft();
        ArrayList<Object> ings = new ArrayList();
        ArrayList<Recipe> recipes = Crafter2.getRecipesFor(targetCraft);
        for (Recipe recipe : recipes) {
            ings = this.getIngrediants(recipe);
            if (ings.size() == 0) continue;
            this.updateCraftingMaterialChoices(ings);
            if (this.lastIngredients != null) {
                this.lastIngredients.clear();
            }
            HashMap<ItemStack, Integer> recipeTotalledStacks = Crafter2.getTotaledStacks(ings);
            this.lastIngredients = recipeTotalledStacks;
        }
    }

    @Override
    public void onUIClick(InventoryClickEvent event) {
        if (event.getSlot() == 4) {
            this.updateLastIngredients();
            ArrayList<ItemStack> needed = new ArrayList<ItemStack>(this.getLastIngredients());
            if (needed.size() > 0) {
                PlayerData pd = PlayerData.getPlayerData(event.getWhoClicked().getUniqueId().toString());
                for (ItemStack stack : this.getInputItems()) {
                    for (ItemStack need : needed) {
                        if (!need.isSimilar(stack)) continue;
                        need.setAmount(need.getAmount() - stack.getAmount());
                    }
                }
                for (ItemStack need : new ArrayList<ItemStack>(needed)) {
                    if (need.getAmount() > 0) continue;
                    needed.remove(need);
                }
                pd.setGroceryList(needed, new HashMap<NamespacedKey, Integer>(), this.getTargetCraft(), "Crafter");
            }
            Player player = (Player)event.getWhoClicked();
            player.playSound((Entity)player, Sound.ITEM_BOOK_PAGE_TURN, 0.5f, 1.0f);
        }
    }

    public ArrayList<ItemStack> getIngrediants(Recipe recipe) {
        if (this.lastRecipe != null && this.lastRecipe.equals(recipe)) {
            return new ArrayList<ItemStack>(this.lastIngs);
        }
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>(this.getCraftingIngredients(recipe));
        for (ItemStack ing : new ArrayList<ItemStack>(ings)) {
            if (ing != null) continue;
            ings.remove(ing);
        }
        if (this.isVanillaRecipe(recipe)) {
            for (ItemStack stack : new ArrayList<ItemStack>(ings)) {
                ings.remove(stack);
                stack.setItemMeta(Bukkit.getServer().getItemFactory().getItemMeta(stack.getType()));
                ings.add(stack);
            }
        }
        if (MineMain.recipeFix) {
            for (ItemStack stack : new ArrayList<ItemStack>(ings)) {
                if (!stack.toString().contains("UNSPECIFIC_META:{meta-type=UNSPECIFIC, Damage=0}") && !stack.toString().contains("UNSPECIFIC_META:{meta-type=UNSPECIFIC, Damage=32767}")) continue;
                ings.remove(stack);
                stack.setItemMeta(Bukkit.getServer().getItemFactory().getItemMeta(stack.getType()));
                ings.add(stack);
            }
        }
        this.lastRecipe = recipe;
        this.lastIngs = new ArrayList<ItemStack>(ings);
        return ings;
    }
}

