/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Manufactoring;

import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Guide.MinetorioTables;
import com.MT.xxxtrigger50xxx.MineMain;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.inventory.ItemStack;

public class Crusher
extends Device {
    private static final long serialVersionUID = 7571974070728037013L;

    public Crusher(Location loc) {
        super(loc);
        this.setMaterial("GRINDSTONE");
        this.deviceName = "Crusher";
        this.setActionTimer(2);
        this.setGridRange(5);
        this.setUseUI(true);
        this.setRefreshInv(false);
        this.setIdlePower(1);
        this.setActionPower(5);
        this.useAutoSlots();
        this.setStoreForm(false);
        this.updateDeviceHeadItem();
        this.displayLockedHorizontal = true;
        this.displayRotationOffset = 180;
    }

    @Override
    public int getGridScore() {
        return 2;
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Will crush inputted materials if possible.");
        lore.add("- Results are placed into the output slots.");
        lore.add("- You can crush the following.");
        lore.add("- Diorite, andesite, granite-");
        lore.add("- cobblestone, tuff and gravel.");
        lore.add("- Gravel when crushed give sand or flint.");
        lore.add("- Deepslate crushes into 2 cobblestone.");
        lore.add("- Logs, 8 sticks & bone blocks can be crushed for charcoal.");
        return lore;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
    }

    @Override
    public void action() {
        if (this.isPowered()) {
            if (this.getOutputSlot() == -1) {
                this.setFailReason("No output space");
                return;
            }
            if (!this.getGrid().hasPower(this.getActionPower())) {
                this.setFailReason("Not enough power");
                return;
            }
            boolean crushedd = false;
            boolean playSound = false;
            boolean playerNear = TUMaths.isPlayerNearby(this.getLocation(), MineMain.farDistance);
            for (ItemStack input : this.getInputItems()) {
                if (!MinetorioTables.isCrushable(input)) continue;
                ItemStack result = MinetorioTables.crushStack(input);
                int amountNeeded = MinetorioTables.crushCount(input);
                if (result == null || !this.getInventory().containsAtLeast(input, amountNeeded)) continue;
                this.getInventory().setItem(this.getOutputSlot(), result);
                TUMaths.removeStackAmount(this.getInventory(), input, amountNeeded);
                this.logItem(result, result.getAmount());
                this.logItem(input, -amountNeeded);
                this.getGrid().consumePower(this, this.getActionPower());
                this.setConsumingPower(true);
                playSound = true;
                crushedd = true;
                break;
            }
            if (!crushedd) {
                this.setFailReason("Nothing to crush");
            }
            if (playerNear) {
                if (playSound && TUMaths.isPlayerNearby(this.getLocation(), MineMain.closeDistance)) {
                    this.getLocation().getWorld().playSound(this.getLocation(), Sound.BLOCK_ANVIL_PLACE, 0.05f, 0.7f);
                } else if (!crushedd) {
                    this.spawnInactiveParticles();
                }
            }
        }
    }
}

