/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices;

import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Belt;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Lift;
import com.MT.xxxtrigger50xxx.Devices.Mover;
import com.MT.xxxtrigger50xxx.Devices.MoverIOCenter;
import com.MT.xxxtrigger50xxx.Devices.Producers.ElectricBlastFurnace;
import com.MT.xxxtrigger50xxx.Devices.Producers.ElectricFurnace;
import com.MT.xxxtrigger50xxx.Devices.Producers.ElectricSmoker;
import com.MT.xxxtrigger50xxx.Devices.Transport.TrainStation;
import com.MT.xxxtrigger50xxx.Devices.VanillaDevice;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import us.lynuxcraft.deadsilenceiv.advancedchests.AdvancedChestsAPI;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.AdvancedChest;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.page.ChestPage;

public class MoverInput {
    private Mover mover;
    private MoverIOCenter.DeviceIOType type;
    private transient Inventory cachedInv = null;
    private boolean grabBothOverride = false;
    private int cX;
    private int cZ;
    private World world;
    private HashSet<Integer> cachedInputSlots;
    private int invSize = 0;
    private static Predicate<Entity> itemFilter = entity -> entity instanceof Item;
    private Location centerCache = null;

    public MoverInput(Mover mover, MoverIOCenter.DeviceIOType inType, boolean grabBoth) {
        this.setMover(mover);
        this.setType(inType);
        this.setGrabBothOverride(grabBoth);
        this.world = mover.getLocation().getWorld();
        this.cX = mover.getInChunk().getX();
        this.cZ = mover.getInChunk().getZ();
        this.getInventory();
    }

    public boolean isLoaded() {
        return this.world.isChunkLoaded(this.cX, this.cZ);
    }

    public Mover getMover() {
        return this.mover;
    }

    public void setMover(Mover mover) {
        this.mover = mover;
    }

    public MoverIOCenter.DeviceIOType getType() {
        return this.type;
    }

    public void setType(MoverIOCenter.DeviceIOType type) {
        this.type = type;
    }

    public Inventory getInventory() {
        ElectricFurnace ef;
        Device device;
        TrainStation ts;
        if (this.cachedInv != null) {
            return this.cachedInv;
        }
        if (this.type.equals((Object)MoverIOCenter.DeviceIOType.CHAIN) || this.type.equals((Object)MoverIOCenter.DeviceIOType.STANDARD)) {
            this.cachedInv = Device.getDevice(this.mover.getInputLocation()).getInventory();
            return this.cachedInv;
        }
        if (this.type.equals((Object)MoverIOCenter.DeviceIOType.CRAFTER)) {
            this.cachedInv = Device.getDevice(this.mover.getInputLocation()).getInventory();
            return this.cachedInv;
        }
        if (this.type.equals((Object)MoverIOCenter.DeviceIOType.AUTODEVICE)) {
            this.cachedInv = Device.getDevice(this.mover.getInputLocation()).getInventory();
            return this.cachedInv;
        }
        if (this.type.equals((Object)MoverIOCenter.DeviceIOType.ASSEMBLER)) {
            this.cachedInv = Device.getDevice(this.mover.getInputLocation()).getInventory();
            return this.cachedInv;
        }
        if (this.type.equals((Object)MoverIOCenter.DeviceIOType.TRAIN_STATION) && (ts = (TrainStation)Device.getDevice(this.mover.getInputLocation())) != null) {
            this.cachedInv = ts.getInventory();
            return this.cachedInv;
        }
        if (this.type.equals((Object)MoverIOCenter.DeviceIOType.STORAGE_CART)) {
            for (Entity ent : this.mover.getInputLocation().getWorld().getNearbyEntities(this.mover.getInputLocation(), 1.0, 1.0, 1.0)) {
                if (!ent.getType().equals((Object)MineMain.version.getMinecartChestEntityType())) continue;
                StorageMinecart sm = (StorageMinecart)ent;
                this.cachedInv = sm.getInventory();
                return this.cachedInv;
            }
        }
        if ((device = Device.getDevice(this.mover.getInputLocation())) instanceof ElectricFurnace) {
            ef = (ElectricFurnace)device;
            this.cachedInv = ef.getInventory();
            return this.cachedInv;
        }
        if (device instanceof ElectricBlastFurnace) {
            ef = (ElectricBlastFurnace)device;
            this.cachedInv = ef.getInventory();
            return this.cachedInv;
        }
        if (device instanceof ElectricSmoker) {
            ef = (ElectricSmoker)device;
            this.cachedInv = ef.getInventory();
            return this.cachedInv;
        }
        if (MoverIOCenter.isBlockHolderIOType(this.type)) {
            if (this.type.equals((Object)MoverIOCenter.DeviceIOType.DISPENSER) && Mover.isMover(this.mover.getInputLocation())) {
                return null;
            }
            VanillaDevice vd = VanillaDevice.getVanillaDevice(this.mover.getInputLocation());
            if (vd != null) {
                this.cachedInv = vd.getInventory();
                return this.cachedInv;
            }
        }
        return null;
    }

    public int getInventorySize() {
        if (this.invSize != 0) {
            return this.invSize;
        }
        if (this.getInventory() != null) {
            this.invSize = this.getInventory().getSize();
        }
        return this.invSize;
    }

    private boolean isGrabber(Belt belt) {
        boolean isGrabber = false;
        if (!belt.getDirection().equals((Object)this.getMover().getFacing())) {
            isGrabber = true;
        }
        return isGrabber;
    }

    private boolean isGrabber(Lift lift) {
        boolean isGrabber = false;
        if (!lift.getMover().liftDirection.equals((Object)this.getMover().getFacing())) {
            isGrabber = true;
        }
        return isGrabber;
    }

    public ArrayList<ItemStack> getStacks() {
        ItemStack leftStack;
        ItemStack rightStack;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (this.getType().equals((Object)MoverIOCenter.DeviceIOType.ADVANCED_CHEST)) {
            AdvancedChest chest = AdvancedChestsAPI.getChestManager().getAdvancedChest(this.mover.getInputLocation());
            int i = 0;
            while (i <= chest.getPages().size() - 1) {
                ChestPage page = chest.getPageById(i);
                Inventory inventory = page.getBukkitInventory();
                int a = 0;
                while (a < inventory.getSize() - 9) {
                    ItemStack stack = inventory.getItem(a);
                    if (stack != null) {
                        if (this.mover.hasFilters()) {
                            if (this.mover.isFilterItem(stack)) {
                                stacks.add(stack);
                            }
                        } else {
                            stacks.add(stack);
                        }
                    }
                    ++a;
                }
                ++i;
            }
            return stacks;
        }
        if (this.centerCache == null) {
            this.centerCache = TUMaths.centerLocation(this.mover.getLocation(), 0.0);
        }
        if (this.getType().equals((Object)MoverIOCenter.DeviceIOType.AIR)) {
            if (MinetorioListener.isPlayerNearbyOPT(this.centerCache, MineMain.chunkViewDistance)) {
                Location loc = this.getMover().getInputPickupLocation();
                for (Entity entity : loc.getWorld().getNearbyEntities(loc, 0.5, 0.5, 0.5, itemFilter)) {
                    Item item = (Item)entity;
                    if (item.hasMetadata(MineMain.noPickupMetaValue) || MineMain.usingEliteMobs && item.hasMetadata("betterdrops_ignore")) continue;
                    stacks.add(item.getItemStack());
                    break;
                }
            }
            return stacks;
        }
        if (this.getType().equals((Object)MoverIOCenter.DeviceIOType.LIFT)) {
            Lift lift = Lift.getLift(this.getMover().getInputLocation());
            if (lift != null) {
                if (this.getMover().getFacing().equals((Object)BlockFace.UP) || this.getMover().getFacing().equals((Object)BlockFace.DOWN)) {
                    if (lift.getLeftStack() != null) {
                        stacks.add(lift.getLeftStack());
                    }
                    if (lift.getRightStack() != null) {
                        stacks.add(lift.getRightStack());
                    }
                    return stacks;
                }
                ItemStack stack = lift.getClosestStack(this.centerCache, this.grabBothOverride);
                if (stack != null) {
                    stacks.add(stack);
                }
            }
            return stacks;
        }
        if (!this.getType().equals((Object)MoverIOCenter.DeviceIOType.BELT)) {
            Inventory inv = this.getInventory();
            if (inv != null) {
                int invSize = this.getInventorySize();
                for (int slot : MoverIOCenter.getInSlots(this)) {
                    ItemStack slotStack;
                    if (slot >= invSize || !TUItems.isValid(slotStack = inv.getItem(slot))) continue;
                    if (this.mover.hasFilters()) {
                        if (!this.mover.isFilterItem(slotStack)) continue;
                        stacks.add(slotStack);
                        continue;
                    }
                    stacks.add(slotStack);
                }
            }
            return stacks;
        }
        Belt belt = Belt.getBelt(this.mover.getInputLocation());
        if (belt == null) {
            return stacks;
        }
        boolean isVertical = false;
        if (this.mover.getFacing().equals((Object)BlockFace.DOWN) || this.mover.getFacing().equals((Object)BlockFace.UP) || this.isGrabBothOverride()) {
            isVertical = true;
        }
        if ((rightStack = belt.getRightStack()) != null) {
            Location center;
            if (this.centerCache == null) {
                this.centerCache = TUMaths.centerLocation(this.mover.getLocation(), 0.0);
            }
            if ((center = this.centerCache).distance(belt.getRightLocation()) <= 1.08 || isVertical && center.distance(belt.getRightLocation()) <= 1.33) {
                if (this.mover.hasFilters()) {
                    if (this.mover.isFilterItem(rightStack)) {
                        stacks.add(rightStack);
                    }
                } else {
                    stacks.add(rightStack);
                }
            }
        }
        if ((leftStack = belt.getLeftStack()) != null) {
            Location center;
            if (this.centerCache == null) {
                this.centerCache = TUMaths.centerLocation(this.mover.getLocation(), 0.0);
            }
            if ((center = this.centerCache).distance(belt.getLeftLocation()) <= 1.08 || isVertical && center.distance(belt.getLeftLocation()) <= 1.33) {
                if (this.mover.hasFilters()) {
                    if (this.mover.isFilterItem(leftStack)) {
                        stacks.add(leftStack);
                    }
                } else {
                    stacks.add(leftStack);
                }
            }
        }
        return stacks;
    }

    public void removeStack(ItemStack item, int amount) {
        if (this.getType().equals((Object)MoverIOCenter.DeviceIOType.ADVANCED_CHEST)) {
            AdvancedChest chest = AdvancedChestsAPI.getChestManager().getAdvancedChest(this.mover.getInputLocation());
            int i = 0;
            while (i <= chest.getPages().size() - 1) {
                ChestPage page = chest.getPageById(i);
                Inventory inventory = page.getBukkitInventory();
                if (inventory.containsAtLeast(item, amount)) {
                    TUMaths.removeStackAmount(inventory, item, amount);
                    return;
                }
                ++i;
            }
            return;
        }
        if (this.getType().equals((Object)MoverIOCenter.DeviceIOType.AIR)) {
            item.setAmount(item.getAmount() - 1);
        }
        if (this.getType().equals((Object)MoverIOCenter.DeviceIOType.LIFT)) {
            boolean override;
            ItemStack closest;
            Lift lift = Lift.getLift(this.getMover().getInputLocation());
            if (lift != null && (closest = lift.getClosestStack(this.centerCache, override = this.grabBothOverride || !this.isGrabber(lift))) != null) {
                if (lift.isLeftCloser(this.centerCache)) {
                    if (lift.getLeftStack() != null && closest.equals((Object)lift.getLeftStack())) {
                        lift.setLeftStack(null);
                        return;
                    }
                    if (lift.leftTransit != null && closest.equals((Object)lift.leftTransit.getItemStack())) {
                        lift.leftTransit.remove();
                        lift.leftTransit = null;
                        return;
                    }
                    if (lift.getRightStack() != null && closest.equals((Object)lift.getRightStack())) {
                        lift.setRightStack(null);
                        return;
                    }
                    if (lift.rightTransit != null && closest.equals((Object)lift.rightTransit.getItemStack())) {
                        lift.rightTransit.remove();
                        lift.rightTransit = null;
                        return;
                    }
                } else {
                    if (lift.getRightStack() != null && closest.equals((Object)lift.getRightStack())) {
                        lift.setRightStack(null);
                        return;
                    }
                    if (lift.rightTransit != null && closest.equals((Object)lift.rightTransit.getItemStack())) {
                        lift.rightTransit.remove();
                        lift.rightTransit = null;
                        return;
                    }
                    if (lift.getLeftStack() != null && closest.equals((Object)lift.getLeftStack())) {
                        lift.setLeftStack(null);
                        return;
                    }
                    if (lift.leftTransit != null && closest.equals((Object)lift.leftTransit.getItemStack())) {
                        lift.leftTransit.remove();
                        lift.leftTransit = null;
                        return;
                    }
                }
            }
            return;
        }
        if (!this.getType().equals((Object)MoverIOCenter.DeviceIOType.BELT)) {
            Inventory inventory = this.getInventory();
            ItemStack removeItem = item.clone();
            removeItem.setAmount(1);
            for (int i : MoverIOCenter.getInSlots(this)) {
                if (amount <= 0) break;
                if (inventory.getItem(i) == null || inventory.getItem(i).getType().equals((Object)Material.AIR)) continue;
                ItemStack comparingItem = inventory.getItem(i).clone();
                comparingItem.setAmount(1);
                if (!comparingItem.equals((Object)removeItem)) continue;
                int amountInStack = inventory.getItem(i).getAmount();
                if (amountInStack > amount) {
                    ItemStack newItem = inventory.getItem(i);
                    newItem.setAmount(amountInStack - amount);
                    inventory.setItem(i, newItem);
                    amount = 0;
                    continue;
                }
                amount -= amountInStack;
                inventory.setItem(i, new ItemStack(Material.AIR));
            }
            return;
        }
        Belt belt = Belt.getBelt(this.mover.getInputLocation());
        boolean isGrabber = this.isGrabber(belt);
        boolean isVertical = false;
        if (this.mover.getFacing().equals((Object)BlockFace.DOWN) || this.mover.getFacing().equals((Object)BlockFace.UP) || this.isGrabBothOverride()) {
            isVertical = true;
        }
        boolean grabLeft = false;
        boolean grabRight = false;
        if (isGrabber) {
            Location center = TUMaths.centerLocation(this.mover.getLocation(), 0.0);
            if (center.distance(belt.getLeftLocation()) < center.distance(belt.getRightLocation())) {
                grabLeft = true;
            } else {
                grabRight = true;
            }
        }
        if (this.attemptRemoveLeft(belt, isGrabber, grabLeft, isVertical, item)) {
            return;
        }
        if (this.attemptRemoveRight(belt, isGrabber, grabRight, isVertical, item)) {
            return;
        }
        if (belt.getLeftStack() != null && belt.getLeftStack().isSimilar(item)) {
            this.removeLeft(belt);
            return;
        }
        if (belt.getRightStack() != null && belt.getRightStack().isSimilar(item)) {
            this.removeRight(belt);
            return;
        }
    }

    private boolean attemptRemoveLeft(Belt belt, boolean isGrabber, boolean grabLeft, boolean isVertical, ItemStack item) {
        ItemStack leftStack = belt.getLeftStack();
        if (leftStack != null && ((!isGrabber || isGrabber && grabLeft) && leftStack.isSimilar(item) || isVertical && leftStack.isSimilar(item))) {
            this.removeLeft(belt);
            return true;
        }
        return false;
    }

    private void removeLeft(Belt belt) {
        belt.setLeftStack(null);
        if (belt.leftIncoming != null && !belt.isLastBelt) {
            final ItemDisplay incomingFinal = belt.leftIncoming;
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    incomingFinal.remove();
                }
            }, belt.lastMoveDelay / 2L);
        }
    }

    private boolean attemptRemoveRight(Belt belt, boolean isGrabber, boolean grabRight, boolean isVertical, ItemStack item) {
        ItemStack rightStack = belt.getRightStack();
        if (rightStack != null && ((!isGrabber || isGrabber && grabRight) && rightStack.isSimilar(item) || isVertical && rightStack.isSimilar(item))) {
            this.removeRight(belt);
            return true;
        }
        return false;
    }

    private void removeRight(Belt belt) {
        belt.setRightStack(null);
        if (belt.rightIncoming != null && !belt.isLastBelt) {
            final ItemDisplay incomingFinal = belt.rightIncoming;
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    incomingFinal.remove();
                }
            }, belt.lastMoveDelay / 2L);
        }
    }

    public boolean isGrabBothOverride() {
        return this.grabBothOverride;
    }

    public void setGrabBothOverride(boolean grabBothOverride) {
        this.grabBothOverride = grabBothOverride;
    }

    public void setCachedDynamicSlot(HashSet<Integer> slots) {
        this.cachedInputSlots = slots;
    }

    public HashSet<Integer> getCachedInputSlots() {
        if (this.cachedInputSlots == null) {
            return null;
        }
        return this.cachedInputSlots;
    }
}

