/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices;

import com.MT.triggersUtility.SkullCreator;
import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Guide.ExampleFactorys;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.LocaleUtil;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.PowerGrid;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class PowerPylon
extends Device {
    private static final long serialVersionUID = -3929401797254451315L;
    public static PowerLineType lineType = PowerLineType.NONE;
    private static String classSpacedNamed = "Power Pylon";

    public PowerPylon(Location loc) {
        super(loc);
        this.setMaterial("OBSERVER");
        this.deviceName = "Power Pylon";
        this.setActionTimer(3);
        this.setActionPower(1);
        this.setIdlePower(0);
        this.setOpenable(true);
        this.setGridRange(20);
        this.setUseUI(true);
        this.setStoreForm(false);
        this.updateDeviceHeadItem();
        this.displayLockedHorizontal = true;
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- This device has a large power range.");
        lore.add("- Making it useful for power to other devices.");
        return lore;
    }

    @Override
    public void updateUI() {
        ArrayList<String> gridInfo = new ArrayList<String>();
        PowerGrid grid = this.getGrid();
        if (grid != null) {
            gridInfo.add(MineUtil.colon(" Current Load", MineItems.getEnergyIcon() + grid.getLastConsume()) + "/" + MineItems.getEnergyIcon() + grid.getPotentialLoad());
            gridInfo.add(MineUtil.colon(" Power Production", MineItems.getEnergyIcon() + grid.getLastGenerate() + "/" + MineItems.getEnergyIcon() + grid.getPotentialGeneration()));
            int netRate = this.getGrid().getLastGenerate() - grid.getLastConsume();
            String rate = String.valueOf(ChatColor.GREEN) + MineItems.getEnergyIcon() + netRate;
            if (netRate <= 0) {
                rate = String.valueOf(ChatColor.RED) + ChatColor.stripColor((String)rate);
            }
            gridInfo.add(MineUtil.colon(" Net Power", rate));
            int maxCap = this.getGrid().batteryMaxCapacity();
            int bat = grid.batteryPower();
            Object capStr = "" + maxCap;
            Object batStr = "" + bat;
            if (maxCap > 10000) {
                capStr = TUMaths.simplifyNumber(maxCap);
                batStr = TUMaths.simplifyNumber(bat);
            }
            gridInfo.add(MineUtil.colon(" Battery Power", MineItems.getEnergyIcon() + (String)batStr + "/" + MineItems.getEnergyIcon() + (String)capStr));
            gridInfo.add(MineUtil.colon(" Connections", String.valueOf(this.getGrid().gridSize())));
            gridInfo.add(MineUtil.colon(" Grid Score", "" + grid.getGridScore()));
            if (maxCap >= bat && this.getGrid().getPower() > 0) {
                gridInfo.add(" ");
                gridInfo.add(MineItems.redBold() + " Wasting Power");
            }
        } else {
            gridInfo.add(MineItems.redBold() + " No Grid Connection");
        }
        if (!this.getPoweredState().equals((Object)Device.PoweredState.ON)) {
            gridInfo.add(" ");
            gridInfo.add(MineItems.redBold() + " " + this.getPoweredStateString());
        }
        ArrayList<String> loadInfo = new ArrayList<String>();
        if (grid != null) {
            int idleLoad = 0;
            int activeLoad = 0;
            int total = 0;
            HashMap<Device, Integer> lastConsumers = grid.getLastConsumers();
            HashMap<String, Integer> activeLoadConsumers = new HashMap<String, Integer>();
            HashMap<String, Integer> idleLoadConsumers = new HashMap<String, Integer>();
            HashMap<String, Integer> activeLoadConsumersCount = new HashMap<String, Integer>();
            HashMap<String, Integer> idleLoadConsumersCount = new HashMap<String, Integer>();
            for (Device device : new ArrayList<Device>(lastConsumers.keySet())) {
                total += lastConsumers.get(device).intValue();
                if (lastConsumers.get(device).intValue() != device.getIdlePower()) {
                    activeLoad += device.getActionPower() + device.getIdlePower();
                    activeLoadConsumers.put(device.getName(), activeLoadConsumers.getOrDefault(device.getName(), 0) + device.getActionPower() + device.getIdlePower());
                    activeLoadConsumersCount.put(device.getName(), activeLoadConsumersCount.getOrDefault(device.getName(), 0) + 1);
                    continue;
                }
                idleLoad += device.getIdlePower();
                idleLoadConsumers.put(device.getName(), idleLoadConsumers.getOrDefault(device.getName(), 0) + device.getIdlePower());
                idleLoadConsumersCount.put(device.getName(), idleLoadConsumersCount.getOrDefault(device.getName(), 0) + 1);
            }
            loadInfo.add(MineUtil.colon(" Total Load", MineItems.getEnergyIcon() + total));
            loadInfo.add(MineUtil.colon(" Potential Load", MineItems.getEnergyIcon() + grid.getPotentialLoad()));
            loadInfo.add(" ");
            loadInfo.add(MineItems.whiteBold() + " Active Load >> " + MineItems.getEnergyIcon() + activeLoad);
            for (String activeLoadDevice : new ArrayList(activeLoadConsumers.keySet())) {
                loadInfo.add(String.valueOf(ChatColor.GOLD) + "  " + String.valueOf(activeLoadConsumersCount.get(activeLoadDevice)) + "x " + activeLoadDevice + " " + String.valueOf(ChatColor.WHITE) + MineItems.getEnergyIcon() + String.valueOf(activeLoadConsumers.get(activeLoadDevice)));
            }
            loadInfo.add(" ");
            loadInfo.add(MineItems.whiteBold() + " Idle Load >> " + MineItems.getEnergyIcon() + idleLoad);
            for (String idleLoadDevice : new ArrayList(idleLoadConsumers.keySet())) {
                loadInfo.add(String.valueOf(ChatColor.GOLD) + "  " + String.valueOf(idleLoadConsumersCount.get(idleLoadDevice)) + "x " + idleLoadDevice + " " + String.valueOf(ChatColor.WHITE) + MineItems.getEnergyIcon() + String.valueOf(idleLoadConsumers.get(idleLoadDevice)));
            }
        } else {
            loadInfo.add(MineItems.redBold() + " No Grid Connection");
        }
        ArrayList<String> genInfo = new ArrayList<String>();
        if (grid != null) {
            int totalPower = 0;
            int renewablePower = 0;
            int dirtyPower = 0;
            HashMap<Device, Integer> lastGenerators = grid.getLastGenerators();
            HashMap<String, Integer> renewableGenCount = new HashMap<String, Integer>();
            HashMap<String, Integer> renewableGenTotal = new HashMap<String, Integer>();
            HashMap<String, Integer> dirtyGenCount = new HashMap<String, Integer>();
            HashMap<String, Integer> dirtyGenTotal = new HashMap<String, Integer>();
            for (Device device : new ArrayList<Device>(lastGenerators.keySet())) {
                int genned = lastGenerators.get(device);
                totalPower += genned;
                if (PowerPylon.isReneweable(device.getName())) {
                    renewablePower += genned;
                    renewableGenTotal.put(device.getName(), renewableGenTotal.getOrDefault(device.getName(), 0) + genned);
                    renewableGenCount.put(device.getName(), renewableGenCount.getOrDefault(device.getName(), 0) + 1);
                    continue;
                }
                dirtyGenTotal.put(device.getName(), dirtyGenTotal.getOrDefault(device.getName(), 0) + genned);
                dirtyGenCount.put(device.getName(), dirtyGenCount.getOrDefault(device.getName(), 0) + 1);
                dirtyPower += genned;
            }
            genInfo.add(MineUtil.colon(" Total Power", MineItems.getEnergyIcon() + totalPower));
            genInfo.add(MineUtil.colon(" Potential Power", MineItems.getEnergyIcon() + grid.getPotentialGeneration()));
            genInfo.add(" ");
            genInfo.add(MineItems.whiteBold() + " Renewable Power >> " + MineItems.getEnergyIcon() + renewablePower);
            for (String string : new ArrayList(renewableGenTotal.keySet())) {
                genInfo.add(String.valueOf(ChatColor.GOLD) + "  " + String.valueOf(renewableGenCount.get(string)) + "x " + string + " " + String.valueOf(ChatColor.WHITE) + MineItems.getEnergyIcon() + String.valueOf(renewableGenTotal.get(string)));
            }
            genInfo.add(" ");
            genInfo.add(MineItems.whiteBold() + " Non-Renewable Power >> " + MineItems.getEnergyIcon() + dirtyPower);
            for (String string : new ArrayList(dirtyGenTotal.keySet())) {
                genInfo.add(String.valueOf(ChatColor.GOLD) + "  " + String.valueOf(dirtyGenCount.get(string)) + "x " + string + " " + String.valueOf(ChatColor.WHITE) + MineItems.getEnergyIcon() + String.valueOf(dirtyGenTotal.get(string)));
            }
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            HashMap<String, Integer> inactiveTotal = new HashMap<String, Integer>();
            int totalInactive = 0;
            for (Device device : grid.getPowerGenerators()) {
                if (lastGenerators.containsKey(device)) continue;
                inactiveTotal.put(device.getName(), inactiveTotal.getOrDefault(device.getName(), 0) + device.getPowerGen());
                hashMap.put(device.getName(), hashMap.getOrDefault(device.getName(), 0) + 1);
                totalInactive += device.getPowerGen();
            }
            genInfo.add(" ");
            genInfo.add(MineItems.whiteBold() + " Inactive Power >> " + MineItems.getEnergyIcon() + totalInactive);
            for (String string : new ArrayList(inactiveTotal.keySet())) {
                genInfo.add(String.valueOf(ChatColor.GOLD) + "  " + String.valueOf(hashMap.get(string)) + "x " + string + " " + String.valueOf(ChatColor.WHITE) + MineItems.getEnergyIcon() + String.valueOf(inactiveTotal.get(string)));
            }
        } else {
            genInfo.add(MineItems.redBold() + " No Grid Connection");
        }
        ItemStack powerStack = TUItems.setModelData(TUItems.createItem(Material.OBSERVER, String.valueOf(MineItems.whiteBold()) + "Grid Information", gridInfo), 9524);
        ItemStack loadStack = TUItems.setModelData(TUItems.createItem(Material.RED_CONCRETE, String.valueOf(MineItems.whiteBold()) + "Load Information", loadInfo), 9524);
        ItemStack genStack = TUItems.setModelData(TUItems.createItem(Material.GREEN_CONCRETE, String.valueOf(MineItems.whiteBold()) + "Generation Information", genInfo), 9524);
        Inventory inv = this.getInventory();
        inv.setItem(8, this.createUpgradeStack());
        inv.setItem(15, genStack);
        inv.setItem(13, powerStack);
        inv.setItem(11, loadStack);
        ItemStack gPane = MainMenu.createGoldPane();
        int i = 0;
        while (i <= 26) {
            if (i != 13 && i != 11 && i != 15 && i != 8) {
                inv.setItem(i, gPane);
            }
            ++i;
        }
    }

    public ItemStack createUpgradeStack() {
        ItemStack upgradeStack = ExampleFactorys.directionHead("UP").clone();
        ArrayList<String> lore = new ArrayList<String>();
        if (!this.isUpgradedPylon()) {
            lore.addAll(MineUtil.wrapText("You can click this to upgrade the power pylon. Upgrading it increases its power pylon range by 3x! This will take the require materials from your inventory and place the blocks for you. Make sure the area above this is clear!", 45, ChatColor.WHITE, 1));
            lore.add(" ");
            lore.add(MineUtil.colon(" " + LocaleUtil.uiText("General_Click"), "Upgrade!"));
        } else {
            lore.addAll(MineUtil.wrapText("This power pylon can reach other power pylons that are 3x the distance then normal!", 45, ChatColor.WHITE, 1));
            lore.add(" ");
            lore.add(String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.BOLD) + " Power Pylon Upgraded");
        }
        TUItems.addLore(upgradeStack, lore);
        TUItems.setName(upgradeStack, MineItems.goldBold() + "Power Pylon Upgrade");
        return upgradeStack;
    }

    @Override
    public void onUIClick(InventoryClickEvent event) {
        this.pylonUpgradeClick(this.getLocation(), this.getFacing(), event);
    }

    public void pylonUpgradeClick(Location location, BlockFace face, InventoryClickEvent event) {
        if (event.getSlot() == 8) {
            if (!location.getBlock().getRelative(BlockFace.UP).getType().toString().contains("WALL")) {
                if (MineUtil.hasInventoryTaggedItem((Inventory)event.getWhoClicked().getInventory(), "WALL")) {
                    location.getBlock().getRelative(BlockFace.UP).setType(MineUtil.removeInventoryTaggedItem((Inventory)event.getWhoClicked().getInventory(), "WALL"));
                } else {
                    MineUtil.sendWarning((CommandSender)event.getWhoClicked(), LocaleUtil.messageText("Pylon_Need_Wall"));
                    return;
                }
            }
            Block block = location.getBlock().getRelative(BlockFace.UP);
            int i = 0;
            while (i <= 3) {
                if (!(block = block.getRelative(BlockFace.UP)).getType().toString().contains("FENCE")) {
                    if (MineUtil.hasInventoryTaggedItem((Inventory)event.getWhoClicked().getInventory(), "FENCE")) {
                        block.setType(MineUtil.removeInventoryTaggedItem((Inventory)event.getWhoClicked().getInventory(), "FENCE"));
                    } else {
                        MineUtil.sendWarning((CommandSender)event.getWhoClicked(), LocaleUtil.messageText("Pylon_Need_Fence"));
                        return;
                    }
                }
                ++i;
            }
            BlockFace facing = face;
            BlockFace checkFace1 = BlockFace.NORTH;
            BlockFace checkFace2 = BlockFace.SOUTH;
            if (facing.equals((Object)BlockFace.NORTH) || facing.equals((Object)BlockFace.SOUTH)) {
                checkFace1 = BlockFace.EAST;
                checkFace2 = BlockFace.WEST;
            }
            if (!block.getRelative(checkFace1).getType().toString().contains("FENCE")) {
                if (MineUtil.hasInventoryTaggedItem((Inventory)event.getWhoClicked().getInventory(), "FENCE")) {
                    block.getRelative(checkFace1).setType(MineUtil.removeInventoryTaggedItem((Inventory)event.getWhoClicked().getInventory(), "FENCE"));
                } else {
                    MineUtil.sendWarning((CommandSender)event.getWhoClicked(), LocaleUtil.messageText("Pylon_Need_Fence"));
                    return;
                }
            }
            if (!block.getRelative(checkFace2).getType().toString().contains("FENCE")) {
                if (MineUtil.hasInventoryTaggedItem((Inventory)event.getWhoClicked().getInventory(), "FENCE")) {
                    block.getRelative(checkFace2).setType(MineUtil.removeInventoryTaggedItem((Inventory)event.getWhoClicked().getInventory(), "FENCE"));
                } else {
                    MineUtil.sendWarning((CommandSender)event.getWhoClicked(), LocaleUtil.messageText("Pylon_Need_Fence"));
                    return;
                }
            }
            MineUtil.sendMessage((CommandSender)event.getWhoClicked(), LocaleUtil.messageText("Pylon_Fully_Upgraded"));
        }
    }

    public static boolean isReneweable(String name) {
        if (name.equals("Solar Panel") || name.equals("Moonlight Panel")) {
            return true;
        }
        if (name.equals("Cold Fusion Reactor")) {
            return true;
        }
        if (name.equals("Geothermal Generator") || name.equals("Wind Turbine")) {
            return true;
        }
        return name.equals("Tidal Generator") || name.equals("Lightning Generator");
    }

    @Override
    public void action() {
        if (this.getGrid() != null && this.getGrid().hasPower(this.getActionPower())) {
            this.getGrid().consumePower(this, this.getActionPower());
            this.setConsumingPower(true);
        }
        this.checkPylonVisualUpdate();
    }

    public void checkPylonVisualUpdate() {
        if (this.getGrid() != null && this.getGrid().gridSize() > 1 && this.getPoweredState().equals((Object)Device.PoweredState.ON)) {
            this.updateDisplayStack(SkullCreator.getHead("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNTc0YzAzMmE4MjhlODI5YTY4ODcwYjlkYTZmNzYxZmUwMWYxN2NmMTlkZDJlOTU3NGYwZDgxMDcwMDVkZmU3ZiJ9fX0="));
        } else {
            this.updateDisplayStack(this.getDisplayStack());
        }
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.REDSTONE_TORCH, 1.0);
    }

    @Override
    public boolean allowGridConnectionTick() {
        if (!this.getPoweredState().equals((Object)Device.PoweredState.ON)) {
            if (this.getGrid() != null) {
                this.disconnectFromGrid();
            }
            return false;
        }
        return true;
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, PowerPylon.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.POWER, new PowerPylon(null).getDeviceStack(), false);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(new ItemStack(Material.COPPER_INGOT, 2));
        ings.add(new ItemStack(Material.REDSTONE));
        ings.add(new ItemStack(Material.SMOOTH_STONE, 6));
        RecipeUtils.addDefaultRecipe(new PowerPylon(null).getDeviceStack(), ings, MTRecipe.RecipeType.CRUDE, false);
    }

    public static enum PowerLineType {
        DISPLAY,
        PARTICLE,
        NONE;

    }
}

