/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Producers;

import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.MushroomCow;
import org.bukkit.inventory.ItemStack;

public class AutoMilker
extends Device {
    private static final long serialVersionUID = 7571974070728037022L;
    private transient Item item = null;

    public AutoMilker(Location loc) {
        super(loc);
        this.setMaterial("QUARTZ_SLAB");
        this.deviceName = "Auto Milker";
        this.setActionTimer(5);
        this.setGridRange(5);
        this.setUseUI(true);
        this.setRefreshInv(false);
        this.setIdlePower(1);
        this.setActionPower(5);
        this.useAutoSlots();
        this.setPollutionGen(5);
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Will milk any cows nearby!");
        lore.add("- This requires a empty bucket to be in the input slots to operate.");
        lore.add("- Input slots are the top row of slots.");
        lore.add("- Each milk bucket collected is placed into its own output slot.");
        lore.add("- A mover will only extract items from the output slots.");
        lore.add("- Output slots are the bottom row of slots.");
        lore.add("- Range is limited to a 10x10x10 area.");
        return lore;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.MILK_BUCKET, 0.5);
    }

    @Override
    public void cleanup() {
        if (this.item != null) {
            this.item.remove();
        }
    }

    @Override
    public void action() {
        if (this.isPowered()) {
            if (this.getOutputSlot() == -1) {
                this.setFailReason("No output space");
                return;
            }
            boolean playSound = false;
            boolean playerNear = TUMaths.isPlayerNearby(this.getLocation(), MineMain.distantDistance);
            boolean hasBuckets = false;
            block0: for (Entity entity : MineUtil.getEntitiesInCubeRange(this.getLocation(), 5.0)) {
                ItemStack milk;
                Cow cow;
                if (!this.getGrid().hasPower(this.getActionPower())) break;
                if (this.getOutputSlot() == -1) continue;
                for (ItemStack stack : this.getInventory()) {
                    if (stack == null || !stack.getType().equals((Object)Material.BUCKET)) continue;
                    hasBuckets = true;
                    if (!entity.getType().equals((Object)EntityType.COW)) break;
                    cow = (Cow)entity;
                    if (playerNear) {
                        MineUtil.spawnParticleLine(TUMaths.centerLocation(this.getLocation(), 0.8), cow.getEyeLocation(), MineMain.version.getDrippingLavaParticle(), 1, 0.5);
                    }
                    this.getGrid().consumePower(this, this.getActionPower());
                    this.setConsumingPower(true);
                    milk = new ItemStack(Material.MILK_BUCKET);
                    this.getInventory().setItem(this.getOutputSlot(), milk);
                    this.logItem(stack, -1);
                    this.logItem(milk);
                    stack.setAmount(stack.getAmount() - 1);
                    playSound = true;
                    break;
                }
                if (playSound) continue;
                for (ItemStack stack : this.getInventory()) {
                    if (stack == null || !stack.getType().equals((Object)Material.BOWL)) continue;
                    hasBuckets = true;
                    if (!entity.getType().equals((Object)EntityType.MOOSHROOM)) continue block0;
                    cow = (MushroomCow)entity;
                    if (playerNear) {
                        MineUtil.spawnParticleLine(TUMaths.centerLocation(this.getLocation(), 0.8), cow.getEyeLocation(), MineMain.version.getDrippingLavaParticle(), 1, 0.5);
                    }
                    this.getGrid().consumePower(this, this.getActionPower());
                    this.setConsumingPower(true);
                    milk = new ItemStack(Material.MUSHROOM_STEW);
                    this.getInventory().setItem(this.getOutputSlot(), milk);
                    this.logItem(stack, -1);
                    this.logItem(milk);
                    stack.setAmount(stack.getAmount() - 1);
                    playSound = true;
                    continue block0;
                }
            }
            if (playSound) {
                this.getLocation().getWorld().playSound(this.getLocation(), Sound.ITEM_BUCKET_FILL, 1.0f, 1.0f);
            } else {
                if (!hasBuckets) {
                    this.spawnInactiveParticles();
                }
                this.setFailReason("Missing empty buckets / bowls");
            }
        }
    }
}

