/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Spaceship;

import com.MT.triggersUtility.Events.TUEvents;
import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Spaceship.ShipCore;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Planets.SpaceObjects.ResourceAsteroid;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class AsteroidCollector
extends Device {
    private static final long serialVersionUID = 7902256251582291258L;
    private static String classSpacedNamed = "Asteroid Collector";
    private transient ResourceAsteroid target;

    public AsteroidCollector(Location loc) {
        super(loc);
        this.setMaterial("DISPENSER");
        this.deviceName = classSpacedNamed;
        this.setActionTimer(1);
        this.setOpenable(true);
        this.setStoreForm(true);
        this.setIdlePower(2);
        this.setActionPower(2);
        this.setUseUI(true);
        this.useAutoSlots();
        this.useAutoUI();
        if (loc != null) {
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    Directional directional;
                    BlockData data = AsteroidCollector.this.getLocation().getBlock().getBlockData();
                    if (data instanceof Directional && (directional = (Directional)data).getFaces().contains(BlockFace.NORTH)) {
                        directional.setFacing(BlockFace.NORTH);
                        AsteroidCollector.this.getLocation().getBlock().setBlockData((BlockData)directional);
                    }
                }
            }, 1L);
        }
        this.updateDeviceHeadItem();
        this.displayLockedHorizontal = true;
        this.lockRotation = true;
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Used to gather asteroid chunks.");
        lore.add("- Requires iron pickaxes or better!");
        lore.add("- Will always face north when placed.");
        return lore;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
        ItemStack stack = this.createInfoIcon();
        ArrayList<String> lore = new ArrayList<String>();
        if (this.target != null) {
            lore.add(" ");
            lore.add(MineItems.whiteBold() + " Asteroid Chunk Info");
            lore.add(" ");
            lore.add(MineUtil.colon(" Type", this.target.getStoredResource().getType().toString()));
            lore.add(MineUtil.colon(" Amount", "" + this.target.getStoredAmount()));
            lore.add(" ");
        } else {
            lore.add(String.valueOf(ChatColor.YELLOW) + " Scanning for chunks...");
        }
        TUItems.addLore(stack, lore);
        this.getInventory().setItem(13, stack);
    }

    @Override
    public void action() {
        if (this.getGrid() == null) {
            return;
        }
        if (this.getOutputSlot() == -1) {
            this.setFailReason("Missing output slot");
            return;
        }
        if (!this.getGrid().hasPower(this.getActionPower())) {
            if (this.target != null) {
                Location newTarget = this.target.getLocation();
                newTarget.setZ(200.0);
                this.target.setTargetLocation(newTarget);
                this.target.setCollectorLocked(false);
                this.target = null;
            }
            this.setFailReason("Need more power");
            return;
        }
        if (this.target != null && this.target.removed) {
            this.target = null;
        }
        if (this.target == null) {
            if (this.getLocationREADONLY().getWorld().getName().equals("MT_world_space") && this.getCore() != null) {
                if (this.getCore().incomingRoids == null) {
                    this.getCore().incomingRoids = new HashSet();
                }
                for (ResourceAsteroid roid : this.getCore().incomingRoids) {
                    if (roid.removed || roid.isCollectorLocked() || !roid.getAsteroidSize().equals((Object)ResourceAsteroid.Size.CHUNK) || TUMaths.get2DManhattanDistance(roid.getLocation(), this.getLocation()) > 128 || !(roid.getLocation().getZ() < this.getLocation().getZ())) continue;
                    this.target = roid;
                    this.target.setCollectorLocked(true);
                    this.target.setTargetLocation(this.getLocation().add(0.5, 0.5, -1.0));
                    break;
                }
            }
        } else {
            this.getGrid().consumePower(this, this.getActionPower());
            this.setConsumingPower(true);
            if (TUMaths.getManhattanDistance(this.target.getLocation(), this.getLocationREADONLY()) <= 1) {
                ItemStack pick = this.getPickaxe();
                if (pick == null) {
                    this.setFailReason("Missing iron or better pickaxe");
                    return;
                }
                ItemStack extracted = this.target.getStoredResource().clone();
                int amount = (extracted = this.getDrop(extracted)).getType().getMaxStackSize() / 8;
                if (amount > this.target.getStoredAmount()) {
                    amount = this.target.getStoredAmount();
                }
                extracted.setAmount(amount);
                MineUtil.damageItemStack(pick, this.getLocation(), this.getInventory(), amount);
                this.target.setStoredAmount(this.target.getStoredAmount() - amount);
                if (this.target.getStoredAmount() <= 0) {
                    this.target.removeObject();
                    this.target = null;
                }
                this.getInventory().setItem(this.getOutputSlot(), extracted);
                if (MinetorioListener.isPlayerNearby2DOPT(this.getLocation(), 6.0)) {
                    this.getLocationREADONLY().getWorld().playSound(this.getLocationREADONLY(), Sound.BLOCK_STONE_BREAK, 1.0f, 0.8f);
                }
            } else {
                int density = TUMaths.getManhattanDistance(this.getLocation(), this.target.getLocation()) / 10;
                int mod = density * 3;
                if (MinetorioListener.isPlayerNearby2DOPT(this.getLocation(), MineMain.chunkViewDistance)) {
                    this.spawnSpiralCone(this.target.group.center, this.getLocation().add(0.5, 0.5, -0.5), Particle.COMPOSTER, 1.5, 5, density, mod);
                    if (TUMaths.isMultipleOf(TUEvents.serverTimeSeconds, 3) && MinetorioListener.isPlayerNearby2DOPT(this.getLocation(), 6.0)) {
                        this.getLocationREADONLY().getWorld().playSound(this.getLocationREADONLY(), Sound.BLOCK_BEACON_AMBIENT, 1.0f, 1.0f);
                    }
                }
            }
        }
    }

    public ItemStack getDrop(ItemStack storedType) {
        if (!storedType.getType().isBlock()) {
            return storedType;
        }
        Location loc2 = this.getLocation().add(0.0, -100.0, 0.0);
        Block block = loc2.getBlock();
        Material oldType = block.getType();
        block.setType(storedType.getType(), false);
        ItemStack tool = new ItemStack(Material.IRON_PICKAXE);
        Collection drops = block.getDrops(tool);
        block.setType(oldType, false);
        Iterator iterator = drops.iterator();
        if (iterator.hasNext()) {
            ItemStack drop = (ItemStack)iterator.next();
            return drop;
        }
        return null;
    }

    private ItemStack getPickaxe() {
        for (ItemStack stack : this.getInputItems()) {
            if (!stack.getType().equals((Object)Material.IRON_PICKAXE) && !stack.getType().equals((Object)Material.DIAMOND_PICKAXE) && !stack.getType().equals((Object)Material.NETHERITE_PICKAXE)) continue;
            return stack;
        }
        return null;
    }

    private ShipCore getCore() {
        ShipCore core = null;
        ArrayList<Device> cores = Device.getNearbyDevicesByType(this.getLocation(), 100, "Ship Core");
        if (cores.size() > 0) {
            core = (ShipCore)Device.getNearbyDevicesByType(this.getLocation(), 100, "Ship Core").get(0);
        }
        return core;
    }

    public void spawnSpiralCone(Location from, Location to, final Particle particle, double radius, int revolutions, double density, double delayMod) {
        final World world = from.getWorld();
        if (world == null) {
            return;
        }
        Vector direction = to.toVector().subtract(from.toVector());
        double length = direction.length();
        direction.normalize();
        Vector ortho = direction.clone().getCrossProduct(new Vector(0, 1, 0));
        if (ortho.lengthSquared() == 0.0) {
            ortho = new Vector(1, 0, 0);
        }
        ortho.normalize();
        Vector up = direction.clone().getCrossProduct(ortho).normalize();
        int totalPoints = (int)(length * density * (double)revolutions);
        int i = 0;
        while (i <= totalPoints) {
            double t = (double)i / (double)totalPoints;
            double angle = Math.PI * 2 * (double)revolutions * t;
            Vector point = direction.clone().multiply(t * length);
            double currentRadius = radius * (1.0 - t);
            double x = Math.cos(angle) * currentRadius;
            double y = Math.sin(angle) * currentRadius;
            Vector offset = ortho.clone().multiply(x).add(up.clone().multiply(y));
            point.add(offset);
            final Location loc = from.clone().add(point);
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    world.spawnParticle(particle, loc, 0, 0.0, 0.0, 0.0, 0.0, null, true);
                }
            }, (long)((double)i / delayMod));
            ++i;
        }
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, AsteroidCollector.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.AUTOMATION, new AsteroidCollector(null).getDeviceStack(), false);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(MineItems.getIndustrialItem("Processing Unit", 3));
        ings.add(MineItems.getIndustrialItem("Electric Engine Unit", 3));
        ings.add(MineItems.getIndustrialItem("Processing Unit", 3));
        RecipeUtils.addDefaultRecipe(new AsteroidCollector(null).getDeviceStack(), ings, MTRecipe.RecipeType.ADVANCED, true);
    }

    @Override
    public int getGridScore() {
        return 3;
    }
}

