/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Spaceship;

import com.MT.triggersUtility.ChatInput;
import com.MT.triggersUtility.SkullCreator;
import com.MT.triggersUtility.TUItems;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Spaceship.ShipCore;
import com.MT.xxxtrigger50xxx.Devices.Transport.RocketSilo;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Planets.Planet;
import com.MT.xxxtrigger50xxx.Planets.PlanetHandler;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;

public class Atlas
extends Device {
    private static final long serialVersionUID = -3141147692747844336L;
    private static String classSpacedNamed = "Atlas";
    private transient HashMap<String, Entity> atlastEnts;
    private transient boolean leftCooldown = false;
    private transient boolean rightCooldown = false;
    private transient boolean confirmCooldown = false;
    private String targetPlanet = "Earthlike";

    public Atlas(Location loc) {
        super(loc);
        this.setMaterial("CARTOGRAPHY_TABLE");
        this.deviceName = classSpacedNamed;
        this.setActionTimer(1);
        this.setOpenable(true);
        this.setStoreForm(true);
        this.setIdlePower(2);
        this.setActionPower(2);
        this.setUseUI(true);
        if (loc != null) {
            this.populateUI();
            this.targetPlanet = "Earthlike";
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    Directional directional;
                    BlockData data = Atlas.this.getLocation().getBlock().getBlockData();
                    if (data instanceof Directional && (directional = (Directional)data).getFaces().contains(BlockFace.SOUTH)) {
                        directional.setFacing(BlockFace.SOUTH);
                        Atlas.this.getLocation().getBlock().setBlockData((BlockData)directional);
                    }
                }
            }, 1L);
        }
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Used to propel connected spaceships.");
        lore.add("- Will always face south when placed.");
        lore.add("- Will damage and break blocks in south direction.");
        lore.add("- In a 3x3x10 area!");
        return lore;
    }

    @Override
    public void updateUI() {
        this.populateUI();
    }

    public void populateUI() {
        int i = 0;
        while (i <= 26) {
            this.getInventory().setItem(i, MainMenu.createGoldPane());
            ++i;
        }
        ItemStack info = this.createInfoIcon();
        ArrayList<String> lore = new ArrayList<String>();
        int xCord = 0;
        int zCord = 0;
        int xCurrent = 0;
        int zCurrent = 0;
        int distance = 0;
        if (this.getCore() != null) {
            xCord = this.getCore().xCord;
            zCord = this.getCore().zCord;
            xCurrent = this.getCore().getVirtualLocation().getBlockX();
            zCurrent = this.getCore().getVirtualLocation().getBlockZ();
            distance = Math.abs(xCord - xCurrent) + Math.abs(zCord - zCurrent);
        }
        lore.add(MineUtil.colon(" Target Coordinates", xCord + "x/" + zCord + "z"));
        lore.add(MineUtil.colon(" Current Coordinates", xCurrent + "x/" + zCurrent + "z"));
        lore.add(MineUtil.colon(" Distance", "" + distance));
        lore.add(" ");
        lore.add(String.valueOf(ChatColor.YELLOW) + "  -> Click to set target coordinates.");
        lore.add(" ");
        String desc = "Note coordinates that are outside of the world border, when falling off the ship you will appear at the border of the world relative to your coordinates. Do not attempt to jump off the ship if the ship is not in orbit! You will simply die!";
        for (String str : MineUtil.wrapText(desc, 45)) {
            lore.add(String.valueOf(ChatColor.WHITE) + " " + str);
        }
        TUItems.addLore(info, lore);
        this.getInventory().setItem(13, info);
    }

    @Override
    public void onUIClick(InventoryClickEvent event) {
        if (event.getSlot() == 13) {
            ShipCore core = this.getCore();
            Player player = (Player)event.getWhoClicked();
            player.closeInventory();
            class ChatInput
            extends com.MT.triggersUtility.ChatInput {
                private final /* synthetic */ ShipCore val$core;
                private final /* synthetic */ Player val$player;

                public ChatInput(String startMessage, boolean numbersonly, ShipCore shipCore, Player player) {
                    this.val$core = shipCore;
                    this.val$player = player;
                    super(startMessage, numbersonly);
                }

                @Override
                public void inputAction(String message) {
                    this.val$core.setTargetCords(Integer.valueOf(message.split("/")[0]), Integer.valueOf(message.split("/")[1]));
                    this.val$player.openInventory(Atlas.this.getInventory());
                }
            }
            ChatInput input = new ChatInput("Enter the x and y coordinates to orbit above, use this format XXXX/ZZZZ, for example, 100/3", false, core, player);
            input.start(player);
        }
    }

    @Override
    public void action() {
        if (this.getGrid() == null) {
            return;
        }
        if (MinetorioListener.isPlayerNearbyOPT(this.getLocation(), 30.0)) {
            this.updateAtlas();
            this.rotateHeads();
            int i = 1;
            while (i <= 3) {
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        Atlas.this.rotateHeads();
                    }
                }, (long)i * 5L);
                ++i;
            }
        } else {
            this.removeAtlas();
        }
    }

    private void rotateHeads() {
        for (String type : new ArrayList<String>(this.atlastEnts.keySet())) {
            if (!type.equals("Center") && !type.equals("Left") && !type.equals("Right") || !this.atlastEnts.containsKey(type) || this.atlastEnts.get(type).isDead()) continue;
            ArmorStand stand = (ArmorStand)this.atlastEnts.get(type);
            stand.setHeadPose(stand.getHeadPose().add(0.0, Math.toRadians(10.0), 0.0));
        }
    }

    @Override
    public void cleanup() {
        this.removeAtlas();
    }

    private void updateAtlas() {
        if (this.atlastEnts == null) {
            this.atlastEnts = new HashMap();
        }
        this.updatePiece("Distance", this.getLocation().add(0.5, 0.0, 0.5), null, 30);
        this.updatePiece("Center", this.getLocation().add(0.5, -0.25, 0.5), null, 30);
        this.updatePiece("Left", this.getLocation().add(0.5, 0.95, 0.5).add(-0.85, 0.0, 0.0), null, 15);
        this.updatePiece("Right", this.getLocation().add(0.5, 0.95, 0.5).add(0.85, 0.0, 0.0), null, 15);
        this.updatePiece("CONFIRM", this.getLocation().add(0.5, 0.65, 1.0), null, 5);
        this.updatePiece("LB", this.getLocation().add(0.2, 0.65, 1.0), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvY2RjOWU0ZGNmYTQyMjFhMWZhZGMxYjViMmIxMWQ4YmVlYjU3ODc5YWYxYzQyMzYyMTQyYmFlMWVkZDUifX19", 5);
        this.updatePiece("RB", this.getLocation().add(0.8, 0.65, 1.0), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOTU2YTM2MTg0NTllNDNiMjg3YjIyYjdlMjM1ZWM2OTk1OTQ1NDZjNmZjZDZkYzg0YmZjYTRjZjMwYWI5MzExIn19fQ", 5);
    }

    private void updatePiece(String type, Location loc, String head, int distance) {
        World world = this.getLocationREADONLY().getWorld();
        ArmorStand stand = null;
        if (!MinetorioListener.isPlayerNearbyOPT(this.getLocationREADONLY(), distance)) {
            if (this.atlastEnts != null && this.atlastEnts.containsKey(type)) {
                stand = (ArmorStand)this.atlastEnts.get(type);
                stand.remove();
                this.atlastEnts.remove(type);
            }
            return;
        }
        stand = this.atlastEnts != null && this.atlastEnts.containsKey(type) ? (ArmorStand)this.atlastEnts.get(type) : (ArmorStand)world.spawnEntity(loc, EntityType.ARMOR_STAND);
        stand.setVisible(false);
        stand.setGravity(false);
        stand.setInvulnerable(true);
        stand.setMetadata("MT-ATLAS", (MetadataValue)new FixedMetadataValue(MineMain.getPlugin(), (Object)this));
        if (type.equals("LB")) {
            stand.setMetadata("MT-ATLAS-LEFT", (MetadataValue)new FixedMetadataValue(MineMain.getPlugin(), (Object)this));
        }
        if (type.equals("RB")) {
            stand.setMetadata("MT-ATLAS-RIGHT", (MetadataValue)new FixedMetadataValue(MineMain.getPlugin(), (Object)this));
        }
        if (type.equals("CONFIRM")) {
            stand.setMetadata("MT-ATLAS-CONFIRM", (MetadataValue)new FixedMetadataValue(MineMain.getPlugin(), (Object)this));
        }
        if (type.equals("LB") || type.equals("RB") || type.equals("CONFIRM")) {
            AttributeModifier ga = new AttributeModifier(new NamespacedKey(MineMain.getPlugin(), "MT-UI-SCALE"), -0.75, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.ANY);
            if (!stand.getAttribute(MineMain.version.getScaleAttribute()).getModifiers().contains(ga)) {
                stand.getAttribute(MineMain.version.getScaleAttribute()).addModifier(ga);
            }
        }
        stand.setSmall(true);
        ItemStack headStack = null;
        if (head != null) {
            headStack = SkullCreator.getHead(head);
        }
        if (type.equals("Distance")) {
            stand.setSmall(false);
            double targetDistance = this.getCore().getDistanceToTargetPlanet(this.centerPlanet().getPlanetName());
            String meterDistance = PlanetHandler.formatDistance(targetDistance *= 1000.0);
            if (targetDistance == 0.0) {
                meterDistance = "Orbiting";
            }
            stand.setCustomName(String.valueOf(ChatColor.GRAY) + "(" + meterDistance + ")");
            stand.setCustomNameVisible(MinetorioListener.isPlayerNearbyOPT(this.getLocationREADONLY(), 5.0));
        }
        if (type.equals("Center")) {
            stand.setSmall(false);
            stand.setCustomName(String.valueOf(this.getPlanetNameColor(this.centerPlanet())) + this.centerPlanet().getPlanetName());
            stand.setCustomNameVisible(MinetorioListener.isPlayerNearbyOPT(this.getLocationREADONLY(), 5.0));
            headStack = this.centerPlanet().getAtlastHeadCode().equals("NONE") ? new ItemStack(Material.valueOf((String)this.centerPlanet().getAtlasMaterial())) : SkullCreator.getHead(this.centerPlanet().getAtlastHeadCode());
        }
        if (type.equals("Left")) {
            stand.setCustomName(String.valueOf(this.getPlanetNameColor(this.leftPlanet())) + this.leftPlanet().getPlanetName());
            stand.setCustomNameVisible(MinetorioListener.isPlayerNearbyOPT(this.getLocationREADONLY(), 3.0));
            headStack = this.leftPlanet().getAtlastHeadCode().equals("NONE") ? new ItemStack(Material.valueOf((String)this.leftPlanet().getAtlasMaterial())) : SkullCreator.getHead(this.leftPlanet().getAtlastHeadCode());
            AttributeModifier ga = new AttributeModifier(new NamespacedKey(MineMain.getPlugin(), "MT-UI-SCALE"), -0.5, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.ANY);
            if (!stand.getAttribute(MineMain.version.getScaleAttribute()).getModifiers().contains(ga)) {
                stand.getAttribute(MineMain.version.getScaleAttribute()).addModifier(ga);
            }
        }
        if (type.equals("Right")) {
            stand.setCustomName(String.valueOf(this.getPlanetNameColor(this.rightPlanet())) + this.rightPlanet().getPlanetName());
            stand.setCustomNameVisible(MinetorioListener.isPlayerNearbyOPT(this.getLocationREADONLY(), 3.0));
            headStack = this.rightPlanet().getAtlastHeadCode().equals("NONE") ? new ItemStack(Material.valueOf((String)this.rightPlanet().getAtlasMaterial())) : SkullCreator.getHead(this.rightPlanet().getAtlastHeadCode());
            AttributeModifier ga = new AttributeModifier(new NamespacedKey(MineMain.getPlugin(), "MT-UI-SCALE"), -0.5, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.ANY);
            if (!stand.getAttribute(MineMain.version.getScaleAttribute()).getModifiers().contains(ga)) {
                stand.getAttribute(MineMain.version.getScaleAttribute()).addModifier(ga);
            }
        }
        if (type.equals("CONFIRM")) {
            stand.setMetadata("MT-ATLAS-CONFIRM", (MetadataValue)new FixedMetadataValue(MineMain.getPlugin(), (Object)this));
            headStack = new ItemStack(Material.LIME_CONCRETE);
        }
        MineUtil.setDisposableEntity((Entity)stand);
        if (headStack != null) {
            stand.getEquipment().setHelmet(headStack);
        }
        this.atlastEnts.put(type, (Entity)stand);
    }

    private ChatColor getPlanetNameColor(Planet planet) {
        Planet tPlanet = Planet.getByPlanetName(this.getCore().getTargetPlanet());
        if (tPlanet != null && planet.equals(tPlanet)) {
            return ChatColor.GREEN;
        }
        if (this.getCore().closestPlanet().equals(planet)) {
            return ChatColor.YELLOW;
        }
        return ChatColor.WHITE;
    }

    private void removeAtlas() {
        if (this.atlastEnts == null) {
            return;
        }
        for (Entity entity : this.atlastEnts.values()) {
            entity.remove();
        }
        this.atlastEnts.clear();
    }

    public void shiftLeft() {
        if (this.leftCooldown) {
            return;
        }
        this.getLocation().getWorld().playSound(this.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        ArrayList<Planet> planets = Planet.getPlanets();
        planets.addAll(Planet.getPlanets());
        this.targetPlanet = RocketSilo.getNextEntry(planets, Planet.getByPlanetName(this.targetPlanet)).getPlanetName();
        this.updateAtlas();
        this.leftCooldown = true;
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

            @Override
            public void run() {
                Atlas.this.leftCooldown = false;
            }
        }, 5L);
    }

    public void shiftRight() {
        if (this.rightCooldown) {
            return;
        }
        this.getLocation().getWorld().playSound(this.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        ArrayList<Planet> flipped = Planet.getPlanets();
        flipped.addAll(Planet.getPlanets());
        Collections.reverse(flipped);
        this.targetPlanet = RocketSilo.getNextEntry(flipped, Planet.getByPlanetName(this.targetPlanet)).getPlanetName();
        this.updateAtlas();
        this.rightCooldown = true;
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

            @Override
            public void run() {
                Atlas.this.rightCooldown = false;
            }
        }, 5L);
    }

    private ShipCore getCore() {
        ShipCore core = null;
        ArrayList<Device> cores = Device.getNearbyDevicesByType(this.getLocation(), 100, "Ship Core");
        if (cores.size() > 0) {
            core = (ShipCore)Device.getNearbyDevicesByType(this.getLocation(), 100, "Ship Core").get(0);
        }
        return core;
    }

    public void confirmTarget() {
        if (this.confirmCooldown) {
            return;
        }
        this.getLocation().getWorld().playSound(this.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.25f);
        ShipCore core = this.getCore();
        if (core != null) {
            core.setTargetPlanet(this.centerPlanet().getPlanetName());
        }
        this.updateAtlas();
        this.confirmCooldown = true;
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

            @Override
            public void run() {
                Atlas.this.confirmCooldown = false;
            }
        }, 20L);
    }

    public Planet centerPlanet() {
        Planet planet = Planet.getByPlanetName(this.targetPlanet);
        if (planet == null) {
            planet = Planet.getPlanets().get(0);
        }
        return planet;
    }

    public Planet rightPlanet() {
        String next = null;
        ArrayList<Planet> planets = Planet.getPlanets();
        planets.addAll(Planet.getPlanets());
        next = RocketSilo.getNextEntry(planets, Planet.getByPlanetName(this.targetPlanet)).getPlanetName();
        return Planet.getByPlanetName(next);
    }

    public Planet leftPlanet() {
        String next = null;
        ArrayList<Planet> planets = Planet.getPlanets();
        planets.addAll(Planet.getPlanets());
        Collections.reverse(planets);
        next = RocketSilo.getNextEntry(planets, Planet.getByPlanetName(this.targetPlanet)).getPlanetName();
        return Planet.getByPlanetName(next);
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, Atlas.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.LOGISTICS, new Atlas(null).getDeviceStack(), false);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(MineItems.getIndustrialItem("Processing Unit"));
        ings.add(MineItems.getIndustrialItem("Steel Plate", 5));
        RecipeUtils.addDefaultRecipe(new Atlas(null).getDeviceStack(), ings, MTRecipe.RecipeType.ADVANCED, true);
    }

    @Override
    public int getGridScore() {
        return 2;
    }
}

