/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Spaceship;

import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Planets.Planet;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;

public class AtmosphericController
extends Device {
    private static final long serialVersionUID = 9191989939708640603L;
    private static String classSpacedNamed = "Atmospheric Controller";
    public double Oxygen = 0.0;
    public boolean spaceHeated = false;
    private int rebuild = 0;
    private transient List<Location> volume = new ArrayList<Location>();
    private boolean toLarge = false;

    public AtmosphericController(Location loc) {
        super(loc);
        this.setMaterial("DISPENSER");
        this.deviceName = classSpacedNamed;
        this.setActionTimer(1);
        this.setOpenable(true);
        this.setStoreForm(true);
        this.setIdlePower(2);
        this.setActionPower(2);
        this.setUseUI(true);
        this.useAutoSlots();
        this.useAutoUI();
        this.displayLockedHorizontal = true;
        this.updateDeviceHeadItem();
    }

    @Override
    public void postCreate(boolean isFirstTime) {
        this.rebuild = 0;
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Stabilizes a 100 block volume of space.");
        lore.add("- Emits oxygen using gas canisters with oxygen.");
        lore.add("- Will use power to produce heat.");
        lore.add("- Space must be enclosed!");
        lore.add("- Emission occurs from the top of the device!");
        return lore;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
        ItemStack stack = this.createInfoIcon();
        TUItems.addLore(stack, MineUtil.colon(" Oxygen", "" + TUMaths.roundDouble(this.Oxygen, 1)));
        int roomSize = 0;
        if (this.volume != null) {
            roomSize = this.volume.size();
        }
        TUItems.addLore(stack, MineUtil.colon(" Room Size", "" + roomSize));
        TUItems.addLore(stack, MineUtil.colon(" Room Heated", "" + this.spaceHeated));
        TUItems.addLore(stack, MineUtil.colon(" Next Update", "" + this.rebuild));
        if (this.volume == null) {
            TUItems.addLore(stack, String.valueOf(ChatColor.YELLOW) + " Room not enclosed");
        }
        if (this.toLarge) {
            TUItems.addLore(stack, String.valueOf(ChatColor.YELLOW) + " Room is to large");
        }
        this.getInventory().setItem(13, stack);
    }

    @Override
    public void action() {
        ItemStack stack;
        if (this.getGrid() == null) {
            return;
        }
        if (this.Oxygen <= 900.0 && (stack = this.getInputStack(MineItems.getGasCanister(Planet.Gas.OXYGEN))) != null) {
            this.Oxygen += 100.0;
            stack.setAmount(stack.getAmount() - 1);
            this.getInventory().setItem(this.getOutputSlot(), MineItems.getIndustrialItem("Empty Gas Canister"));
            if (MinetorioListener.isPlayerNearbyOPT(this.getLocation(), 6.0)) {
                this.getLocationREADONLY().getWorld().playSound(this.getLocationREADONLY(), Sound.ENTITY_BREEZE_IDLE_AIR, 0.5f, 2.0f);
            }
        }
        if (this.volume != null && this.volume.size() > 0 && this.getGrid().hasPower(10)) {
            this.getGrid().consumePower(this, this.getActionPower());
            this.setConsumingPower(true);
            this.spaceHeated = true;
        } else {
            this.spaceHeated = false;
        }
        if (MinetorioListener.isPlayerNearbyOPT(this.getLocation(), MineMain.chunkViewDistance / 2)) {
            --this.rebuild;
            if (MinetorioListener.isPlayerNearbyOPT(this.getLocation(), 6.0)) {
                this.rebuild -= 10;
            }
            if (this.rebuild <= 0) {
                if (this.volume != null) {
                    for (Location location : this.volume) {
                        location.getBlock().removeMetadata("MT-STABLE", MineMain.getPlugin());
                    }
                }
                this.volume = this.getEnclosedAirRegion(this.getLocation().add(0.0, 1.0, 0.0));
                if (this.volume != null) {
                    for (Location location : this.volume) {
                        location.getBlock().setMetadata("MT-STABLE", (MetadataValue)new FixedMetadataValue(MineMain.getPlugin(), (Object)this));
                    }
                }
                this.rebuild = 60;
            }
        }
        if (this.getOutputSlot() == -1) {
            this.setFailReason("Missing output slot");
            return;
        }
    }

    @Override
    public void cleanup() {
        if (this.volume != null) {
            for (Location location : this.volume) {
                location.getBlock().removeMetadata("MT-STABLE", MineMain.getPlugin());
            }
        }
    }

    public List<Location> getEnclosedAirRegion(Location start) {
        World world = start.getWorld();
        if (world == null) {
            TUMaths.dm("break 0");
            return null;
        }
        HashSet<Location> visited = new HashSet<Location>();
        LinkedList<Location> toCheck = new LinkedList<Location>();
        visited.add(start);
        toCheck.add(start);
        int maxSize = 500;
        this.toLarge = false;
        while (!toCheck.isEmpty()) {
            Location loc = (Location)toCheck.poll();
            for (Location neighbor : this.getAdjacentLocations(loc)) {
                Block block;
                if (visited.contains(neighbor) || !(block = world.getBlockAt(neighbor)).getType().isAir()) continue;
                visited.add(neighbor);
                toCheck.add(neighbor);
                if (visited.size() < maxSize) continue;
                this.toLarge = true;
                return null;
            }
        }
        return new ArrayList<Location>(visited);
    }

    private List<Location> getAdjacentLocations(Location loc) {
        ArrayList<Location> list = new ArrayList<Location>(6);
        list.add(loc.clone().add(1.0, 0.0, 0.0));
        list.add(loc.clone().add(-1.0, 0.0, 0.0));
        list.add(loc.clone().add(0.0, 1.0, 0.0));
        list.add(loc.clone().add(0.0, -1.0, 0.0));
        list.add(loc.clone().add(0.0, 0.0, 1.0));
        list.add(loc.clone().add(0.0, 0.0, -1.0));
        return list;
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, AtmosphericController.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.DEFENSE, new AtmosphericController(null).getDeviceStack(), false);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(MineItems.getIndustrialItem("Plastic Bar", 3));
        ings.add(MineItems.getIndustrialItem("Steel Plate", 5));
        ings.add(MineItems.getIndustrialItem("Processing Unit"));
        RecipeUtils.addDefaultRecipe(new AtmosphericController(null).getDeviceStack(), ings, MTRecipe.RecipeType.ADVANCED, true);
    }

    @Override
    public int getGridScore() {
        return 1;
    }
}

