/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Spaceship;

import com.MT.triggersUtility.ChatInput;
import com.MT.triggersUtility.SkullCreator;
import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Spaceship.Thruster;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Planets.AsteroidField;
import com.MT.xxxtrigger50xxx.Planets.BatField;
import com.MT.xxxtrigger50xxx.Planets.Planet;
import com.MT.xxxtrigger50xxx.Planets.SpaceObjects.Asteroid;
import com.MT.xxxtrigger50xxx.Planets.SpaceObjects.ResourceAsteroid;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Transformation;
import org.bukkit.util.Vector;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ShipCore
extends Device {
    private static final long serialVersionUID = 2394684609996399325L;
    private static String classSpacedNamed = "Ship Core";
    private String shipName;
    private String targetPlanet = "Earthlike";
    private double spacePosition = 0.0;
    public static int lastX = 0;
    private boolean movingInSpace = false;
    private String virtualLocation;
    private boolean atLocalLocation = true;
    public int xCord = 0;
    public int zCord = 0;
    private static HashSet<ShipCore> allCores = new HashSet();
    private transient HashMap<Planet, ItemDisplay> renderedPlanets = new HashMap();
    private double facing = 0.0;
    private transient ItemDisplay sun;
    private float sunYaw = 0.0f;
    private static NamespacedKey hpKey = new NamespacedKey(MineMain.getPlugin(), "BAT-HP");
    private static NamespacedKey dmgKey = new NamespacedKey(MineMain.getPlugin(), "BAT-DMG");
    private static NamespacedKey scaleKey = new NamespacedKey(MineMain.getPlugin(), "BAT-SCALE");
    public transient HashSet<Asteroid> decorRoids;
    public transient HashSet<ResourceAsteroid> incomingRoids;
    private static int spaceShipSize = 30;

    public ShipCore(Location loc, Location virtualLocation) {
        super(loc);
        this.setMaterial("REDSTONE_LAMP");
        if (loc != null) {
            loc.getBlock().setType(this.getPlaceType());
        }
        this.deviceName = classSpacedNamed;
        this.setActionTimer(1);
        this.setOpenable(true);
        this.setStoreForm(true);
        this.setIdlePower(1);
        this.setActionPower(2);
        this.setUseUI(true);
        this.useAutoSlots();
        this.useAutoUI();
        if (loc != null) {
            allCores.add(this);
            if (this.getLocation().getBlockX() > lastX) {
                lastX = this.getLocation().getBlockX();
            }
            virtualLocation.setWorld(Bukkit.getWorld((String)"MT_world_space"));
            this.setVirtualLocation(TUMaths.locationString(virtualLocation));
            this.setTargetCords(virtualLocation.getBlockX(), virtualLocation.getBlockZ());
            this.atLocalLocation = true;
            this.setShipName("Ship - " + TUMaths.rollRange(0, 999999));
        } else {
            this.setShipName("Ship - DEBUG");
        }
        this.builtInPylon = true;
        this.builtInPylonRange = 25;
        this.updateDeviceHeadItem();
        this.displayLockedHorizontal = true;
    }

    @Override
    public void postCreate(boolean isFirstTime) {
        if (this.getLocation() != null) {
            allCores.add(this);
            if (this.getLocation().getBlockX() > lastX) {
                lastX = this.getLocation().getBlockX();
            }
        }
    }

    @Override
    public void onDeviceRemove() {
        allCores.remove(this);
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- The heart of any spaceship.");
        return lore;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
        ItemStack stack = this.createInfoIcon();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(" ");
        lore.add(MineUtil.colon(" Ship Name", this.getName()));
        lore.add(MineUtil.colon(" Left Click", "Change Name"));
        TUItems.addLore(stack, lore);
        this.getInventory().setItem(13, stack);
    }

    @Override
    public void onUIClick(InventoryClickEvent event) {
        if (event.getSlot() == 13) {
            Player player = (Player)event.getWhoClicked();
            player.closeInventory();
            class ChatInput
            extends com.MT.triggersUtility.ChatInput {
                private final /* synthetic */ Player val$player;

                public ChatInput(String startMessage, boolean numbersonly, Player player) {
                    this.val$player = player;
                    super(startMessage, numbersonly);
                }

                @Override
                public void inputAction(String message) {
                    ShipCore.this.setShipName(message);
                    ShipCore.this.updateUI();
                    this.val$player.openInventory(ShipCore.this.getInventory());
                }
            }
            ChatInput input = new ChatInput("Enter the new name of the ship now!", false, player);
            input.start(player);
        }
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.REDSTONE_BLOCK, 1.0);
    }

    public double getDistanceToTargetPlanet(String planetName) {
        Planet orbitTarget = Planet.getByPlanetName(planetName);
        if (orbitTarget != null) {
            return TUMaths.roundDouble(Math.abs(this.getSpacePosition() - orbitTarget.getStartPlanetDistance()), 3);
        }
        return 0.0;
    }

    @Override
    public void action() {
        this.spawnSpaceObjects();
        this.renderDistantPlanets();
        this.renderSun();
        if (this.getGrid() == null) {
            return;
        }
        this.moveTowardLocation(this.xCord, this.zCord);
        if (this.getOutputSlot() == -1) {
            this.setFailReason("No output space");
            return;
        }
        Planet orbitTarget = Planet.getByPlanetName(this.targetPlanet);
        if (orbitTarget != null) {
            double distance = this.getDistanceToTargetPlanet(this.targetPlanet);
            if (distance > 0.0) {
                this.movingInSpace = true;
                double speed = 0.01;
                for (Device device : Device.getNearbyDevicesByType(this.getLocationREADONLY(), 100, "Thruster")) {
                    Thruster thruster = (Thruster)device;
                    if (thruster == null || !thruster.provideThurst()) continue;
                    speed += 1.0 * thruster.getCrowdingEffeciency(0.25);
                }
                if (speed > distance) {
                    speed = distance;
                }
                if ((distance -= speed) <= 0.0) {
                    this.setSpacePosition(orbitTarget.getStartPlanetDistance());
                } else if (this.getSpacePosition() > orbitTarget.getStartPlanetDistance()) {
                    this.setSpacePosition(this.getSpacePosition() - speed);
                } else {
                    this.setSpacePosition(this.getSpacePosition() + speed);
                }
            } else {
                if (this.movingInSpace) {
                    this.movingInSpace = false;
                    this.sendOwnerMessage(this.getShipName() + " has arrived at " + orbitTarget.getPlanetName());
                }
                this.getSpacePosition();
                orbitTarget.getStartPlanetDistance();
            }
        }
    }

    public boolean inOrbit() {
        Planet orbitTarget = Planet.getByPlanetName(this.targetPlanet);
        return orbitTarget != null && this.getSpacePosition() == orbitTarget.getStartPlanetDistance();
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, ShipCore.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.LOGISTICS, new ShipCore(null, null).getDeviceStack(), false);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(MineItems.getIndustrialItem("Processing Unit", 5));
        ings.add(MineItems.getIndustrialItem("Steel Plate", 4));
        RecipeUtils.addDefaultRecipe(new ShipCore(null, null).getDeviceStack(), ings, MTRecipe.RecipeType.ADVANCED, true);
    }

    @Override
    public int getGridScore() {
        return 3;
    }

    public String getShipName() {
        return this.shipName;
    }

    public void setShipName(String shipName) {
        this.shipName = shipName;
    }

    public void setVirtualLocation(String virtualLocation) {
        this.virtualLocation = virtualLocation;
    }

    public Location getVirtualLocation() {
        return TUMaths.getStringLocation(this.virtualLocation);
    }

    public void moveTowardLocation(int x, int z) {
        Location targetSpace = this.getVirtualLocation().clone();
        targetSpace.setX((double)x);
        targetSpace.setZ((double)z);
        double distance = TUMaths.distanceNoY(this.getVirtualLocation(), targetSpace);
        if (distance > 0.0) {
            this.atLocalLocation = false;
            double speed = 0.1;
            for (Device device : Device.getNearbyDevicesByType(this.getLocationREADONLY(), 100, "Thruster")) {
                Thruster thruster = (Thruster)device;
                if (thruster == null || !thruster.provideThurst()) continue;
                speed += 1.0;
            }
            if ((speed *= 10.0) > distance) {
                speed = distance;
            }
            if ((distance -= speed) <= 0.0) {
                this.setVirtualLocation(TUMaths.locationString(targetSpace));
            } else {
                this.setVirtualLocation(TUMaths.locationString(this.moveTowards(this.getVirtualLocation(), targetSpace, speed)));
            }
        } else if (!this.atLocalLocation) {
            this.atLocalLocation = true;
            this.sendOwnerMessage(this.getShipName() + " is now at " + x + "x, " + z + "z");
        }
    }

    public void setTargetCords(int x, int z) {
        this.xCord = x;
        this.zCord = z;
    }

    public Location moveTowards(Location from, Location to, double maxStep) {
        Vector direction = to.toVector().subtract(from.toVector());
        double distance = direction.length();
        if (distance <= maxStep) {
            return to.clone();
        }
        direction.normalize().multiply(maxStep);
        return from.clone().add(direction);
    }

    public World closestWorld() {
        Planet closest = null;
        for (Planet near : Planet.getPlanets()) {
            if (closest == null) {
                closest = near;
                continue;
            }
            int closestDistance = (int)Math.abs(closest.getStartPlanetDistance() - this.getSpacePosition());
            int nearDistance = (int)Math.abs(near.getStartPlanetDistance() - this.getSpacePosition());
            if (nearDistance >= closestDistance) continue;
            closest = near;
        }
        return Bukkit.getWorld((String)closest.getBoundWorld());
    }

    public Planet closestPlanet() {
        Planet closest = null;
        for (Planet near : Planet.getPlanets()) {
            if (closest == null) {
                closest = near;
                continue;
            }
            int closestDistance = (int)Math.abs(closest.getStartPlanetDistance() - this.getSpacePosition());
            int nearDistance = (int)Math.abs(near.getStartPlanetDistance() - this.getSpacePosition());
            if (nearDistance >= closestDistance) continue;
            closest = near;
        }
        return closest;
    }

    public static ArrayList<ShipCore> getShips(UUID placer) {
        ArrayList<ShipCore> scs = new ArrayList<ShipCore>();
        for (ShipCore sc : allCores) {
            if (!sc.getPlacerUUID().equals(placer)) continue;
            scs.add(sc);
        }
        return scs;
    }

    public static ArrayList<ShipCore> getCores(UUID placer, Location fromLocation) {
        Location fLoc = fromLocation.clone();
        fLoc.setWorld(Bukkit.getWorld((String)"MT_world_space"));
        ArrayList<ShipCore> cores = ShipCore.getShips(placer);
        cores.sort(Comparator.comparingDouble(core -> core.getVirtualLocation().distanceSquared(fLoc)));
        return cores;
    }

    public static ArrayList<ShipCore> getCores(Location fromLocation) {
        Location fLoc = fromLocation.clone();
        fLoc.setWorld(Bukkit.getWorld((String)"MT_world_space"));
        ArrayList<ShipCore> cores = new ArrayList<ShipCore>(allCores);
        cores.sort(Comparator.comparingDouble(core -> core.getVirtualLocation().distanceSquared(fLoc)));
        return cores;
    }

    public static ShipCore getCoreByName(String shipName) {
        if (shipName == null) {
            return null;
        }
        for (ShipCore sc : allCores) {
            if (!shipName.equals(sc.getShipName())) continue;
            return sc;
        }
        return null;
    }

    public String getTargetPlanet() {
        return this.targetPlanet;
    }

    public void setTargetPlanet(String targetPlanet) {
        this.targetPlanet = targetPlanet;
    }

    public double getSpacePosition() {
        return this.spacePosition;
    }

    public void setSpacePosition(double spacePosition) {
        this.spacePosition = spacePosition;
    }

    public void renderDistantPlanets() {
        if (this.getTargetPlanet() != null) {
            Planet target = Planet.getByPlanetName(this.getTargetPlanet());
            int turnSpeed = 10;
            int i = 0;
            while (i < turnSpeed) {
                if (this.facing == target.getSolarAngle()) break;
                this.facing = this.facing > target.getSolarAngle() ? (this.facing -= 1.0) : (this.facing += 1.0);
                ++i;
            }
        }
        if (this.renderedPlanets == null) {
            this.renderedPlanets = new HashMap();
        }
        if (MinetorioListener.isPlayerNearby2DOPT(this.getLocationREADONLY(), MineMain.chunkViewDistance)) {
            for (Planet planet : Planet.getPlanets()) {
                if (this.renderedPlanets.containsKey(planet)) continue;
                this.renderedPlanets.put(planet, null);
            }
        }
        for (Planet planet : new ArrayList<Planet>(this.renderedPlanets.keySet())) {
            ItemDisplay display;
            double distance = this.getDistanceToTargetPlanet(planet.getPlanetName());
            Location planetLocation = this.getLocationOnCircle(this.getLocationREADONLY(), (double)MineMain.chunkViewDistance * 0.7, this.adjustPlanetAngle(planet.getSolarAngle() - this.facing - 90.0, planet)).add(0.0, planet.getSolarHeight() + 32.0, 0.0);
            if (MinetorioListener.isPlayerNearby2DOPT(planetLocation, MineMain.chunkViewDistance) && this.getDistanceToTargetPlanet(planet.getPlanetName()) < 1000.0) {
                display = this.renderedPlanets.get(planet);
                ItemStack stack = planet.getPlanetStack();
                if (display == null) {
                    planetLocation.setYaw((float)planet.getRotation());
                    display = (ItemDisplay)planetLocation.getWorld().spawn(planetLocation, ItemDisplay.class);
                    display.setItemStack(stack);
                    display.setTeleportDuration(25);
                    display.setViewRange((float)MineMain.chunkViewDistance);
                    MineUtil.setDisposableEntity((Entity)display);
                    this.renderedPlanets.put(planet, display);
                } else {
                    planet.rotate();
                    planetLocation.setYaw((float)planet.getRotation());
                    display.teleport(planetLocation);
                }
                Transformation form = display.getTransformation();
                form.getTranslation().set((Vector3fc)new Vector3f(-0.5f, -0.5f, -0.5f));
                double scale = this.getNormalizedFalloff(distance, 1000.0) * 30.0;
                if (scale <= 0.0) {
                    scale = 0.01;
                }
                form.getScale().set(scale *= planet.getSolarScale());
                display.setTransformation(form);
                int brightness = 15 - Math.min(15, (int)(distance / 54.0));
                if (brightness < 0) {
                    brightness = 0;
                }
                display.setBrightness(new Display.Brightness(brightness, brightness));
                continue;
            }
            display = this.renderedPlanets.get(planet);
            if (display != null) {
                display.remove();
            }
            this.renderedPlanets.remove(planet);
        }
    }

    public void renderSun() {
        if (this.getTargetPlanet() != null) {
            Planet target = Planet.getByPlanetName(this.getTargetPlanet());
            int turnSpeed = 10;
            int i = 0;
            while (i < turnSpeed) {
                if (this.facing == target.getSolarAngle()) break;
                this.facing = this.facing > target.getSolarAngle() ? (this.facing -= 1.0) : (this.facing += 1.0);
                ++i;
            }
        }
        double distance = this.getSpacePosition() / 5.0;
        double sunAngle = -35.0;
        double sunSolarSize = 2.0;
        Location sunLocation = this.getLocationOnCircle(this.getLocationREADONLY(), (double)MineMain.chunkViewDistance * 0.7, this.adjustPlanetAngle(sunAngle - this.facing - 90.0, null)).add(0.0, -16.0, 0.0);
        if (MinetorioListener.isPlayerNearby2DOPT(sunLocation, MineMain.chunkViewDistance) && distance <= 1000.0) {
            ItemDisplay display = this.sun;
            if (display == null) {
                sunLocation.setYaw(this.sunYaw);
                display = (ItemDisplay)sunLocation.getWorld().spawn(sunLocation, ItemDisplay.class);
                ItemStack stack = SkullCreator.getHead("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYmYwZWU2NDdhNjIxMWU1YzJmODE2MTZhNTk3N2E2NTg1MWU0ZGI3ODM0Y2Y0NTAxMjQ2ZGU2YjM5YWRhMzI5MSJ9fX0=");
                display.setItemStack(stack);
                display.setTeleportDuration(25);
                display.setViewRange((float)MineMain.chunkViewDistance);
                MineUtil.setDisposableEntity((Entity)display);
                this.sun = display;
            } else {
                this.sunYaw += 10.0f;
                if (this.sunYaw > 360.0f) {
                    this.sunYaw -= 360.0f;
                }
                sunLocation.setYaw(this.sunYaw);
                display.teleport(sunLocation);
            }
            Transformation form = display.getTransformation();
            form.getTranslation().set((Vector3fc)new Vector3f(-0.5f, -0.5f, -0.5f));
            double scale = this.getNormalizedFalloff(distance, 1000.0) * 30.0;
            if (scale <= 0.0) {
                scale = 0.01;
            }
            form.getScale().set(scale *= sunSolarSize);
            display.setTransformation(form);
            display.setBrightness(new Display.Brightness(15, 15));
        } else if (this.sun != null) {
            this.sun.remove();
            this.sun = null;
        }
    }

    private double adjustPlanetAngle(double angleDegrees, Planet planet) {
        return angleDegrees;
    }

    public double pullAngleTowards(double current, double target, double strength) {
        double diff = ((target = (target % 360.0 + 360.0) % 360.0) - (current = (current % 360.0 + 360.0) % 360.0) + 540.0) % 360.0 - 180.0;
        double pullAmount = diff * strength;
        if (Math.abs(pullAmount) > Math.abs(diff)) {
            return target;
        }
        double result = current + pullAmount;
        return (result + 360.0) % 360.0;
    }

    public double rotateAngle(double angle, double degrees, boolean left) {
        angle = left ? (angle -= degrees) : (angle += degrees);
        angle %= 360.0;
        if (angle < 0.0) {
            angle += 360.0;
        }
        return angle;
    }

    public void rotatePlanet(Display display) {
        Transformation transformation = display.getTransformation();
        transformation.getTranslation().set((Vector3fc)new Vector3f(-0.5f, -0.5f, -0.5f));
        display.setTransformation(transformation);
    }

    public double getNormalizedFalloff(double distance, double maxRange) {
        if (maxRange <= 0.0) {
            return 0.0;
        }
        double clamped = Math.max(0.0, Math.min(distance, maxRange));
        return 1.0 - clamped / maxRange;
    }

    public Location getLocationOnCircle(Location center, double radius, double angleDegrees) {
        double angleRadians = Math.toRadians(angleDegrees);
        double x = center.getX() + radius * Math.cos(angleRadians);
        double z = center.getZ() + radius * Math.sin(angleRadians);
        return new Location(center.getWorld(), x, center.getY(), z, center.getYaw(), center.getPitch());
    }

    public ArrayList<AsteroidField> getFields() {
        ArrayList<AsteroidField> fields = new ArrayList<AsteroidField>();
        double spaceLocation = this.getSpacePosition();
        for (AsteroidField field : AsteroidField.getAsteroidFields()) {
            if (!(spaceLocation >= field.getStartDistance()) || !(spaceLocation <= field.getStopDistance())) continue;
            fields.add(field);
        }
        return fields;
    }

    public ArrayList<BatField> getBatFields() {
        ArrayList<BatField> fields = new ArrayList<BatField>();
        double spaceLocation = this.getSpacePosition();
        for (BatField field : BatField.getFields()) {
            if (!(spaceLocation >= field.getStartDistance()) || !(spaceLocation <= field.getStopDistance())) continue;
            fields.add(field);
        }
        return fields;
    }

    public void spawnSpaceObjects() {
        for (AsteroidField asteroidField : this.getFields()) {
            this.spawnAsteroids(asteroidField);
        }
        for (BatField batField : this.getBatFields()) {
            this.spawnBats(batField);
        }
    }

    public void spawnBats(final BatField field) {
        if (TUMaths.rollRange(0, 3999) > field.getChance()) {
            return;
        }
        if (!MinetorioListener.isPlayerNearby1DOPT(this.getLocationREADONLY(), MineMain.chunkViewDistance)) {
            return;
        }
        int amount = (int)(10.0 * field.getAmountScaler());
        int spacing = 0;
        int i = 0;
        while (i < amount) {
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    ShipCore.this.spawnBat(field);
                }
            }, (long)spacing);
            spacing += TUMaths.rollRange(40, 120);
            ++i;
        }
    }

    public void spawnBat(BatField field) {
        World world = this.getLocationREADONLY().getWorld();
        int range = (int)((double)MineMain.chunkViewDistance * 0.5);
        Location randLoc = this.getLocation().add((double)TUMaths.rollRange(-range, range), 0.0, (double)TUMaths.rollRange(-range, range));
        randLoc.setY((double)world.getHighestBlockYAt(randLoc));
        if (randLoc.getY() < 100.0) {
            randLoc.setY(100.0);
        }
        randLoc.setY(randLoc.getY() + 25.0 + (double)TUMaths.rollRange(0, 16));
        Phantom phantom = (Phantom)world.spawnEntity(randLoc, EntityType.PHANTOM);
        MineUtil.setDisposableEntity((Entity)phantom);
        double variance = field.getVariance();
        double size = field.getStrength() + TUMaths.rollRange(-variance, variance);
        double bonusHP = (size - 1.0) * 20.0;
        double bonusDNG = (size - 1.0) * 3.0;
        double bonusScale = (size - 1.0) * 2.0;
        if (bonusHP < 0.0) {
            bonusHP = 0.0;
        }
        if (bonusDNG < 0.0) {
            bonusDNG = 0.0;
        }
        if (bonusScale < 0.0) {
            bonusScale = 0.0;
        }
        if (bonusHP != 0.0) {
            AttributeModifier am = new AttributeModifier(hpKey, bonusHP, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.ANY);
            phantom.getAttribute(MineMain.version.getMaxHealthAttribute()).addModifier(am);
            phantom.setHealth(phantom.getAttribute(MineMain.version.getMaxHealthAttribute()).getValue());
        }
        if (bonusDNG != 0.0) {
            AttributeModifier dm = new AttributeModifier(dmgKey, bonusDNG, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.ANY);
            phantom.getAttribute(MineMain.version.getAttackAttribute()).addModifier(dm);
        }
        if (MineMain.version.canModifyEntitySize() && bonusScale != 0.0) {
            AttributeModifier ga = new AttributeModifier(scaleKey, bonusScale, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.ANY);
            phantom.getAttribute(MineMain.version.getScaleAttribute()).addModifier(ga);
        }
    }

    public void spawnAsteroids(final AsteroidField field) {
        if (!MinetorioListener.isPlayerNearby1DOPT(this.getLocationREADONLY(), MineMain.chunkViewDistance)) {
            return;
        }
        double spawnChance = field.getDensity();
        if ((double)TUMaths.rollRange(0, 3999) <= spawnChance) {
            int amount = (int)(20.0 * field.getScaler());
            int spacing = 0;
            int i = 0;
            while ((double)i < (double)amount * 0.75) {
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        ShipCore.this.spawnDistantDecorationAsteroid(field);
                    }
                }, (long)spacing);
                spacing += TUMaths.rollRange(10, 40);
                ++i;
            }
            i = 0;
            while ((double)i < (double)amount * 0.25) {
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        ShipCore.this.spawnIncomingAsteroid(field);
                    }
                }, (long)spacing);
                spacing += TUMaths.rollRange(10, 40);
                ++i;
            }
        }
    }

    private void spawnIncomingAsteroid(AsteroidField field) {
        if (this.incomingRoids == null) {
            this.incomingRoids = new HashSet();
        }
        Location spawnLoc = this.getLocation().add((double)TUMaths.rollRange(-44, 44), (double)TUMaths.rollRange(-44, 44), (double)MineMain.chunkViewDistance * -0.95);
        Location targetLoc = spawnLoc.clone().add(0.0, 0.0, 200.0);
        Location toLoc = this.getLocationInDirection(spawnLoc, targetLoc, MineMain.chunkViewDistance * 2);
        ResourceAsteroid incoming = new ResourceAsteroid(spawnLoc, this);
        incoming.setPeiceMat(field.rollOreType(false));
        incoming.setMainMat(field.rollMainType());
        incoming.setTargetLocation(toLoc);
        incoming.setDisplayMoveSpeed(TUMaths.rollRange(3, 10));
        incoming.setStoredResource(incoming.getPeiceMat().asItemType().createItemStack());
        incoming.setAsteroidSize(field.rollSize());
        incoming.setScale(9);
        incoming.setStoredAmount(TUMaths.rollRange(32, 128));
        this.incomingRoids.add(incoming);
    }

    private void spawnDistantDecorationAsteroid(AsteroidField field) {
        double xSpawnRange;
        if (this.decorRoids == null) {
            this.decorRoids = new HashSet();
        }
        double yLevel = (double)spaceShipSize * 1.2;
        if (TUMaths.rollRange(0, 1) == 0) {
            yLevel *= -1.0;
        }
        if ((xSpawnRange = (double)MineMain.chunkViewDistance * 0.5) < (double)spaceShipSize) {
            xSpawnRange = spaceShipSize;
        }
        double zSpawn = (double)MineMain.chunkViewDistance * -0.95;
        Location spawnLoc = this.getLocation().add(TUMaths.rollRange(-xSpawnRange, xSpawnRange), yLevel, zSpawn);
        int decorXMin = spaceShipSize;
        if (Math.abs(spawnLoc.getBlockX() - this.getLocation().getBlockX()) > decorXMin) {
            spawnLoc.setY((double)(this.getLocation().getBlockY() + TUMaths.rollRange(-decorXMin, decorXMin)));
        }
        Location targetLoc = spawnLoc.clone().add(0.0, 0.0, 200.0);
        Location toLoc = this.getLocationInDirection(spawnLoc, targetLoc, MineMain.chunkViewDistance * 2);
        Asteroid decor = new Asteroid(spawnLoc, this);
        decor.setMainMat(field.rollMainType());
        decor.setPeiceMat(field.rollOreType(true));
        decor.setTargetLocation(toLoc);
        decor.setDisplayMoveSpeed(TUMaths.rollRange(3, 10));
        ResourceAsteroid.Size size = field.rollSize();
        if (size.equals((Object)ResourceAsteroid.Size.MEDIUM)) {
            decor.setScale(6);
        }
        if (size.equals((Object)ResourceAsteroid.Size.LARGE)) {
            decor.setScale(9);
        }
        this.decorRoids.add(decor);
    }

    public Location getLocationInDirection(Location from, Location toward, double distance) {
        if (!from.getWorld().equals(toward.getWorld())) {
            throw new IllegalArgumentException("Locations must be in the same world.");
        }
        Vector direction = toward.toVector().subtract(from.toVector()).normalize().multiply(distance);
        return from.clone().add(direction);
    }

    public void sendOwnerMessage(String message) {
        Player player = Bukkit.getPlayer((UUID)this.getPlacerUUID());
        if (player != null && player.isOnline()) {
            MineUtil.sendMessage(player, message);
        }
    }
}

