/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Transport;

import com.MT.triggersUtility.ChatInput;
import com.MT.triggersUtility.Saveable;
import com.MT.triggersUtility.TUInterface.TUIComponent;
import com.MT.triggersUtility.TUInterface.TUInterface;
import com.MT.triggersUtility.TUInterface.TUInterfaceScrolling;
import com.MT.triggersUtility.TUInterface.TUInventory;
import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Transport.TrainStation;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.LocaleUtil;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;

public class Locomotive
extends Saveable {
    private static final long serialVersionUID = -8648079383405175427L;
    private static HashMap<String, Locomotive> locomotives = new HashMap();
    private transient Inventory inv;
    private HashMap<Integer, String> serializedItems2 = new HashMap();
    private ArrayList<String> boarded = new ArrayList();
    private String pickupStation;
    private String dropOffStation;
    private int pickupTime = -1;
    private int dropOffTime = -1;
    private int timer = 0;
    private int fuel = 60;
    private String locomativeName;

    public static void removeLocomotive(Locomotive loco) {
        locomotives.remove(loco.getID());
    }

    public static ArrayList<Locomotive> getLocomotives() {
        return new ArrayList<Locomotive>(locomotives.values());
    }

    public static Locomotive getLocomotive(String id) {
        if (locomotives.containsKey(id)) {
            return locomotives.get(id);
        }
        return null;
    }

    public Locomotive() {
        super("Locomotives", UUID.randomUUID().toString());
        this.setLocomativeName("Unnamed Locomotive");
        if (!locomotives.containsKey(this.getID())) {
            locomotives.put(this.getID(), this);
        }
    }

    @Override
    public void onCreate(boolean isFirstTime) {
        if (!locomotives.containsKey(this.getID())) {
            locomotives.put(this.getID(), this);
        }
    }

    public Inventory getInv() {
        if (this.inv == null) {
            this.createInventory();
        }
        return this.inv;
    }

    public int firstEmpty() {
        Inventory inv = this.getInv();
        int i = 9;
        while (i <= 53) {
            if (inv.getItem(i) == null) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getFirstStoredStack() {
        Inventory inv = this.getInv();
        int i = 9;
        while (i <= 53) {
            if (inv.getItem(i) != null) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getSlotForItem(ItemStack itemToInsert) {
        Inventory inv = this.getInv();
        int size = inv.getSize();
        int rows = size / 9 + 1;
        int col = 0;
        while (col < 9) {
            ItemStack topItem = inv.getItem(col);
            boolean matches = false;
            if (topItem == null) {
                matches = true;
            } else if (topItem.isSimilar(itemToInsert)) {
                matches = true;
            }
            if (matches) {
                int row = 1;
                while (row <= rows) {
                    ItemStack current;
                    int slot = row * 9 + col;
                    if (slot < size && (current = inv.getItem(slot)) == null) {
                        return slot;
                    }
                    ++row;
                }
            }
            ++col;
        }
        return -1;
    }

    public void createInventory() {
        if (this.serializedItems2 == null) {
            this.serializedItems2 = new HashMap();
        }
        this.inv = TUInventory.createInventory(MineItems.goldBold() + "Locomotive Storage", 6, "Locomotive:" + this.getFileName());
        for (int key : new ArrayList<Integer>(this.serializedItems2.keySet())) {
            String itemSTR = this.serializedItems2.get(key);
            this.inv.setItem(key, TUItems.createStackFromString(itemSTR));
        }
        this.serializedItems2.clear();
    }

    public void saveInventory() {
        if (this.serializedItems2 == null) {
            this.serializedItems2 = new HashMap();
        }
        this.serializedItems2.clear();
        Inventory inv = this.getInv();
        int slot = 0;
        while (slot <= 53) {
            ItemStack stack = inv.getItem(slot);
            if (stack != null) {
                this.serializedItems2.put(slot, TUItems.createStackString(stack));
            }
            ++slot;
        }
    }

    @Override
    public void onSave() {
        this.saveInventory();
    }

    public void boardTrain(Player player) {
        if (!this.boarded.contains(player.getUniqueId().toString())) {
            this.boarded.add(player.getUniqueId().toString());
            MineUtil.sendMessage(player, LocaleUtil.messageText("Loco_Wait"));
        }
    }

    public void disembarkFrom(String who, String reason, Location teleportStation) {
        this.boarded.remove(who);
        Player player = Bukkit.getPlayer((UUID)UUID.fromString(who));
        if (player != null && player.isOnline() && reason != null) {
            if (reason.equals("To Far")) {
                MineUtil.sendWarning(player, LocaleUtil.messageText("Loco_Missed"));
            }
            if (reason.equals("Arrived")) {
                MineUtil.sendMessage(player, LocaleUtil.messageText("Loco_Arrived"));
                if (teleportStation != null) {
                    player.setMetadata("MT-Teleported", (MetadataValue)new FixedMetadataValue(MineMain.getPlugin(), (Object)"MT-Teleported"));
                    player.teleport(teleportStation.add(0.0, 1.0, 0.0));
                    player.removeMetadata("MT-Teleported", MineMain.getPlugin());
                }
            }
        }
    }

    public void disembarkAll(Location toStation) {
        for (String str : new ArrayList<String>(this.boarded)) {
            this.disembarkFrom(str, "Arrived", toStation);
        }
    }

    public ArrayList<String> getAllBoarded() {
        return new ArrayList<String>(this.boarded);
    }

    public void sendPassengersMessage(String message) {
        for (String str : new ArrayList<String>(this.boarded)) {
            Player player = Bukkit.getPlayer((UUID)UUID.fromString(str));
            if (player == null || !player.isOnline()) continue;
            MineUtil.sendMessage(player, message);
        }
    }

    public TrainStation getPickupStation() {
        return TrainStation.getStation(this.pickupStation);
    }

    public void setPickupStation(TrainStation pickupStation) {
        this.pickupStation = pickupStation.getID();
    }

    public TrainStation getDropOffStation() {
        return TrainStation.getStation(this.dropOffStation);
    }

    public void setDropOffStation(TrainStation dropOffStation) {
        this.dropOffStation = dropOffStation.getID();
    }

    public int getPickupTime() {
        return this.pickupTime;
    }

    public void setPickupTime(int pickupTime) {
        this.pickupTime = pickupTime;
    }

    public int getDropOffTime() {
        return this.dropOffTime;
    }

    public void setDropOffTime(int dropOffTime) {
        this.dropOffTime = dropOffTime;
    }

    public int getTimer() {
        return this.timer;
    }

    public void setTimer(int timer) {
        this.timer = timer;
    }

    public String getLocomativeName() {
        return this.locomativeName;
    }

    public void setLocomativeName(String locomativeName) {
        this.locomativeName = locomativeName;
    }

    public void openEditor(Player player, TrainStation station) {
        TUInterface face = new TUInterface(MineItems.goldBold() + "Locomotive Editor", 3);
        ArrayList<String> lore = TUItems.basicLore(MineUtil.colon(" " + LocaleUtil.uiText("General_Click"), "Open Inventory"));
        lore.add(" ");
        lore.addAll(MineUtil.wrapText("The top row of the locomotive isn't used as an inventory. Instead it is used to decide what items will be grabbed from the train station. Placing cobblestone in the first slot means all slots beneath it will be reserved for cobblestone. Leaving it blank means any item can be picked up.", 45, ChatColor.WHITE, 1));
        class InventoryButton
        extends TUIComponent {
            public InventoryButton(int slot, ItemStack linkStack) {
                super(slot, linkStack);
            }

            @Override
            public void onLeftClick(Player player) {
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                player.openInventory(Locomotive.this.getInv());
            }
        }
        face.addComponent(new InventoryButton(2, TUItems.createItem(Material.CHEST, MineItems.goldBold() + "Locomotive Inventory", lore)));
        class NameButton
        extends TUIComponent {
            private final /* synthetic */ TrainStation val$station;

            public NameButton(int slot, ItemStack linkStack, TrainStation trainStation) {
                this.val$station = trainStation;
                super(slot, linkStack);
            }

            @Override
            public void onLeftClick(Player player) {
                player.playSound((Entity)player, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                class ChatInput
                extends com.MT.triggersUtility.ChatInput {
                    private final /* synthetic */ Player val$player;
                    private final /* synthetic */ TrainStation val$station;

                    public ChatInput(String startMessage, boolean numbersonly, Player player, TrainStation trainStation) {
                        this.val$player = player;
                        this.val$station = trainStation;
                        super(startMessage, numbersonly);
                    }

                    @Override
                    public void inputAction(String message) {
                        Locomotive.this.setLocomativeName(message);
                        this.val$player.playSound((Entity)this.val$player, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                        Locomotive.this.openEditor(this.val$player, this.val$station);
                    }
                }
                ChatInput input = new ChatInput("Enter the new locomotive name in chat now!", false, player, this.val$station);
                input.start(player);
            }
        }
        face.addComponent(new NameButton(11, TUItems.createItem(Material.PAPER, MineItems.goldBold() + "Locomotive Name", TUItems.basicLore(MineUtil.colon(" " + LocaleUtil.uiText("General_Click"), "Set Name"), MineUtil.colon(" Current Name", this.getLocomativeName()))), station));
        String pickupName = "Not set";
        if (this.getPickupStation() != null) {
            pickupName = this.getPickupStation().getStationName();
        }
        class PickupButton
        extends TUIComponent {
            private final /* synthetic */ TrainStation val$station;

            public PickupButton(int slot, ItemStack linkStack, TrainStation trainStation) {
                this.val$station = trainStation;
                super(slot, linkStack);
            }

            @Override
            public void onLeftClick(Player player) {
                player.playSound((Entity)player, Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
                Locomotive.this.selectStation(player, "Pickup", this.val$station);
            }
        }
        face.addComponent(new PickupButton(4, TUItems.createItem(Material.COMPASS, MineItems.goldBold() + "Pickup Station", TUItems.basicLore(MineUtil.colon(" " + LocaleUtil.uiText("General_Click"), "Pick Station"), MineUtil.colon(" Set Station", pickupName))), station));
        String droppName = "Not set";
        if (this.getDropOffStation() != null) {
            droppName = this.getDropOffStation().getStationName();
        }
        class DropButton
        extends TUIComponent {
            private final /* synthetic */ TrainStation val$station;

            public DropButton(int slot, ItemStack linkStack, TrainStation trainStation) {
                this.val$station = trainStation;
                super(slot, linkStack);
            }

            @Override
            public void onLeftClick(Player player) {
                player.playSound((Entity)player, Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
                Locomotive.this.selectStation(player, "Dropoff", this.val$station);
            }
        }
        face.addComponent(new DropButton(6, TUItems.createItem(Material.RECOVERY_COMPASS, MineItems.goldBold() + "Dropoff Station", TUItems.basicLore(MineUtil.colon(" " + LocaleUtil.uiText("General_Click"), "Set Station"), MineUtil.colon(" Dropoff Station", droppName))), station));
        class PickupTime
        extends TUIComponent {
            private final /* synthetic */ TrainStation val$station;

            public PickupTime(int slot, ItemStack linkStack, TrainStation trainStation) {
                this.val$station = trainStation;
                super(slot, linkStack);
            }

            @Override
            public void onLeftClick(Player player) {
                player.playSound((Entity)player, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                class ChatInput
                extends com.MT.triggersUtility.ChatInput {
                    private final /* synthetic */ Player val$player;
                    private final /* synthetic */ TrainStation val$station;

                    public ChatInput(String startMessage, boolean numbersonly, Player player, TrainStation trainStation) {
                        this.val$player = player;
                        this.val$station = trainStation;
                        super(startMessage, numbersonly);
                    }

                    @Override
                    public void inputAction(String message) {
                        if (TUMaths.containsOnlyNumber(message)) {
                            Locomotive.this.setPickupTime(Integer.valueOf(message));
                            Locomotive.this.setTimer(Integer.valueOf(message));
                        }
                        if (message.equals("-1")) {
                            Locomotive.this.setPickupTime(-1);
                            Locomotive.this.setTimer(-1);
                        }
                        this.val$player.sendMessage(String.valueOf(ChatColor.GREEN) + LocaleUtil.messageText("Loco_Time_Updated"));
                        Locomotive.this.openEditor(this.val$player, this.val$station);
                    }
                }
                ChatInput input = new ChatInput("Enter the new timer now, enter only numbers or -1.", false, player, this.val$station);
                input.start(player);
            }
        }
        face.addComponent(new PickupTime(13, TUItems.createItem(Material.CLOCK, MineItems.goldBold() + "Pickup Time", TUItems.basicLore(MineUtil.colon(" " + LocaleUtil.uiText("General_Click"), "Set Timer"), MineUtil.colon(" Current Timer", "" + this.getPickupTime()), String.valueOf(ChatColor.GRAY) + " If set to -1, it'll wait until full.")), station));
        class DroppTime
        extends TUIComponent {
            private final /* synthetic */ TrainStation val$station;

            public DroppTime(int slot, ItemStack linkStack, TrainStation trainStation) {
                this.val$station = trainStation;
                super(slot, linkStack);
            }

            @Override
            public void onLeftClick(Player player) {
                player.playSound((Entity)player, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                class ChatInput
                extends com.MT.triggersUtility.ChatInput {
                    private final /* synthetic */ Player val$player;
                    private final /* synthetic */ TrainStation val$station;

                    public ChatInput(String startMessage, boolean numbersonly, Player player, TrainStation trainStation) {
                        this.val$player = player;
                        this.val$station = trainStation;
                        super(startMessage, numbersonly);
                    }

                    @Override
                    public void inputAction(String message) {
                        if (TUMaths.containsOnlyNumber(message)) {
                            Locomotive.this.setDropOffTime(Integer.valueOf(message));
                            Locomotive.this.setTimer(Integer.valueOf(message));
                        }
                        if (message.equals("-1")) {
                            Locomotive.this.setDropOffTime(-1);
                            Locomotive.this.setTimer(-1);
                        }
                        this.val$player.sendMessage(String.valueOf(ChatColor.GREEN) + LocaleUtil.messageText("Loco_Time_Updated"));
                        Locomotive.this.openEditor(this.val$player, this.val$station);
                    }
                }
                ChatInput input = new ChatInput("Enter the new timer now, enter only numbers or -1.", false, player, this.val$station);
                input.start(player);
            }
        }
        face.addComponent(new DroppTime(15, TUItems.createItem(Material.CLOCK, MineItems.goldBold() + "Dropoff Time", TUItems.basicLore(MineUtil.colon(" " + LocaleUtil.uiText("General_Click"), "Set Timer"), MineUtil.colon(" Current Timer", "" + this.getDropOffTime()), String.valueOf(ChatColor.GRAY) + " If set to -1, it'll wait until full.")), station));
        class ReturnButton
        extends TUIComponent {
            private final /* synthetic */ TrainStation val$station;

            public ReturnButton(int slot, ItemStack linkStack, TrainStation trainStation) {
                this.val$station = trainStation;
                super(slot, linkStack);
            }

            @Override
            public void onLeftClick(Player player) {
                player.openInventory(this.val$station.getInventory());
                player.playSound((Entity)player, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
            }
        }
        face.addComponent(new ReturnButton(22, MainMenu.createReturnArrow(), station));
        ItemStack pane = MainMenu.createGoldPane();
        ItemStack white = MainMenu.createWhitePane();
        int i = 18;
        while (i < 27) {
            if (i != 22) {
                face.addComponent(new TUIComponent(i, pane));
            }
            ++i;
        }
        i = 1;
        while (i <= 7) {
            face.addComponent(new TUIComponent(i, white));
            face.addComponent(new TUIComponent(i + 9, white));
            i += 2;
        }
        face.openInterface(player);
    }

    public void selectStation(Player player, String selectType, TrainStation editor) {
        ItemStack pane = MainMenu.createGoldPane();
        ArrayList<TrainStation> stations = new ArrayList<TrainStation>();
        for (String stationID : new ArrayList<String>(editor.connectedStations)) {
            stations.add(TrainStation.getStation(stationID));
        }
        if (TrainStation.allowVirtualConnections) {
            for (String stationID : new ArrayList<String>(editor.virtuallyConnectedStations)) {
                if (editor.connectedStations.contains(stationID)) continue;
                stations.add(TrainStation.getStation(stationID));
            }
        }
        HashMap stacks = new HashMap();
        class LeaderScroller
        extends TUInterfaceScrolling {
            private final /* synthetic */ ArrayList val$stations;
            private final /* synthetic */ HashMap val$stacks;
            private final /* synthetic */ String val$selectType;
            private final /* synthetic */ TrainStation val$editor;

            public LeaderScroller(String name, int rows, ArrayList arrayList, HashMap hashMap, String string, TrainStation trainStation) {
                this.val$stations = arrayList;
                this.val$stacks = hashMap;
                this.val$selectType = string;
                this.val$editor = trainStation;
                super(name, rows);
            }

            @Override
            public ItemStack defineScrolling(int i) {
                if (this.val$stations.size() > i) {
                    TrainStation ts = (TrainStation)this.val$stations.get(i);
                    ItemStack stack = TUItems.createItem(Material.CARTOGRAPHY_TABLE, MineItems.goldBold() + ts.getStationName());
                    this.val$stacks.put(stack, ts);
                    return stack;
                }
                return null;
            }

            @Override
            public void scrollingActionClick(Player player, ItemStack item, InventoryClickEvent event) {
                if (this.val$selectType.equals("Pickup")) {
                    Locomotive.this.setPickupStation((TrainStation)this.val$stacks.get(item));
                }
                if (this.val$selectType.equals("Dropoff")) {
                    Locomotive.this.setDropOffStation((TrainStation)this.val$stacks.get(item));
                }
                Locomotive.this.openEditor(player, this.val$editor);
            }
        }
        LeaderScroller face = new LeaderScroller(ChatColor.GOLD + ChatColor.BOLD + "Select Train Station", 6, stations, stacks, selectType, editor);
        int i = 45;
        while (i <= 53) {
            if (i != 48 && i != 50) {
                face.addComponent(new TUIComponent(i, pane));
            }
            ++i;
        }
        ArrayList<Integer> scrollingSlots = new ArrayList<Integer>();
        int j = 0;
        while (j <= 44) {
            scrollingSlots.add(j);
            ++j;
        }
        face.setScrollingSlots(scrollingSlots);
        class LeftScroll
        extends TUIComponent {
            public LeftScroll(int slot, ItemStack linkStack) {
                super(slot, linkStack);
            }

            @Override
            public void onLeftClick(Player player) {
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            }
        }
        LeftScroll leftScroller = new LeftScroll(48, MineUtil.getLeftScollingStack());
        class RightScroll
        extends TUIComponent {
            public RightScroll(int slot, ItemStack linkStack) {
                super(slot, linkStack);
            }

            @Override
            public void onLeftClick(Player player) {
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            }
        }
        RightScroll rightScroller = new RightScroll(50, MineUtil.getRightScrollingStack());
        face.addComponent(leftScroller);
        face.addComponent(rightScroller);
        face.setLeftComp(leftScroller);
        face.setRightComp(rightScroller);
        face.updateScrolling();
        face.openInterface(player);
    }

    public String getID() {
        return this.getFileName();
    }

    public int getFuel() {
        return this.fuel;
    }

    public void setFuel(int fuel) {
        if (fuel > 100) {
            fuel = 100;
        }
        if (fuel < 0) {
            fuel = 0;
        }
        this.fuel = fuel;
    }

    public boolean hasFuel(Location from, Location destination) {
        return this.tripFuel(from, destination) <= this.getFuel();
    }

    public void useFuel(Location from, Location destination) {
        this.setFuel(this.getFuel() - this.tripFuel(from, destination));
    }

    public int tripFuel(Location from, Location destination) {
        int distance = TUMaths.getManhattanDistance(from, destination);
        return distance / 20 + 1;
    }
}

