/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Utility;

import com.MT.triggersUtility.ChatInput;
import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Utility.PowerReceiver;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.LocaleUtil;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class PowerProvider
extends Device {
    private static final long serialVersionUID = -1132109111254171315L;
    private static String classSpacedNamed = "Power Provider";
    private transient String placerName;
    private int maxClientDistance = 0;
    private double wattPrice = 0.01;
    private double funds = 0.0;

    public PowerProvider(Location loc) {
        super(loc);
        this.setMaterial("NOTE_BLOCK");
        this.deviceName = classSpacedNamed;
        this.setActionTimer(1);
        this.setOpenable(true);
        this.setStoreForm(false);
        this.setIdlePower(0);
        this.setActionPower(0);
        this.setUseUI(true);
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- This device can provide power to any power reciever.");
        lore.add("- However the user of the power reciever will be charged");
        lore.add("- for using power provided from this.");
        lore.add("- Pricing can be configured in the device.");
        return lore;
    }

    public double getWattPrice() {
        return this.wattPrice;
    }

    public int getDistance() {
        return this.maxClientDistance;
    }

    public String getPlacerName() {
        if (this.placerName != null) {
            return this.placerName;
        }
        if (this.getPlacerUUIDString() != null) {
            return Bukkit.getOfflinePlayer((UUID)UUID.fromString(this.getPlacerUUIDString())).getName();
        }
        return "Server";
    }

    @Override
    public void updateUI() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(MineUtil.colon(" Watt Price", this.wattPrice + " (" + this.wattPrice * 1000.0 + " per kw)"));
        lore.add(MineUtil.colon(" Max Distance", "" + this.maxClientDistance));
        lore.add(MineUtil.colon(" Max Transmission Loss", "" + this.maxClientDistance / 50));
        int actualFunds = (int)Math.floor(this.funds);
        lore.add(MineUtil.colon(" Funds", "" + actualFunds));
        lore.add(" ");
        lore.add(MineUtil.colon(" " + LocaleUtil.uiText("General_Left_Click"), "Set Watt Price"));
        lore.add(MineUtil.colon(" " + LocaleUtil.uiText("General_Right_Click"), "Set Max Distance"));
        lore.add(MineUtil.colon(" Shift Click", "Collect Funds"));
        if (this.getFailReason() != null && !this.getFailReason().equals("None")) {
            lore.add(" ");
            lore.add(" " + String.valueOf(ChatColor.RED) + this.getFailReason());
        }
        ItemStack powerStack = TUItems.createItem(Material.OBSERVER, String.valueOf(MineItems.goldBold()) + "Provider Settings", lore);
        powerStack = TUItems.setModelData(powerStack, 9531);
        Inventory inv = this.getInventory();
        inv.setItem(13, powerStack);
        ItemStack gPane = MainMenu.createGoldPane();
        int i = 0;
        while (i <= 26) {
            if (i != 13) {
                inv.setItem(i, gPane);
            }
            ++i;
        }
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.REDSTONE_BLOCK, 1.0);
    }

    @Override
    public void action() {
        this.getGrid();
    }

    public int getTransmissionCost(Device toWho) {
        return TUMaths.get2DManhattanDistance(toWho.getLocation(), this.getLocation()) / 50;
    }

    public boolean providePower(PowerReceiver toWho, int needed) {
        if (this.getGrid().hasPower(needed)) {
            this.getGrid().consumePower(this, needed);
            this.setConsumingPower(true);
            this.setActionPower(needed);
            toWho.addPower(needed);
            return true;
        }
        return false;
    }

    public void addFunds(double funds) {
        this.funds += funds;
    }

    @Override
    public void onUIClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.getSlot() == 13) {
            com.MT.triggersUtility.ChatInput input;
            if (event.isShiftClick()) {
                int actualFunds = (int)Math.floor(this.funds);
                if (actualFunds > 0) {
                    this.funds -= (double)actualFunds;
                    MineMain.getEconomy().depositPlayer((OfflinePlayer)player, (double)actualFunds);
                    MineUtil.sendMessage(player, LocaleUtil.messageText("PP_Collect").replace("%funds%", "" + actualFunds));
                }
                return;
            }
            if (event.isLeftClick()) {
                class ChatInput
                extends com.MT.triggersUtility.ChatInput {
                    private final /* synthetic */ Player val$player;

                    public ChatInput(String startMessage, boolean numbersonly, Player player) {
                        this.val$player = player;
                        super(startMessage, numbersonly);
                    }

                    @Override
                    public void inputAction(String message) {
                        TUMaths.dm("val: " + message);
                        PowerProvider.this.wattPrice = Double.valueOf(message);
                        MineUtil.sendMessage(this.val$player, LocaleUtil.messageText("PP_Wattage").replace("%price%", "" + PowerProvider.this.wattPrice));
                        PowerProvider.this.updateUI();
                        this.val$player.openInventory(PowerProvider.this.getInventory());
                    }
                }
                input = new ChatInput(LocaleUtil.messageText("PP_Watt_Input"), false, player);
                input.setIgnorePeriod(true);
                input.start(player);
            }
            if (event.isRightClick()) {
                class ChatInput
                extends com.MT.triggersUtility.ChatInput {
                    private final /* synthetic */ Player val$player;

                    public ChatInput(String startMessage, boolean numbersonly, Player player) {
                        this.val$player = player;
                        super(startMessage, numbersonly);
                    }

                    @Override
                    public void inputAction(String message) {
                        PowerProvider.this.maxClientDistance = Integer.valueOf(message);
                        MineUtil.sendMessage(this.val$player, LocaleUtil.messageText("PP_Distance_Input_2").replace("%distance%", "" + PowerProvider.this.maxClientDistance));
                        PowerProvider.this.updateUI();
                        this.val$player.openInventory(PowerProvider.this.getInventory());
                    }
                }
                input = new ChatInput(LocaleUtil.messageText("PP_Distance_Input"), true, player);
                input.start(player);
            }
            player.closeInventory();
        }
    }

    public static void addDevice() {
        if (MineMain.getEconomy() == null) {
            return;
        }
        MinetorioListener.deviceClasses.put(classSpacedNamed, PowerProvider.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.POWER, new PowerProvider(null).getDeviceStack(), false);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(MineItems.getIndustrialItem("Iron Plate", 6));
        ings.add(MineItems.getIndustrialItem("Electronic Circuit", 2));
        ings.add(new ItemStack(Material.ENDER_PEARL));
        RecipeUtils.addDefaultRecipe(new PowerProvider(null).getDeviceStack(), ings, MTRecipe.RecipeType.ADVANCED, true);
    }
}

