/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Guide;

import com.MT.triggersUtility.Saveable;
import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Guide.TablesMenu;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.ResourceZone;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class MinetorioTables
extends Saveable {
    public static MinetorioTables table;
    private static final long serialVersionUID = 5147661155101000654L;
    public HashMap<TablesMenu.Category, ArrayList<String>> tables = new HashMap();
    public ArrayList<String> alreadyPopulated = new ArrayList();
    private static HashMap<Material, ItemStack> crushChoices;
    private static HashMap<Material, Integer> crushCounts;
    private static HashMap<Material, ArrayList<ItemStack>> siftChoices;
    private static HashMap<ItemStack, Integer> siftChance;
    private static HashMap<ItemStack, Integer> siftMin;
    private static HashMap<ItemStack, Integer> siftMax;
    private static HashMap<ItemStack, Boolean> defaultMaterial;
    private static HashMap<ItemStack, ArrayList<String>> biomeBlockedGeneral;
    private static HashMap<ItemStack, HashMap<String, Integer>> biomeGeneralBonus;
    private static HashMap<ItemStack, HashMap<Double, Integer>> tempLowBonus;
    private static HashMap<ItemStack, HashMap<Double, Integer>> tempHighBonus;
    private static HashMap<ItemStack, HashMap<Integer, Integer>> yLowBonus;
    private static HashMap<ItemStack, Integer> rzMin;
    private static HashMap<ItemStack, Integer> rzMax;
    private static HashMap<ItemStack, Integer> rzChance;
    private static HashMap<ItemStack, Boolean> oilMat;
    private static HashMap<ItemStack, Double> rzColderThen;
    private static HashMap<ItemStack, Double> rzWarmerThen;
    private static HashMap<ItemStack, ItemStack> cleanStack;

    static {
        crushChoices = new HashMap();
        crushCounts = new HashMap();
        siftChoices = new HashMap();
        siftChance = new HashMap();
        siftMin = new HashMap();
        siftMax = new HashMap();
        defaultMaterial = new HashMap();
        biomeBlockedGeneral = new HashMap();
        biomeGeneralBonus = new HashMap();
        tempLowBonus = new HashMap();
        tempHighBonus = new HashMap();
        yLowBonus = new HashMap();
        rzMin = new HashMap();
        rzMax = new HashMap();
        rzChance = new HashMap();
        oilMat = new HashMap();
        rzColderThen = new HashMap();
        rzWarmerThen = new HashMap();
        cleanStack = new HashMap();
    }

    public MinetorioTables() {
        super("Table Data", "MinetorioTables");
    }

    @Override
    public void onCreate(boolean isFirstTime) {
        if (table == null) {
            table = this;
        }
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

            @Override
            public void run() {
                MinetorioTables.populateDefaults();
                MinetorioTables.this.saveTables();
                MinetorioTables.this.loadTables();
            }
        }, 20L);
    }

    public void saveTables() {
        this.tables = TablesMenu.tables;
        this.save();
    }

    public void loadTables() {
        TablesMenu.tables = this.tables;
        TablesMenu.Category[] categoryArray = TablesMenu.Category.values();
        int n = categoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            TablesMenu.Category cat = categoryArray[n2];
            if (!TablesMenu.tables.containsKey((Object)cat)) {
                TablesMenu.tables.put(cat, new ArrayList());
            }
            ++n2;
        }
        MinetorioTables.updateChoices(TablesMenu.Category.SIFTER);
        MinetorioTables.updateChoices(TablesMenu.Category.CRUSHER);
        MinetorioTables.updateChoices(TablesMenu.Category.RESOURCE_ZONE);
    }

    public static void populateDefaults() {
        if (MinetorioTables.table.alreadyPopulated == null) {
            MinetorioTables.table.alreadyPopulated = new ArrayList();
        }
        MinetorioTables.populateDefaultRecipe(TablesMenu.Category.SIFTER, new ItemStack(Material.SAND), 25, 1, 1, false, Material.SAND, Material.RED_SAND);
        MinetorioTables.populateDefaultRecipe(TablesMenu.Category.SIFTER, new ItemStack(Material.FLINT), 20, 1, 1, true, Material.SAND, Material.RED_SAND);
        MinetorioTables.populateDefaultRecipe(TablesMenu.Category.SIFTER, new ItemStack(Material.IRON_NUGGET), 20, 3, 6, false, Material.SAND, Material.RED_SAND);
        MinetorioTables.populateDefaultRecipe(TablesMenu.Category.SIFTER, new ItemStack(Material.FEATHER), 15, 1, 3, false, Material.SAND, Material.RED_SAND);
        MinetorioTables.populateDefaultRecipe(TablesMenu.Category.SIFTER, new ItemStack(Material.STICK), 15, 1, 3, false, Material.SAND, Material.RED_SAND);
        MinetorioTables.populateDefaultRecipe(TablesMenu.Category.SIFTER, new ItemStack(Material.BONE), 10, 1, 3, false, Material.SAND, Material.RED_SAND);
        MinetorioTables.populateDefaultRecipe(TablesMenu.Category.SIFTER, new ItemStack(Material.GOLD_NUGGET), 5, 1, 3, false, Material.SAND, Material.RED_SAND);
        MinetorioTables.populateDefaultRecipe(TablesMenu.Category.SIFTER, new ItemStack(Material.REDSTONE), 10, 1, 1, false, Material.SAND, Material.RED_SAND);
        MinetorioTables.populateDefaultRecipe(TablesMenu.Category.SIFTER, new ItemStack(Material.STRING), 5, 1, 1, false, Material.SAND, Material.RED_SAND);
        MinetorioTables.populateDefaultRecipe(TablesMenu.Category.SIFTER, new ItemStack(Material.CLAY_BALL), 100, 1, 1, true, Material.DIRT, null);
        MinetorioTables.populateDefaultRecipe(TablesMenu.Category.SIFTER, new ItemStack(Material.WHEAT_SEEDS), 5, 1, 1, false, Material.DIRT, null);
        MinetorioTables.populateDefaultRecipe(TablesMenu.Category.SIFTER, new ItemStack(Material.PUMPKIN_SEEDS), 5, 1, 1, false, Material.DIRT, null);
        MinetorioTables.populateDefaultRecipe(TablesMenu.Category.SIFTER, new ItemStack(Material.MELON_SEEDS), 5, 1, 1, false, Material.DIRT, null);
        MinetorioTables.populateDefaultRecipe(TablesMenu.Category.SIFTER, new ItemStack(Material.POTATO), 2, 1, 1, false, Material.DIRT, null);
        MinetorioTables.populateDefaultRecipe(TablesMenu.Category.SIFTER, new ItemStack(Material.CARROT), 2, 1, 1, false, Material.DIRT, null);
        MinetorioTables.populateDefaultRecipe(TablesMenu.Category.SIFTER, new ItemStack(Material.BONE), 20, 1, 1, false, Material.DIRT, null);
        MinetorioTables.populateDefaultRecipe(TablesMenu.Category.SIFTER, new ItemStack(Material.FLINT), 10, 1, 1, false, Material.DIRT, null);
        MinetorioTables.populateDefaultRecipe(TablesMenu.Category.SIFTER, new ItemStack(Material.STICK), 25, 1, 1, false, Material.DIRT, null);
        MinetorioTables.populateDefaultRecipe(TablesMenu.Category.SIFTER, new ItemStack(Material.BARRIER), 100, 1, 1, true, Material.SOUL_SAND, null);
        MinetorioTables.populateDefaultRecipe(TablesMenu.Category.SIFTER, new ItemStack(Material.SOUL_SAND), 33, 1, 1, false, Material.SOUL_SAND, null);
        MinetorioTables.populateDefaultRecipe(TablesMenu.Category.SIFTER, new ItemStack(Material.QUARTZ), 5, 1, 1, false, Material.SOUL_SAND, null);
        MinetorioTables.populateDefaultRecipe(TablesMenu.Category.SIFTER, new ItemStack(Material.GOLD_NUGGET), 5, 1, 3, false, Material.SOUL_SAND, null);
        MinetorioTables.populateDefaultRecipe(TablesMenu.Category.SIFTER, new ItemStack(Material.ENDER_PEARL), 1, 1, 1, false, Material.SOUL_SAND, null);
        MinetorioTables.populateDefaultRecipe(TablesMenu.Category.SIFTER, new ItemStack(Material.BARRIER), 100, 1, 1, true, Material.SOUL_SOIL, null);
        MinetorioTables.populateDefaultRecipe(TablesMenu.Category.SIFTER, new ItemStack(Material.SOUL_SOIL), 33, 1, 1, false, Material.SOUL_SOIL, null);
        MinetorioTables.populateDefaultRecipe(TablesMenu.Category.SIFTER, new ItemStack(Material.BONE), 5, 1, 1, false, Material.SOUL_SOIL, null);
        MinetorioTables.populateDefaultRecipe(TablesMenu.Category.SIFTER, new ItemStack(Material.NETHER_WART), 1, 1, 1, false, Material.SOUL_SOIL, null);
        MinetorioTables.populateDefaultRecipe(TablesMenu.Category.SIFTER, new ItemStack(Material.WARPED_FUNGUS), 10, 1, 1, false, Material.SOUL_SOIL, null);
        ArrayList<Object> gravelMats = new ArrayList<Material>();
        gravelMats.add(Material.CALCITE);
        gravelMats.add(Material.TUFF);
        gravelMats.add(Material.DIORITE);
        gravelMats.add(Material.ANDESITE);
        gravelMats.add(Material.GRANITE);
        MinetorioTables.populateDefaultRecipeCrusher(new ItemStack(Material.GRAVEL), gravelMats, 1);
        gravelMats = new ArrayList();
        gravelMats.add(Material.COBBLESTONE);
        MinetorioTables.populateDefaultRecipeCrusher(new ItemStack(Material.GRAVEL), gravelMats, 1);
        gravelMats = new ArrayList();
        gravelMats.add(Material.NETHERRACK);
        MinetorioTables.populateDefaultRecipeCrusher(new ItemStack(Material.SOUL_SAND), gravelMats, 2);
        ArrayList<Material> logMats = new ArrayList<Material>();
        Material[] materialArray = Material.values();
        int n = materialArray.length;
        int n2 = 0;
        while (n2 < n) {
            Material material = materialArray[n2];
            if (material.toString().contains("_LOG") || material.toString().contains("_WOOD")) {
                logMats.add(material);
            }
            ++n2;
        }
        MinetorioTables.populateDefaultRecipeCrusher(new ItemStack(Material.CHARCOAL), logMats, 1);
        ArrayList<Material> stickCrush = new ArrayList<Material>();
        stickCrush.add(Material.STICK);
        MinetorioTables.populateDefaultRecipeCrusher(new ItemStack(Material.CHARCOAL), stickCrush, 8);
        ArrayList<Material> slateCrush = new ArrayList<Material>();
        slateCrush.add(Material.DEEPSLATE);
        slateCrush.add(Material.COBBLED_DEEPSLATE);
        MinetorioTables.populateDefaultRecipeCrusher(new ItemStack(Material.COBBLESTONE, 2), slateCrush, 1);
        ArrayList<Material> gravelCrush = new ArrayList<Material>();
        gravelCrush.add(Material.GRAVEL);
        MinetorioTables.populateDefaultRecipeCrusher(new ItemStack(Material.SAND), gravelCrush, 1);
        ArrayList<Material> sandCrush = new ArrayList<Material>();
        sandCrush.add(Material.SANDSTONE);
        MinetorioTables.populateDefaultRecipeCrusher(new ItemStack(Material.SAND, 4), sandCrush, 1);
        sandCrush.clear();
        sandCrush.add(Material.RED_SANDSTONE);
        MinetorioTables.populateDefaultRecipeCrusher(new ItemStack(Material.RED_SAND, 4), sandCrush, 1);
        sandCrush.clear();
        sandCrush.add(Material.SMOOTH_BASALT);
        MinetorioTables.populateDefaultRecipeCrusher(new ItemStack(Material.IRON_NUGGET, 5), sandCrush, 1);
        ArrayList<String> mods = new ArrayList<String>();
        mods.add(String.valueOf(ChatColor.WHITE) + "General Biome: CAVE/10");
        mods.add(String.valueOf(ChatColor.WHITE) + "Temp Low Bonus: 0.25/2");
        mods.add(String.valueOf(ChatColor.WHITE) + "Temp Low Bonus: 0.2/2");
        mods.add(String.valueOf(ChatColor.WHITE) + "Temp Low Bonus: 0.0/2");
        MinetorioTables.populateDefaultDeepDrill(new ItemStack(Material.RAW_IRON), 2, 3500, 7000, mods);
        mods.clear();
        mods.add(String.valueOf(ChatColor.WHITE) + "General Biome: SAVANNA/10");
        mods.add(String.valueOf(ChatColor.WHITE) + "General Biome: PLAINS/10");
        MinetorioTables.populateDefaultDeepDrill(new ItemStack(Material.RAW_COPPER), 6, 7000, 14000, mods);
        mods.clear();
        mods.add(String.valueOf(ChatColor.WHITE) + "Y Level Low Bonus: -32/1");
        MinetorioTables.populateDefaultDeepDrill(new ItemStack(Material.RAW_GOLD), 0, 500, 1000, mods);
        mods.clear();
        mods.add(String.valueOf(ChatColor.WHITE) + "General Biome: LUSH/10");
        MinetorioTables.populateDefaultDeepDrill(new ItemStack(Material.REDSTONE), 0, 5000, 10000, mods);
        mods.clear();
        mods.add(String.valueOf(ChatColor.WHITE) + "General Biome: SWAMP/10");
        mods.add(String.valueOf(ChatColor.WHITE) + "General Biome: FOREST/2");
        MinetorioTables.populateDefaultDeepDrill(new ItemStack(Material.COAL), 0, 5000, 10000, mods);
        mods.clear();
        mods.add(String.valueOf(ChatColor.WHITE) + "Not Biome General: OCEAN");
        mods.add(String.valueOf(ChatColor.WHITE) + "Colder Then: 0.3");
        MinetorioTables.populateDefaultDeepDrill(MineItems.getIndustrialItem("Uranium Ore"), 10, 5000, 10000, mods);
        mods.clear();
        mods.add(String.valueOf(ChatColor.WHITE) + "IS OIL");
        mods.add(String.valueOf(ChatColor.WHITE) + "General Biome: DEEP/10");
        mods.add(String.valueOf(ChatColor.WHITE) + "General Biome: DESERT/10");
        mods.add(String.valueOf(ChatColor.WHITE) + "General Biome: BADLANDS/10");
        mods.add(String.valueOf(ChatColor.WHITE) + "Temp High Bonus: 0.0/2");
        mods.add(String.valueOf(ChatColor.WHITE) + "Warmer Then: 0.2");
        MinetorioTables.populateDefaultDeepDrill(new ItemStack(Material.BUCKET), 2, 100000, 200000, mods);
        mods.clear();
    }

    public static void enableTables() {
        if (table == null) {
            MinetorioTables table;
            MinetorioTables.table = table = new MinetorioTables();
        }
        table.loadTables();
    }

    private static void populateDefaultRecipe(TablesMenu.Category cat, ItemStack stack, int chance, int min, int max, boolean def, Material proccessMaterial, Material pm2) {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(String.valueOf(ChatColor.WHITE) + "Min: " + min);
        lore.add(String.valueOf(ChatColor.WHITE) + "Max: " + max);
        lore.add(String.valueOf(ChatColor.WHITE) + "Chance: " + chance);
        lore.add(String.valueOf(ChatColor.WHITE) + "Default: " + def);
        lore.add(String.valueOf(ChatColor.WHITE) + "Material: " + String.valueOf(proccessMaterial));
        if (pm2 != null) {
            lore.add(String.valueOf(ChatColor.WHITE) + "Material: " + String.valueOf(pm2));
        }
        TUItems.addLore(stack, lore);
        String str = TUItems.createStackString(stack);
        String popSTR = cat.toString() + ":" + str;
        if (!TablesMenu.tables.get((Object)cat).contains(str) && !MinetorioTables.table.alreadyPopulated.contains(popSTR)) {
            TablesMenu.tables.get((Object)cat).add(str);
            MinetorioTables.table.alreadyPopulated.add(popSTR);
        }
    }

    private static void populateDefaultRecipeCrusher(ItemStack stack, ArrayList<Material> mats, int amountNeeded) {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(String.valueOf(ChatColor.WHITE) + "Amount Needed: " + amountNeeded);
        for (Material mat : mats) {
            lore.add(String.valueOf(ChatColor.WHITE) + "Material: " + String.valueOf(mat));
        }
        TUItems.addLore(stack, lore);
        String str = TUItems.createStackString(stack);
        if (!TablesMenu.tables.get((Object)TablesMenu.Category.CRUSHER).contains(str) && !MinetorioTables.table.alreadyPopulated.contains(str)) {
            TablesMenu.tables.get((Object)TablesMenu.Category.CRUSHER).add(str);
            MinetorioTables.table.alreadyPopulated.add(str);
        }
    }

    private static void populateDefaultDeepDrill(ItemStack stack, int chance, int min, int max, ArrayList<String> mods) {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(String.valueOf(ChatColor.WHITE) + "Min: " + min);
        lore.add(String.valueOf(ChatColor.WHITE) + "Max: " + max);
        lore.add(String.valueOf(ChatColor.WHITE) + "Chance: " + chance);
        lore.addAll(mods);
        TUItems.addLore(stack, lore);
        String str = TUItems.createStackString(stack);
        if (!TablesMenu.tables.get((Object)TablesMenu.Category.RESOURCE_ZONE).contains(str)) {
            TablesMenu.tables.get((Object)TablesMenu.Category.RESOURCE_ZONE).add(str);
        }
    }

    public static void giveCleaned(Player player) {
        for (ItemStack cleaned : cleanStack.values()) {
            player.getInventory().addItem(new ItemStack[]{cleaned});
        }
    }

    public static ResourceZone generateResourceZone(Location loc) {
        ItemStack lowest = null;
        Block block = loc.getBlock();
        double temp = block.getTemperature();
        Biome biome = block.getBiome();
        for (ItemStack possible : new ArrayList<ItemStack>(rzChance.keySet())) {
            boolean blocked = false;
            for (String blockedBiome : biomeBlockedGeneral.get(possible)) {
                if (!biome.toString().contains(blockedBiome)) continue;
                blocked = true;
                break;
            }
            if (rzColderThen.containsKey(possible) && temp >= rzColderThen.get(possible)) {
                blocked = true;
            }
            if (rzWarmerThen.containsKey(possible) && temp <= rzWarmerThen.get(possible)) {
                blocked = true;
            }
            if (blocked) continue;
            int chance = rzChance.get(possible);
            for (String bonusBiome : new ArrayList<String>(biomeGeneralBonus.get(possible).keySet())) {
                if (!biome.toString().contains(bonusBiome)) continue;
                chance += biomeGeneralBonus.get(possible).get(bonusBiome).intValue();
            }
            for (Double tempThreshhold : new ArrayList<Double>(tempLowBonus.get(possible).keySet())) {
                if (!(tempThreshhold <= temp)) continue;
                chance += tempLowBonus.get(possible).get(tempThreshhold).intValue();
            }
            for (Double tempThreshhold : new ArrayList<Double>(tempHighBonus.get(possible).keySet())) {
                if (!(tempThreshhold >= temp)) continue;
                chance += tempHighBonus.get(possible).get(tempThreshhold).intValue();
            }
            for (Integer yLevelThreshold : new ArrayList<Integer>(yLowBonus.get(possible).keySet())) {
                if (loc.getBlockY() > yLevelThreshold) continue;
                chance += yLowBonus.get(possible).get(yLevelThreshold).intValue();
            }
            int rolled = TUMaths.rollRange(0, 99);
            if (rolled > chance) continue;
            if (lowest == null) {
                lowest = possible;
                continue;
            }
            if (chance >= rzChance.get(lowest)) continue;
            lowest = possible;
        }
        if (lowest == null) {
            return null;
        }
        ItemStack cleaned = cleanStack.get(lowest);
        ResourceZone rz = new ResourceZone(loc, cleaned);
        if (oilMat.get(lowest).booleanValue()) {
            rz.setStoredLiquid(Device.LiquidType.OIL);
        }
        double richness = 1.0;
        if (TUMaths.rollRange(0, 99) <= 50) {
            richness += 0.25;
        }
        if (TUMaths.rollRange(0, 99) <= 25) {
            richness += 0.25;
        }
        if (TUMaths.rollRange(0, 99) <= 10) {
            richness += 0.25;
        }
        if (TUMaths.rollRange(0, 99) <= 5) {
            richness += 0.25;
        }
        int amount = (int)((double)TUMaths.rollRange(rzMin.get(lowest), rzMax.get(lowest)) * richness);
        amount = (int)((double)amount * MineMain.richnessScale);
        rz.setStoredResource(amount);
        return rz;
    }

    public static void updateChoices(TablesMenu.Category cat) {
        if (cat.equals((Object)TablesMenu.Category.RESOURCE_ZONE)) {
            for (String strStack : MinetorioTables.table.tables.get((Object)cat)) {
                ItemStack stack = TUItems.createStackFromString(strStack);
                if (!biomeGeneralBonus.containsKey(stack)) {
                    biomeGeneralBonus.put(stack, new HashMap());
                    tempLowBonus.put(stack, new HashMap());
                    tempHighBonus.put(stack, new HashMap());
                    yLowBonus.put(stack, new HashMap());
                    biomeBlockedGeneral.put(stack, new ArrayList());
                }
                int min = 1;
                int max = 1;
                int chance = 0;
                oilMat.put(stack, false);
                ArrayList<String> newLore = new ArrayList<String>();
                for (String str : stack.getItemMeta().getLore()) {
                    boolean pluginLore = false;
                    if (str.contains("Min: ")) {
                        min = Integer.valueOf(ChatColor.stripColor((String)str.split(": ")[1]));
                        pluginLore = true;
                    }
                    if (str.contains("Max: ")) {
                        max = Integer.valueOf(ChatColor.stripColor((String)str.split(": ")[1]));
                        pluginLore = true;
                    }
                    if (str.contains("Chance: ")) {
                        chance = Integer.valueOf(ChatColor.stripColor((String)str.split(": ")[1]));
                        pluginLore = true;
                    }
                    if (str.contains("General Biome:")) {
                        biomeGeneralBonus.get(stack).put(ChatColor.stripColor((String)str.split(": ")[1].split("/")[0]), Integer.valueOf(ChatColor.stripColor((String)str.split(": ")[1].split("/")[1])));
                        pluginLore = true;
                    }
                    if (str.contains("Temp Low Bonus:")) {
                        tempLowBonus.get(stack).put(Double.valueOf(ChatColor.stripColor((String)str.split(": ")[1].split("/")[0])), Integer.valueOf(ChatColor.stripColor((String)str.split(": ")[1].split("/")[1])));
                        pluginLore = true;
                    }
                    if (str.contains("Temp High Bonus:")) {
                        tempHighBonus.get(stack).put(Double.valueOf(ChatColor.stripColor((String)str.split(": ")[1].split("/")[0])), Integer.valueOf(ChatColor.stripColor((String)str.split(": ")[1].split("/")[1])));
                        pluginLore = true;
                    }
                    if (str.contains("Y Level Low Bonus:")) {
                        yLowBonus.get(stack).put(Integer.valueOf(ChatColor.stripColor((String)str.split(": ")[1].split("/")[0])), Integer.valueOf(ChatColor.stripColor((String)str.split(": ")[1].split("/")[1])));
                        pluginLore = true;
                    }
                    if (str.contains("Not Biome General:")) {
                        biomeBlockedGeneral.get(stack).add(ChatColor.stripColor((String)str.split(": ")[1]));
                        pluginLore = true;
                    }
                    if (str.contains("Warmer Then:")) {
                        rzWarmerThen.put(stack, Double.valueOf(ChatColor.stripColor((String)str.split(": ")[1])));
                        pluginLore = true;
                    }
                    if (str.contains("Colder Then:")) {
                        rzColderThen.put(stack, Double.valueOf(ChatColor.stripColor((String)str.split(": ")[1])));
                        pluginLore = true;
                    }
                    if (str.contains("IS OIL")) {
                        oilMat.put(stack, true);
                        pluginLore = true;
                    }
                    if (pluginLore) continue;
                    newLore.add(str);
                }
                rzMin.put(stack, min);
                rzMax.put(stack, max);
                rzChance.put(stack, chance);
                ItemStack cleanedStack = stack.clone();
                ItemMeta meta = cleanedStack.getItemMeta();
                meta.setLore(newLore);
                cleanedStack.setItemMeta(meta);
                cleanStack.put(stack, cleanedStack);
            }
            return;
        }
        for (String strStack : MinetorioTables.table.tables.get((Object)cat)) {
            int min = 1;
            int max = 1;
            int chance = 0;
            int crushCount = 1;
            boolean def = false;
            ArrayList<Material> types = new ArrayList<Material>();
            ItemStack stack = TUItems.createStackFromString(strStack);
            if (stack.getAmount() > 0) {
                min = stack.getAmount();
                max = stack.getAmount();
            }
            if (TUItems.hasLoreLineNoColor(stack, "Min:")) {
                min = Integer.valueOf(ChatColor.stripColor((String)TUItems.getLoreLineNoColor(stack, "Min:").split(": ")[1]));
                TUItems.removeLoreNoColor(stack, "Min:");
            }
            if (TUItems.hasLoreLineNoColor(stack, "Max:")) {
                max = Integer.valueOf(ChatColor.stripColor((String)TUItems.getLoreLineNoColor(stack, "Max:").split(": ")[1]));
                TUItems.removeLoreNoColor(stack, "Max:");
            }
            if (TUItems.hasLoreLineNoColor(stack, "Chance:")) {
                chance = Integer.valueOf(ChatColor.stripColor((String)TUItems.getLoreLineNoColor(stack, "Chance:").split(": ")[1]));
                TUItems.removeLoreNoColor(stack, "Chance:");
            }
            if (TUItems.hasLoreLineNoColor(stack, "Amount Needed:")) {
                crushCount = Integer.valueOf(ChatColor.stripColor((String)TUItems.getLoreLineNoColor(stack, "Amount Needed:").split(": ")[1]));
                TUItems.removeLoreNoColor(stack, "Amount Needed:");
            }
            if (TUItems.hasLoreLineNoColor(stack, "Default:")) {
                def = Boolean.valueOf(ChatColor.stripColor((String)TUItems.getLoreLineNoColor(stack, "Default:").split(": ")[1]));
                TUItems.removeLoreNoColor(stack, "Default:");
            }
            while (TUItems.hasLoreLineNoColor(stack, "Material:")) {
                types.add(Material.valueOf((String)ChatColor.stripColor((String)TUItems.getLoreLineNoColor(stack, "Material:").split(": ")[1])));
                TUItems.removeLoreNoColor(stack, "Material:");
            }
            if (types.size() <= 0) continue;
            for (Material type : types) {
                if (cat.equals((Object)TablesMenu.Category.SIFTER)) {
                    if (!siftChoices.containsKey(type)) {
                        siftChoices.put(type, new ArrayList());
                    }
                    siftChoices.get(type).add(stack);
                    siftChance.put(stack, chance);
                    siftMin.put(stack, min);
                    siftMax.put(stack, max);
                    defaultMaterial.put(stack, def);
                }
                if (!cat.equals((Object)TablesMenu.Category.CRUSHER)) continue;
                crushChoices.put(type, stack);
                crushCounts.put(type, crushCount);
            }
        }
    }

    public static boolean isSiftable(ItemStack stack) {
        return siftChoices.containsKey(stack.getType());
    }

    public static ItemStack siftStack(ItemStack stack) {
        if (MinetorioTables.isSiftable(stack)) {
            HashMap<ItemStack, Integer> rolled = new HashMap<ItemStack, Integer>();
            ItemStack def = null;
            for (ItemStack choice : siftChoices.get(stack.getType())) {
                if (TUMaths.rollRange(1, 100) <= siftChance.get(choice)) {
                    rolled.put(choice, siftChance.get(choice));
                    continue;
                }
                if (!defaultMaterial.get(choice).booleanValue()) continue;
                def = choice;
            }
            ItemStack sifted = null;
            if (rolled.size() == 0 && def != null) {
                sifted = def;
            }
            if (rolled.size() > 0) {
                for (ItemStack choice : new ArrayList(rolled.keySet())) {
                    if (sifted == null) {
                        sifted = choice;
                        continue;
                    }
                    if ((Integer)rolled.get(sifted) <= (Integer)rolled.get(choice)) continue;
                    sifted = choice;
                }
            }
            if (sifted != null) {
                sifted = sifted.clone();
                sifted.setAmount(TUMaths.rollRange(siftMin.get(sifted), siftMax.get(sifted)));
                if (sifted.getType().equals((Object)Material.BARRIER)) {
                    sifted.setType(Material.AIR);
                }
                return sifted;
            }
        }
        return null;
    }

    public static int crushCount(ItemStack stack) {
        if (MinetorioTables.isCrushable(stack)) {
            return crushCounts.get(stack.getType());
        }
        return 1;
    }

    public static boolean isCrushable(ItemStack stack) {
        return crushChoices.containsKey(stack.getType());
    }

    public static ItemStack crushStack(ItemStack stack) {
        if (MinetorioTables.isCrushable(stack) && crushCounts.get(stack.getType()) <= stack.getAmount()) {
            return crushChoices.get(stack.getType());
        }
        return null;
    }
}

