/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx;

import com.MT.triggersUtility.SkullCreator;
import com.MT.triggersUtility.TUInterface.TUIComponent;
import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Belt;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Lift;
import com.MT.xxxtrigger50xxx.Devices.Mover;
import com.MT.xxxtrigger50xxx.Devices.MoverIOCenter;
import com.MT.xxxtrigger50xxx.Devices.PowerPylon;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.LocaleUtil;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public class MineUtil {
    private static int activationRange = 64;
    private static Enchantment cacheEnch = null;
    private static ItemStack northStack = null;
    private static ItemStack eastStack = null;
    private static ItemStack southStack = null;
    private static ItemStack westStack = null;
    private static ItemStack leftStack = null;
    private static ItemStack rightStack = null;
    private static ItemStack checkMark = null;
    private static final String FILE_PATH = "plugins/Minetorio/SavedStacks.yml";
    private static HashSet<Material> toolMats = new HashSet();
    public static FixedMetadataValue fixed = new FixedMetadataValue(MineMain.getPlugin(), (Object)"MT-DISPOSE");

    public static void sendRedWarning(Player player, String message) {
        player.playSound((Entity)player, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
        player.sendMessage(String.valueOf(ChatColor.RED) + message);
    }

    public static void sendWarning(Player player, String message) {
        player.playSound((Entity)player, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + message);
    }

    public static void sendWarning(CommandSender sender, String message) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            player.playSound((Entity)player, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
        }
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + message);
    }

    public static void sendMessage(Player player, String message) {
        if (player != null && player.isOnline()) {
            player.playSound((Entity)player, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + message);
        }
    }

    public static void sendMessage(CommandSender sender, String message) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            player.playSound((Entity)player, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
        }
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + message);
    }

    public static boolean isActive(Location loc) {
        return TUMaths.isPlayerNearby(loc, activationRange);
    }

    public static void damageItemStack(ItemStack stack, Location location, Inventory inv) {
        MineUtil.damageItemStack(stack, location, inv, 1.0);
    }

    public static Enchantment getUnbreakingEnchantment() {
        if (cacheEnch == null) {
            for (Enchantment ench : Registry.ENCHANTMENT) {
                if (!ench.getName().contains("DURABILITY") && !ench.getName().contains("UNBREAKING")) continue;
                cacheEnch = ench;
                break;
            }
        }
        return cacheEnch;
    }

    public static void damageItemStack(ItemStack stack, Location location, Inventory inv, double damage) {
        boolean takeDamage = true;
        if (damage < 1.0) {
            takeDamage = (double)TUMaths.rollRange(0, 99) <= 100.0 * damage;
        }
        if (takeDamage && stack.containsEnchantment(MineUtil.getUnbreakingEnchantment())) {
            int chance = stack.getEnchantmentLevel(MineUtil.getUnbreakingEnchantment()) + 1;
            chance = 100 / chance;
            if (TUMaths.rollRange(0, 99) > chance) {
                takeDamage = false;
            }
        }
        if (takeDamage) {
            Damageable damageable = (Damageable)stack.getItemMeta();
            damageable.setDamage((int)((double)damageable.getDamage() + damage));
            if (damageable.getDamage() >= stack.getType().getMaxDurability()) {
                location.getWorld().playSound(location, Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
                inv.remove(stack);
            } else {
                stack.setItemMeta((ItemMeta)damageable);
            }
        }
    }

    public static void spawnParticleLine(Location startLocation, Location endLocation, Particle particle, int particleCount, double particleSpacing) {
        MineUtil.spawnParticleLine(startLocation, endLocation, particle, particleCount, particleSpacing, null);
    }

    public static void spawnParticleLine(Location startLocation, Location endLocation, Particle particle, int particleCount, double particleSpacing, Player player) {
        World world = startLocation.getWorld();
        Vector direction = endLocation.toVector().subtract(startLocation.toVector()).normalize();
        double i = 0.0;
        while (i < startLocation.distance(endLocation)) {
            Vector offset = direction.clone().multiply(i);
            Location particleLocation = startLocation.clone().add(offset);
            if (particle.equals((Object)MineMain.version.getDustParticle())) {
                Particle.DustOptions dust = new Particle.DustOptions(Color.RED, 1.0f);
                if (player != null) {
                    player.spawnParticle(particle, particleLocation, particleCount, (Object)dust);
                } else {
                    world.spawnParticle(particle, particleLocation, particleCount, (Object)dust);
                }
            } else if (player != null) {
                player.spawnParticle(particle, particleLocation, particleCount);
            } else {
                world.spawnParticle(particle, particleLocation, particleCount);
            }
            if (particleLocation.distance(endLocation) <= particleSpacing) break;
            i += particleSpacing;
        }
    }

    public static void spawnParticleLine(Location startLocation, Location endLocation, final Particle particle, final int particleCount, double particleSpacing, final Player player, final Particle.DustOptions dust) {
        final World world = startLocation.getWorld();
        Vector direction = endLocation.toVector().subtract(startLocation.toVector()).normalize();
        long delay = 0L;
        double i = 0.0;
        while (i < startLocation.distance(endLocation)) {
            if (i != 0.0) {
                delay = (long)((double)delay + i / 2.0);
            }
            Vector offset = direction.clone().multiply(i);
            final Location particleLocation = startLocation.clone().add(offset);
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    if (particle.equals((Object)MineMain.version.getDustParticle())) {
                        if (player != null) {
                            player.spawnParticle(particle, particleLocation, particleCount, (Object)dust);
                        } else {
                            world.spawnParticle(particle, particleLocation, particleCount, (Object)dust);
                        }
                    } else if (player != null) {
                        player.spawnParticle(particle, particleLocation, particleCount);
                    } else {
                        world.spawnParticle(particle, particleLocation, particleCount);
                    }
                }
            }, delay);
            if (particleLocation.distance(endLocation) <= particleSpacing) break;
            i += particleSpacing;
        }
    }

    public static List<Location> generateLocationsInArea(Location corner1, Location corner2) {
        ArrayList<Location> locations = new ArrayList<Location>();
        int minX = Math.min(corner1.getBlockX(), corner2.getBlockX());
        int minY = Math.min(corner1.getBlockY(), corner2.getBlockY());
        int minZ = Math.min(corner1.getBlockZ(), corner2.getBlockZ());
        int maxX = Math.max(corner1.getBlockX(), corner2.getBlockX());
        int maxY = Math.max(corner1.getBlockY(), corner2.getBlockY());
        int maxZ = Math.max(corner1.getBlockZ(), corner2.getBlockZ());
        int x = minX;
        while (x <= maxX) {
            int y = minY;
            while (y <= maxY) {
                int z = minZ;
                while (z <= maxZ) {
                    locations.add(new Location(corner1.getWorld(), (double)x + 0.5, (double)y + 0.5, (double)z + 0.5));
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return locations;
    }

    public static String colon(String pre, String post) {
        return String.valueOf(ChatColor.GOLD) + pre + ": " + String.valueOf(ChatColor.WHITE) + post;
    }

    public static ArrayList<Location> getLocationLine(Location startLocation, Location endLocation, double spacing) {
        ArrayList<Location> locs = new ArrayList<Location>();
        Vector direction = endLocation.toVector().subtract(startLocation.toVector()).normalize();
        double i = 0.0;
        while (i < startLocation.distance(endLocation)) {
            Vector offset = direction.clone().multiply(i);
            Location lineLocation = startLocation.clone().add(offset);
            locs.add(lineLocation);
            if (lineLocation.distance(endLocation) <= spacing) break;
            i += spacing;
        }
        return locs;
    }

    public static ArrayList<Location> getBlockLine(Location startLocation, Location endLocation, double spacing) {
        ArrayList<Location> locs = new ArrayList<Location>();
        Vector direction = endLocation.toVector().subtract(startLocation.toVector()).normalize();
        double i = 0.0;
        while (i < startLocation.distance(endLocation)) {
            Vector offset = direction.clone().multiply(i);
            Location lineLocation = startLocation.clone().add(offset);
            if (!locs.contains(lineLocation.getBlock().getLocation())) {
                locs.add(lineLocation.getBlock().getLocation());
            }
            if (lineLocation.distance(endLocation) <= spacing) break;
            i += spacing;
        }
        return locs;
    }

    public static void spawnChunkOutline(Location playerLocation, Particle particle) {
        World world = playerLocation.getWorld();
        int chunkX = playerLocation.getBlockX() >> 4;
        int chunkZ = playerLocation.getBlockZ() >> 4;
        int yLevel = playerLocation.getBlockY();
        int x = 0;
        while (x <= 15) {
            MineUtil.spawnParticle(world, chunkX * 16 + x, yLevel, chunkZ * 16, particle);
            MineUtil.spawnParticle(world, chunkX * 16 + x, yLevel, chunkZ * 16 + 15, particle);
            ++x;
        }
        int z = 0;
        while (z <= 15) {
            MineUtil.spawnParticle(world, chunkX * 16, yLevel, chunkZ * 16 + z, particle);
            MineUtil.spawnParticle(world, chunkX * 16 + 15, yLevel, chunkZ * 16 + z, particle);
            ++z;
        }
    }

    private static void spawnParticle(World world, int x, int y, int z, Particle particle) {
        Location particleLocation = new Location(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        world.spawnParticle(particle, particleLocation, 1, 0.0, 0.0, 0.0, 1.0E-9);
    }

    public static int burnSeconds(Material material) {
        if (material.equals((Object)Material.AIR)) {
            return 0;
        }
        if (material.equals((Object)Material.STICK)) {
            return 5;
        }
        if (material.equals((Object)Material.COAL)) {
            return 80;
        }
        if (material.equals((Object)Material.CHARCOAL)) {
            return 80;
        }
        if (material.equals((Object)Material.COAL_BLOCK)) {
            return 800;
        }
        if (material.equals((Object)Material.DRIED_KELP_BLOCK)) {
            return 200;
        }
        if (material.equals((Object)Material.BAMBOO_BLOCK)) {
            return 15;
        }
        if (material.equals((Object)Material.BAMBOO)) {
            return 2;
        }
        if (material.equals((Object)Material.LAVA_BUCKET)) {
            return 800;
        }
        return 15;
    }

    /*
     * WARNING - void declaration
     */
    public static ArrayList<String> wrapText(String text, int maxWidth, ChatColor lineColor, int spaces) {
        ArrayList<String> wrappedLines = MineUtil.wrapText(text, maxWidth);
        ArrayList<String> lastLines = new ArrayList<String>();
        for (String string : wrappedLines) {
            void var6_7;
            if (spaces > 0) {
                int i = spaces;
                while (i > 0) {
                    String string2 = " " + (String)var6_7;
                    --i;
                }
            }
            lastLines.add(String.valueOf(lineColor) + (String)var6_7);
        }
        return lastLines;
    }

    public static ArrayList<String> wrapText(String text, int maxWidth, ChatColor lineColor) {
        ArrayList<String> wrappedLines = MineUtil.wrapText(text, maxWidth);
        ArrayList<String> lastLines = new ArrayList<String>();
        for (String line : wrappedLines) {
            lastLines.add(String.valueOf(lineColor) + line);
        }
        return lastLines;
    }

    public static ArrayList<String> wrapText(String text, int maxWidth) {
        ArrayList<String> wrappedLines = new ArrayList<String>();
        String[] words = text.split("\\s+");
        StringBuilder currentLine = new StringBuilder();
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            if (currentLine.length() + word.length() > maxWidth) {
                wrappedLines.add(currentLine.toString());
                currentLine = new StringBuilder();
            }
            if (currentLine.length() > 0) {
                currentLine.append(" ");
            }
            currentLine.append(word);
            ++n2;
        }
        if (currentLine.length() > 0) {
            wrappedLines.add(currentLine.toString());
        }
        return wrappedLines;
    }

    public static TUIComponent createInfoComponent(int slot, String desc) {
        return MineUtil.createInfoComponent(slot, desc, false);
    }

    public static TUIComponent createInfoComponent(int slot, String desc, boolean addGlow) {
        ItemStack itemStack = TUItems.createItem(Material.BELL, MineItems.goldBold() + "Info");
        ArrayList<String> lore = new ArrayList<String>();
        for (String str : MineUtil.wrapText(desc, 30)) {
            lore.add(String.valueOf(ChatColor.WHITE) + " " + str);
        }
        TUItems.addLore(itemStack, lore);
        if (addGlow) {
            itemStack = TUMaths.addGlow(itemStack);
        }
        return new TUIComponent(slot, TUItems.setModelData(itemStack, 9502));
    }

    public static ItemStack getCardinalHead(String direction) {
        if (direction.equals("NORTH")) {
            if (northStack == null) {
                northStack = SkullCreator.getHead("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZGEyMjFlNGY5NmJlZTYyNjE3NTIzOTZhMzI2NWZmYTRkZWRmOGZmNDgzOWFiZDE0ZjQ5ZWRlZTFlNTMwOTIifX19");
            }
            return northStack;
        }
        if (direction.equals("EAST")) {
            if (eastStack == null) {
                eastStack = SkullCreator.getHead("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMWFlZWY4OGUyYzkyOGI0NjZjNmVkNWRlYWE0ZTE5NzVhOTQzNmMyYjFiNDk4ZjlmN2NiZjkyYTliNTk5YTYifX19");
            }
            return eastStack;
        }
        if (direction.equals("SOUTH")) {
            if (southStack == null) {
                southStack = SkullCreator.getHead("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZDcxMDEzODQxNjUyODg4OTgxNTU0OGI0NjIzZDI4ZDg2YmJiYWU1NjE5ZDY5Y2Q5ZGJjNWFkNmI0Mzc0NCJ9fX0=");
            }
            return southStack;
        }
        if (direction.equals("WEST")) {
            if (westStack == null) {
                westStack = SkullCreator.getHead("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvODBjOTQ4M2Y1MWQxMjY3NDMyZTBmMmYzYmFhOGNkOTNlNjViNWVhYzc0ODJiMjdkYmNjZWJhZmI3MjE3NDhiIn19fQ==");
            }
            return westStack;
        }
        return new ItemStack(Material.PLAYER_HEAD);
    }

    public static ItemStack getLeftScollingStack() {
        if (leftStack == null) {
            leftStack = SkullCreator.getHead("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvY2RjOWU0ZGNmYTQyMjFhMWZhZGMxYjViMmIxMWQ4YmVlYjU3ODc5YWYxYzQyMzYyMTQyYmFlMWVkZDUifX19");
            if (leftStack == null) {
                leftStack = TUItems.createItem(Material.ARROW, MineItems.goldBold() + LocaleUtil.uiText("General_Scroll_Left"));
            } else {
                ItemMeta im = leftStack.getItemMeta();
                im.setDisplayName(MineItems.goldBold() + LocaleUtil.uiText("General_Scroll_Left"));
                leftStack.setItemMeta(im);
            }
            leftStack = TUItems.setModelData(leftStack, 9503);
        }
        return leftStack;
    }

    public static ItemStack getRightScrollingStack() {
        if (rightStack == null) {
            rightStack = SkullCreator.getHead("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOTU2YTM2MTg0NTllNDNiMjg3YjIyYjdlMjM1ZWM2OTk1OTQ1NDZjNmZjZDZkYzg0YmZjYTRjZjMwYWI5MzExIn19fQ==");
            if (rightStack == null) {
                rightStack = TUItems.createItem(Material.ARROW, MineItems.goldBold() + LocaleUtil.uiText("General_Scroll_Right"));
            } else {
                ItemMeta im = rightStack.getItemMeta();
                im.setDisplayName(MineItems.goldBold() + LocaleUtil.uiText("General_Scroll_Right"));
                rightStack.setItemMeta(im);
            }
            rightStack = TUItems.setModelData(rightStack, 9504);
        }
        return rightStack;
    }

    public static TUIComponent createLeftScroll(int slot) {
        ItemStack itemStack = MineUtil.getLeftScollingStack();
        ItemMeta meta = itemStack.getItemMeta();
        meta.setDisplayName(MineItems.goldBold() + LocaleUtil.uiText("General_Scroll_Left"));
        itemStack.setItemMeta(meta);
        return new TUIComponent(slot, itemStack){

            @Override
            public void onLeftClick(Player player) {
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            }
        };
    }

    public static TUIComponent createRightScroll(int slot) {
        ItemStack itemStack = MineUtil.getRightScrollingStack();
        ItemMeta meta = itemStack.getItemMeta();
        meta.setDisplayName(MineItems.goldBold() + LocaleUtil.uiText("General_Scroll_Right"));
        itemStack.setItemMeta(meta);
        return new TUIComponent(slot, itemStack){

            @Override
            public void onLeftClick(Player player) {
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            }
        };
    }

    public static TUIComponent createReturnArrow() {
        ItemStack itemStack = MainMenu.createReturnArrow();
        return new TUIComponent(49, itemStack){

            @Override
            public void onLeftClick(Player player) {
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                MainMenu.openGuideMenu(player, null);
            }
        };
    }

    public static ItemStack getCheckMarkStack() {
        if (checkMark == null) {
            checkMark = SkullCreator.getHead("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZWUyOGJlYTlkMzkzNzNkMzZlZThmYTQwZWM4M2Y5YzNmY2RkOTMxNzUyMjc3NDNmOWRkMWY3ZTc4ODZiN2VlNSJ9fX0=");
            if (checkMark == null) {
                checkMark = TUItems.createItem(Material.GREEN_CONCRETE, MineItems.goldBold() + " ");
            }
            checkMark = TUItems.setModelData(checkMark, 9558);
        }
        return checkMark;
    }

    public static void movementTest(final LivingEntity entity, final Location targetLocation, final double speed) {
        new BukkitRunnable(){

            public void run() {
                if (entity.isDead() || !entity.isValid()) {
                    this.cancel();
                    return;
                }
                Location currentLocation = entity.getLocation();
                if (currentLocation.distance(targetLocation) < 1.0) {
                    this.cancel();
                    return;
                }
                Vector direction = targetLocation.toVector().subtract(currentLocation.toVector()).normalize();
                Vector scaledDirection = direction.multiply(speed);
                entity.teleport(currentLocation.add(scaledDirection));
            }
        }.runTaskTimer(MineMain.getPlugin(), 0L, 20L);
    }

    public static void saveItemStack(ItemStack item, String key) {
        File file = new File(FILE_PATH);
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        Map serializedItem = item.serialize();
        config.createSection(key, serializedItem);
        try {
            config.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ItemStack loadItemStack(String key) {
        File file = new File(FILE_PATH);
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        Map serializedItem = config.getConfigurationSection(key).getValues(false);
        return ItemStack.deserialize((Map)serializedItem);
    }

    public static void mergeItemStacks(Inventory inventory, List<Integer> targetSlots) {
        int i = 0;
        while (i < targetSlots.size()) {
            int slot = targetSlots.get(i);
            ItemStack currentItem = inventory.getItem(slot);
            if (currentItem != null && currentItem.getAmount() != currentItem.getMaxStackSize()) {
                int j = i + 1;
                while (j < targetSlots.size()) {
                    int otherSlot = targetSlots.get(j);
                    ItemStack otherItem = inventory.getItem(otherSlot);
                    if (otherItem != null && currentItem.isSimilar(otherItem)) {
                        int transferAmount = Math.min(currentItem.getMaxStackSize() - currentItem.getAmount(), otherItem.getAmount());
                        currentItem.setAmount(currentItem.getAmount() + transferAmount);
                        otherItem.setAmount(otherItem.getAmount() - transferAmount);
                        inventory.setItem(slot, currentItem);
                        if (otherItem.getAmount() <= 0) {
                            inventory.setItem(otherSlot, null);
                        } else {
                            inventory.setItem(otherSlot, otherItem);
                        }
                        if (currentItem.getAmount() == currentItem.getMaxStackSize()) break;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public static void mergeItemStacks(Inventory inventory) {
        ArrayList<Integer> targetSlots = new ArrayList<Integer>();
        int i = 0;
        while (i < inventory.getSize()) {
            targetSlots.add(i);
            ++i;
        }
        i = 0;
        while (i < targetSlots.size()) {
            int slot = (Integer)targetSlots.get(i);
            ItemStack currentItem = inventory.getItem(slot);
            if (currentItem != null && currentItem.getAmount() != currentItem.getMaxStackSize()) {
                int j = i + 1;
                while (j < targetSlots.size()) {
                    int otherSlot = (Integer)targetSlots.get(j);
                    ItemStack otherItem = inventory.getItem(otherSlot);
                    if (otherItem != null && currentItem.isSimilar(otherItem)) {
                        int transferAmount = Math.min(currentItem.getMaxStackSize() - currentItem.getAmount(), otherItem.getAmount());
                        currentItem.setAmount(currentItem.getAmount() + transferAmount);
                        otherItem.setAmount(otherItem.getAmount() - transferAmount);
                        inventory.setItem(slot, currentItem);
                        if (otherItem.getAmount() <= 0) {
                            inventory.setItem(otherSlot, null);
                        } else {
                            inventory.setItem(otherSlot, otherItem);
                        }
                        if (currentItem.getAmount() == currentItem.getMaxStackSize()) break;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public static boolean isTool(Material material) {
        if (toolMats.size() == 0) {
            Material[] materialArray = Material.values();
            int n = materialArray.length;
            int n2 = 0;
            while (n2 < n) {
                Material mat = materialArray[n2];
                if (mat.getMaxDurability() > 0) {
                    toolMats.add(mat);
                }
                ++n2;
            }
        }
        return toolMats.contains(material);
    }

    public static int getMoverMaxStackSize(Material matType, MoverIOCenter.DeviceIOType type) {
        int stackSize = matType.getMaxStackSize();
        if (type.equals((Object)MoverIOCenter.DeviceIOType.ROCKET_SILO)) {
            stackSize = 100;
            return stackSize;
        }
        if (!MoverIOCenter.isContainer(type)) {
            if (type.equals((Object)MoverIOCenter.DeviceIOType.TRAIN_STATION)) {
                stackSize *= 4;
            } else {
                stackSize = (int)Math.floor(stackSize / 8);
                ++stackSize;
            }
            if (stackSize <= 3) {
                stackSize = 3;
                if (matType.toString().contains("POTION")) {
                    stackSize = 4;
                }
                if (matType.equals((Object)Material.LAVA_BUCKET)) {
                    stackSize = 1;
                }
            }
        }
        return stackSize;
    }

    public static String formatMaterialName(Material material) {
        String[] words = material.toString().toLowerCase().split("_");
        StringBuilder formattedName = new StringBuilder();
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            if (!word.isEmpty()) {
                formattedName.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
            }
            ++n2;
        }
        return formattedName.toString().trim();
    }

    public static boolean isPylonDevice(ItemStack stack) {
        boolean isPylon = false;
        if (Device.isDeviceStack(stack, "Power Pylon")) {
            return true;
        }
        if (Device.isDeviceStack(stack, "Power Pylon Mk2")) {
            return true;
        }
        return isPylon;
    }

    public static boolean isPylonDevice(Device device) {
        return device instanceof PowerPylon || device.builtInPylon;
    }

    public static String getPermissionMask(String string) {
        return MineMain.builtPermissionMask.getOrDefault(string, string);
    }

    public static void setDisposableEntity(Entity entity) {
        entity.setPersistent(false);
        entity.setSilent(true);
    }

    public static void spawnArcedParticleLine(World world, Location start, Location end, Particle particle, int points, double arcHeight, Player player) {
        start = start.clone().add(0.0, 1.0, 0.0);
        end = end.clone().add(0.0, 1.0, 0.0);
        Vector diff = end.clone().subtract(start).toVector();
        int i = 0;
        while (i <= points) {
            double t = (double)i / (double)points;
            double x = start.getX() + diff.getX() * t;
            double y = start.getY() + diff.getY() * t;
            double z = start.getZ() + diff.getZ() * t;
            double arc = Math.sin(Math.PI * t) * arcHeight;
            y += arc;
            if (player == null) {
                world.spawnParticle(particle, new Location(world, x, y, z), 1, 0.0, 0.0, 0.0, 0.0, null, true);
            } else {
                player.spawnParticle(particle, new Location(world, x, y, z), 1, 0.0, 0.0, 0.0, 0.0, null, true);
            }
            ++i;
        }
    }

    public static void spawnArcedParticleLine(World world, Location start, Location end, Color color, int points, double arcHeight, float dustSize, Player player) {
        start = start.clone().add(0.0, 1.0, 0.0);
        end = end.clone().add(0.0, 1.0, 0.0);
        Vector diff = end.clone().subtract(start).toVector();
        int i = 0;
        while (i <= points) {
            double t = (double)i / (double)points;
            double x = start.getX() + diff.getX() * t;
            double y = start.getY() + diff.getY() * t;
            double z = start.getZ() + diff.getZ() * t;
            double arc = Math.sin(Math.PI * t) * arcHeight;
            y += arc;
            Particle.DustOptions dust = new Particle.DustOptions(color, 1.0f);
            if (player == null) {
                world.spawnParticle(Particle.DUST, new Location(world, x, y, z), 1, 0.0, 0.0, 0.0, 0.0, (Object)dust, true);
            } else {
                player.spawnParticle(Particle.DUST, new Location(world, x, y, z), 1, 0.0, 0.0, 0.0, 0.0, (Object)dust, true);
            }
            ++i;
        }
    }

    public static boolean isWithinCubeRange(Location a, Location b, double range) {
        if (!a.getWorld().equals(b.getWorld())) {
            return false;
        }
        double dx = Math.abs(a.getX() - b.getX());
        double dy = Math.abs(a.getY() - b.getY());
        double dz = Math.abs(a.getZ() - b.getZ());
        return dx <= range && dy <= range && dz <= range;
    }

    public static Collection<Entity> getEntitiesInCubeRange(Location source, double range) {
        double x = (double)source.getBlockX() + 0.5;
        double y = (double)source.getBlockY() + 0.5;
        double z = (double)source.getBlockZ() + 0.5;
        BoundingBox box = new BoundingBox(x - range, y - range, z - range, x + range, y + range, z + range);
        return source.getWorld().getNearbyEntities(box);
    }

    public static List<Device> sortDevicesByDistance(Location target, List<Device> devices) {
        ArrayList<Device> sorted = new ArrayList<Device>(devices);
        sorted.sort(Comparator.comparingDouble(d -> d.getLocation().distanceSquared(target)));
        return sorted;
    }

    public static boolean hasInventoryTaggedItem(Inventory inv, String checkType) {
        for (ItemStack stack : inv) {
            if (stack == null) continue;
            if (checkType.equals("WALL") && stack.getAmount() > 0 && Tag.WALLS.isTagged((Keyed)stack.getType())) {
                return true;
            }
            if (!checkType.equals("FENCE") || stack.getAmount() <= 0 || !Tag.FENCES.isTagged((Keyed)stack.getType())) continue;
            return true;
        }
        return false;
    }

    public static Material removeInventoryTaggedItem(Inventory inv, String checkType) {
        for (ItemStack stack : inv) {
            if (stack == null) continue;
            if (checkType.equals("WALL") && Tag.WALLS.isTagged((Keyed)stack.getType())) {
                Material type = stack.getType();
                stack.setAmount(stack.getAmount() - 1);
                return type;
            }
            if (!checkType.equals("FENCE") || !Tag.FENCES.isTagged((Keyed)stack.getType())) continue;
            Material type = stack.getType();
            stack.setAmount(stack.getAmount() - 1);
            return type;
        }
        return null;
    }

    public static boolean isPaperServer() {
        try {
            Class.forName("com.destroystokyo.paper.PaperConfig");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isSpigotServer() {
        return !MineUtil.isPaperServer();
    }

    public static boolean isMinetorioLocation(Location loc) {
        if (Device.isDevice(loc)) {
            return true;
        }
        if (Mover.isMover(loc)) {
            return true;
        }
        if (Belt.isBelt(loc)) {
            return true;
        }
        return Lift.getLift(loc) != null;
    }
}

