/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Planets;

import com.MT.triggersUtility.Events.ServerTimeUpdate;
import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Spaceship.Atlas;
import com.MT.xxxtrigger50xxx.Devices.Spaceship.AtmosphericController;
import com.MT.xxxtrigger50xxx.Devices.Spaceship.PhaseRelay;
import com.MT.xxxtrigger50xxx.Devices.Spaceship.ShipCore;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.Planets.AsteroidField;
import com.MT.xxxtrigger50xxx.Planets.BatField;
import com.MT.xxxtrigger50xxx.Planets.LightningManager;
import com.MT.xxxtrigger50xxx.Planets.MeteorManager;
import com.MT.xxxtrigger50xxx.Planets.Planet;
import com.MT.xxxtrigger50xxx.Planets.SpaceObjects.ResourceAsteroid;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.entity.EntityAirChangeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class PlanetHandler
implements Listener {
    public static HashMap<String, Planet> allPlanets = new HashMap();
    private HashSet<UUID> thermoCooldown = new HashSet();
    private static HashMap<Planet, Double> msTime = new HashMap();
    private static HashSet<UUID> haveAIR = new HashSet();
    private static HashSet<UUID> airSoundCooldown = new HashSet();
    private static HashSet<UUID> coldWarning = new HashSet();
    private static HashSet<UUID> hotWarning = new HashSet();
    private static HashSet<Player> freezeFreezingTicks = new HashSet();
    private static HashSet<UUID> heatBonus = new HashSet();

    public static Planet getPlanetByWorld(String worldName) {
        return allPlanets.get(worldName);
    }

    public static void loadPlanets() {
        File planetsFile = new File(MineMain.getPlugin().getDataFolder(), "planets.yml");
        YamlConfiguration planetsConfig = YamlConfiguration.loadConfiguration((File)planetsFile);
        ConfigurationSection planetSection = planetsConfig.getConfigurationSection("planets");
        if (planetSection != null) {
            for (String planetName : planetSection.getKeys(false)) {
                Planet planet = new Planet(planetName, planetsConfig.getString("planets." + planetName + ".Minecraft World"));
                planet.setStormLevel(planetsConfig.getDouble("planets." + planetName + ".Storm Level"));
                planet.setGravityLevel(planetsConfig.getDouble("planets." + planetName + ".Gravity Level"));
                planet.setTidalLevels(planetsConfig.getDouble("planets." + planetName + ".Tidal Level"));
                planet.setWindLevels(planetsConfig.getDouble("planets." + planetName + ".Wind Level"));
                planet.setMoonDistance(planetsConfig.getDouble("planets." + planetName + ".Moon Mod"));
                planet.setSunDistance(planetsConfig.getDouble("planets." + planetName + ".Sun Mod"));
                planet.setMeteorIntensity(planetsConfig.getDouble("planets." + planetName + ".Meteor Intensity"));
                planet.setCropGrowth(planetsConfig.getDouble("planets." + planetName + ".Crop Growth"));
                planet.setTempature(planetsConfig.getDouble("planets." + planetName + ".Temperature"));
                planet.setDayTimeSpeed(planetsConfig.getDouble("planets." + planetName + ".Day Time Speed"));
                planet.setLightningIntensity(planetsConfig.getDouble("planets." + planetName + ".Lightning Intensity"));
                planet.setAtlasMaterial(planetsConfig.getString("planets." + planetName + ".Atlas Material"));
                planet.setAtlastHeadCode(planetsConfig.getString("planets." + planetName + ".Atlas Head Code"));
                planet.setStartPlanetDistance(planetsConfig.getDouble("planets." + planetName + ".Start World Distance"));
                planet.setSolarAngle(planetsConfig.getDouble("planets." + planetName + ".Solar Angle"));
                planet.setSolarHeight(planetsConfig.getDouble("planets." + planetName + ".Solar Height"));
                planet.setSolarRotation(planetsConfig.getDouble("planets." + planetName + ".Solar Rotation"));
                planet.setSolarScale(planetsConfig.getDouble("planets." + planetName + ".Solar Scale"));
                for (String gasComposition : planetsConfig.getStringList("planets." + planetName + ".Atmosphere")) {
                    planet.setGasLevel(Planet.Gas.valueOf(gasComposition.split(":")[0]), Double.valueOf(gasComposition.split(":")[1]));
                }
                allPlanets.put(planetsConfig.getString("planets." + planetName + ".Minecraft World"), planet);
            }
        }
        new BukkitRunnable(){
            ArrayList<Player> removed = new ArrayList();

            public void run() {
                PlanetHandler.tickTime();
                for (Player player : freezeFreezingTicks) {
                    if (player.isOnline()) {
                        player.setFreezeTicks(player.getFreezeTicks() + 2);
                        continue;
                    }
                    this.removed.add(player);
                }
                if (this.removed.size() > 0) {
                    freezeFreezingTicks.removeAll(this.removed);
                    this.removed.clear();
                }
            }
        }.runTaskTimer(MineMain.getPlugin(), 1L, 1L);
    }

    public static void loadSpaceStuff() {
        File planetsFile = new File(MineMain.getPlugin().getDataFolder(), "space.yml");
        YamlConfiguration planetsConfig = YamlConfiguration.loadConfiguration((File)planetsFile);
        ConfigurationSection configSection = planetsConfig.getConfigurationSection("Asteroid Fields");
        if (configSection != null) {
            for (String asteroidFieldName : configSection.getKeys(false)) {
                double chance;
                Material compType;
                AsteroidField af = new AsteroidField(asteroidFieldName);
                af.setDensity(planetsConfig.getDouble("Asteroid Fields." + asteroidFieldName + ".Density"));
                af.setStartDistance(planetsConfig.getDouble("Asteroid Fields." + asteroidFieldName + ".Start Distance"));
                af.setStopDistance(planetsConfig.getDouble("Asteroid Fields." + asteroidFieldName + ".Stop Distance"));
                af.setScaler(planetsConfig.getDouble("Asteroid Fields." + asteroidFieldName + ".Amount Scaler"));
                for (String composition : planetsConfig.getStringList("Asteroid Fields." + asteroidFieldName + ".Composition")) {
                    compType = Material.matchMaterial((String)composition.split(":")[0]);
                    chance = Double.valueOf(composition.split(":")[1]);
                    af.addOreType(compType, chance);
                }
                for (String composition : planetsConfig.getStringList("Asteroid Fields." + asteroidFieldName + ".Sizes")) {
                    ResourceAsteroid.Size size = ResourceAsteroid.Size.valueOf(composition.split(":")[0]);
                    chance = Double.valueOf(composition.split(":")[1]);
                    af.addSizeType(size, chance);
                }
                for (String composition : planetsConfig.getStringList("Asteroid Fields." + asteroidFieldName + ".Asteroid Materials")) {
                    compType = Material.matchMaterial((String)composition.split(":")[0]);
                    chance = Double.valueOf(composition.split(":")[1]);
                    af.addMainType(compType, chance);
                }
            }
        }
        if ((configSection = planetsConfig.getConfigurationSection("Space Bats")) != null) {
            for (String fieldName : configSection.getKeys(false)) {
                BatField bf = new BatField(fieldName);
                bf.setStopDistance(planetsConfig.getDouble("Space Bats." + fieldName + ".Stop Distance"));
                bf.setStartDistance(planetsConfig.getDouble("Space Bats." + fieldName + ".Start Distance"));
                bf.setAmountScaler(planetsConfig.getDouble("Space Bats." + fieldName + ".Amount Scaler"));
                bf.setStrength(planetsConfig.getDouble("Space Bats." + fieldName + ".Strength"));
                bf.setVariance(planetsConfig.getDouble("Space Bats." + fieldName + ".Strength Variance"));
                bf.setChance(planetsConfig.getInt("Space Bats." + fieldName + ".Chance"));
            }
        }
    }

    @EventHandler
    public void onEntityInteract(PlayerInteractAtEntityEvent event) {
        if (!MineMain.useSpaceContent) {
            return;
        }
        if (event.getRightClicked().getType().equals((Object)EntityType.ARMOR_STAND) && event.getRightClicked().hasMetadata("MT-ATLAS")) {
            Atlas atlas = (Atlas)((MetadataValue)event.getRightClicked().getMetadata("MT-ATLAS").get(0)).value();
            if (event.getRightClicked().hasMetadata("MT-ATLAS-LEFT")) {
                atlas.shiftLeft();
            }
            if (event.getRightClicked().hasMetadata("MT-ATLAS-RIGHT")) {
                atlas.shiftRight();
            }
            if (event.getRightClicked().hasMetadata("MT-ATLAS-CONFIRM")) {
                atlas.confirmTarget();
            }
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInteract(final PlayerInteractEvent event) {
        Device device;
        if (event.getItem() != null && MineItems.isIndustrialItem(event.getItem(), "Thermometer")) {
            event.setCancelled(true);
        }
        if (!event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) || this.thermoCooldown.contains(event.getPlayer().getUniqueId())) {
            return;
        }
        if (event.getItem() != null && MineItems.isIndustrialItem(event.getItem(), "Thermometer")) {
            Planet planet = PlanetHandler.getPlanetByWorld(event.getPlayer().getWorld().getName());
            double effectiveTemp = 1.0;
            if (planet != null) {
                effectiveTemp = PlanetHandler.getLocalTemperature(event.getPlayer().getWorld(), planet, event.getPlayer());
            }
            this.thermoCooldown.add(event.getPlayer().getUniqueId());
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    PlanetHandler.this.thermoCooldown.remove(event.getPlayer().getUniqueId());
                }
            }, 20L);
            String desc = String.valueOf(ChatColor.GREEN) + "Temperate";
            if (effectiveTemp < 0.75) {
                desc = String.valueOf(ChatColor.YELLOW) + "Cold";
            }
            if (effectiveTemp < 0.5) {
                desc = String.valueOf(ChatColor.RED) + "Very Cold";
            }
            if (effectiveTemp > 1.25) {
                desc = String.valueOf(ChatColor.YELLOW) + "Hot";
            }
            if (effectiveTemp > 1.5) {
                desc = String.valueOf(ChatColor.RED) + "Very Hot";
            }
            effectiveTemp = TUMaths.roundDouble(effectiveTemp, 3);
            MineUtil.sendMessage(event.getPlayer(), String.valueOf(ChatColor.WHITE) + "The tempature here is " + desc + String.valueOf(ChatColor.GRAY) + " (" + effectiveTemp + ")");
        }
        if (!MineMain.useSpaceContent) {
            return;
        }
        if (event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) && event.getClickedBlock().getType().equals((Object)Material.CARTOGRAPHY_TABLE) && event.getClickedBlock().getWorld().getName().equals("MT_world_space") && Device.isDevice(event.getClickedBlock().getLocation()) && (device = Device.getDevice(event.getClickedBlock())) instanceof Atlas) {
            Atlas at = (Atlas)device;
            if (event.getClickedPosition().getY() > 0.7 && event.getClickedPosition().getZ() >= 0.99) {
                if (event.getClickedPosition().getX() <= 0.27 && event.getClickedPosition().getX() >= 0.13) {
                    event.getPlayer().closeInventory();
                    at.shiftLeft();
                }
                if (event.getClickedPosition().getX() >= 0.73 && event.getClickedPosition().getX() <= 0.87) {
                    event.getPlayer().closeInventory();
                    at.shiftRight();
                }
                if (event.getClickedPosition().getX() >= 0.42 && event.getClickedPosition().getX() <= 0.58) {
                    event.getPlayer().closeInventory();
                    at.confirmTarget();
                }
            }
        }
    }

    @EventHandler
    public void onWeather(WeatherChangeEvent event) {
        Planet planet;
        if (!MineMain.useSpaceContent) {
            return;
        }
        if (event.toWeatherState() && (planet = PlanetHandler.getPlanetByWorld(event.getWorld().getName())) != null && planet.getStormLevel() == 0.0) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onCropGrow(BlockGrowEvent event) {
        if (!MineMain.useSpaceContent) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        World world = event.getBlock().getWorld();
        Planet planet = PlanetHandler.getPlanetByWorld(world.getName());
        if (planet == null) {
            return;
        }
        double growthRate = planet.getCropGrowth();
        if (growthRate == 1.0) {
            return;
        }
        if (growthRate < 1.0) {
            if (Math.random() > growthRate) {
                event.setCancelled(true);
            }
        } else {
            int extraGrowths = (int)Math.floor(growthRate - 1.0);
            int i = 0;
            while (i < extraGrowths) {
                Bukkit.getScheduler().runTaskLater(MineMain.getPlugin(), () -> this.applyGrowth(event.getBlock()), (long)(i + 1) * 20L);
                ++i;
            }
        }
    }

    private void applyGrowth(Block block) {
        if (!(block.getBlockData() instanceof Ageable)) {
            return;
        }
        Ageable ageable = (Ageable)block.getBlockData();
        if (ageable.getAge() < ageable.getMaximumAge()) {
            ageable.setAge(ageable.getAge() + 1);
            block.setBlockData((BlockData)ageable);
        }
    }

    public static Location clampToWorldBorder(Location loc) {
        WorldBorder border = loc.getWorld().getWorldBorder();
        Location center = border.getCenter();
        double radius = border.getSize() / 2.0;
        double minX = center.getX() - radius;
        double maxX = center.getX() + radius;
        double minZ = center.getZ() - radius;
        double maxZ = center.getZ() + radius;
        double clampedX = Math.max(minX, Math.min(loc.getX(), maxX));
        double clampedZ = Math.max(minZ, Math.min(loc.getZ(), maxZ));
        return new Location(loc.getWorld(), clampedX, loc.getY(), clampedZ, loc.getYaw(), loc.getPitch());
    }

    public static void teleportToPlanet(Player player, double bonusHeight) {
        if (player.getLocation().getY() <= 0.0 && player.getWorld().getName().equals("MT_world_space")) {
            ArrayList<ShipCore> nearby = ShipCore.getCores(player.getUniqueId(), player.getLocation());
            for (ShipCore core : nearby) {
                if (TUMaths.get2DManhattanDistance(core.getLocationREADONLY(), player.getLocation()) > 100 || core.closestPlanet() == null || !core.inOrbit()) continue;
                Location loc = core.getVirtualLocation().clone();
                loc.setWorld(core.closestWorld());
                player.teleport(PlanetHandler.clampToWorldBorder(loc.getWorld().getHighestBlockAt(loc).getLocation().add(0.0, bonusHeight, 0.0)));
            }
        }
    }

    @EventHandler
    public void onInteract3(PlayerInteractEvent event) {
        PhaseRelay relay;
        if ((event.getAction().equals((Object)Action.RIGHT_CLICK_AIR) || event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) && event.getItem() != null && (relay = MineItems.getPhaseRelay(event.getItem())) != null) {
            if (relay.charge >= 100) {
                relay.charge = 0;
                event.getPlayer().teleport(relay.getLocation().add(0.5, 1.0, 0.5));
                event.getPlayer().playSound((Entity)event.getPlayer(), Sound.ITEM_CHORUS_FRUIT_TELEPORT, 1.0f, 0.5f);
            } else {
                MineUtil.sendWarning(event.getPlayer(), "The relay is still charging. (" + relay.charge + "%)");
            }
        }
    }

    @EventHandler
    public void onSecond(ServerTimeUpdate event) {
        if (!MineMain.useSpaceContent) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            PlanetHandler.teleportToPlanet(player, 200.0);
        }
        haveAIR.clear();
        for (Player player : Bukkit.getOnlinePlayers()) {
            Planet planet = PlanetHandler.getPlanetByWorld(player.getWorld().getName());
            this.applyTemperature(planet, player);
            this.applyGravity(planet, player);
            this.applyOxygen(planet, player);
            this.applyHydrogen(planet, player);
        }
        for (Planet planet : allPlanets.values()) {
            World world = Bukkit.getWorld((String)planet.getBoundWorld());
            if (world == null) continue;
            if (planet.weatherController != null) {
                planet.weatherController.tick();
            }
            if (planet.getMeteorIntensity() > 0.0) {
                MeteorManager.getManager().tick(world, planet.getMeteorIntensity());
            }
            if (!(planet.getLightningIntensity() > 0.0)) continue;
            LightningManager.getManager().tick(world, planet.getLightningIntensity());
        }
    }

    @EventHandler
    public void onExplode(EntityExplodeEvent event) {
        if (event.getEntity().getPersistentDataContainer().has(new NamespacedKey(MineMain.getPlugin(), "MT-METEOR"))) {
            for (Entity entity : event.getEntity().getPassengers()) {
                entity.remove();
            }
            if (MeteorManager.damageType.equals((Object)MeteorManager.MeteorBlockDamage.FULL)) {
                return;
            }
            if (MeteorManager.damageType.equals((Object)MeteorManager.MeteorBlockDamage.NONE)) {
                event.blockList().clear();
                return;
            }
            for (Block block : event.blockList()) {
                boolean isMT = MineUtil.isMinetorioLocation(block.getLocation());
                if (isMT && MeteorManager.damageType.equals((Object)MeteorManager.MeteorBlockDamage.VANILLA)) {
                    event.blockList().remove(block);
                }
                if (isMT || !MeteorManager.damageType.equals((Object)MeteorManager.MeteorBlockDamage.DEVICES)) continue;
                event.blockList().remove(block);
            }
        }
    }

    private static void tickTime() {
        for (Planet planet : allPlanets.values()) {
            double daylightHours;
            World world = Bukkit.getWorld((String)planet.getBoundWorld());
            if (world == null || world.getTime() >= 12300L && world.getTime() <= 23850L || (daylightHours = planet.getDayTimeSpeed()) == 1.0) continue;
            world.setTime(world.getTime() - 1L);
            int timeMod = 0;
            double stored = msTime.getOrDefault(planet, 0.0);
            msTime.put(planet, stored += daylightHours);
            while (msTime.get(planet) >= 1.0) {
                msTime.put(planet, msTime.get(planet) - 1.0);
                ++timeMod;
            }
            world.setTime(world.getTime() + (long)timeMod);
        }
    }

    private void applyGravity(Planet planet, Player player) {
        if (planet == null) {
            return;
        }
        double gravity = planet.getGravityLevel();
        if (gravity == 1.0) {
            player.removePotionEffect(PotionEffectType.JUMP_BOOST);
        }
        int amplifier = 0;
        if (gravity < 1.0) {
            if (gravity < 0.75) {
                amplifier = 1;
            }
            if (gravity < 0.5) {
                amplifier = 2;
            }
            if (gravity < 0.25) {
                amplifier = 3;
            }
        } else {
            return;
        }
        player.addPotionEffect(new PotionEffect(PotionEffectType.JUMP_BOOST, 40, amplifier, false, false, false));
    }

    private void applyOxygen(Planet planet, final Player player) {
        AtmosphericController controller;
        if (haveAIR.contains(player.getUniqueId())) {
            return;
        }
        double oxygen = 1.0;
        if (player.getWorld().getName().equals("MT_world_space")) {
            oxygen = 0.0;
        }
        if (planet != null) {
            oxygen = planet.getGasLevel(Planet.Gas.OXYGEN);
        }
        boolean regenAir = false;
        if (player.getLocation().getBlock().hasMetadata("MT-STABLE") && (controller = (AtmosphericController)((MetadataValue)player.getLocation().getBlock().getMetadata("MT-STABLE").get(0)).value()) != null && controller.Oxygen > 0.0) {
            controller.Oxygen -= 0.1;
            haveAIR.add(player.getUniqueId());
            regenAir = true;
        }
        if (!regenAir && oxygen < 1.0) {
            if (player.getRemainingAir() < player.getMaximumAir() - 20 && (player.getEquipment().getHelmet() != null && MineItems.isIndustrialItem(player.getEquipment().getHelmet(), "Oxygen Mask") || player.hasMetadata("MT-HAS-EVA"))) {
                if (oxygen < 0.75) {
                    int slot = 9;
                    while (slot <= 17) {
                        int stored;
                        ItemStack tank;
                        if (TUItems.isValid(player.getInventory().getItem(slot)) && (tank = player.getInventory().getItem(slot)) != null && MineItems.isIndustrialItem(tank, "Oxygen Tank") && (stored = MineItems.getOxygenInTank(tank)) > 0) {
                            player.getInventory().setItem(slot, MineItems.getOxygenTank(stored - 1));
                            haveAIR.add(player.getUniqueId());
                            player.setRemainingAir(Math.min(player.getMaximumAir(), player.getRemainingAir() + 5));
                            if (!airSoundCooldown.contains(player.getUniqueId())) {
                                player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_BREATH, 0.5f, 0.8f);
                                airSoundCooldown.add(player.getUniqueId());
                                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                                    @Override
                                    public void run() {
                                        airSoundCooldown.remove(player.getUniqueId());
                                    }
                                }, 200L);
                            }
                            return;
                        }
                        ++slot;
                    }
                } else {
                    regenAir = true;
                }
            }
            if (!regenAir) {
                int currentAir = player.getRemainingAir();
                int lossPerSecond = (int)((1.0 - oxygen) * 12.0);
                int newAir = Math.max(0, currentAir - lossPerSecond);
                player.setRemainingAir(newAir);
            }
        } else {
            regenAir = true;
        }
        if (regenAir && player.getRemainingAir() < player.getMaximumAir() && !player.isInWater()) {
            player.setRemainingAir(Math.min(player.getMaximumAir(), player.getRemainingAir() + 5));
        }
        if (player.getRemainingAir() <= 0) {
            player.damage(1.0);
        }
    }

    @EventHandler
    public void onAir(EntityAirChangeEvent event) {
        if (!MineMain.useSpaceContent) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Planet planet = PlanetHandler.getPlanetByWorld(event.getEntity().getWorld().getName());
            if (event.getEntity().getWorld().getName().equals("MT_world_space")) {
                if (haveAIR.contains(player.getUniqueId())) {
                    return;
                }
                if (event.getAmount() > player.getRemainingAir()) {
                    event.setCancelled(true);
                }
                return;
            }
            if (planet == null) {
                return;
            }
            double oxygen = planet.getGasLevel(Planet.Gas.OXYGEN);
            if (oxygen == 1.0) {
                return;
            }
            if (haveAIR.contains(player.getUniqueId())) {
                return;
            }
            if (oxygen < 1.0 && event.getAmount() > player.getRemainingAir()) {
                event.setCancelled(true);
            }
        }
    }

    private void applyHydrogen(Planet planet, Player player) {
        if (planet == null) {
            return;
        }
        double hydrogen = planet.getGasLevel(Planet.Gas.HYDROGEN);
        if (hydrogen >= 1.0 && (double)TUMaths.rollRange(0, 99) <= hydrogen) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.POISON, 5, 0));
        }
    }

    private void applyTemperature(Planet planet, Player player) {
        AtmosphericController controller;
        World world = player.getWorld();
        if (planet == null || planet != null && planet.getTempature() == 1.0 || player.getGameMode().equals((Object)GameMode.CREATIVE)) {
            freezeFreezingTicks.remove(player);
            return;
        }
        double effectiveTemp = -1.0;
        effectiveTemp = player.getLocation().getBlock().hasMetadata("MT-STABLE") ? ((controller = (AtmosphericController)((MetadataValue)player.getLocation().getBlock().getMetadata("MT-STABLE").get(0)).value()) != null && controller.spaceHeated ? 1.0 : PlanetHandler.getLocalTemperature(world, planet, player)) : PlanetHandler.getLocalTemperature(world, planet, player);
        if (effectiveTemp < 0.5) {
            freezeFreezingTicks.add(player);
            double coldFactor = 0.5 - effectiveTemp;
            if (player.getFreezeTicks() <= 160) {
                int freezeLevel = (int)(coldFactor * 28.0);
                player.setFreezeTicks(player.getFreezeTicks() + freezeLevel);
            }
            if (player.getFoodLevel() > 1 && player.getFreezeTicks() > 0 && TUMaths.rollRange(0, 99) <= player.getFreezeTicks() / 20) {
                player.setFoodLevel(player.getFoodLevel() - 1);
            }
            if (!coldWarning.contains(player.getUniqueId())) {
                MineUtil.sendWarning(player, "It's to cold to survive here! You need better protection from the cold! Try warming up by a torch or get some sunlight!");
                coldWarning.add(player.getUniqueId());
            }
        } else {
            freezeFreezingTicks.remove(player);
            if (effectiveTemp > 1.5) {
                double heatFactor = effectiveTemp - 1.5;
                player.damage(heatFactor);
                if (effectiveTemp >= 3.0) {
                    player.setFireTicks(40);
                }
                if (!hotWarning.contains(player.getUniqueId())) {
                    MineUtil.sendWarning(player, "It's to hot to survive here! You need better protection from the heat! Try a dark area or jumping in water!");
                    hotWarning.add(player.getUniqueId());
                }
            }
        }
    }

    private static double getLocalTemperature(World world, Planet planet, Player player) {
        double effectiveTemp = 1.0;
        if (player.getWorld().getName().equals("MT_world_space")) {
            effectiveTemp = 0.0;
        }
        if (planet != null) {
            effectiveTemp = PlanetHandler.getEffectiveTemp(world, planet);
        }
        effectiveTemp = PlanetHandler.suitImproveTempature(player, effectiveTemp);
        effectiveTemp = PlanetHandler.localTempatureAdjustment(player, effectiveTemp);
        return effectiveTemp;
    }

    public static double localTempatureAdjustment(final Player player, double temp) {
        if (player.isInWater()) {
            temp -= 0.2;
        }
        temp += 0.01 * (double)player.getLocation().getBlock().getLightFromBlocks();
        byte sky = player.getLocation().getBlock().getLightFromSky();
        if (sky != 7) {
            if (sky < 7) {
                sky = (byte)(7 - sky);
                temp -= 0.02 * (double)(sky + 1);
            } else {
                temp += 0.02 * (double)sky;
            }
        }
        if (player.isSneaking() && !heatBonus.contains(player.getUniqueId())) {
            for (Block near : TUMaths.getNearbyBlocks(player.getLocation().getBlock(), 1)) {
                if (!near.getType().equals((Object)Material.FIRE) && !near.getType().equals((Object)Material.CAMPFIRE)) continue;
                heatBonus.add(player.getUniqueId());
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        heatBonus.remove(player.getUniqueId());
                    }
                }, 3600L);
                break;
            }
        }
        if (heatBonus.contains(player.getUniqueId())) {
            temp += 0.3;
        }
        if (player.hasPotionEffect(PotionEffectType.FIRE_RESISTANCE) && temp > 1.0) {
            int level = player.getPotionEffect(PotionEffectType.FIRE_RESISTANCE).getAmplifier() + 1;
            temp = Math.max(temp * (1.0 - (double)level * 0.2), 1.0);
        }
        return temp;
    }

    public static double suitImproveTempature(Player player, double temp) {
        if (player.getEquipment().getChestplate() != null && MineItems.isIndustrialItem(player.getEquipment().getChestplate(), "Space Suit") || player.hasMetadata("MT-HAS-EVA")) {
            temp = temp < 1.0 ? Math.min(temp * 2.0, 1.0) : Math.max(temp / 2.0, 1.0);
        }
        return temp;
    }

    private static double getEffectiveTemp(World world, Planet planet) {
        double temp = planet.getTempature();
        long time = world.getTime();
        double dayFactor = PlanetHandler.getDaylightMultiplier(time, planet.getTempature() / 2.0);
        double effectiveTemp = temp / 2.0 + dayFactor;
        return effectiveTemp;
    }

    private static double getDaylightMultiplier(long time, double peakValue) {
        time = (time + 6000L) % 24000L;
        double angle = Math.PI * 2 * (double)time / 24000.0;
        return peakValue * 0.5 * (1.0 - Math.cos(angle));
    }

    public static double planetAdjustment(Location location, double value, double mod) {
        Planet planet = PlanetHandler.getPlanetByWorld(location.getWorld().getName());
        if (planet != null) {
            return value * mod;
        }
        return value;
    }

    public static int getPlanetPowerDraw(Location location, int power) {
        double effectiveTemp;
        if (location == null) {
            return power;
        }
        Planet planet = PlanetHandler.getPlanetByWorld(location.getWorld().getName());
        if (planet != null && planet.getTempature() > 1.0 && (effectiveTemp = PlanetHandler.getEffectiveTemp(location.getWorld(), planet)) > 1.0) {
            double tempMod = Math.min(effectiveTemp, 2.0);
            power = (int)((double)power * tempMod);
            return power;
        }
        return power;
    }

    public static World createVoidWorld(String name) {
        WorldCreator creator = new WorldCreator(name);
        creator.generator((ChunkGenerator)new VoidWorldGenerator());
        creator.environment(World.Environment.NORMAL);
        creator.type(WorldType.FLAT);
        creator.generateStructures(false);
        World world = creator.createWorld();
        world.setSpawnLimit(SpawnCategory.MONSTER, 0);
        world.setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)false);
        world.setGameRule(GameRule.DO_WEATHER_CYCLE, (Object)false);
        world.setGameRule(GameRule.DO_INSOMNIA, (Object)false);
        world.setTime(18000L);
        return world;
    }

    public static String formatDistance(double meters) {
        if (meters < 1000.0) {
            return String.format("%.2f m", meters);
        }
        if (meters < 1000000.0) {
            double km = meters / 1000.0;
            return String.format("%.2f km", km);
        }
        double megaKm = meters / 1000000.0;
        return String.format("%.2f Mm", megaKm);
    }

    @EventHandler
    public void onGrow(BlockGrowEvent event) {
        if (!MineMain.useSpaceContent) {
            return;
        }
        if (event.getBlock().getWorld().getName().equals("MT_world_space") && !event.getBlock().getRelative(BlockFace.UP).hasMetadata("MT-STABLE")) {
            event.setCancelled(true);
        }
    }

    public static class VoidWorldGenerator
    extends ChunkGenerator {
        public void generateNoise(WorldInfo worldInfo, Random random, int chunkX, int chunkZ, ChunkGenerator.ChunkData chunkData) {
        }

        public void generateSurface(WorldInfo worldInfo, Random random, int chunkX, int chunkZ, ChunkGenerator.ChunkData chunkData) {
        }

        public void generateBedrock(WorldInfo worldInfo, Random random, int chunkX, int chunkZ, ChunkGenerator.ChunkData chunkData) {
        }

        public void generateCaves(WorldInfo worldInfo, Random random, int chunkX, int chunkZ, ChunkGenerator.ChunkData chunkData) {
        }
    }
}

