/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx;

import com.MT.triggersUtility.Saveable;
import com.MT.triggersUtility.TUInterface.TUIComponent;
import com.MT.triggersUtility.TUInterface.TUInterfaceScrolling;
import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Manufactoring.CrudeAssembler;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.LocaleUtil;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.Technology.TechTree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;

public class PlayerData
extends Saveable {
    private static final long serialVersionUID = -8485406521279459276L;
    private static HashMap<String, PlayerData> allPlayers = new HashMap();
    private int batteryPower = 0;
    private HashMap<String, Boolean> autoCraftPermissionsOffline = new HashMap();
    private HashSet<String> unlockedTechs = new HashSet();
    private HashSet<String> checkedGuides = new HashSet();
    private ArrayList<String> sharedUsers = new ArrayList();
    private ArrayList<String> pendingCommandRewards = new ArrayList();
    private String currentResearch = null;
    private HashMap<String, Integer> techProgression = new HashMap();
    public transient BossBar techbar;
    public transient int barTimer = 0;
    private transient ArrayList<ItemStack> groceryList;
    private transient HashMap<NamespacedKey, Integer> groceryList2;
    private String neededDevice;
    private transient Scoreboard groceryBoard;
    private transient Objective objective;
    private transient ItemStack targetStack = null;

    public PlayerData(String uuid) {
        super("Player Data", uuid);
        if (!allPlayers.containsKey(uuid)) {
            allPlayers.put(uuid, this);
        }
    }

    @Override
    public void onCreate(boolean isFirstTime) {
        if (!allPlayers.containsKey(this.getFileName())) {
            allPlayers.put(this.getFileName(), this);
        }
        if (this.checkedGuides == null) {
            this.checkedGuides = new HashSet();
        }
        if (this.sharedUsers == null) {
            this.sharedUsers = new ArrayList();
        }
        if (this.pendingCommandRewards == null) {
            this.pendingCommandRewards = new ArrayList();
        }
    }

    public void addPendingCommand(String command) {
        if (this.pendingCommandRewards == null) {
            this.pendingCommandRewards = new ArrayList();
        }
        this.pendingCommandRewards.add(command);
        this.save();
    }

    public void grantPendingCommands() {
        if (this.pendingCommandRewards == null || this.pendingCommandRewards != null && this.pendingCommandRewards.size() == 0) {
            return;
        }
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        for (String command : this.pendingCommandRewards) {
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.replace("%player_name%", player.getName()));
        }
        this.pendingCommandRewards.clear();
        this.save();
    }

    public boolean hasAutoCraftPermission(String permission) {
        Player player = this.getPlayer();
        if (player != null) {
            return player.hasPermission(permission);
        }
        return this.autoCraftPermissionsOffline.getOrDefault(permission, true);
    }

    public void rebuildOfflineAutoCraftPermissions() {
        Player player = this.getPlayer();
        if (player != null) {
            if (this.autoCraftPermissionsOffline == null) {
                this.autoCraftPermissionsOffline = new HashMap();
            }
            this.autoCraftPermissionsOffline.clear();
            for (String consideredPerm : new ArrayList<String>(MineMain.autoCrafterPermissions)) {
                this.autoCraftPermissionsOffline.put(consideredPerm, player.hasPermission(consideredPerm));
            }
        }
    }

    public ArrayList<String> getSharedUsers() {
        return new ArrayList<String>(this.sharedUsers);
    }

    public void shareFactory(UUID who) {
        if (!this.sharedUsers.contains(who.toString())) {
            this.sharedUsers.add(who.toString());
        }
    }

    public void unShareFactory(UUID who) {
        this.sharedUsers.remove(who.toString());
    }

    public void unShareFactory(String who) {
        this.sharedUsers.remove(who);
    }

    public boolean isShared(UUID who) {
        return this.sharedUsers.contains(who.toString());
    }

    public static HashSet<PlayerData> getAllData() {
        return new HashSet<PlayerData>(allPlayers.values());
    }

    public static PlayerData getPlayerData(String uuid) {
        if (allPlayers.containsKey(uuid)) {
            return allPlayers.get(uuid);
        }
        return null;
    }

    public static PlayerData createPlayerData(String uuid) {
        if (allPlayers.containsKey(uuid)) {
            return allPlayers.get(uuid);
        }
        return new PlayerData(uuid);
    }

    public boolean hasTech(String technology) {
        if (technology == null) {
            return true;
        }
        if (!MineMain.useTechnology) {
            return true;
        }
        if (MineMain.defaultTech.contains(technology)) {
            return true;
        }
        return this.unlockedTechs.contains(technology);
    }

    public HashSet<String> getUnlockedTechs() {
        return new HashSet<String>(this.unlockedTechs);
    }

    public void unlockTech(String tech) {
        if (!this.unlockedTechs.contains(tech)) {
            this.unlockedTechs.add(tech);
        }
    }

    public boolean isCheckedOff(String guideName) {
        return this.checkedGuides.contains(guideName);
    }

    public void addCheckedOff(String guideName) {
        if (!this.isCheckedOff(guideName)) {
            this.checkedGuides.add(guideName);
        }
    }

    public void removeCheckedOff(String guideName) {
        this.checkedGuides.remove(guideName);
    }

    public String getCurrentResearch() {
        return this.currentResearch;
    }

    public void setCurrentResearch(String tech) {
        this.currentResearch = tech;
        if (!this.techProgression.containsKey(this.currentResearch)) {
            this.techProgression.put(tech, 0);
        }
    }

    public int getTechProgression(String tech) {
        if (this.techProgression.containsKey(tech)) {
            int needed = TechTree.getRequirementStacks(tech).get(0).getAmount();
            int progress = this.techProgression.get(tech);
            if (progress != 0) {
                return (int)TUMaths.roundDouble((double)progress / ((double)needed * 1.0) * 100.0, 1);
            }
            return 0;
        }
        return 0;
    }

    public int getTechConsumedItems(String tech) {
        return this.techProgression.getOrDefault(tech, 0);
    }

    public void progressTech(String whichResearch) {
        if (whichResearch != null && !this.hasTech(whichResearch)) {
            ArrayList<ItemStack> reqs = TechTree.getRequirementStacks(whichResearch);
            if (reqs.size() == 0) {
                TUMaths.dm(MineMain.getBanner() + String.valueOf(ChatColor.YELLOW) + whichResearch + " has no required research items. Add one to fix this error. (tech.yml)", ChatColor.YELLOW);
                this.currentResearch = null;
                return;
            }
            int needed = reqs.get(0).getAmount();
            int progress = this.techProgression.getOrDefault(whichResearch, 0) + 1;
            this.techProgression.put(whichResearch, progress);
            Player player = this.getPlayer();
            if (player != null) {
                this.showTechBar(player, whichResearch, (double)progress / ((double)needed * 1.0));
            }
            if (progress >= needed) {
                this.techProgression.remove(whichResearch);
                this.unlockedTechs.add(whichResearch);
                TechTree.grantTechPermissions(this);
                TechTree.addPendingTechCommands(whichResearch, this);
                this.save();
                if (player != null && player.isOnline()) {
                    player.playSound((Entity)player, Sound.UI_TOAST_CHALLENGE_COMPLETE, 0.5f, 1.1f);
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "You've finished " + whichResearch + " research!");
                }
                if (this.currentResearch != null && whichResearch == this.currentResearch) {
                    this.currentResearch = null;
                }
            }
        }
    }

    public void showTechBar(Player player, String tech, double percentage) {
        if (MineMain.disableTechBossBar) {
            return;
        }
        percentage = Math.max(0.0, Math.min(1.0, percentage));
        if (this.techbar == null) {
            this.techbar = Bukkit.createBossBar((String)(tech + " Research"), (BarColor)BarColor.GREEN, (BarStyle)BarStyle.SEGMENTED_10, (BarFlag[])new BarFlag[0]);
            this.techbar.addPlayer(player);
        }
        this.barTimer = 3;
        this.techbar.setProgress(percentage);
    }

    public void removeTechBar() {
        if (this.techbar == null && this.getPlayer() != null) {
            return;
        }
        this.techbar.removePlayer(this.getPlayer());
        this.techbar = null;
    }

    public int researchLevel() {
        int level = 0;
        if (this.hasTech("Research Efficiency I")) {
            ++level;
        }
        if (this.hasTech("Research Efficiency II")) {
            ++level;
        }
        if (this.hasTech("Research Efficiency III")) {
            ++level;
        }
        return level;
    }

    public Player getPlayer() {
        Player player = Bukkit.getPlayer((UUID)UUID.fromString(this.getFileName()));
        if (player != null && player.isOnline()) {
            return player;
        }
        return null;
    }

    public OfflinePlayer getOfflinePlayer() {
        return Bukkit.getOfflinePlayer((UUID)UUID.fromString(this.getFileName()));
    }

    public static void openFactorySharing(Player player) {
        MainMenu.lastMenu.put(player.getUniqueId(), "Sharing");
        ItemStack pane = MainMenu.createGoldPane();
        PlayerData pd = PlayerData.getPlayerData(player.getUniqueId().toString());
        ArrayList<String> authorizedUsers = pd.getSharedUsers();
        HashMap stacks = new HashMap();
        class LeaderScroller
        extends TUInterfaceScrolling {
            private final /* synthetic */ ArrayList val$authorizedUsers;
            private final /* synthetic */ HashMap val$stacks;
            private final /* synthetic */ PlayerData val$pd;

            public LeaderScroller(String name, int rows, ArrayList arrayList, HashMap hashMap, PlayerData playerData) {
                this.val$authorizedUsers = arrayList;
                this.val$stacks = hashMap;
                this.val$pd = playerData;
                super(name, rows);
            }

            @Override
            public ItemStack defineScrolling(int i) {
                if (this.val$authorizedUsers.size() > i) {
                    String user = (String)this.val$authorizedUsers.get(i);
                    OfflinePlayer oPlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(user));
                    ItemStack stack = TUItems.getHead(user, MineItems.goldBold() + oPlayer.getName());
                    TUItems.addLore(stack, MineUtil.colon(" " + LocaleUtil.uiText("General_Click"), LocaleUtil.uiText("SM_Button_Remove_User")));
                    this.val$stacks.put(i, user);
                    return stack;
                }
                return null;
            }

            @Override
            public void scrollingActionClick(Player player, ItemStack item, InventoryClickEvent event) {
                String user = (String)this.val$stacks.get(event.getSlot());
                this.val$pd.unShareFactory(user);
                OfflinePlayer oPlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(user));
                MineUtil.sendMessage(player, oPlayer.getName() + " is no longer authorized to use your factory.");
                PlayerData.openFactorySharing(player);
            }
        }
        LeaderScroller face = new LeaderScroller(MineItems.uiTitle() + LocaleUtil.uiText("SM_Title"), 6, authorizedUsers, stacks, pd);
        face.addComponent(MineUtil.createInfoComponent(52, LocaleUtil.uiText("SM_Button_Info_Desc")));
        int i = 45;
        while (i <= 53) {
            if (i != 46 && i != 48 && i != 50 && i != 49 && i != 52) {
                face.addComponent(new TUIComponent(i, pane));
            }
            ++i;
        }
        ArrayList<Integer> scrollingSlots = new ArrayList<Integer>();
        int j = 0;
        while (j <= 44) {
            scrollingSlots.add(j);
            ++j;
        }
        face.setScrollingSlots(scrollingSlots);
        class AddButton
        extends TUIComponent {
            public AddButton(int slot, ItemStack linkStack) {
                super(slot, linkStack);
            }

            @Override
            public void onLeftClick(Player player) {
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                PlayerData.openAuthOnline(player);
            }
        }
        AddButton addButt = new AddButton(46, TUItems.createItem(Material.LIME_CONCRETE, MineItems.greenBold() + LocaleUtil.uiText("SM_Button_Auth"), TUItems.basicLore(MineUtil.colon(" " + LocaleUtil.uiText("General_Click"), LocaleUtil.uiText("SM_Button_Auth_Desc")))));
        class ReturnButton
        extends TUIComponent {
            public ReturnButton(int slot, ItemStack linkStack) {
                super(slot, linkStack);
            }

            @Override
            public void onLeftClick(Player player) {
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                MainMenu.openGuideMenu(player, null);
            }
        }
        ReturnButton returnButt = new ReturnButton(49, MainMenu.createReturnArrow());
        TUIComponent leftScroller = MineUtil.createLeftScroll(48);
        TUIComponent rightScroller = MineUtil.createRightScroll(50);
        face.addComponent(addButt);
        face.addComponent(returnButt);
        face.addComponent(leftScroller);
        face.addComponent(rightScroller);
        face.setLeftComp(leftScroller);
        face.setRightComp(rightScroller);
        face.updateScrolling();
        face.openInterface(player);
    }

    public static void openAuthOnline(Player player) {
        ItemStack pane = MainMenu.createGoldPane();
        PlayerData pd = PlayerData.getPlayerData(player.getUniqueId().toString());
        ArrayList<String> authorizedUsers = pd.getSharedUsers();
        ArrayList onlinePlayers = new ArrayList(Bukkit.getOnlinePlayers());
        HashMap stacks = new HashMap();
        class LeaderScroller
        extends TUInterfaceScrolling {
            private final /* synthetic */ ArrayList val$onlinePlayers;
            private final /* synthetic */ ArrayList val$authorizedUsers;
            private final /* synthetic */ HashMap val$stacks;
            private final /* synthetic */ PlayerData val$pd;

            public LeaderScroller(String name, int rows, ArrayList arrayList, ArrayList arrayList2, HashMap hashMap, PlayerData playerData) {
                this.val$onlinePlayers = arrayList;
                this.val$authorizedUsers = arrayList2;
                this.val$stacks = hashMap;
                this.val$pd = playerData;
                super(name, rows);
            }

            @Override
            public ItemStack defineScrolling(int i) {
                Player whom;
                if (this.val$onlinePlayers.size() > i && !this.val$authorizedUsers.contains((whom = (Player)this.val$onlinePlayers.get(i)).getUniqueId().toString())) {
                    String user = whom.getUniqueId().toString();
                    OfflinePlayer oPlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(user));
                    ItemStack stack = TUItems.getHead(user, MineItems.goldBold() + oPlayer.getName());
                    TUItems.addLore(stack, MineUtil.colon(" " + LocaleUtil.uiText("General_Click"), LocaleUtil.uiText("SM_Button_Add_User")));
                    this.val$stacks.put(i, whom.getUniqueId());
                    return stack;
                }
                return null;
            }

            @Override
            public void scrollingActionClick(Player player, ItemStack item, InventoryClickEvent event) {
                UUID target = (UUID)this.val$stacks.get(event.getSlot());
                String targetName = Bukkit.getOfflinePlayer((UUID)target).getName();
                if (target != null) {
                    this.val$pd.shareFactory(target);
                    MineUtil.sendMessage(player, targetName + " has been authorized to use your factory devices!");
                }
                PlayerData.openAuthOnline(player);
            }
        }
        LeaderScroller face = new LeaderScroller(ChatColor.GOLD + ChatColor.BOLD + "Select User(s)", 6, onlinePlayers, authorizedUsers, stacks, pd);
        face.addComponent(MineUtil.createInfoComponent(52, LocaleUtil.uiText("SM_Button_User_Info")));
        int i = 45;
        while (i <= 53) {
            if (i != 48 && i != 50 && i != 49 && i != 52) {
                face.addComponent(new TUIComponent(i, pane));
            }
            ++i;
        }
        ArrayList<Integer> scrollingSlots = new ArrayList<Integer>();
        int j = 0;
        while (j <= 44) {
            scrollingSlots.add(j);
            ++j;
        }
        face.setScrollingSlots(scrollingSlots);
        class ReturnButton
        extends TUIComponent {
            public ReturnButton(int slot, ItemStack linkStack) {
                super(slot, linkStack);
            }

            @Override
            public void onLeftClick(Player player) {
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                PlayerData.openFactorySharing(player);
            }
        }
        ReturnButton returnButt = new ReturnButton(49, MainMenu.createReturnArrow());
        TUIComponent leftScroller = MineUtil.createLeftScroll(48);
        TUIComponent rightScroller = MineUtil.createRightScroll(50);
        face.addComponent(returnButt);
        face.addComponent(leftScroller);
        face.addComponent(rightScroller);
        face.setLeftComp(leftScroller);
        face.setRightComp(rightScroller);
        face.updateScrolling();
        face.openInterface(player);
    }

    public int getBatteryPower() {
        return this.batteryPower;
    }

    public void setBatteryPower(int batteryPower) {
        this.batteryPower = batteryPower;
    }

    public void setGroceryList(ArrayList<ItemStack> needed, HashMap<NamespacedKey, Integer> needed2, ItemStack forStack, String forDevice) {
        this.groceryList = needed;
        this.groceryList2 = needed2;
        this.targetStack = forStack;
        this.neededDevice = forDevice;
    }

    public boolean lookingForGroceries() {
        return this.groceryList != null && this.groceryList.size() > 0 || this.groceryList2 != null && this.groceryList2.size() > 0;
    }

    public boolean hasGroceries() {
        Player player = this.getPlayer();
        if (player == null) {
            return false;
        }
        for (ItemStack stack : this.groceryList) {
            if (player.getInventory().contains(stack, stack.getAmount())) continue;
            return false;
        }
        if (this.groceryList2 != null) {
            for (NamespacedKey key : this.groceryList2.keySet()) {
                int needed = this.groceryList2.get(key);
                for (ItemStack stack : player.getInventory()) {
                    if (stack.hasItemMeta() && stack.getItemMeta().getPersistentDataContainer().has(key)) {
                        needed -= stack.getAmount();
                    }
                    if (needed <= 0) break;
                }
                if (needed <= 0) continue;
                return false;
            }
        }
        return true;
    }

    public void updateGroceryDisplay(Player player) {
        if (!this.lookingForGroceries() && this.groceryBoard != null) {
            this.clearGroceryDisplay(player);
            return;
        }
        if (!this.lookingForGroceries()) {
            return;
        }
        if (this.groceryBoard == null) {
            ScoreboardManager manager = Bukkit.getScoreboardManager();
            this.groceryBoard = manager.getNewScoreboard();
            this.objective = this.groceryBoard.registerNewObjective("MT-GROCERY", Criteria.DUMMY, MineItems.goldBold() + "Needed Items   ");
            this.objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        }
        for (String entry : this.groceryBoard.getEntries()) {
            Score score = this.objective.getScore(entry);
            this.groceryBoard.resetScores(score.getEntry());
        }
        int score = 2;
        ArrayList<ItemStack> neededList = new ArrayList<ItemStack>(this.groceryList);
        for (ItemStack stack : new ArrayList<ItemStack>(neededList)) {
            Score grocery;
            String text = TUMaths.capitalizeWords(Device.getMissingName(stack));
            ItemStack stack2 = stack.clone();
            stack2.setAmount(1);
            int amountInInv = TUMaths.inventoryGetStackAmount((Inventory)player.getInventory(), stack2);
            ++score;
            if (amountInInv < stack.getAmount()) {
                grocery = this.objective.getScore("    " + (String)text + " x" + (stack.getAmount() - amountInInv));
                grocery.setScore(score);
                continue;
            }
            grocery = this.objective.getScore("    " + String.valueOf(ChatColor.GRAY) + String.valueOf(ChatColor.STRIKETHROUGH) + (String)text + " x" + stack.getAmount());
            grocery.setScore(stack.getAmount());
            neededList.remove(stack);
        }
        ArrayList<NamespacedKey> neededList2 = new ArrayList<NamespacedKey>(this.groceryList2.keySet());
        for (NamespacedKey key : new ArrayList<NamespacedKey>(neededList2)) {
            Score grocery;
            int amountNeeded = this.groceryList2.get(key);
            String text = TUMaths.capitalizeWords(key.getKey().replace("mt_", "").replace("_", " "));
            int amountInInv = CrudeAssembler.getPDCItemCount((Inventory)player.getInventory(), key);
            ++score;
            if (amountInInv < amountNeeded) {
                grocery = this.objective.getScore("    " + text + " x" + (amountNeeded - amountInInv));
                grocery.setScore(score);
                continue;
            }
            grocery = this.objective.getScore("    " + String.valueOf(ChatColor.GRAY) + String.valueOf(ChatColor.STRIKETHROUGH) + text + " x" + amountNeeded);
            grocery.setScore(amountNeeded);
            neededList2.remove(key);
        }
        if (neededList.size() == 0 && neededList2.size() == 0) {
            String name = TUMaths.capitalizeWords(Device.getMissingName(this.targetStack));
            if (this.neededDevice != null) {
                MineUtil.sendMessage(player, "All items have been collected for the " + String.valueOf(ChatColor.UNDERLINE) + this.neededDevice + String.valueOf(ChatColor.GRAY) + " (" + name + " Recipe)");
            } else {
                MineUtil.sendMessage(player, "All items have been collected for the " + String.valueOf(ChatColor.UNDERLINE) + name + " Recipe");
            }
            this.clearGroceryDisplay(player);
            return;
        }
        Score emptyLine = this.objective.getScore("\u25c6" + String.valueOf(ChatColor.STRIKETHROUGH) + "\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af" + String.valueOf(ChatColor.RESET) + "\u25c6");
        emptyLine.setScore(score + 3);
        Score emptyLine2 = this.objective.getScore("\u25c6" + String.valueOf(ChatColor.STRIKETHROUGH) + "\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af\u23af" + String.valueOf(ChatColor.RESET) + "\u25c6 ");
        emptyLine2.setScore(1);
        Score hint = this.objective.getScore(String.valueOf(ChatColor.WHITE) + "   /mt needs - to clear!");
        hint.setScore(0);
        player.setScoreboard(this.groceryBoard);
    }

    public void clearGroceryDisplay(Player player) {
        this.groceryBoard = null;
        this.groceryList = null;
        this.groceryList2 = null;
        player.setScoreboard(Bukkit.getScoreboardManager().getMainScoreboard());
    }
}

