/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Pollution;

import com.MT.triggersUtility.Events.ServerTimeUpdate;
import com.MT.triggersUtility.Events.TUEvents;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Pollution.BiterAttack;
import com.MT.xxxtrigger50xxx.Pollution.BiterNest;
import com.MT.xxxtrigger50xxx.Pollution.SuperChunk;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.entity.SheepRegrowWoolEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.Inventory;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PollutionListener
implements Listener {
    private static int pollutionThreshold = 10;
    private static HashMap<UUID, Integer> nestTags = new HashMap();
    private static ArrayList<Block> nestRemoval = new ArrayList();
    private static NamespacedKey hpKey = new NamespacedKey(MineMain.getPlugin(), "BITER-HP");
    private static NamespacedKey dmgKey = new NamespacedKey(MineMain.getPlugin(), "BITER-DMG");
    private static NamespacedKey scaleKey = new NamespacedKey(MineMain.getPlugin(), "BITER-SCALE");

    @EventHandler
    public void onSecond(ServerTimeUpdate event) {
        BiterAttack.tickAttackChunks();
        PollutionListener.tickDebuffs();
        for (BiterAttack ba : BiterAttack.getAllAttacks()) {
            ba.tickAttack();
        }
        if (TUMaths.isMultipleOf(TUEvents.serverTimeSeconds, 5)) {
            this.spawnPollutionParticles();
        }
        if (!TUMaths.isMultipleOf(TUEvents.serverTimeSeconds, 60) && !TUMaths.isMultipleOf(TUEvents.serverTimeSeconds, 5)) {
            return;
        }
        ArrayList<Location> locs = new ArrayList<Location>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (MineMain.disabledWorlds.contains(player.getWorld().getName())) continue;
            for (Location loc : new ArrayList(locs)) {
                if (loc.getWorld().equals(player.getWorld()) && TUMaths.get2DManhattanDistance(loc, player.getLocation()) > 32) continue;
            }
            locs.add(player.getLocation());
        }
        HashSet<SuperChunk> activeChunks = new HashSet<SuperChunk>();
        int range = (int)((double)MineMain.chunkViewDistance * 0.5);
        for (Location playerLoc : locs) {
            int x = playerLoc.getBlockX() - range;
            while (x <= playerLoc.getBlockX() + range) {
                int z = playerLoc.getBlockZ() - range;
                while (z <= playerLoc.getBlockZ() + range) {
                    if (SuperChunk.superChunkExists(new Location(playerLoc.getWorld(), (double)x, 0.0, (double)z))) {
                        SuperChunk sc = SuperChunk.getSuperChunk(new Location(playerLoc.getWorld(), (double)x, 0.0, (double)z));
                        activeChunks.add(sc);
                    }
                    z += 48;
                }
                x += 48;
            }
        }
        for (SuperChunk sc : activeChunks) {
            if (TUMaths.isMultipleOf(TUEvents.serverTimeSeconds, 60)) {
                sc.validateNests();
            }
            if (!TUMaths.isMultipleOf(TUEvents.serverTimeSeconds, 5)) continue;
            sc.dissapationTagged = true;
        }
    }

    private void spawnPollutionParticles() {
        if (!MineMain.usePollutionParticles) {
            return;
        }
        HashSet<Chunk> chunks = new HashSet<Chunk>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            chunks.addAll(this.getChunksAround(player.getLocation(), 3));
        }
        for (Chunk chunk : chunks) {
            if (!SuperChunk.superChunkExists(chunk.getBlock(0, 0, 0).getLocation())) continue;
            SuperChunk sc = SuperChunk.getSuperChunk(chunk.getBlock(0, 0, 0).getLocation());
            if (sc.getPollution() >= 100) {
                this.spawnParticles(sc.getPollution(), chunk, Color.GRAY, Color.BLACK);
            }
            if (sc.getEcoDamage() <= 100) continue;
            this.spawnParticles(sc.getEcoDamage(), chunk, Color.GREEN, Color.OLIVE);
        }
    }

    private void spawnParticles(int value, final Chunk chunk, final Color color1, final Color color2) {
        long increment;
        int particles = value / 40;
        if (particles > 10) {
            particles = 10;
        }
        long delay = increment = (long)(100 / particles);
        int i = 0;
        while (i < particles) {
            Location particleLocation = chunk.getBlock(TUMaths.rollRange(0, 15), 64, TUMaths.rollRange(0, 15)).getLocation();
            particleLocation = particleLocation.getWorld().getHighestBlockAt(particleLocation).getLocation();
            particleLocation.add(0.0, (double)TUMaths.rollRange(0, 8), 0.0);
            final Location fparticleLocation = particleLocation;
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    if (TUMaths.rollRange(0, 1) == 0) {
                        chunk.getWorld().spawnParticle(Particle.ENTITY_EFFECT, fparticleLocation, 1, 0.0, 0.0, 0.0, 10000.0, (Object)color1, true);
                    } else {
                        chunk.getWorld().spawnParticle(Particle.ENTITY_EFFECT, fparticleLocation, 1, 0.0, 0.0, 0.0, 10000.0, (Object)color2, true);
                    }
                }
            }, delay);
            delay += increment;
            ++i;
        }
    }

    public List<Chunk> getChunksAround(Location location, int chunkRadius) {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        World world = location.getWorld();
        if (world == null) {
            return chunks;
        }
        int centerX = location.getChunk().getX();
        int centerZ = location.getChunk().getZ();
        int dx = -chunkRadius;
        while (dx <= chunkRadius) {
            int dz = -chunkRadius;
            while (dz <= chunkRadius) {
                Chunk chunk = world.getChunkAt(centerX + dx, centerZ + dz);
                chunks.add(chunk);
                ++dz;
            }
            ++dx;
        }
        return chunks;
    }

    @EventHandler
    public void onGrow(BlockGrowEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!MineMain.stuntPlants || !MineMain.usePollution) {
            return;
        }
        boolean poll = PollutionListener.pollutionCancel(event.getBlock().getLocation(), (Cancellable)event);
        if (poll) {
            for (Player player : MinetorioListener.getNearbyPlayersOPT(event.getBlock().getLocation(), 3.0)) {
                MineUtil.sendWarning(player, "Your crops couldn't grow due to pollution levels here.");
            }
        }
    }

    private static boolean pollutionCancel(Location location, Cancellable event) {
        SuperChunk sc;
        if (SuperChunk.superChunkExists(location) && (sc = SuperChunk.getSuperChunk(location)).getPollution() > pollutionThreshold) {
            int stopChance = sc.getPollution() / pollutionThreshold;
            if (stopChance < 100) {
                if (TUMaths.rollRange(1, 100) <= stopChance) {
                    event.setCancelled(true);
                    return true;
                }
            } else {
                event.setCancelled(true);
                return true;
            }
        }
        return false;
    }

    @EventHandler
    public void onGrow2(StructureGrowEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!MineMain.stuntPlants || !MineMain.usePollution) {
            return;
        }
        PollutionListener.pollutionCancel(event.getLocation(), (Cancellable)event);
    }

    @EventHandler
    public void onWoolGrow(SheepRegrowWoolEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!MineMain.stuntAnimalStuff || !MineMain.usePollution) {
            return;
        }
        PollutionListener.pollutionCancel(event.getEntity().getLocation(), (Cancellable)event);
    }

    @EventHandler
    public void onItemSpawn(ItemSpawnEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!MineMain.stuntAnimalStuff || !MineMain.usePollution) {
            return;
        }
        if (event.getEntity().getItemStack().getType().equals((Object)Material.EGG)) {
            for (Entity entity : event.getLocation().getWorld().getNearbyEntities(event.getLocation(), 1.0, 1.0, 1.0)) {
                if (!entity.getType().equals((Object)EntityType.CHICKEN)) continue;
                PollutionListener.pollutionCancel(event.getEntity().getLocation(), (Cancellable)event);
                break;
            }
        }
    }

    @EventHandler
    public void onBreed(EntityBreedEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!MineMain.stuntAnimalSpawns || !MineMain.usePollution) {
            return;
        }
        PollutionListener.pollutionCancel(event.getEntity().getLocation(), (Cancellable)event);
    }

    @EventHandler
    public void onFurnaceSmelt(FurnaceSmeltEvent event) {
        if (!MineMain.usePollution) {
            return;
        }
        SuperChunk sc = SuperChunk.getSuperChunk(event.getBlock().getLocation());
        sc.addPollution(10);
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.getCause().equals((Object)EntityDamageEvent.DamageCause.SUFFOCATION)) {
            return;
        }
        if (event.getEntity().hasMetadata("MT-Biter")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onDisable(PluginDisableEvent event) {
        if (event.getPlugin().equals(MineMain.getPlugin())) {
            for (BiterAttack ba : BiterAttack.getAllAttacks()) {
                ba.endAttack();
            }
        }
    }

    @EventHandler
    public void onDeath(EntityDeathEvent event) {
        SuperChunk sc;
        boolean reduceDrops = false;
        if (event.getEntity().hasMetadata("BITER-NEST")) {
            BiterNest bn = (BiterNest)((MetadataValue)event.getEntity().getMetadata("BITER-NEST").get(0)).value();
            bn.killSpawnedBiter(event.getEntity());
            reduceDrops = true;
        }
        if (event.getEntity().hasMetadata("MT-Biter")) {
            reduceDrops = true;
        }
        if (reduceDrops && TUMaths.rollRange(0, 99) <= 90) {
            event.getDrops().clear();
        }
        if (!(event.getEntity() instanceof Animals)) {
            return;
        }
        if (SuperChunk.superChunkExists(event.getEntity().getLocation()) && (sc = SuperChunk.getSuperChunk(event.getEntity().getLocation())).getPollution() > pollutionThreshold) {
            int stopChance = sc.getPollution() / pollutionThreshold;
            if (stopChance < 100) {
                if (TUMaths.rollRange(1, 100) <= stopChance) {
                    Player player;
                    event.getDrops().clear();
                    if (event.getEntity().getKiller() != null && (player = event.getEntity().getKiller()) instanceof Player) {
                        Player player2 = player;
                        MineUtil.sendWarning(player2, "Your crops couldn't grow due to pollution levels here.");
                    }
                }
            } else {
                Player player;
                event.getDrops().clear();
                if (event.getEntity().getKiller() != null && (player = event.getEntity().getKiller()) instanceof Player) {
                    Player player3 = player;
                    MineUtil.sendWarning(player3, "Your crops couldn't grow due to pollution levels here.");
                }
            }
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        if (event.getClickedBlock() != null && event.getAction().equals((Object)Action.LEFT_CLICK_BLOCK) && MineItems.isIndustrialItem(event.getItem(), "Repair Pack")) {
            ArrayList<Block> blocks = new ArrayList<Block>(TUMaths.getNearbyBlocks(event.getClickedBlock(), 1));
            blocks.addAll(TUMaths.getNearbyBlocks(event.getClickedBlock().getLocation().add(0.0, 1.0, 0.0).getBlock(), 1));
            blocks.addAll(TUMaths.getNearbyBlocks(event.getClickedBlock().getLocation().add(0.0, -1.0, 0.0).getBlock(), 1));
            blocks.add(event.getClickedBlock());
            blocks.add(event.getClickedBlock().getRelative(BlockFace.DOWN));
            blocks.add(event.getClickedBlock().getRelative(BlockFace.UP));
            boolean repairedAnything = false;
            for (Block block : blocks) {
                boolean healed = BiterAttack.healBlock(block);
                if (!healed) continue;
                repairedAnything = true;
            }
            if (repairedAnything) {
                event.getPlayer().playSound((Entity)event.getPlayer(), Sound.BLOCK_ANVIL_USE, 0.2f, 0.8f);
                MineUtil.damageItemStack(event.getItem(), event.getPlayer().getLocation(), (Inventory)event.getPlayer().getInventory());
            }
        }
    }

    @EventHandler
    public void onBreak(BlockBreakEvent event) {
        if (event.isCancelled() || !event.getPlayer().getGameMode().equals((Object)GameMode.SURVIVAL)) {
            return;
        }
        if (event.getPlayer().hasMetadata("NestDebuff")) {
            if (event.getBlock().getType().equals((Object)Material.COBWEB) && TUMaths.rollRange(0, 99) <= 25) {
                event.getPlayer().addPotionEffect(new PotionEffect(PotionEffectType.POISON, 100, 0));
                MineUtil.sendWarning(event.getPlayer(), "Some of the webs fall on you, they burn!");
            }
            if (event.getBlock().getType().equals((Object)Material.CRIMSON_HYPHAE) || event.getBlock().getType().equals((Object)Material.NETHER_WART_BLOCK)) {
                event.setCancelled(true);
                MineUtil.sendWarning(event.getPlayer(), "This is to strong to break!");
            }
        }
    }

    @EventHandler
    public void onWater(PlayerBucketEmptyEvent event) {
        if (event.isCancelled() || !event.getPlayer().getGameMode().equals((Object)GameMode.SURVIVAL)) {
            return;
        }
        if (!event.getPlayer().hasMetadata("NestDebuff") && Device.getNearbyDevices(event.getBlock().getLocation(), 16, false, "Biter Nest").size() == 0) {
            return;
        }
        event.setCancelled(true);
        MineUtil.sendWarning(event.getPlayer(), "You cannot empty buckets this close to a biter nest!");
    }

    public static void applyNestDebuff(Player player) {
        nestTags.put(player.getUniqueId(), 2);
        if (!player.hasMetadata("NestDebuff")) {
            player.setMetadata("NestDebuff", (MetadataValue)new FixedMetadataValue(MineMain.getPlugin(), (Object)"NestDebuff"));
        }
    }

    public static boolean hasNestDebuff(Player player) {
        return nestTags.containsKey(player.getUniqueId());
    }

    public static void tickDebuffs() {
        for (UUID uuid : new ArrayList<UUID>(nestTags.keySet())) {
            Player player = Bukkit.getPlayer((UUID)uuid);
            int timer = nestTags.get(uuid);
            if (--timer <= 0) {
                nestTags.remove(uuid);
                if (player == null || !player.isOnline()) continue;
                player.removeMetadata("NestDebuff", MineMain.getPlugin());
                continue;
            }
            nestTags.put(uuid, timer);
            if (player == null || !player.isOnline() || player.hasMetadata("NestDebuff")) continue;
            player.setMetadata("NestDebuff", (MetadataValue)new FixedMetadataValue(MineMain.getPlugin(), (Object)"NestDebuff"));
        }
    }

    public static void doAllNestRemovals() {
        for (Block block : nestRemoval) {
            PollutionListener.removeNestBlock(block, false);
        }
    }

    public static void removeNestOld(Location center) {
        if (TUMaths.isPlayerNearby(center, 16.0)) {
            center.getWorld().playSound(center, Sound.BLOCK_SOUL_SOIL_BREAK, 1.0f, 1.0f);
        }
        final boolean deadDome = false;
        World world = center.getWorld();
        ArrayList<Block> nestBlocks = new ArrayList<Block>();
        int x = -7;
        while (x <= 7) {
            int z = -7;
            while (z <= 7) {
                int y = -11;
                while (y <= 6) {
                    Block block = world.getBlockAt(x, y * -1, z).getLocation().add(center).getBlock();
                    if (block.getType().equals((Object)Material.WEEPING_VINES_PLANT) || block.getType().equals((Object)Material.WEEPING_VINES)) {
                        block.setType(Material.AIR);
                    } else if (PollutionListener.isNestBlock(block)) {
                        nestRemoval.add(block);
                        nestBlocks.add(block);
                    }
                    ++y;
                }
                ++z;
            }
            ++x;
        }
        long delay = 1L;
        Collections.shuffle(nestBlocks);
        for (final Block block : nestBlocks) {
            if (TUMaths.rollRange(0, 1) == 0) {
                delay += (long)TUMaths.rollRange(0, 1);
            }
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    PollutionListener.removeNestBlock(block, deadDome);
                }
            }, delay);
        }
    }

    public static void removeNest(BiterNest nest, Location center) {
        if (TUMaths.isPlayerNearby(center, 16.0)) {
            center.getWorld().playSound(center, Sound.ENTITY_SPIDER_DEATH, 1.0f, 0.5f);
        }
        final boolean deadDome = false;
        ArrayList<Block> nestBlocks = nest.getNestBlocks();
        for (Block block2 : new ArrayList<Block>(nestBlocks)) {
            if (block2.getType().equals((Object)Material.WEEPING_VINES) || block2.getType().equals((Object)Material.WEEPING_VINES_PLANT)) {
                PollutionListener.removeWeepingVinesFromBottom(block2);
            }
            if (PollutionListener.isNestBlock(block2)) continue;
            nestBlocks.remove(block2);
        }
        long delay = 10L;
        nestBlocks.sort(Comparator.comparingDouble(block -> -block.getLocation().distanceSquared(center)));
        nestRemoval.addAll(nestBlocks);
        for (final Block block3 : nestBlocks) {
            if (TUMaths.rollRange(0, 1) == 0) {
                delay += (long)TUMaths.rollRange(0, 1);
            }
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    PollutionListener.removeNestBlock(block3, deadDome);
                }
            }, delay);
        }
    }

    public static void removeWeepingVinesFromBottom(Block block) {
        Block currentBlock = block.getRelative(BlockFace.DOWN);
        while (currentBlock.getType() == Material.WEEPING_VINES || currentBlock.getType() == Material.WEEPING_VINES_PLANT) {
            currentBlock = currentBlock.getRelative(BlockFace.DOWN);
        }
        currentBlock = currentBlock.getRelative(BlockFace.UP);
        while (currentBlock.getType() == Material.WEEPING_VINES || currentBlock.getType() == Material.WEEPING_VINES_PLANT) {
            currentBlock.setType(Material.AIR);
            currentBlock = currentBlock.getRelative(BlockFace.UP);
        }
    }

    private static boolean isNestBlock(Block block) {
        Material type = block.getType();
        if (type.equals((Object)Material.CRIMSON_NYLIUM) || block.getType().equals((Object)Material.NETHERRACK)) {
            return true;
        }
        if (type.equals((Object)Material.WARPED_FUNGUS) || block.getType().equals((Object)Material.CRIMSON_ROOTS)) {
            return true;
        }
        if (type.equals((Object)Material.COBWEB) || block.getType().equals((Object)Material.WEEPING_VINES)) {
            return true;
        }
        if (type.equals((Object)Material.WEEPING_VINES_PLANT) || block.getType().equals((Object)Material.NETHER_WART_BLOCK)) {
            return true;
        }
        if (type.equals((Object)Material.CRIMSON_HYPHAE)) {
            return true;
        }
        return type.equals((Object)Material.DEAD_TUBE_CORAL_BLOCK);
    }

    private static void removeNestBlock(Block block, boolean deadDome) {
        boolean removed = false;
        if (block.getType().equals((Object)Material.CRIMSON_NYLIUM) || block.getType().equals((Object)Material.NETHERRACK)) {
            removed = true;
            switch (TUMaths.rollRange(0, 1)) {
                case 0: {
                    block.setType(Material.GRASS_BLOCK);
                    break;
                }
                case 1: {
                    block.setType(Material.DIRT);
                }
            }
        }
        if (block.getType().equals((Object)Material.WEEPING_VINES) || block.getType().equals((Object)Material.WEEPING_VINES_PLANT)) {
            block.setType(Material.AIR);
            removed = true;
        }
        if (block.getType().equals((Object)Material.WARPED_FUNGUS) || block.getType().equals((Object)Material.CRIMSON_ROOTS) || block.getType().equals((Object)Material.COBWEB) || block.getType().equals((Object)Material.DEAD_TUBE_CORAL_BLOCK)) {
            block.setType(Material.AIR);
            removed = true;
        }
        if (block.getType().equals((Object)Material.NETHER_WART_BLOCK) || block.getType().equals((Object)Material.CRIMSON_HYPHAE)) {
            if (deadDome) {
                switch (TUMaths.rollRange(0, 3)) {
                    case 0: {
                        block.setType(Material.DEAD_BRAIN_CORAL_BLOCK);
                        break;
                    }
                    case 1: {
                        block.setType(Material.DEAD_TUBE_CORAL_BLOCK);
                        break;
                    }
                    case 2: {
                        block.setType(Material.DEAD_BUBBLE_CORAL_BLOCK);
                        break;
                    }
                    case 3: {
                        block.setType(Material.DEAD_HORN_CORAL_BLOCK);
                    }
                }
            } else {
                removed = true;
                block.setType(Material.AIR);
            }
        }
        if (TUMaths.isPlayerNearby(block.getLocation(), 16.0) && removed && TUMaths.rollRange(0, 2) == 0) {
            block.getWorld().playSound(block.getLocation(), Sound.BLOCK_WEEPING_VINES_BREAK, 1.0f, 0.5f);
        }
        nestRemoval.remove(block);
    }

    @EventHandler
    public void onBlockDropItem(BlockDropItemEvent event) {
        if (nestRemoval.contains(event.getBlock())) {
            event.setCancelled(true);
        }
    }

    public static void spawnNest(BiterNest nest, Location center) {
        World world = center.getWorld();
        int x = -7;
        while (x <= 7) {
            int z = -7;
            while (z <= 7) {
                int y = -5;
                while (y <= 5) {
                    block14: {
                        Block block;
                        block15: {
                            block = world.getBlockAt(x, y * -1, z).getLocation().add(center).getBlock();
                            if (block.getLocation().distanceSquared(center) <= 0.0 || block.getRelative(BlockFace.UP).getType().isSolid() || block.getType().isAir()) break block14;
                            int distance = TUMaths.getManhattanDistance(block.getLocation(), center);
                            if (distance <= 3) break block15;
                            int distanceCancel = (int)((double)distance / 21.0 * 100.0);
                            if (TUMaths.rollRange(0, 99) <= distanceCancel) break block14;
                        }
                        if (block.getType().equals((Object)Material.TALL_GRASS) || block.getType().equals((Object)Material.SHORT_GRASS)) {
                            if (TUMaths.rollRange(0, 99) > 25) {
                                block.setType(Material.CRIMSON_ROOTS);
                            } else {
                                block.setType(Material.WARPED_FUNGUS);
                            }
                            block.getRelative(BlockFace.DOWN).setType(Material.CRIMSON_NYLIUM);
                            nest.addNestBlock(block);
                            nest.addNestBlock(block.getRelative(BlockFace.DOWN));
                        }
                        if (block.getType().equals((Object)Material.FERN)) {
                            if (TUMaths.rollRange(0, 99) > 25) {
                                block.setType(Material.CRIMSON_ROOTS);
                            } else {
                                block.setType(Material.WARPED_FUNGUS);
                            }
                            block.getRelative(BlockFace.DOWN).setType(Material.CRIMSON_NYLIUM);
                            nest.addNestBlock(block);
                            nest.addNestBlock(block.getRelative(BlockFace.DOWN));
                        }
                        if (block.getType().equals((Object)Material.GRASS_BLOCK) || block.getType().equals((Object)Material.DIRT) || block.getType().equals((Object)Material.STONE) || block.getType().equals((Object)Material.SAND)) {
                            block.setType(Material.CRIMSON_NYLIUM);
                            nest.addNestBlock(block);
                            if (TUMaths.rollRange(0, 2) == 0 && block.getRelative(BlockFace.UP).getType().isAir()) {
                                block.getRelative(BlockFace.UP).setType(Material.COBWEB);
                                nest.addNestBlock(block.getRelative(BlockFace.UP));
                            }
                        }
                    }
                    ++y;
                }
                ++z;
            }
            ++x;
        }
        PollutionListener.createBiterDome(nest, center, 5);
    }

    public static void createBiterDome(BiterNest nest, Location center, int radius) {
        World world = center.getWorld();
        int centerX = center.getBlockX();
        int centerY = center.getBlockY();
        int centerZ = center.getBlockZ();
        int x = centerX - radius;
        while (x <= centerX + radius) {
            int y = centerY - radius;
            while (y <= centerY + radius) {
                int z = centerZ - radius;
                while (z <= centerZ + radius) {
                    double distance = Math.sqrt(Math.pow(centerX - x, 2.0) + Math.pow(centerY - y, 2.0) + Math.pow(centerZ - z, 2.0));
                    if (distance <= (double)radius && distance > (double)(radius - 1)) {
                        Block block = world.getBlockAt(x, y, z);
                        if (!block.getType().isSolid()) {
                            if (TUMaths.rollRange(0, 99) <= 25) {
                                block.setType(Material.CRIMSON_HYPHAE);
                            } else {
                                block.setType(Material.NETHER_WART_BLOCK);
                            }
                            nest.addNestBlock(block);
                            if (TUMaths.rollRange(0, 3) == 0 && block.getRelative(BlockFace.UP).getType().isAir()) {
                                block.getRelative(BlockFace.UP).setType(Material.COBWEB);
                                nest.addNestBlock(block.getRelative(BlockFace.UP));
                            }
                            int i = 1;
                            while (i <= 3) {
                                if (!block.getRelative(0, i * -1, 0).getType().isAir() || TUMaths.rollRange(0, 3) == 0) break;
                                block.getRelative(0, i * -1, 0).setType(Material.WEEPING_VINES);
                                nest.addNestBlock(block.getRelative(0, i * -1, 0));
                                ++i;
                            }
                            i = 1;
                            while (i <= 5) {
                                if (block.getRelative(0, i * -1, 0).getType().isAir() && TUMaths.rollRange(0, 3) == 0) {
                                    block.getRelative(0, i * -1, 0).setType(Material.COBWEB);
                                    nest.addNestBlock(block.getRelative(0, i * -1, 0));
                                }
                                ++i;
                            }
                        }
                        int bubbleChance = 5;
                        if (TUMaths.rollRange(0, 99) <= 99) {
                            bubbleChance = 10;
                        }
                        if (y >= (centerY + radius) / 2 && TUMaths.rollRange(0, 99) <= bubbleChance) {
                            ArrayList<Block> blocks = new ArrayList<Block>();
                            blocks.add(block);
                            blocks.add(block.getRelative(BlockFace.UP));
                            blocks.add(block.getRelative(BlockFace.NORTH));
                            blocks.add(block.getRelative(BlockFace.NORTH).getRelative(BlockFace.UP));
                            for (Block block2 : new ArrayList(blocks)) {
                                blocks.add(block2.getRelative(BlockFace.EAST));
                            }
                            for (Block block2 : blocks) {
                                if (block2.getType().isSolid() || PollutionListener.isNestBlock(block2)) continue;
                                block2.setType(Material.DEAD_TUBE_CORAL_BLOCK);
                                nest.addNestBlock(block2);
                            }
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        int doors = TUMaths.rollRange(1, 4);
        int i = 1;
        while (i <= doors) {
            switch (TUMaths.rollRange(1, 4)) {
                case 1: {
                    PollutionListener.addBiterDoor(nest, center, -4, 0);
                    break;
                }
                case 2: {
                    PollutionListener.addBiterDoor(nest, center, 4, 0);
                    break;
                }
                case 3: {
                    PollutionListener.addBiterDoor(nest, center, 0, 4);
                    break;
                }
                case 4: {
                    PollutionListener.addBiterDoor(nest, center, 0, -4);
                }
            }
            ++i;
        }
    }

    private static void addBiterDoor(BiterNest nest, Location center, int x, int z) {
        center = center.clone();
        Location offset = center.add((double)x, 0.0, (double)z);
        offset.getBlock().setType(Material.COBWEB);
        nest.addNestBlock(offset.getBlock());
        offset.getBlock().getRelative(0, 1, 0).setType(Material.AIR);
        nest.addNestBlock(offset.getBlock().getRelative(0, 1, 0));
        offset.getBlock().getRelative(0, 2, 0).setType(Material.COBWEB);
        nest.addNestBlock(offset.getBlock().getRelative(0, 2, 0));
        for (Block block : TUMaths.getNearbyBlocks(offset.getBlock(), 1)) {
            if (!block.getType().isSolid()) continue;
            if (TUMaths.rollRange(0, 1) == 0) {
                block.setType(Material.AIR);
                continue;
            }
            block.setType(Material.COBWEB);
            nest.addNestBlock(block);
        }
        for (Block block : TUMaths.getNearbyBlocks(offset.getBlock().getRelative(0, 1, 0), 1)) {
            if (TUMaths.rollRange(0, 8) == 0) {
                block.setType(Material.AIR);
                continue;
            }
            block.setType(Material.COBWEB);
            nest.addNestBlock(block);
        }
    }

    public static LivingEntity spawnBiter(Location spawnLocation, String biterType) {
        EntityType spawnType = EntityType.SPIDER;
        if (biterType.contains("Spitter")) {
            spawnType = EntityType.CAVE_SPIDER;
        }
        LivingEntity lent = (LivingEntity)spawnLocation.getWorld().spawnEntity(spawnLocation, spawnType);
        lent.setMetadata("MT-Biter", (MetadataValue)new FixedMetadataValue(MineMain.getPlugin(), (Object)biterType));
        lent.setRemoveWhenFarAway(false);
        lent.setPersistent(false);
        PollutionListener.wrapBiter(lent, biterType, "Medium Biter", 8, 2, 0.25);
        PollutionListener.wrapBiter(lent, biterType, "Big Biter", 16, 4, 0.5);
        PollutionListener.wrapBiter(lent, biterType, "Behemoth Biter", 32, 4, 1.0);
        PollutionListener.wrapBiter(lent, biterType, "Small Spitter", 0, 0, 0.1);
        PollutionListener.wrapBiter(lent, biterType, "Medium Spitter", 4, 1, 0.2);
        PollutionListener.wrapBiter(lent, biterType, "Big Spitter", 8, 2, 0.3);
        PollutionListener.wrapBiter(lent, biterType, "Behemoth Spitter", 20, 3, 1.0);
        lent.setHealth(lent.getAttribute(MineMain.version.getMaxHealthAttribute()).getValue());
        return lent;
    }

    private static void wrapBiter(LivingEntity lent, String type, String targetType, int bonusHP, int bonusDNG, double scale) {
        if (type.equals(targetType)) {
            if (bonusHP != 0) {
                AttributeModifier am = new AttributeModifier(hpKey, (double)bonusHP, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.ANY);
                lent.getAttribute(MineMain.version.getMaxHealthAttribute()).addModifier(am);
            }
            if (bonusDNG != 0) {
                AttributeModifier dm = new AttributeModifier(dmgKey, (double)bonusDNG, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.ANY);
                lent.getAttribute(MineMain.version.getAttackAttribute()).addModifier(dm);
            }
            if (MineMain.version.canModifyEntitySize() && scale != 0.0) {
                AttributeModifier ga = new AttributeModifier(scaleKey, scale, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.ANY);
                lent.getAttribute(MineMain.version.getScaleAttribute()).addModifier(ga);
            }
        }
    }
}

