/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx;

import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Battery2;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Transport.ProviderChest;
import com.MT.xxxtrigger50xxx.Devices.Transport.RequesterChest;
import com.MT.xxxtrigger50xxx.Devices.Utility.PowerReceiver;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.Pollution.BiterWaves;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitRunnable;

public class PowerGrid {
    public HashMap<Device, Device> deviceConnections;
    private int power = 0;
    private int lastConsume = 0;
    private int lastGenerate = 0;
    public HashMap<Device, Integer> consumerSources;
    public HashMap<Device, Integer> consumerSourcesLAST = new HashMap();
    public HashMap<Device, Integer> generatorSources;
    public HashMap<Device, Integer> generatorSourcesLAST = new HashMap();
    private HashMap<String, Integer> productionLog = new HashMap();
    private HashMap<Integer, HashMap<String, Integer>> productionLogs = new HashMap();
    private int productionTimer = 0;
    private ArrayList<ProviderChest> pChests = new ArrayList();
    private ArrayList<RequesterChest> rChests = new ArrayList();
    private ArrayList<Device> powerEmitters = new ArrayList();
    private int nextWave = MineMain.waveAttackInterval + TUMaths.rollRange(-MineMain.waveAttackVariance, MineMain.waveAttackVariance);
    private HashMap<Integer, HashMap<String, Integer>> producedSecond = new HashMap();
    private HashMap<Integer, HashMap<String, Integer>> consumedSecond = new HashMap();
    private HashMap<String, Integer> producedLog = new HashMap();
    private HashMap<String, Integer> consumedLog = new HashMap();
    private static String pollutionKey = "Pollution";
    private ArrayList<Battery2> gridBatteries = new ArrayList();
    private ArrayList<PowerReceiver> gridPowerRecievers = new ArrayList();
    private ArrayList<Device> gridPowerProducers = new ArrayList();
    private ArrayList<Device> gridDevices = new ArrayList();

    public PowerGrid(Device device) {
        this.deviceConnections = new HashMap();
        this.consumerSources = new HashMap();
        this.generatorSources = new HashMap();
        if (device == null) {
            return;
        }
        this.addGridDevice(device, null);
        new BukkitRunnable(){

            public void run() {
                if (PowerGrid.this.deviceConnections.keySet().size() == 0) {
                    this.cancel();
                } else {
                    for (Device device : PowerGrid.this.gridDevices) {
                        if (device.getPowerGen() <= 0) continue;
                        device.tickDeviceAction();
                    }
                    for (Device device : PowerGrid.this.gridDevices) {
                        if (device.getPowerGen() > 0) continue;
                        device.tickDeviceAction();
                    }
                    if (PowerGrid.this.power > 0) {
                        PowerGrid.this.chargeGridBatteries();
                    }
                    PowerGrid.this.lastConsume = PowerGrid.this.getConsumeRate();
                    PowerGrid.this.lastGenerate = PowerGrid.this.getGenerationRate();
                    PowerGrid.this.consumerSourcesLAST = new HashMap<Device, Integer>(PowerGrid.this.consumerSources);
                    PowerGrid.this.generatorSourcesLAST = new HashMap<Device, Integer>(PowerGrid.this.generatorSources);
                    PowerGrid.this.generatorSources.clear();
                    PowerGrid.this.consumerSources.clear();
                    PowerGrid.this.productionLogs.put(PowerGrid.this.productionTimer, new HashMap<String, Integer>(PowerGrid.this.productionLog));
                    PowerGrid.this.producedSecond.put(PowerGrid.this.productionTimer, new HashMap<String, Integer>(PowerGrid.this.producedLog));
                    PowerGrid.this.consumedSecond.put(PowerGrid.this.productionTimer, new HashMap<String, Integer>(PowerGrid.this.consumedLog));
                    PowerGrid.this.productionLog.clear();
                    PowerGrid.this.producedLog.clear();
                    PowerGrid.this.consumedLog.clear();
                    ++PowerGrid.this.productionTimer;
                    if (PowerGrid.this.productionTimer >= 60) {
                        PowerGrid.this.productionTimer = 0;
                    }
                    PowerGrid.this.tickWaveSystem();
                }
            }
        }.runTaskTimer(MineMain.getPlugin(), 0L, 20L);
    }

    public HashMap<Device, Integer> getLastConsumers() {
        return new HashMap<Device, Integer>(this.consumerSourcesLAST);
    }

    public HashMap<Device, Integer> getLastGenerators() {
        return new HashMap<Device, Integer>(this.generatorSourcesLAST);
    }

    public void tickWaveSystem() {
        if (!MineMain.useWaveAttacks) {
            return;
        }
        if (this.nextWave <= 0) {
            if (BiterWaves.canBeAttacked(this)) {
                BiterWaves.createWaveAttack(this);
            }
            this.nextWave = MineMain.waveAttackInterval + TUMaths.rollRange(-MineMain.waveAttackVariance, MineMain.waveAttackVariance);
        } else {
            --this.nextWave;
        }
    }

    public HashMap<String, Integer> getMinuteLog() {
        HashMap<String, Integer> log = new HashMap<String, Integer>();
        for (int second : new ArrayList<Integer>(this.productionLogs.keySet())) {
            HashMap itemLog = new HashMap(this.productionLogs.get(second));
            for (String key : new ArrayList(itemLog.keySet())) {
                if (log.containsKey(key)) {
                    log.put(key, log.get(key) + (Integer)itemLog.get(key));
                    continue;
                }
                log.put(key, (Integer)itemLog.get(key));
            }
        }
        return log;
    }

    public HashMap<String, Integer> getMinuteLogNEW() {
        HashMap itemLog;
        HashMap<String, Integer> log = new HashMap<String, Integer>();
        for (int second : new ArrayList<Integer>(this.producedSecond.keySet())) {
            itemLog = new HashMap((Map)this.producedSecond.get(second));
            for (String key : new ArrayList(itemLog.keySet())) {
                log.put(key, itemLog.getOrDefault(key, (Integer)itemLog.get(key)));
            }
        }
        for (int second : new ArrayList<Integer>(this.consumedSecond.keySet())) {
            itemLog = new HashMap(this.consumedSecond.get(second));
            for (String key : new ArrayList(itemLog.keySet())) {
                log.put(key, itemLog.getOrDefault(key, (Integer)itemLog.get(key)));
            }
        }
        return log;
    }

    public HashMap<String, Integer> getMinuteLogType(boolean positive) {
        HashMap<String, Integer> log = new HashMap<String, Integer>();
        for (int second : new ArrayList<Integer>(this.productionLogs.keySet())) {
            HashMap itemLog = new HashMap(this.productionLogs.get(second));
            for (String key : new ArrayList(itemLog.keySet())) {
                int amount = (Integer)itemLog.get(key);
                if (positive && amount < 0 || !positive && amount > 0) continue;
                if (log.containsKey(key)) {
                    log.put(key, log.get(key) + amount);
                    continue;
                }
                log.put(key, amount);
            }
        }
        return log;
    }

    public HashMap<String, Integer> getMinuteLogTypeNEW(boolean positive) {
        HashMap<String, Integer> log = new HashMap<String, Integer>();
        if (positive) {
            for (int second : new ArrayList<Integer>(this.producedSecond.keySet())) {
                HashMap itemLog = new HashMap(this.producedSecond.get(second));
                for (String key : new ArrayList(itemLog.keySet())) {
                    log.put(key, log.getOrDefault(key, 0) + (Integer)itemLog.get(key));
                }
            }
        } else {
            for (int second : new ArrayList<Integer>(this.consumedSecond.keySet())) {
                HashMap itemLog = new HashMap(this.consumedSecond.get(second));
                for (String key : new ArrayList(itemLog.keySet())) {
                    log.put(key, log.getOrDefault(key, 0) + (Integer)itemLog.get(key));
                }
            }
        }
        return log;
    }

    public void logLiquid(Device.LiquidType type, int netChange) {
        String liquidKey = type.toString();
        this.productionLog.put(liquidKey, this.productionLog.getOrDefault(liquidKey, 0) + netChange);
        if (netChange > 0) {
            this.producedLog.put(liquidKey, this.producedLog.getOrDefault(liquidKey, 0) + netChange);
        } else {
            this.consumedLog.put(liquidKey, this.consumedLog.getOrDefault(liquidKey, 0) + netChange);
        }
    }

    public void logPollution(int netChange) {
        this.productionLog.put(pollutionKey, this.productionLog.getOrDefault(pollutionKey, 0) + netChange);
        if (netChange > 0) {
            this.producedLog.put(pollutionKey, this.producedLog.getOrDefault(pollutionKey, 0) + netChange);
        } else {
            this.consumedLog.put(pollutionKey, this.consumedLog.getOrDefault(pollutionKey, 0) + netChange);
        }
    }

    public void logItem(ItemStack stack, int netChange) {
        if (stack == null) {
            new Exception("Null attempted to be logged, send this to Methedex / Trigger").printStackTrace();
            return;
        }
        if (stack.getType().equals((Object)Material.AIR)) {
            new Exception("Air attempted to be logged, send this to Methedex / Trigger").printStackTrace();
            return;
        }
        String key = stack.getType().toString();
        if (stack.hasItemMeta() && stack.getItemMeta().hasDisplayName()) {
            key = ChatColor.stripColor((String)stack.getItemMeta().getDisplayName());
        }
        if (!this.productionLog.containsKey(key)) {
            this.productionLog.put(key, 0);
        }
        int newAmount = this.productionLog.get(key) + netChange;
        this.productionLog.put(key, newAmount);
        if (netChange > 0) {
            this.producedLog.put(key, this.producedLog.getOrDefault(key, 0) + netChange);
        } else {
            this.consumedLog.put(key, this.consumedLog.getOrDefault(key, 0) + netChange);
        }
    }

    public void logItem(ItemStack stack) {
        this.logItem(stack, stack.getAmount());
    }

    private void chargeGridBatteries() {
        this.power = (int)((double)this.power * 0.75);
        if (this.power > 0) {
            for (Battery2 battery : this.getConnectedBatteries()) {
                if (battery.getUncharged() <= 0) continue;
                int chargeAmount = 0;
                chargeAmount = battery.getUncharged() >= this.power ? this.power : battery.getUncharged();
                this.power -= chargeAmount;
                battery.addPower(chargeAmount);
                if (this.power <= 0) break;
            }
        }
        this.power = 0;
    }

    public void addGridDevice(Device device, Device connector) {
        if (!this.deviceConnections.containsKey(device)) {
            this.deviceConnections.put(device, connector);
            this.gridDevices.add(device);
            if (device instanceof Battery2) {
                Battery2 bat = (Battery2)device;
                this.gridBatteries.add(bat);
            }
            if (device instanceof ProviderChest) {
                ProviderChest pc = (ProviderChest)device;
                this.pChests.add(pc);
            }
            if (device instanceof RequesterChest) {
                RequesterChest rc = (RequesterChest)device;
                this.rChests.add(rc);
            }
            if (device instanceof PowerReceiver) {
                PowerReceiver pr = (PowerReceiver)device;
                this.gridPowerRecievers.add(pr);
            }
            if (device.getPowerGen() > 0) {
                this.gridPowerProducers.add(device);
            }
            if (Device.isPowerPylon(device)) {
                this.powerEmitters.add(device);
            }
        }
    }

    public ArrayList<Device> getPowerGenerators() {
        return this.gridPowerProducers;
    }

    private ArrayList<Battery2> getConnectedBatteries() {
        return this.gridBatteries;
    }

    public ArrayList<ProviderChest> getProviderChests() {
        return this.pChests;
    }

    public ArrayList<RequesterChest> getRequesterChests() {
        return this.rChests;
    }

    public void removeDevice(Device removedDevice) {
        if (removedDevice instanceof Battery2) {
            Battery2 bat = (Battery2)removedDevice;
            this.gridBatteries.remove(bat);
        }
        if (removedDevice instanceof ProviderChest) {
            ProviderChest pc = (ProviderChest)removedDevice;
            this.pChests.remove(pc);
        }
        if (removedDevice instanceof RequesterChest) {
            RequesterChest rc = (RequesterChest)removedDevice;
            this.rChests.remove(rc);
        }
        this.gridDevices.remove(removedDevice);
        this.powerEmitters.remove(removedDevice);
        this.gridPowerProducers.remove(removedDevice);
        this.deviceConnections.remove(removedDevice);
        removedDevice.removeFromGrid();
        for (Device connectedDevice : new ArrayList<Device>(this.deviceConnections.keySet())) {
            if (this.deviceConnections.get(connectedDevice) == null || !this.deviceConnections.get(connectedDevice).equals(removedDevice)) continue;
            this.removeDevice(connectedDevice);
        }
    }

    public boolean isGridSource(Device device) {
        return !MineMain.usingPowerSystem() || this.deviceConnections.containsKey(device) && this.deviceConnections.get(device) == null;
    }

    public boolean isConnected(Device device) {
        Device connected;
        if (!MineMain.usingPowerSystem()) {
            return true;
        }
        return this.deviceConnections.containsKey(device) && this.deviceConnections.get(device) != null && !(connected = this.deviceConnections.get(device)).isRemoved();
    }

    public int gridSize() {
        return this.deviceConnections.keySet().size();
    }

    public int getPower() {
        if (!MineMain.usingPowerSystem()) {
            return 100000;
        }
        return this.power;
    }

    public boolean hasPower(int power) {
        if (!MineMain.usingPowerSystem()) {
            return true;
        }
        int needed = power;
        if (this.power >= needed) {
            return true;
        }
        if (this.batteryPower() >= (needed -= this.power)) {
            return true;
        }
        return this.recieverPower() >= (needed -= this.batteryPower());
    }

    public void consumePower(Device consumer, int power) {
        if (!MineMain.usingPowerSystem()) {
            return;
        }
        if (this.power >= power) {
            this.power -= power;
            if (this.power < 0) {
                this.power = 0;
            }
            this.consumerSources.put(consumer, this.consumerSources.getOrDefault(consumer, 0) + power);
        } else {
            int needed = power;
            if (this.batteryPower() + this.recieverPower() >= needed) {
                needed -= this.power;
                this.power = 0;
                this.consumerSources.put(consumer, this.consumerSources.getOrDefault(consumer, 0) + power);
                boolean batteriesCovered = false;
                for (Battery2 battery : this.getConnectedBatteries()) {
                    if (battery.getStored() <= 0) continue;
                    if (battery.getStored() >= needed) {
                        battery.removePower(needed);
                        batteriesCovered = true;
                        break;
                    }
                    needed -= battery.getStored();
                    battery.removePower(battery.getStored());
                }
                if (!batteriesCovered && needed > 0) {
                    for (PowerReceiver pr : this.gridPowerRecievers) {
                        if (pr.getStoredPower() <= 0) continue;
                        if (pr.getStoredPower() >= needed) {
                            pr.consumePower(needed);
                            break;
                        }
                        needed -= pr.getStoredPower();
                        pr.consumePower(pr.getStoredPower());
                    }
                }
            }
        }
    }

    public void addPower(Device device, int power) {
        this.generatorSources.put(device, power);
        this.power += power;
        device.lastGen = power;
    }

    public int batteryPower() {
        if (!MineMain.usingPowerSystem()) {
            return 100000;
        }
        int amount = 0;
        for (Battery2 device : this.getConnectedBatteries()) {
            amount += device.getStored();
        }
        return amount;
    }

    public int recieverPower() {
        if (!MineMain.usingPowerSystem()) {
            return 100000;
        }
        int amount = 0;
        for (PowerReceiver pr : new ArrayList<PowerReceiver>(this.gridPowerRecievers)) {
            amount += pr.getStoredPower();
        }
        return amount;
    }

    public int batteryMaxCapacity() {
        if (!MineMain.usingPowerSystem()) {
            return 100000;
        }
        int amount = 0;
        for (Device device : new ArrayList<Device>(this.deviceConnections.keySet())) {
            if (!(device instanceof Battery2)) continue;
            Battery2 battery = (Battery2)device;
            amount += battery.getCapacity();
        }
        return amount;
    }

    public int getGenerationRate() {
        int rate = 0;
        for (Device device : this.generatorSources.keySet()) {
            rate += this.generatorSources.get(device).intValue();
        }
        return rate;
    }

    public int getConsumeRate() {
        int rate = 0;
        for (Device device : this.consumerSources.keySet()) {
            rate += this.consumerSources.get(device).intValue();
        }
        return rate;
    }

    public int getLastConsume() {
        return this.lastConsume;
    }

    public int getLastGenerate() {
        return this.lastGenerate;
    }

    public HashMap<Device, Device> getConnectedDevices() {
        return new HashMap<Device, Device>(this.deviceConnections);
    }

    public int getPotentialLoad() {
        int load = 0;
        for (Device device : this.getConnectedDevices().keySet()) {
            if (device.getActionPower() > device.getIdlePower() && device.getActionPower() != 0) {
                load += device.getActionPower() * (device.getOverDrive() + 1);
                continue;
            }
            if (device.getIdlePower() <= device.getActionPower() || device.getIdlePower() == 0) continue;
            load += device.getIdlePower();
        }
        return load;
    }

    public int getPotentialGeneration() {
        int generator = 0;
        for (Device device : this.getConnectedDevices().keySet()) {
            if (device.getPowerGen() <= 0) continue;
            generator += device.getPowerGen();
        }
        return generator;
    }

    public int getGridScore() {
        int score = 0;
        for (Device device : this.getConnectedDevices().keySet()) {
            score += device.getGridScore();
        }
        return score;
    }

    public static void constructGrids() {
        int maxRun = 200;
        while (maxRun > 0) {
            boolean change = false;
            for (Device device : Device.getDevicesREADONLY()) {
                if (!device.tickGrid()) continue;
                change = true;
            }
            if (!change) break;
            --maxRun;
        }
        HashSet<PowerGrid> grids = new HashSet<PowerGrid>();
        for (Device device : Device.getDevicesREADONLY()) {
            grids.add(device.getGrid());
        }
    }

    public ArrayList<Device> getPowerEmitters() {
        return this.powerEmitters;
    }

    public static void constructGrids2() {
    }

    public static List<List<Device>> groupDevices(List<Device> devices) {
        ArrayList<List<Device>> groups = new ArrayList<List<Device>>();
        HashSet<Device> visited = new HashSet<Device>();
        for (Device device : devices) {
            if (visited.contains(device)) continue;
            ArrayList<Device> group = new ArrayList<Device>();
            PowerGrid.explore(device, devices, visited, group);
            groups.add(group);
        }
        return groups;
    }

    private static void explore(Device start, List<Device> allDevices, Set<Device> visited, List<Device> group) {
        LinkedList<Device> queue = new LinkedList<Device>();
        queue.add(start);
        visited.add(start);
        while (!queue.isEmpty()) {
            Device current = (Device)queue.poll();
            group.add(current);
            for (Device other : allDevices) {
                if (visited.contains(other) || !PowerGrid.isConnected(current, other) || !PowerGrid.sameOwner(current, other)) continue;
                visited.add(other);
                queue.add(other);
            }
        }
    }

    private static boolean isConnected(Device a, Device b) {
        return MineUtil.isWithinCubeRange(a.getLocationREADONLY(), b.getLocationREADONLY(), Device.getPowerRange(a)) || MineUtil.isWithinCubeRange(a.getLocationREADONLY(), b.getLocationREADONLY(), Device.getPowerRange(b));
    }

    private static boolean sameOwner(Device a, Device b) {
        return a.getPlacerUUID().equals(b.getPlacerUUID());
    }
}

