/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices;

import com.MT.triggersUtility.Events.TUEvents;
import com.MT.triggersUtility.Saveable;
import com.MT.triggersUtility.SkullCreator;
import com.MT.triggersUtility.TUInterface.TUInventory;
import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Battery2;
import com.MT.xxxtrigger50xxx.Devices.Generators.CombustionGenerator;
import com.MT.xxxtrigger50xxx.Devices.Generators.HeatExchanger;
import com.MT.xxxtrigger50xxx.Devices.Generators.HeavySteamGenerator;
import com.MT.xxxtrigger50xxx.Devices.Generators.NuclearReactor;
import com.MT.xxxtrigger50xxx.Devices.Generators.PetroleumEngine;
import com.MT.xxxtrigger50xxx.Devices.Generators.SteamEngine;
import com.MT.xxxtrigger50xxx.Devices.Lift;
import com.MT.xxxtrigger50xxx.Devices.Liquids.Boiler;
import com.MT.xxxtrigger50xxx.Devices.Liquids.Pump;
import com.MT.xxxtrigger50xxx.Devices.Manufactoring.CrudeAssembler;
import com.MT.xxxtrigger50xxx.Devices.Mover;
import com.MT.xxxtrigger50xxx.Devices.PowerPylon;
import com.MT.xxxtrigger50xxx.Devices.PowerPylonMk2;
import com.MT.xxxtrigger50xxx.Devices.PowerSubstation;
import com.MT.xxxtrigger50xxx.Devices.Producers.DeepDrill;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.LocaleUtil;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Planets.PlanetHandler;
import com.MT.xxxtrigger50xxx.PlayerData;
import com.MT.xxxtrigger50xxx.Pollution.BiterNest;
import com.MT.xxxtrigger50xxx.Pollution.SuperChunk;
import com.MT.xxxtrigger50xxx.PowerGrid;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Technology.ResearchLab;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Furnace;
import org.bukkit.block.data.Directional;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Transformation;
import org.bukkit.util.Vector;

public abstract class Device
extends Saveable {
    private static final long serialVersionUID = -8432590091722449941L;
    protected Material materialType;
    protected String deviceName = "Device";
    private String location;
    private String failReason = "None";
    private ArrayList<Integer> inputSlotNumbers;
    private ArrayList<Integer> outputSlotNumbers;
    private ArrayList<Integer> clickableSlots;
    private int uiSize = 3;
    private int idlePower;
    private int actionPower = 0;
    private int powerGen = 0;
    private int actionTimer = 0;
    private int timer;
    private int pollutionGen = 0;
    public int lastGen = 0;
    private boolean removed = false;
    private boolean useUI = false;
    private boolean allowOpen = false;
    private boolean powered = false;
    private boolean refreshInv;
    private boolean needsPower = false;
    private boolean producingPower = false;
    private boolean consumingPower = false;
    private int gridRange = 0;
    private transient PowerGrid powerGrid = null;
    private boolean storeForm = true;
    private boolean usingAutoUI = false;
    private transient boolean firstRender = true;
    private transient Location cachedLocation;
    public transient Inventory inv = null;
    private static HashMap<Location, Device> allDevices = new HashMap();
    private static ArrayList<Device> readDevices = new ArrayList();
    private static ArrayList<Device> readPylons = new ArrayList();
    private HashMap<LiquidType, Integer> storedLiquids;
    private HashMap<LiquidType, Integer> maxLiquids;
    private boolean allowPowerIndicator = true;
    private String placerUUID = null;
    private PoweredState state = PoweredState.ON;
    public boolean chainingMoverBehavior = false;
    public boolean standardMoverBehavior = false;
    public boolean builtInPylon = false;
    public int builtInPylonRange = 0;
    private ArrayList<String> tags = new ArrayList();
    public static HashMap<Class<?>, Device> allDeviceClasss = new HashMap();
    public static HashMap<String, HashSet<Device>> pendingDevices = new HashMap();
    private boolean useDeviceCrowding = false;
    private int lastCrowding = 0;
    public int crowdingDistance = 25;
    private transient boolean initialTickingComplete = false;
    private transient boolean ranValidation = false;
    private transient int invStoreTimer = 0;
    public boolean useSpecificInputs = false;
    private HashSet<String> specificInputs;
    private transient boolean addedTicket = false;
    private transient SuperChunk sc;
    private HashMap<Integer, String> strItems = new HashMap();
    private transient ArrayList<Device> cachedNearbyDevices = new ArrayList();
    private transient ArrayList<Device> cachedNearbySharedDevices = new ArrayList();
    public static int duplicateDevices = 0;
    public static NamespacedKey isDeviceItemKey = new NamespacedKey(MineMain.getPlugin(), "MT_IS_DEVICE");
    private transient ItemStack cachedDeviceStack;
    private transient ItemStack cachedDeviceStackAsPrototype;
    private int overDrive = 0;
    private transient UUID uuid;
    public static NamespacedKey iconStackKey = new NamespacedKey(MineMain.getPlugin(), "MTIconKey");
    public static VisualType visualType = VisualType.DISPLAY;
    private transient Entity visualItem;
    private static int saveTimer = 605;
    private transient boolean upgradedPylon = false;
    private transient boolean linkedSameFacing = false;
    private transient Location pylonSegment1;
    private transient Location pylonSegment2;
    private transient Device linkedPylon;
    private transient Device incomingPylon;
    private transient BlockDisplay wire1;
    private transient BlockDisplay wire2;
    private BlockFace cachedFacing;
    public int displayRotationOffset = 0;
    public int displayYawOffset = 0;
    public float displayYScaleShift = 0.0f;
    public boolean displayLockedHorizontal = false;
    public boolean lockRotation = false;
    private String displayStackString = null;
    private transient ItemDisplay linkedDisplay;
    private transient ItemStack tempDisplayStack;
    private String headDevValue = null;
    private transient TextDisplay textDisplay;
    private transient Location textLocation;

    public Device(final Location loc) {
        super("Device Data", TUMaths.locationString(loc, "UTILITY").replace("/", "=="));
        this.materialType = Material.CRAFTING_TABLE;
        this.inputSlotNumbers = new ArrayList();
        this.outputSlotNumbers = new ArrayList();
        this.clickableSlots = new ArrayList();
        this.timer = TUMaths.rollRange(0, this.actionTimer);
        this.storedLiquids = new HashMap();
        this.maxLiquids = new HashMap();
        if (loc != null) {
            this.location = TUMaths.locationString(loc);
            Device.addDevice(this);
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    Block block = loc.getBlock();
                    BlockState blockState = block.getState();
                    if (blockState instanceof Furnace) {
                        Furnace furnace = (Furnace)blockState;
                        furnace.setCustomName(MineItems.whiteBold() + Device.this.deviceName);
                        furnace.update();
                    }
                }
            }, 1L);
        } else {
            this.setSave(false);
            this.setDelete(true);
            allDeviceClasss.put(this.getClass(), this);
        }
    }

    public Material getPlaceType() {
        return this.materialType;
    }

    @Override
    public void onCreate(boolean isFirstTime) {
        if (!isFirstTime) {
            String worldName = TUMaths.getWorldNameFromLOCString(this.location);
            if (worldName != null) {
                World world = Bukkit.getWorld((String)worldName);
                if (world != null) {
                    this.loadDevice();
                } else {
                    if (!pendingDevices.containsKey(worldName)) {
                        pendingDevices.put(worldName, new HashSet());
                    }
                    pendingDevices.get(worldName).add(this);
                }
            }
        } else {
            this.runPostCreate();
        }
    }

    public void loadDevice() {
        if (this.isRemoved()) {
            return;
        }
        if (this.getPoweredState() == null) {
            this.setPoweredState(PoweredState.ON);
        }
        Device.addDevice(this);
        long delay = 101L;
        if (this.powerGen > 0) {
            delay = 100L;
        }
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

            @Override
            public void run() {
                if (Device.this.location == null) {
                    return;
                }
                Device.this.setOverDrive(0);
                Device.this.compute();
            }
        }, delay);
        this.runPostCreate();
    }

    private void runPostCreate() {
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

            @Override
            public void run() {
                if (Device.this.location == null || Device.this.isRemoved()) {
                    return;
                }
                if (Device.this.getHeadDevValue() != null && !MineItems.itemMaterial.containsKey(Device.this.deviceName)) {
                    Device.this.setDisplayStackString(SkullCreator.getHead(Device.this.getHeadDevValue()));
                    Device.this.handleDisplay();
                }
                Device.this.postCreate(false);
            }
        }, 1L);
    }

    public void postCreate(boolean isFirstTime) {
    }

    public double getCrowdingEffeciency(double penaltyPer) {
        double eff = 1.0 - (double)this.lastCrowding * penaltyPer;
        if (eff < 0.0) {
            eff = 0.0;
        }
        return eff;
    }

    public void compute() {
        if (this.inv == null) {
            this.recreateInv();
        }
        this.save();
        this.addedTicket = false;
        if (this.removed) {
            this.removeDevice();
            return;
        }
        this.updatePylonUpgrade();
        new BukkitRunnable(){

            public void run() {
                boolean gridChanged;
                OfflinePlayer player;
                if (Device.this.removed) {
                    this.cancel();
                    return;
                }
                ++Device.this.invStoreTimer;
                if (TUMaths.isMultipleOf(Device.this.invStoreTimer, 600)) {
                    Device.this.storePhysicalForm();
                }
                Location deviceLocation = Device.this.getLocationREADONLY();
                boolean nearby = MinetorioListener.isPlayerNearbyOPT(deviceLocation, 64.0);
                Device.this.handleDisplay();
                if (MineMain.useDeviceTextIcons) {
                    Device.this.handleTextDisplay();
                }
                if (MineMain.devicesDisableOffline && TUMaths.isMultipleOf(TUEvents.serverTimeSeconds, 600) && Device.this.getPlacerUUIDString() != null && !(player = Bukkit.getOfflinePlayer((UUID)UUID.fromString(Device.this.getPlacerUUIDString()))).isOnline() && !player.isOp()) {
                    return;
                }
                if (MineMain.requireLoadedChunks && !MinetorioListener.isPlayerNearbyOPT(deviceLocation, MineMain.chunkViewDistance)) {
                    return;
                }
                Device.this.tickPylonUpgrade();
                if (Device.this.useDeviceCrowding && nearby) {
                    Device.this.lastCrowding = Device.getNearbyDevicesByType(deviceLocation, Device.this.crowdingDistance, Device.this.getName()).size() - 1;
                }
                if (nearby || !Device.this.ranValidation) {
                    Device.this.ranValidation = true;
                    Material currentMat = deviceLocation.getBlock().getType();
                    if (Device.this.getMaterial() != null && !Device.this.getMaterial().equals((Object)currentMat)) {
                        boolean isCauldron = false;
                        if (Device.this.getMaterial().equals((Object)Material.CAULDRON) && (currentMat.equals((Object)Material.LAVA_CAULDRON) || currentMat.equals((Object)Material.WATER_CAULDRON))) {
                            isCauldron = true;
                        }
                        if (!isCauldron) {
                            Device.this.onDeviceRemove();
                            Device.this.cleanup();
                            Device.this.iconCleanup();
                            Device.this.removeDevice();
                            Device.this.removeLinkedDisplay();
                            return;
                        }
                    }
                }
                if (!(!nearby && Device.this.initialTickingComplete || !Device.this.allowGridConnectionTick() || (gridChanged = Device.this.tickGrid()) || Device.this.initialTickingComplete)) {
                    Device.this.initialTickingComplete = true;
                }
                if (Device.this.getGrid() == null) {
                    Device.this.noGridTick();
                }
                Device.this.visualUpdate(nearby);
                Device.this.playerNearbyUpdate(nearby);
                Device.this.ticketChunk(nearby);
            }
        }.runTaskTimer(MineMain.getPlugin(), 0L, 20L);
    }

    public void noGridTick() {
    }

    public void tickDeviceAction() {
        this.tickActivePower();
        this.deviceActionTick(MinetorioListener.isPlayerNearbyOPT(this.getLocationREADONLY(), 64.0));
    }

    private void ticketChunk(boolean nearby) {
        if (nearby) {
            if (!this.addedTicket) {
                this.addedTicket = this.getLocationREADONLY().getChunk().addPluginChunkTicket(MineMain.getPlugin());
            }
        } else if (this.addedTicket) {
            this.getLocationREADONLY().getChunk().removePluginChunkTicket(MineMain.getPlugin());
            this.addedTicket = false;
        }
    }

    private void tickActivePower() {
        boolean hasActivePower = false;
        if (MineMain.usingPowerSystem()) {
            if (this.isNeedsPower()) {
                this.powered = false;
                if (this.getIdlePower() > 0) {
                    if (this.getGrid() != null && this.getGrid().hasPower(this.getIdlePower())) {
                        if (this.getPoweredState().equals((Object)PoweredState.ON)) {
                            this.getGrid().consumePower(this, this.getIdlePower());
                        }
                        this.powered = true;
                    }
                } else {
                    this.powered = true;
                }
                if (this.getActionPower() > 0) {
                    if (this.getGrid() != null && this.getGrid().hasPower(this.getActionPower())) {
                        hasActivePower = true;
                    }
                } else {
                    hasActivePower = true;
                }
            } else {
                this.powered = true;
                hasActivePower = true;
            }
        } else {
            this.powered = true;
            hasActivePower = true;
        }
        if (!this.powered || !hasActivePower) {
            this.failReason = "Not Enough Power";
        } else if (this.failReason.equals("Not Enough Power")) {
            this.failReason = "None";
        }
    }

    private void deviceActionTick(boolean nearby) {
        long delay = 0L;
        this.setConsumingPower(false);
        if (this.actionTimer != 0) {
            Device dev = this;
            --dev.timer;
            if (this.timer <= 0) {
                this.timer = this.actionTimer;
                if (nearby && !this.isPowered() && MinetorioListener.isPlayerNearbyOPT(this.getLocationREADONLY(), 32.0)) {
                    this.spawnInactiveParticles();
                }
                if (this.isPowered()) {
                    this.failReason = "None";
                }
                if (dev.getPoweredState().equals((Object)PoweredState.ON)) {
                    delay = this.overDriveAction();
                } else {
                    this.failReason = this.getPoweredStateString();
                    this.actionNotPowered();
                }
            }
        }
        if ((nearby || this.firstRender) && (this.getInventory().getViewers().size() > 0 || this.firstRender)) {
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    if (Device.this.isRefreshInv()) {
                        Device.this.inv.clear();
                    }
                    Device.this.updateUI();
                    Device.this.firstRender = false;
                }
            }, delay + 1L);
        }
    }

    public boolean allowGridConnectionTick() {
        return true;
    }

    public void actionNotPowered() {
    }

    public boolean hasSpecificInputs() {
        return this.specificInputs != null && this.specificInputs.size() > 0;
    }

    public void addSpecificInput(ItemStack stack) {
        if (this.specificInputs == null) {
            this.specificInputs = new HashSet();
        }
        ItemStack stack2 = stack.clone();
        stack2.setAmount(1);
        this.specificInputs.add(TUItems.createStackString(stack2));
    }

    public void removeSpecificInput(ItemStack stack) {
        if (this.specificInputs == null) {
            this.specificInputs = new HashSet();
        }
        ItemStack stack2 = stack.clone();
        stack2.setAmount(1);
        this.specificInputs.remove(TUItems.createStackString(stack2));
    }

    public boolean isSpecificInput(ItemStack stack) {
        ItemStack stack2 = stack.clone();
        stack2.setAmount(1);
        return this.specificInputs.contains(TUItems.createStackString(stack2));
    }

    private long overDriveAction() {
        long longestDelay = 0L;
        if (this.getEffectiveDrive() > 0) {
            int i = 0;
            while (i <= this.getEffectiveDrive()) {
                long delay = 20 / (this.getEffectiveDrive() + 1);
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        Device.this.action();
                        Device.this.createPollution();
                    }
                }, delay * (long)(i + 1));
                longestDelay = delay * (long)(i + 1);
                ++i;
            }
        } else {
            this.action();
            this.createPollution();
        }
        return longestDelay;
    }

    public void createPollution(boolean forced) {
        if (!MineMain.usePollution) {
            return;
        }
        if (this.getPollutionGen() > 0) {
            if (MineMain.hasAnyNoPollution && MineMain.disabledPollutionWorlds.contains(this.getLocationREADONLY().getWorld().toString())) {
                return;
            }
            if (this.isConsumingPower() || this.isProducingPower() || forced) {
                if (this.sc == null) {
                    this.sc = SuperChunk.getSuperChunk(this.getLocation());
                }
                int pollution = (int)((double)this.getPollutionGen() * MineMain.pollutionMP);
                this.sc.addPollution(pollution);
                this.sc.addPollutingLocation(this.getLocation());
                if (this.getGrid() != null) {
                    this.getGrid().logPollution(pollution);
                }
            }
        }
    }

    public void createPollution() {
        this.createPollution(false);
    }

    public void recreateInv() {
        this.inv = TUInventory.createInventory(MineItems.uiTitle() + this.deviceName, this.uiSize, "MTINV:" + this.deviceName);
    }

    public boolean tickGrid() {
        PowerGrid largestGrid = null;
        Device connector = null;
        UUID uuid = null;
        if (this.getPlacerUUIDString() != null) {
            uuid = UUID.fromString(this.getPlacerUUIDString());
        }
        for (Device localDevice : this.getNearbySharedPylons(uuid)) {
            if (localDevice.getGrid() == null) continue;
            if (largestGrid == null) {
                largestGrid = localDevice.getGrid();
                connector = localDevice;
                continue;
            }
            if (localDevice.getGrid().gridSize() <= largestGrid.gridSize()) continue;
            largestGrid = localDevice.getGrid();
            connector = localDevice;
        }
        if (this.powerGrid != null) {
            if (!this.powerGrid.isGridSource(this)) {
                if (!this.powerGrid.isConnected(this)) {
                    this.disconnectFromGrid();
                } else if (largestGrid != null && this.powerGrid.gridSize() < largestGrid.gridSize()) {
                    this.disconnectFromGrid();
                }
            } else if (largestGrid != null && this.powerGrid.gridSize() < largestGrid.gridSize()) {
                this.disconnectFromGrid();
            }
        }
        if (this.powerGrid == null) {
            if (largestGrid != null) {
                this.powerGrid = largestGrid;
                this.powerGrid.addGridDevice(this, connector);
            } else if (Device.isPowerPylon(this)) {
                this.powerGrid = new PowerGrid(this);
            }
            return true;
        }
        return false;
    }

    public void disconnectFromGrid() {
        if (this.powerGrid == null) {
            return;
        }
        this.powerGrid.removeDevice(this);
        this.powerGrid = null;
    }

    public void removeFromGrid() {
        this.powerGrid = null;
    }

    public abstract ArrayList<String> stackDescription();

    public abstract void updateUI();

    public abstract void action();

    public boolean onWireRightClick(PlayerInteractEvent event) {
        return false;
    }

    public boolean onLeftClick(PlayerInteractEvent event) {
        return false;
    }

    public boolean onRightClick(PlayerInteractEvent event) {
        return false;
    }

    public void visualUpdate(boolean nearbyPlayer) {
    }

    public void playerNearbyUpdate(boolean nearbyPlayer) {
    }

    public void cleanup() {
    }

    public int getGridScore() {
        return 1;
    }

    public void onDeviceRemove() {
    }

    public Location getLocation() {
        if (this.cachedLocation == null) {
            this.cachedLocation = TUMaths.getStringLocation(this.location);
        }
        return this.cachedLocation.clone();
    }

    public Location getLocationREADONLY() {
        if (this.cachedLocation == null) {
            this.cachedLocation = TUMaths.getStringLocation(this.location);
        }
        return this.cachedLocation;
    }

    public Inventory getInventory() {
        if (this.inv == null) {
            this.recreateInv();
        }
        return this.inv;
    }

    public void setInputSlots(ArrayList<Integer> slots) {
        this.inputSlotNumbers = slots;
    }

    public void setOutputSlots(ArrayList<Integer> slots) {
        this.outputSlotNumbers = slots;
    }

    public void setClickableSlots(ArrayList<Integer> slots) {
        this.clickableSlots = slots;
    }

    public ArrayList<Integer> getOutSlots() {
        return new ArrayList<Integer>(this.outputSlotNumbers);
    }

    public ArrayList<Integer> getInSlots() {
        return new ArrayList<Integer>(this.inputSlotNumbers);
    }

    public ArrayList<ItemStack> getInputItemsAsClones() {
        ArrayList<ItemStack> inputItems = new ArrayList<ItemStack>();
        Inventory inv = this.getInventory();
        for (int i : new ArrayList<Integer>(this.inputSlotNumbers)) {
            if (!TUItems.isValid(inv.getItem(i))) continue;
            inputItems.add(inv.getItem(i).clone());
        }
        return new ArrayList<ItemStack>(inputItems);
    }

    public ArrayList<ItemStack> getInputItems() {
        ArrayList<ItemStack> inputItems = new ArrayList<ItemStack>();
        Inventory inv = this.getInventory();
        for (int i : new ArrayList<Integer>(this.inputSlotNumbers)) {
            if (!TUItems.isValid(inv.getItem(i))) continue;
            inputItems.add(inv.getItem(i));
        }
        return new ArrayList<ItemStack>(inputItems);
    }

    public int getOutputSlot() {
        for (int i : new ArrayList<Integer>(this.outputSlotNumbers)) {
            if (TUItems.isValid(this.getInventory().getItem(i))) continue;
            return i;
        }
        return -1;
    }

    public int getInputSlot() {
        for (int i : new ArrayList<Integer>(this.inputSlotNumbers)) {
            if (TUItems.isValid(this.getInventory().getItem(i))) continue;
            return i;
        }
        return -1;
    }

    public int openSlotCount() {
        int count = 0;
        for (int i : new ArrayList<Integer>(this.outputSlotNumbers)) {
            if (TUItems.isValid(this.getInventory().getItem(i))) continue;
            ++count;
        }
        return count;
    }

    public ArrayList<ItemStack> getOutputItems() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i : new ArrayList<Integer>(this.outputSlotNumbers)) {
            if (this.getInventory().getItem(i) == null || this.getInventory().getItem(i).getType().equals((Object)Material.AIR)) continue;
            stacks.add(this.getInventory().getItem(i));
        }
        return stacks;
    }

    public ItemStack removeOutputItem(ItemStack stack) {
        for (int i : new ArrayList<Integer>(this.outputSlotNumbers)) {
            if (this.getInventory().getItem(i).getType().equals((Object)Material.AIR)) continue;
            ItemStack removed = this.getInventory().getItem(i);
            this.getInventory().setItem(i, new ItemStack(Material.AIR));
            return removed;
        }
        return null;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void removeDevice() {
        if (this.getGrid() != null) {
            this.getGrid().removeDevice(this);
        }
        readDevices.remove(this);
        readPylons.remove(this);
        if (this.getLocationREADONLY() != null) {
            allDevices.remove(this.getLocation());
        }
        this.removeLinkedDisplay();
        this.removeWires();
        this.removeVisualItem();
        this.removeTextDisplay();
        this.removed = true;
        this.setLoadOnStart(false);
        this.getFile().delete();
        this.remove();
    }

    public boolean isClickableSlot(int slot) {
        for (int i : new ArrayList<Integer>(this.clickableSlots)) {
            if (i != slot) continue;
            return true;
        }
        return false;
    }

    public String getFailReason() {
        return this.failReason;
    }

    public void setFailReason(String failReason) {
        this.failReason = failReason;
    }

    public void recreatePhysicalForm() {
        this.recreateInv();
        if (this.isStoreForm()) {
            for (Integer slot : this.strItems.keySet()) {
                ItemStack stack = TUItems.createStackFromString(this.strItems.get(slot));
                this.inv.setItem(slot.intValue(), stack);
            }
        }
    }

    public void storePhysicalForm() {
        if (this.isStoreForm()) {
            this.strItems.clear();
            if (this.inv == null) {
                return;
            }
            int i = 0;
            while (i < this.inv.getSize()) {
                ItemStack stack = this.inv.getItem(i);
                if (stack != null && !stack.getType().equals((Object)Material.AIR)) {
                    this.strItems.put(i, TUItems.createStackString(stack));
                }
                ++i;
            }
        }
    }

    public void setActionTimer(int seconds) {
        this.actionTimer = seconds;
        this.timer = seconds;
    }

    public int getActionTimer() {
        return this.actionTimer;
    }

    public int getCurrentTimer() {
        return this.timer;
    }

    public void setCurrentTimer(int time) {
        this.timer = time;
    }

    public static HashSet<Device> getDevices() {
        return new HashSet<Device>(allDevices.values());
    }

    public static ArrayList<Device> getDevicesREADONLY() {
        return readDevices;
    }

    public static ArrayList<Device> getPylonsREADONLY() {
        return readPylons;
    }

    public static ArrayList<Device> getDevices(String name) {
        ArrayList<Device> devices = new ArrayList<Device>();
        for (Device device : Device.getDevices()) {
            if (!device.deviceName.equals(name)) continue;
            devices.add(device);
        }
        return devices;
    }

    public ArrayList<Device> getNearbyDevices() {
        if (this.cachedNearbyDevices != null && !TUMaths.isPlayerNearby(this.getLocation(), 20.0)) {
            return this.cachedNearbyDevices;
        }
        ArrayList<Device> devices = new ArrayList<Device>();
        Location refLocation = null;
        for (Device device : Device.getDevicesREADONLY()) {
            Location devLocation;
            if (refLocation == null) {
                refLocation = this.getLocation();
            }
            if (TUMaths.getManhattanDistance(devLocation = device.getLocation(), refLocation) <= device.getGridRange()) {
                devices.add(device);
                continue;
            }
            if (TUMaths.getManhattanDistance(devLocation, refLocation) > this.getGridRange()) continue;
            devices.add(device);
        }
        this.cachedNearbyDevices = devices;
        return devices;
    }

    public ArrayList<Device> getNearbySharedDevices(UUID placer) {
        if (this.cachedNearbySharedDevices != null && !TUMaths.isPlayerNearby(this.getLocation(), 20.0)) {
            return this.cachedNearbySharedDevices;
        }
        ArrayList<Device> devices = this.getNearbyDevices();
        for (Device device : new ArrayList<Device>(devices)) {
            if (device.isAuthorized(placer)) continue;
            devices.remove(device);
        }
        this.cachedNearbySharedDevices = devices;
        return devices;
    }

    public static int getPowerRange(Device device) {
        if (device instanceof PowerPylon) {
            if (device instanceof PowerPylonMk2) {
                return 25;
            }
            if (device instanceof PowerSubstation) {
                PowerSubstation ps = (PowerSubstation)device;
                return ps.getGridRange();
            }
            return 15;
        }
        if (device.builtInPylon) {
            return device.builtInPylonRange;
        }
        return 0;
    }

    public static int getPylonRange(Device device) {
        if (device instanceof PowerPylon) {
            int range = 22;
            if (device instanceof PowerPylonMk2) {
                range = 37;
            }
            if (device instanceof PowerSubstation) {
                PowerSubstation ps = (PowerSubstation)device;
                range = ps.getGridRange() + ps.getGridRange() / 2;
            }
            if (device.isUpgradedPylon()) {
                range *= 3;
            }
            return range;
        }
        if (device.builtInPylon) {
            return (int)((double)device.builtInPylonRange * 0.9);
        }
        return 0;
    }

    public ArrayList<Device> getNearbySharedPylons(UUID placer) {
        ArrayList<Device> devices = new ArrayList<Device>();
        int range = Device.getPylonRange(this);
        for (Device device : Device.getPylonsREADONLY()) {
            if (!Device.isPowerPylon(device) || !MineUtil.isWithinCubeRange(this.getLocationREADONLY(), device.getLocationREADONLY(), Device.getPowerRange(device)) && (range == 0 || !MineUtil.isWithinCubeRange(this.getLocationREADONLY(), device.getLocationREADONLY(), range)) || device.getPlacerUUIDString() == null) continue;
            if (device.getPlacerUUID().equals(placer)) {
                devices.add(device);
                continue;
            }
            if (!device.isAuthorized(placer)) continue;
            devices.add(device);
        }
        return devices;
    }

    public static boolean isPowerPylon(Device device) {
        if (device.builtInPylon) {
            return true;
        }
        return device instanceof PowerPylon || device instanceof PowerPylonMk2 || device instanceof PowerSubstation;
    }

    public static ArrayList<PowerGrid> getNearbySharedGrids(UUID who, Location loc, int range) {
        ArrayList<PowerGrid> grids = new ArrayList<PowerGrid>();
        for (Device device : Device.getDevicesREADONLY()) {
            if (TUMaths.getManhattanDistance(loc, device.getLocationREADONLY()) > range || device.getPlacerUUIDString() == null || device.getGrid() == null || device.getGrid() != null && grids.contains(device.getGrid())) continue;
            if (device.getPlacerUUIDString().equals(who.toString())) {
                grids.add(device.getGrid());
                continue;
            }
            if (!device.isAuthorized(who)) continue;
            grids.add(device.getGrid());
        }
        return grids;
    }

    public static ArrayList<Device> getNearbySharedDevices(UUID who, Location loc, int range) {
        ArrayList<Device> devices = new ArrayList<Device>();
        for (Device device : Device.getDevicesREADONLY()) {
            if (TUMaths.getManhattanDistance(loc, device.getLocationREADONLY()) > range || device.getPlacerUUIDString() == null) continue;
            if (device.getPlacerUUIDString().equals(who.toString())) {
                devices.add(device);
                continue;
            }
            if (!device.isAuthorized(who)) continue;
            devices.add(device);
        }
        return devices;
    }

    public static ArrayList<Device> getNearbyDevices(Location loc, int range, boolean removeBugs, String requiredName) {
        ArrayList<Device> devices = new ArrayList<Device>();
        for (Device device : Device.getDevices()) {
            if (TUMaths.getManhattanDistance(loc, device.getLocation()) > range) continue;
            if (!removeBugs) {
                if (requiredName == null) {
                    devices.add(device);
                    continue;
                }
                if (!device.getName().equals(requiredName)) continue;
                devices.add(device);
                continue;
            }
            if (device.getName().equals("Biter Nest")) continue;
            devices.add(device);
        }
        return devices;
    }

    public static ArrayList<Device> getNearbyDevices(Location loc, int range) {
        return Device.getNearbyDevices(loc, range, false, null);
    }

    public static ArrayList<Device> getNearbyDevicesByType(Location loc, int range, String name) {
        return Device.getNearbyDevices(loc, range, false, name);
    }

    private static void addDevice(Device device) {
        if (device.getLocationREADONLY() == null) {
            device.removeDevice();
            return;
        }
        if (!allDevices.containsKey(device.getLocation())) {
            allDevices.put(device.getLocation(), device);
            readDevices.add(device);
            if (Device.isPowerPylon(device)) {
                readPylons.add(device);
            }
        } else if (!allDevices.get(device.getLocation()).equals(device)) {
            device.removeDevice();
            ++duplicateDevices;
        }
    }

    public static boolean isDevice(Location loc) {
        return allDevices.containsKey(loc);
    }

    public static Device getDevice(Location loc) {
        if (allDevices.containsKey(loc)) {
            return allDevices.get(loc);
        }
        return null;
    }

    public static Device getDevice(Block block) {
        return Device.getDevice(block.getLocation());
    }

    public static Device getDevice(Inventory inv) {
        for (Device device : Device.getDevices()) {
            if (!device.getInventory().equals(inv)) continue;
            return device;
        }
        return null;
    }

    public static void recreateAll() {
        for (Device device : Device.getDevices()) {
            device.recreatePhysicalForm();
        }
    }

    public static void storeAll() {
        for (Device device : Device.getDevices()) {
            device.cleanup();
            device.iconCleanup();
            device.storePhysicalForm();
        }
    }

    public ItemStack getDeviceStack() {
        return this.getDeviceStack(false);
    }

    public ItemStack getDeviceStack(boolean asProtoType) {
        ItemMeta meta;
        if (!asProtoType && this.cachedDeviceStack != null) {
            return this.cachedDeviceStack.clone();
        }
        if (asProtoType && this.cachedDeviceStackAsPrototype != null) {
            return this.cachedDeviceStackAsPrototype.clone();
        }
        String localeName = MineItems.itemNames.get(this.deviceName);
        String desc = MineItems.itemDescs.get(this.deviceName);
        String modelData = MineItems.itemModelData.get(this.deviceName);
        String device = this.deviceName;
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(String.valueOf(ChatColor.WHITE) + " Industrial Device");
        lore.add(String.valueOf(ChatColor.WHITE) + " -----------------------------------------");
        lore.addAll(MineUtil.wrapText(desc, 45, MineItems.descColor(), 1));
        lore.add(String.valueOf(ChatColor.WHITE) + " -----------------------------------------");
        ItemStack stack = TUItems.createItem(this.getMaterial(), MineItems.itemColor() + localeName, lore);
        if (MineMain.useDeviceHeads && this.getHeadDevValue() != null && !MineItems.itemMaterial.containsKey(this.deviceName)) {
            stack = SkullCreator.getHead(this.getHeadDevValue(), true);
            meta = stack.getItemMeta();
            meta.setItemName(MineItems.itemColor() + localeName);
            meta.setDisplayName(MineItems.itemColor() + localeName);
            meta.setLore(lore);
            stack.setItemMeta(meta);
        }
        meta = stack.getItemMeta();
        NamespacedKey key = new NamespacedKey(MineMain.getPlugin(), "MT_" + device.replace(" ", "_"));
        meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)("MT_" + device.replace(" ", "_")));
        meta.getPersistentDataContainer().set(isDeviceItemKey, PersistentDataType.STRING, (Object)"MT_IS_DEVICE");
        if (!modelData.equals("none")) {
            meta.setItemModel(NamespacedKey.fromString((String)modelData));
        }
        stack.setItemMeta(meta);
        Object statLine = "";
        int pgen = this.powerGen;
        int aPower = this.actionPower;
        int iPower = this.idlePower;
        int aTimer = this.actionTimer;
        int poll = this.pollutionGen;
        if (asProtoType) {
            aPower *= 2;
            iPower *= 3;
            poll *= 2;
            if (pgen > 0) {
                pgen = (int)((double)pgen * 0.75);
            }
        }
        if (this.powerGen > 0) {
            statLine = (String)statLine + String.valueOf(ChatColor.YELLOW) + " \u26a1 " + pgen;
        }
        if (this.actionPower > 0) {
            statLine = (String)statLine + String.valueOf(ChatColor.RED) + " \ud83d\udee0 -" + aPower;
        }
        if (this.idlePower > 0) {
            statLine = (String)statLine + String.valueOf(ChatColor.YELLOW) + " \ud83d\udd0c -" + iPower;
        }
        if (this.actionTimer > 0) {
            statLine = (String)statLine + String.valueOf(ChatColor.GOLD) + " \u23f0 " + aTimer + "s";
        }
        if (this.pollutionGen > 0) {
            statLine = (String)statLine + String.valueOf(ChatColor.RED) + " \u2623 " + poll;
        }
        if (this instanceof Pump) {
            statLine = (String)statLine + String.valueOf(ChatColor.BLUE) + " \ud83d\udca7 " + Pump.maxWater + String.valueOf(ChatColor.GRAY) + " \ud83d\udee2 " + Pump.maxWater;
        }
        if (this instanceof SteamEngine) {
            statLine = (String)statLine + String.valueOf(ChatColor.RED) + " \u2668 -" + SteamEngine.neededSteam;
        }
        if (this instanceof HeavySteamGenerator) {
            statLine = (String)statLine + String.valueOf(ChatColor.RED) + " \u2668 -" + HeavySteamGenerator.steamNeeded;
        }
        if (this instanceof DeepDrill) {
            statLine = (String)statLine + String.valueOf(ChatColor.DARK_GREEN) + " \ud83d\udca7 -" + DeepDrill.neededLiquid + String.valueOf(ChatColor.GRAY) + " \ud83d\udee2 " + DeepDrill.oilProduce;
        }
        if (this instanceof Boiler) {
            statLine = (String)statLine + String.valueOf(ChatColor.BLUE) + " \ud83d\udca7 -" + Boiler.neededWater + String.valueOf(ChatColor.GREEN) + " \u2668 " + Boiler.producedSteam;
        }
        if (this instanceof PetroleumEngine) {
            statLine = (String)statLine + String.valueOf(ChatColor.GRAY) + " \ud83d\udca7 -" + PetroleumEngine.petrolNeeded;
        }
        if (this instanceof NuclearReactor) {
            statLine = (String)statLine + String.valueOf(ChatColor.BLUE) + " \ud83d\udca7 -" + NuclearReactor.neededWater + String.valueOf(ChatColor.GREEN) + " \ud83d\udd25 " + NuclearReactor.producedHeat;
        }
        if (this instanceof HeatExchanger) {
            statLine = (String)statLine + String.valueOf(ChatColor.BLUE) + " \ud83d\udca7 -" + HeatExchanger.neededWater + String.valueOf(ChatColor.RED) + " \ud83d\udd25 -" + HeatExchanger.neededHeat + String.valueOf(ChatColor.GREEN) + " \u2668 " + HeatExchanger.producedSteam;
        }
        if (this instanceof PowerPylon) {
            statLine = (String)statLine + String.valueOf(ChatColor.WHITE) + " \ud83d\udccf " + Device.getPylonRange(this);
        }
        if (this instanceof ResearchLab) {
            statLine = (String)statLine + String.valueOf(ChatColor.GREEN) + " \ud83d\udd2c 17";
        }
        if (this instanceof Battery2) {
            statLine = (String)statLine + String.valueOf(ChatColor.GREEN) + " \ud83d\udd0b " + Battery2.maxBatteryCapacity;
        }
        if (asProtoType) {
            statLine = (String)statLine + String.valueOf(ChatColor.GRAY) + " " + String.valueOf(ChatColor.UNDERLINE) + "Prototype";
        }
        TUItems.addLore(stack, (String)statLine);
        if (this.hasTag("Debug Item")) {
            meta = stack.getItemMeta();
            meta.getPersistentDataContainer().set(MineItems.debugItemKey, PersistentDataType.STRING, (Object)"Debug Item");
            stack.setItemMeta(meta);
        }
        if (asProtoType) {
            this.cachedDeviceStackAsPrototype = stack;
            return this.cachedDeviceStackAsPrototype.clone();
        }
        this.cachedDeviceStack = stack;
        return this.cachedDeviceStack.clone();
    }

    public static boolean isDeviceStack(ItemStack stack, String internalName) {
        return stack != null && MineItems.isDeviceItem(stack) && MineItems.isIndustrialItem(stack, internalName);
    }

    public boolean isUseUI() {
        return this.useUI;
    }

    public void setUseUI(boolean useUI) {
        this.useUI = useUI;
    }

    public boolean isOpenable() {
        return this.allowOpen;
    }

    public void setOpenable(boolean allowOpen) {
        this.allowOpen = allowOpen;
    }

    public int getIdlePower() {
        return this.idlePower;
    }

    public void setIdlePower(int idlePower) {
        if (idlePower > 0) {
            this.setNeedsPower(true);
        }
        this.idlePower = idlePower;
    }

    public boolean isPowered() {
        return this.powered;
    }

    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    public int getGridRange() {
        return this.gridRange;
    }

    public void setGridRange(int gridRange) {
        this.gridRange = gridRange;
    }

    public PowerGrid getGrid() {
        if (!MineMain.usingPowerSystem()) {
            return MineMain.freePower;
        }
        return this.powerGrid;
    }

    public boolean isRefreshInv() {
        return this.refreshInv;
    }

    public void setRefreshInv(boolean refreshInv) {
        this.refreshInv = refreshInv;
    }

    public boolean isNeedsPower() {
        return this.needsPower;
    }

    public void setNeedsPower(boolean needsPower) {
        this.needsPower = needsPower;
    }

    public boolean isStoreForm() {
        return this.storeForm;
    }

    public void setStoreForm(boolean storeForm) {
        this.storeForm = storeForm;
    }

    public void useAutoSlots() {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        ArrayList<Integer> inputs = new ArrayList<Integer>();
        int i = 0;
        while (i <= 8) {
            slots.add(i);
            inputs.add(i);
            slots.add(i + 18);
            ++i;
        }
        this.setClickableSlots(slots);
        ArrayList<Integer> outputs = new ArrayList<Integer>();
        int j = 18;
        while (j <= 26) {
            outputs.add(j);
            ++j;
        }
        this.setOutputSlots(outputs);
        this.setInputSlots(inputs);
        this.setUsingAutoUI(true);
    }

    public void useAutoUI() {
        int i = 9;
        while (i <= 17) {
            this.getInventory().setItem(i, MainMenu.createGoldPane());
            ++i;
        }
        this.getInventory().setItem(13, this.createInfoIcon());
    }

    public int getActionPower() {
        return PlanetHandler.getPlanetPowerDraw(this.getLocationREADONLY(), this.actionPower);
    }

    public void setActionPower(int actionPower) {
        if (actionPower > 0) {
            this.setNeedsPower(true);
        }
        this.actionPower = actionPower;
    }

    public ItemStack createInfoIcon() {
        ArrayList<String> lore = new ArrayList<String>();
        if (MineMain.usingPowerSystem()) {
            lore.add(String.valueOf(ChatColor.GOLD) + " Action Time: " + String.valueOf(ChatColor.WHITE) + this.getCurrentTimer() + "s/" + this.getActionTimer() + "s");
            if (this.isConsumingPower()) {
                lore.add(String.valueOf(ChatColor.GOLD) + " Power Usage: " + String.valueOf(ChatColor.WHITE) + this.getActionPower() + " (Active)");
            } else {
                lore.add(String.valueOf(ChatColor.GOLD) + " Power Usage: " + String.valueOf(ChatColor.WHITE) + this.getIdlePower() + " (Idle)");
            }
            if (this.getGrid() != null) {
                int connections = this.getGrid().deviceConnections.size();
                lore.add(String.valueOf(ChatColor.GOLD) + " Grid Connections: " + String.valueOf(ChatColor.WHITE) + connections);
                int gridPower = this.getGrid().getPower() + this.getGrid().batteryPower();
                if (gridPower > 1000) {
                    lore.add(String.valueOf(ChatColor.GOLD) + " Grid Power: " + String.valueOf(ChatColor.WHITE) + TUMaths.simplifyNumber(gridPower));
                } else {
                    lore.add(String.valueOf(ChatColor.GOLD) + " Grid Power: " + String.valueOf(ChatColor.WHITE) + gridPower);
                }
            } else {
                lore.add(String.valueOf(ChatColor.GOLD) + " Grid Connected: " + String.valueOf(ChatColor.WHITE) + "false");
            }
            if (!this.failReason.equals("None")) {
                lore.add(String.valueOf(ChatColor.RED) + " - " + this.failReason);
            }
        }
        for (String string : this.extraInfoLore()) {
            lore.add(string);
        }
        ItemStack stack = TUItems.setModelData(TUItems.createItem(Material.REDSTONE_LAMP, ChatColor.WHITE + ChatColor.BOLD + "Device Information", lore), 9523);
        return stack;
    }

    public ArrayList<String> extraInfoLore() {
        return new ArrayList<String>();
    }

    public int getPowerGen() {
        return this.powerGen;
    }

    public void setPowerGen(int powerGen) {
        this.powerGen = powerGen;
    }

    public boolean isProducingPower() {
        return this.producingPower;
    }

    public void setProducingPower(boolean producingPower) {
        this.producingPower = producingPower;
    }

    public boolean isConsumingPower() {
        return this.consumingPower;
    }

    public void setConsumingPower(boolean consumingPower) {
        this.consumingPower = consumingPower;
    }

    public String getName() {
        return this.deviceName;
    }

    public void spawnInactiveParticles() {
        final Location loc = this.getLocation();
        loc.add(0.5, 1.0, 0.5);
        int i = 0;
        while (i < 3) {
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    loc.add(0.0, 0.33, 0.0);
                    loc.getWorld().spawnParticle(MineMain.version.getInactiveParticle(), loc, 1, 0.0, 0.0, 0.0, 1.0E-5);
                }
            }, 10L * (long)i);
            ++i;
        }
    }

    public boolean isUsingAutoUI() {
        return this.usingAutoUI;
    }

    public void setUsingAutoUI(boolean usingAutoUI) {
        this.usingAutoUI = usingAutoUI;
    }

    public ArrayList<LiquidType> getLiquidTypes() {
        return new ArrayList<LiquidType>(this.storedLiquids.keySet());
    }

    public void addLiquidType(LiquidType type, int max) {
        this.storedLiquids.put(type, 0);
        this.maxLiquids.put(type, max);
    }

    public void removeLiquidType(LiquidType type) {
        this.storedLiquids.remove((Object)type);
        this.maxLiquids.remove((Object)type);
    }

    public int getStoredLiquid(LiquidType type) {
        if (this.storedLiquids.containsKey((Object)type)) {
            return this.storedLiquids.get((Object)type);
        }
        return 0;
    }

    public void setStoredLiquid(LiquidType type, int to) {
        if (to <= this.getMaxLiquid(type)) {
            if (to < 0) {
                this.storedLiquids.put(type, 0);
            } else {
                this.storedLiquids.put(type, to);
            }
        } else {
            this.storedLiquids.put(type, this.getMaxLiquid(type));
        }
    }

    public int getMaxLiquid(LiquidType type) {
        return this.maxLiquids.getOrDefault((Object)type, 0);
    }

    public void setMaxLiquid(LiquidType type, int max) {
        this.storedLiquids.put(type, max);
    }

    public void addLiquid(LiquidType type, int amount) {
        int stored = this.getStoredLiquid(type);
        this.setStoredLiquid(type, stored + amount);
    }

    public void removeLiquid(LiquidType type, int amount) {
        this.setStoredLiquid(type, this.getStoredLiquid(type) - amount);
    }

    public boolean hasLiquid(LiquidType type, int amount) {
        return this.getStoredLiquid(type) >= amount;
    }

    public boolean acceptsLiquid(LiquidType type) {
        return this.storedLiquids.containsKey((Object)type);
    }

    public int getEffectiveDrive() {
        int drive = this.getOverDrive();
        if (drive > 3) {
            drive = 3;
        }
        return drive;
    }

    public int getOverDrive() {
        return this.overDrive;
    }

    public void setOverDrive(int overDrive) {
        this.overDrive = overDrive;
    }

    public boolean isAllowPowerIndicator() {
        return this.allowPowerIndicator;
    }

    public void setAllowPowerIndicator(boolean allowPowerIndicator) {
        this.allowPowerIndicator = allowPowerIndicator;
    }

    public void dropInventory() {
        Furnace furnace;
        CombustionGenerator cg;
        World world = this.getLocation().getWorld();
        Location dropLoc = this.getLocation().add(0.5, 0.5, 0.5);
        ArrayList<ItemStack> dropItems = new ArrayList<ItemStack>();
        Inventory inv = this.getInventory();
        ArrayList<Integer> dropSlots = new ArrayList<Integer>(this.inputSlotNumbers);
        dropSlots.removeAll(this.outputSlotNumbers);
        dropSlots.addAll(this.outputSlotNumbers);
        for (int i : dropSlots) {
            if (!TUItems.isValid(inv.getItem(i))) continue;
            dropItems.add(inv.getItem(i));
        }
        for (ItemStack stack : dropItems) {
            world.dropItemNaturally(dropLoc, stack);
        }
        if (this instanceof CombustionGenerator && (cg = (CombustionGenerator)this) != null && (furnace = cg.getFurnace()).getInventory().getFuel() != null) {
            world.dropItemNaturally(dropLoc, furnace.getInventory().getFuel());
        }
    }

    public void onUIClick(InventoryClickEvent event) {
    }

    public boolean isAuthorized(Player player) {
        if (player.isOp()) {
            return true;
        }
        if (this.getPlacerUUIDString() != null) {
            if (this.getPlacerUUIDString().equals(player.getUniqueId().toString())) {
                return true;
            }
            PlayerData pd = PlayerData.getPlayerData(this.getPlacerUUIDString());
            if (pd != null) {
                return pd.isShared(player.getUniqueId());
            }
        }
        return false;
    }

    public boolean isAuthorized(UUID uuid) {
        if (this.getPlacerUUID() != null && uuid != null) {
            if (this.getPlacerUUID().equals(uuid)) {
                return true;
            }
            PlayerData pd = PlayerData.getPlayerData(this.getPlacerUUIDString());
            if (pd != null) {
                return pd.isShared(uuid);
            }
        }
        return false;
    }

    public UUID getPlacerUUID() {
        String sUUID;
        if (this.uuid == null && (sUUID = this.getPlacerUUIDString()) != null) {
            this.uuid = UUID.fromString(sUUID);
        }
        return this.uuid;
    }

    public String getPlacerUUIDString() {
        return this.placerUUID;
    }

    public void setPlacerUUID(String placerUUID) {
        this.placerUUID = placerUUID;
    }

    public void visualIconUpdate(boolean nearbyPlayer, Material icon, double offset) {
        if (visualType.equals((Object)VisualType.NONE)) {
            return;
        }
        if (nearbyPlayer) {
            Material aboveType = this.getLocation().add(0.0, 1.0, 0.0).getBlock().getType();
            if (aboveType.isSolid() || aboveType.equals((Object)Material.WATER)) {
                this.removeVisualItem();
                return;
            }
            if (this.visualItem == null) {
                ItemStack stack = new ItemStack(icon);
                if (MineMain.usingRoseStacker) {
                    TUItems.addLore(stack, UUID.randomUUID().toString());
                }
                Location loc = this.getLocation();
                if (visualType.equals((Object)VisualType.DISPLAY)) {
                    loc.add(0.0, 0.65, 0.0);
                }
                this.spawnVisualItem(TUMaths.centerLocation(loc, offset), stack);
            } else if (this.visualItem.isDead()) {
                this.removeVisualItem();
            } else if (!this.getCurrentVisualStack().getType().equals((Object)icon)) {
                ItemStack newStack = this.getCurrentVisualStack().clone();
                newStack.setType(icon);
                this.updateVisualStack(newStack);
            } else if (visualType.equals((Object)VisualType.DISPLAY)) {
                final ItemDisplay display = (ItemDisplay)this.visualItem;
                final Location teleLoc = display.getLocation().clone();
                teleLoc.setYaw(teleLoc.getYaw() - 90.0f);
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        display.teleport(teleLoc);
                    }
                }, 1L);
            }
        } else {
            this.removeVisualItem();
        }
    }

    private void removeVisualItem() {
        if (this.visualItem != null) {
            this.visualItem.remove();
            this.visualItem = null;
        }
    }

    private void spawnVisualItem(Location dropLocation, ItemStack stack) {
        if (visualType.equals((Object)VisualType.ITEM)) {
            this.visualItem = this.getLocation().getWorld().dropItem(dropLocation, stack);
            this.visualItem.setMetadata(MineMain.noPickupMetaValue, (MetadataValue)new FixedMetadataValue(MineMain.getPlugin(), (Object)MineMain.noPickupMetaValue));
            this.visualItem.setPersistent(false);
            this.visualItem.setGravity(false);
            this.visualItem.setVelocity(new Vector(0, 0, 0));
            this.visualItem.getPersistentDataContainer().set(iconStackKey, PersistentDataType.BOOLEAN, (Object)true);
            MineUtil.setDisposableEntity(this.visualItem);
        }
        if (visualType.equals((Object)VisualType.DISPLAY)) {
            ItemDisplay display = (ItemDisplay)dropLocation.getWorld().spawn(dropLocation, ItemDisplay.class);
            display.setItemStack(stack);
            Transformation form = Lift.getDisplayScale(display, stack);
            form.getScale().set(form.getScale().x * 2.0f, form.getScale().y * 2.0f, form.getScale().z * 2.0f);
            form.getLeftRotation().x = 0.0f;
            display.setTransformation(form);
            this.visualItem = display;
            display.setTeleportDuration(20);
            MineUtil.setDisposableEntity(this.visualItem);
        }
    }

    public ItemStack getCurrentVisualStack() {
        if (this.visualItem != null) {
            if (visualType.equals((Object)VisualType.ITEM)) {
                return ((Item)this.visualItem).getItemStack();
            }
            if (visualType.equals((Object)VisualType.DISPLAY)) {
                return ((ItemDisplay)this.visualItem).getItemStack();
            }
        }
        return null;
    }

    public void updateVisualStack(ItemStack stack) {
        if (visualType.equals((Object)VisualType.ITEM)) {
            ((Item)this.visualItem).setItemStack(stack);
        }
        if (visualType.equals((Object)VisualType.DISPLAY)) {
            ((ItemDisplay)this.visualItem).setItemStack(stack);
        }
    }

    public void visualIconUpdateAssembler(boolean nearbyPlayer, ItemStack target) {
        if (visualType.equals((Object)VisualType.NONE)) {
            return;
        }
        if (nearbyPlayer) {
            if (target == null || this.getLocation().add(0.0, 1.0, 0.0).getBlock().getType().isSolid()) {
                this.removeVisualItem();
                return;
            }
            if (target != null) {
                if (this.visualItem == null) {
                    Location loc = this.getLocation();
                    if (visualType.equals((Object)VisualType.DISPLAY)) {
                        loc.add(0.0, 0.65, 0.0);
                    }
                    this.spawnVisualItem(TUMaths.centerLocation(loc, 1.0), target.clone());
                } else if (this.visualItem.isDead()) {
                    this.removeVisualItem();
                } else {
                    ItemStack stack = target;
                    this.updateVisualStack(stack);
                    if (TUMaths.isPlayerNearby(this.getLocation(), 8.0)) {
                        String name = stack.getType().toString().replace("_", " ");
                        if (stack.hasItemMeta() && stack.getItemMeta().hasDisplayName()) {
                            name = stack.getItemMeta().getDisplayName();
                        }
                        boolean canSpawn = true;
                        for (Entity entity : this.visualItem.getWorld().getNearbyEntities(this.visualItem.getLocation(), 3.0, 3.0, 3.0)) {
                            if (!entity.getType().equals((Object)MineMain.version.getItemEntityType()) || entity.getCustomName() == null || !entity.getCustomName().equals(name) || !entity.isCustomNameVisible()) continue;
                            canSpawn = false;
                            break;
                        }
                        if (!canSpawn) {
                            return;
                        }
                        this.visualItem.setCustomName(name);
                        this.visualItem.setCustomNameVisible(true);
                    } else {
                        this.visualItem.setCustomNameVisible(false);
                    }
                    if (visualType.equals((Object)VisualType.DISPLAY)) {
                        final ItemDisplay display = (ItemDisplay)this.visualItem;
                        final Location teleLoc = display.getLocation().clone();
                        teleLoc.setYaw(teleLoc.getYaw() - 90.0f);
                        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                            @Override
                            public void run() {
                                display.teleport(teleLoc);
                            }
                        }, 1L);
                    }
                }
            }
        } else if (this.visualItem != null) {
            this.removeVisualItem();
        }
    }

    public void iconCleanup() {
        if (this.visualItem != null) {
            this.visualItem.remove();
        }
    }

    public String getPoweredStateString() {
        if (this.getPoweredState().equals((Object)PoweredState.ON)) {
            return "Turned On";
        }
        if (this.getPoweredState().equals((Object)PoweredState.OFF_BATTERY_MONITOR)) {
            return "Turned Off (Battery Monitor)";
        }
        if (this.getPoweredState().equals((Object)PoweredState.OFF_MANUAL)) {
            return "Turned Off (Manual)";
        }
        if (this.getPoweredState().equals((Object)PoweredState.OFF_BREAKER)) {
            return "Turned Off (Breaker)";
        }
        return "Unknown";
    }

    public PoweredState getPoweredState() {
        return this.state;
    }

    public void setPoweredState(PoweredState state) {
        this.state = state;
        this.onStateChange();
    }

    public void onStateChange() {
    }

    public int getPollutionGen() {
        return this.pollutionGen;
    }

    public void setPollutionGen(int pollutionGen) {
        this.pollutionGen = pollutionGen;
    }

    public void addTag(String tag) {
        if (!this.tags.contains(tag)) {
            this.tags.add(tag);
        }
    }

    public boolean hasTag(String tag) {
        return this.tags.contains(tag);
    }

    public Material getMaterial() {
        if (MineItems.itemMaterial.containsKey(this.deviceName)) {
            return MineItems.itemMaterial.get(this.deviceName);
        }
        return this.materialType;
    }

    public void setMaterial(String value) {
        if (MineItems.itemMaterial.containsKey(this.deviceName)) {
            return;
        }
        Material val = Material.getMaterial((String)value);
        this.materialType = val != null ? val : (value.contains("SLAB") ? Material.SMOOTH_STONE_SLAB : Material.CRAFTING_TABLE);
    }

    public int getStoredAmount(ItemStack stack) {
        int amount = 0;
        for (ItemStack input : this.getInputItems()) {
            if (!input.isSimilar(stack)) continue;
            amount += input.getAmount();
        }
        return amount;
    }

    public ArrayList<ItemStack> getCraftingIngredients(Recipe recipe) {
        ArrayList<Object> ings = new ArrayList<ItemStack>();
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shaped = (ShapedRecipe)recipe;
            String[] stringArray = shaped.getShape();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String row = stringArray[n2];
                char[] cArray = row.toCharArray();
                int n3 = cArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    char c = cArray[n4];
                    if (c != ' ') {
                        Object v = shaped.getChoiceMap().get(Character.valueOf(c));
                        if (v instanceof RecipeChoice.MaterialChoice) {
                            RecipeChoice.MaterialChoice rmc = (RecipeChoice.MaterialChoice)v;
                            if (rmc.getChoices().size() > 1) {
                                ItemStack highest = null;
                                int amount = 0;
                                for (Material matChoice : rmc.getChoices()) {
                                    if (highest == null) {
                                        highest = new ItemStack(matChoice);
                                        amount = this.getStoredAmount(highest);
                                        continue;
                                    }
                                    ItemStack newStack = new ItemStack(matChoice);
                                    int newStored = this.getStoredAmount(newStack);
                                    if (amount >= newStored) continue;
                                    highest = newStack;
                                    amount = newStored;
                                }
                                ings.add(highest);
                            } else {
                                ings.add((ItemStack)shaped.getIngredientMap().get(Character.valueOf(c)));
                            }
                        } else {
                            ings.add((ItemStack)shaped.getIngredientMap().get(Character.valueOf(c)));
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        } else if (recipe instanceof ShapelessRecipe) {
            ShapelessRecipe shapeless = (ShapelessRecipe)recipe;
            ings = new ArrayList(shapeless.getIngredientList());
        }
        return ings;
    }

    public static HashMap<ItemStack, Integer> getTotaledStacks(ArrayList<ItemStack> stackList) {
        HashMap<ItemStack, Integer> totaledStacks = new HashMap<ItemStack, Integer>();
        for (ItemStack stack : stackList) {
            ItemStack oneOf = stack.clone();
            oneOf.setAmount(1);
            if (totaledStacks.containsKey(oneOf)) {
                totaledStacks.put(oneOf, totaledStacks.get(oneOf) + stack.getAmount());
                continue;
            }
            totaledStacks.put(oneOf, stack.getAmount());
        }
        return totaledStacks;
    }

    public void updateCraftingMaterialChoices(ArrayList<ItemStack> ingredients) {
        Material woodType = Material.OAK_PLANKS;
        for (ItemStack stack : this.getInputItems()) {
            if (!stack.getType().toString().contains("_PLANKS")) continue;
            woodType = stack.getType();
            break;
        }
        if (!woodType.equals((Object)Material.OAK_PLANKS)) {
            for (ItemStack ing : ingredients) {
                if (!ing.getType().toString().contains("_PLANKS")) continue;
                ing.setType(woodType);
            }
        }
        for (ItemStack stack : this.getInputItems()) {
            if (!stack.getType().equals((Object)Material.CHARCOAL) && !stack.getType().equals((Object)Material.COAL)) continue;
            Material coalType = stack.getType();
            for (ItemStack ing : ingredients) {
                if (!ing.getType().equals((Object)Material.CHARCOAL) && !ing.getType().equals((Object)Material.COAL)) continue;
                ing.setType(coalType);
            }
        }
    }

    public void logItem(ItemStack item, int amount) {
        if (this.getGrid() != null) {
            this.getGrid().logItem(item, amount);
        }
    }

    public void logItem(ItemStack item) {
        this.logItem(item, item.getAmount());
    }

    public static void tickSavingSystem() {
        if (!MineMain.usePeriodicSaving) {
            return;
        }
        if (--saveTimer == 60) {
            TUMaths.dm(MineMain.getBanner() + String.valueOf(ChatColor.WHITE) + "All devices saving in 60 seconds.");
        }
        if (saveTimer <= 0) {
            saveTimer = 600;
            Device.saveAllDevices();
        }
    }

    public static void saveAllDevices() {
        int devicesPerTick;
        ArrayList<Device> devices = new ArrayList<Device>(Device.getDevices());
        devices.addAll(Mover.getMovers());
        int deviceCount = devices.size();
        int remaining = devicesPerTick = 5;
        int batches = 0;
        HashSet<Saveable> batch = new HashSet<Saveable>();
        long delay = 0L;
        for (Saveable saveable : devices) {
            batch.add(saveable);
            if (--remaining > 0) continue;
            ++batches;
            remaining = devicesPerTick;
            final HashSet processBatch = new HashSet(batch);
            batch.clear();
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    Bukkit.getScheduler().runTaskAsynchronously(MineMain.getPlugin(), () -> {
                        try {
                            for (Saveable pDevice : processBatch) {
                                pDevice.save();
                            }
                        }
                        catch (ConcurrentModificationException concurrentModificationException) {
                            // empty catch block
                        }
                    });
                }
            }, 0L + ++delay);
        }
        double d = TUMaths.roundDouble((double)delay / 20.0, 2);
        TUMaths.dm(MineMain.getBanner() + String.valueOf(ChatColor.WHITE) + "Saving: " + deviceCount + " devices in " + batches + " batches, happening over " + d + " seconds. (Saves Per Tick - " + devicesPerTick + ")");
        if (d > (double)saveTimer) {
            saveTimer = (int)d;
            TUMaths.dm(MineMain.getBanner() + String.valueOf(ChatColor.YELLOW) + "Next save time adjusted to " + saveTimer + " seconds due to device count.");
        }
    }

    public static ArrayList<String> crafterLore(Device device, ItemStack cachedTarget, HashMap<ItemStack, Integer> lastIngredients, HashMap<ItemStack, Integer> lastStored, MTRecipe recipe, HashMap<NamespacedKey, Integer> lastIngredients2, HashMap<NamespacedKey, Integer> lastStored2) {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(MineUtil.colon(" Action Time", device.getCurrentTimer() + "s/" + device.getActionTimer() + "s"));
        if (!device.getFailReason().equals("None") && !device.getFailReason().contains("Missing")) {
            lore.add(String.valueOf(ChatColor.RED) + " - " + device.getFailReason());
        }
        if (cachedTarget != null && device.isPowered() && (lastIngredients != null && lastIngredients.size() != 0 || lastIngredients2 != null && lastIngredients2.size() != 0)) {
            int stored;
            int amount;
            lore.add(" ");
            lore.add(MineItems.whiteBold() + " Ingredients");
            if (lastIngredients != null) {
                for (ItemStack itemStack : new ArrayList<ItemStack>(lastIngredients.keySet())) {
                    amount = lastIngredients.get(itemStack);
                    stored = 0;
                    if (lastStored != null && lastStored.containsKey(itemStack)) {
                        stored += lastStored.get(itemStack).intValue();
                    }
                    if (amount <= stored) {
                        lore.add("  " + MineItems.checkMark + " " + String.valueOf(ChatColor.GREEN) + Device.getMissingName(itemStack) + " x" + amount);
                        continue;
                    }
                    if (stored != 0) {
                        lore.add("  " + String.valueOf(ChatColor.YELLOW) + String.valueOf(ChatColor.BOLD) + ChatColor.stripColor((String)MineItems.xMark) + " " + String.valueOf(ChatColor.YELLOW) + Device.getMissingName(itemStack) + " x" + (amount - stored));
                        continue;
                    }
                    lore.add("  " + MineItems.xMark + " " + String.valueOf(ChatColor.RED) + Device.getMissingName(itemStack) + " x" + (amount - stored));
                }
            }
            if (lastIngredients2 != null) {
                for (NamespacedKey namespacedKey : new ArrayList<NamespacedKey>(lastIngredients2.keySet())) {
                    amount = lastIngredients2.get(namespacedKey);
                    stored = 0;
                    if (lastStored2 != null && lastStored2.containsKey(namespacedKey)) {
                        stored += lastStored2.get(namespacedKey).intValue();
                    }
                    String name = TUMaths.capitalizeWords(namespacedKey.getKey().replace("mt_", "").replace("_", " "));
                    if (amount <= stored) {
                        lore.add("  " + MineItems.checkMark + " " + String.valueOf(ChatColor.GREEN) + name + " x" + amount);
                        continue;
                    }
                    if (stored != 0) {
                        lore.add("  " + String.valueOf(ChatColor.YELLOW) + String.valueOf(ChatColor.BOLD) + ChatColor.stripColor((String)MineItems.xMark) + " " + String.valueOf(ChatColor.YELLOW) + name + " x" + (amount - stored));
                        continue;
                    }
                    lore.add("  " + MineItems.xMark + " " + String.valueOf(ChatColor.RED) + name + " x" + (amount - stored));
                }
            }
            if (recipe != null && recipe.getRecipeLiquid() != null) {
                if (device.hasLiquid(recipe.getRecipeLiquid(), recipe.getLiquidAmount())) {
                    lore.add("  " + MineItems.checkMark + String.valueOf(ChatColor.GREEN) + " " + recipe.getLiquidAmount() + " " + String.valueOf((Object)recipe.getRecipeLiquid()));
                } else if (device.getStoredLiquid(recipe.getRecipeLiquid()) > 0) {
                    lore.add("  " + String.valueOf(ChatColor.YELLOW) + String.valueOf(ChatColor.BOLD) + ChatColor.stripColor((String)MineItems.xMark) + String.valueOf(ChatColor.YELLOW) + " " + recipe.getLiquidAmount() + " " + String.valueOf((Object)recipe.getRecipeLiquid()));
                } else {
                    lore.add("  " + MineItems.xMark + " " + String.valueOf(ChatColor.RED) + (recipe.getLiquidAmount() - device.getStoredLiquid(recipe.getRecipeLiquid())) + " " + String.valueOf((Object)recipe.getRecipeLiquid()));
                }
                lore.add(" ");
                lore.add(MineItems.whiteBold() + " Stored Liquids");
                lore.add(MineUtil.colon("  " + String.valueOf((Object)recipe.getRecipeLiquid()), "" + device.getStoredLiquid(recipe.getRecipeLiquid())));
            }
            lore.add(" ");
            lore.add(MineUtil.colon(" " + LocaleUtil.uiText("General_Click"), "Track Needed"));
        }
        return lore;
    }

    public static String getMissingName(ItemStack needed) {
        String missing = ChatColor.stripColor((String)needed.getType().toString().replace("_", " "));
        if (needed.hasItemMeta() && needed.getItemMeta().hasDisplayName()) {
            missing = ChatColor.stripColor((String)needed.getItemMeta().getDisplayName());
        }
        return missing;
    }

    public boolean useDeviceCrowding() {
        return this.useDeviceCrowding;
    }

    public void setDeviceCrowding(boolean useDeviceCrowding) {
        this.useDeviceCrowding = useDeviceCrowding;
    }

    public int getLastCrowding() {
        return this.lastCrowding;
    }

    public void setLastCrowding(int lastCrowding) {
        this.lastCrowding = lastCrowding;
    }

    public ItemStack fortuneDrop(ItemStack pickaxe, ItemStack drop) {
        if (pickaxe == null) {
            return drop;
        }
        if (pickaxe.containsEnchantment(Enchantment.FORTUNE) && this.isFortuneEffected(drop)) {
            int level = pickaxe.getEnchantmentLevel(Enchantment.FORTUNE);
            if (level == 1 && TUMaths.rollRange(0, 99) <= 33) {
                drop.setAmount(drop.getAmount() * 2);
            }
            if (level == 2 && TUMaths.rollRange(0, 99) <= 50) {
                drop.setAmount(drop.getAmount() * 2);
                if (TUMaths.rollRange(0, 1) == 0) {
                    drop.setAmount(drop.getAmount() * 3);
                }
            }
            if (level >= 3 && TUMaths.rollRange(0, 99) <= 60) {
                int rolled = TUMaths.rollRange(0, 2);
                if (rolled == 0) {
                    drop.setAmount(drop.getAmount() * 2);
                }
                if (rolled == 1) {
                    drop.setAmount(drop.getAmount() * 3);
                }
                if (rolled == 2) {
                    drop.setAmount(drop.getAmount() * 4);
                }
            }
        }
        return drop;
    }

    private boolean isFortuneEffected(ItemStack drop) {
        if (drop.getType().equals((Object)Material.COAL)) {
            return true;
        }
        if (drop.getType().equals((Object)Material.DIAMOND)) {
            return true;
        }
        if (drop.getType().equals((Object)Material.EMERALD)) {
            return true;
        }
        if (drop.getType().equals((Object)Material.RAW_IRON)) {
            return true;
        }
        if (drop.getType().equals((Object)Material.RAW_COPPER)) {
            return true;
        }
        if (drop.getType().equals((Object)Material.RAW_GOLD)) {
            return true;
        }
        if (drop.getType().equals((Object)Material.REDSTONE)) {
            return true;
        }
        return drop.getType().equals((Object)Material.LAPIS_LAZULI);
    }

    private void updatePylonUpgrade() {
        Block block = this.getLocation().getBlock();
        this.upgradedPylon = false;
        if (block.getRelative(BlockFace.UP).getType().toString().contains("WALL")) {
            block = block.getRelative(0, 2, 0);
            boolean hasPole = true;
            int i = 0;
            while (i < 3) {
                if (!block.getType().toString().contains("FENCE")) {
                    hasPole = false;
                    break;
                }
                block = block.getRelative(BlockFace.UP);
                ++i;
            }
            if (hasPole) {
                BlockFace facing = this.getFacing();
                BlockFace checkFace1 = BlockFace.NORTH;
                BlockFace checkFace2 = BlockFace.SOUTH;
                if (facing.equals((Object)BlockFace.NORTH) || facing.equals((Object)BlockFace.SOUTH)) {
                    checkFace1 = BlockFace.EAST;
                    checkFace2 = BlockFace.WEST;
                }
                if (block.getRelative(checkFace1).getType().toString().contains("FENCE") && block.getRelative(checkFace2).getType().toString().contains("FENCE")) {
                    if (!PowerPylon.lineType.equals((Object)PowerPylon.PowerLineType.PARTICLE)) {
                        this.pylonSegment1 = TUMaths.centerLocation(block.getRelative(checkFace1).getLocation(), 0.0).add(0.0, 0.5, 0.0);
                        this.pylonSegment2 = TUMaths.centerLocation(block.getRelative(checkFace2).getLocation(), 0.0).add(0.0, 0.5, 0.0);
                    } else {
                        this.pylonSegment1 = TUMaths.centerLocation(block.getRelative(checkFace1).getLocation(), 0.0).add(0.0, -0.5, 0.0);
                        this.pylonSegment2 = TUMaths.centerLocation(block.getRelative(checkFace2).getLocation(), 0.0).add(0.0, -0.5, 0.0);
                    }
                    this.upgradedPylon = true;
                }
            }
        }
    }

    public boolean isUpgradedPylon() {
        return this.upgradedPylon;
    }

    private void tickPylonUpgrade() {
        if (!Device.isPowerPylon(this)) {
            return;
        }
        if (MinetorioListener.isPlayerNearby1DOPT(this.getLocationREADONLY(), MineMain.chunkViewDistance)) {
            this.updatePylonUpgrade();
            if (this.isUpgradedPylon()) {
                this.linkUpgradePylon();
                this.handleWires();
            } else {
                this.removeWires();
            }
            if (this.incomingPylon != null && this.incomingPylon.isRemoved()) {
                this.incomingPylon = null;
            }
        } else if (this.linkedPylon != null) {
            if (!MinetorioListener.isPlayerNearbyOPT(this.linkedPylon.getLocationREADONLY(), MineMain.chunkViewDistance)) {
                this.removeWires();
            }
        } else {
            this.removeWires();
        }
    }

    private void handleWires() {
        if (PowerPylon.lineType.equals((Object)PowerPylon.PowerLineType.NONE)) {
            return;
        }
        boolean isParticleWires = PowerPylon.lineType.equals((Object)PowerPylon.PowerLineType.PARTICLE);
        if (this.linkedPylon == null || !this.linkedPylon.isUpgradedPylon()) {
            if (this.linkedPylon != null) {
                this.linkedPylon.incomingPylon = null;
                this.linkedPylon = null;
            }
            this.removeWires();
            return;
        }
        if (!isParticleWires && this.wire1 != null) {
            return;
        }
        Location a1 = this.getPylonSegment1();
        Location a2 = this.getPylonSegment2();
        Location b1 = this.linkedPylon.getPylonSegment1();
        Location b2 = this.linkedPylon.getPylonSegment2();
        boolean switchedConnection = false;
        if (!this.linkedSameFacing) {
            boolean validB;
            boolean bSame = b1.equals((Object)b2);
            boolean crossA = Device.linesCross2D(a1, b1, a2, b2);
            boolean crossB = Device.linesCross2D(a1, b2, a2, b1);
            boolean validA = !crossA && !bSame;
            boolean bl = validB = !crossB && !bSame;
            if (validA) {
                switchedConnection = false;
            } else if (validB) {
                switchedConnection = true;
            } else {
                double distA = a1.distanceSquared(b1) + a2.distanceSquared(b2);
                double distB = a1.distanceSquared(b2) + a2.distanceSquared(b1);
                switchedConnection = distB < distA;
            }
        }
        Location t1 = switchedConnection ? b2 : b1;
        Location t2 = switchedConnection ? b1 : b2;
        World world = this.getLocation().getWorld();
        int points1 = TUMaths.getManhattanDistance(a1, t1) * 2;
        int points2 = TUMaths.getManhattanDistance(a2, t2) * 2;
        if (isParticleWires) {
            MineUtil.spawnArcedParticleLine(world, a1, t1, Color.BLACK, points1, -1.0, 1.5f, null);
            Location finalT1 = t1;
            Bukkit.getScheduler().runTaskLater(MineMain.getPlugin(), () -> {
                if (this.location != null) {
                    MineUtil.spawnArcedParticleLine(world, a1, finalT1, Color.BLACK, points1, -1.0, 1.5f, null);
                }
            }, 10L);
            MineUtil.spawnArcedParticleLine(world, a2, t2, Color.BLACK, points2, -1.0, 1.5f, null);
            Location finalT2 = t2;
            Bukkit.getScheduler().runTaskLater(MineMain.getPlugin(), () -> MineUtil.spawnArcedParticleLine(world, a2, finalT2, Color.BLACK, points2, -1.0, 1.5f, null), 10L);
        } else {
            if (this.wire1 == null) {
                this.wire1 = Device.spawnStretchedBlockDisplay(a1, t1, Material.BLACK_CONCRETE);
            }
            if (this.wire2 == null) {
                this.wire2 = Device.spawnStretchedBlockDisplay(a2, t2, Material.BLACK_CONCRETE);
            }
        }
    }

    private void removeWires() {
        if (this.wire1 != null) {
            this.wire1.remove();
        }
        if (this.wire2 != null) {
            this.wire2.remove();
        }
        this.wire1 = null;
        this.wire2 = null;
    }

    private void linkUpgradePylon() {
        if (this.linkedPylon == null) {
            for (Device other : MineUtil.sortDevicesByDistance(this.getLocation(), this.getNearbySharedPylons(this.getPlacerUUID()))) {
                if (other.equals(this) || other.incomingPylon != null || !other.isUpgradedPylon() || other.getLinkedPylon() != null && other.getLinkedPylon().equals(this) || (other.getFacing().equals((Object)this.getFacing()) || other.getFacing().equals((Object)this.getFacing().getOppositeFace()) ? !Device.areCardinallyAligned(this.getLocationREADONLY(), other.getLocationREADONLY(), 10.0) || (this.getFacing().equals((Object)BlockFace.NORTH) || this.getFacing().equals((Object)BlockFace.SOUTH) ? Device.isEastWestAligned(this.getLocationREADONLY(), other.getLocationREADONLY(), 1.0) : Device.isNorthSouthAligned(this.getLocationREADONLY(), other.getLocationREADONLY(), 1.0)) : Device.areCardinallyAligned(this.getLocationREADONLY(), other.getLocationREADONLY(), 1.0))) continue;
                this.linkedSameFacing = false;
                this.removeWires();
                this.linkedPylon = other;
                other.incomingPylon = this;
                if (other.getFacing().equals((Object)this.getFacing()) || other.getFacing().equals((Object)this.getFacing().getOppositeFace())) {
                    this.linkedSameFacing = true;
                }
                break;
            }
        } else if (this.linkedPylon.isRemoved()) {
            this.removeWires();
            this.linkedPylon = null;
        }
    }

    public BlockFace getFacing() {
        BlockFace forwardFace;
        if (this.cachedFacing != null) {
            return this.cachedFacing;
        }
        this.cachedFacing = forwardFace = ((Directional)this.getLocation().getBlock().getBlockData()).getFacing();
        return this.cachedFacing;
    }

    public Device getLinkedPylon() {
        return this.linkedPylon;
    }

    public Location getPylonSegment1() {
        return this.pylonSegment1;
    }

    public Location getPylonSegment2() {
        return this.pylonSegment2;
    }

    public static BlockDisplay spawnStretchedBlockDisplay(Location from, Location to, Material material) {
        World world = from.getWorld();
        if (world == null || to.getWorld() == null || !world.equals(to.getWorld())) {
            return null;
        }
        Vector start = from.toVector();
        Vector end = to.toVector();
        Vector diff = end.clone().subtract(start);
        double length = diff.length();
        Location facingLoc = from.clone();
        facingLoc.setDirection(diff);
        BlockDisplay display = (BlockDisplay)world.spawnEntity(facingLoc, EntityType.BLOCK_DISPLAY);
        display.setBlock(Bukkit.createBlockData((Material)material));
        display.setViewRange((float)MineMain.chunkViewDistance);
        Transformation transformation = display.getTransformation();
        transformation.getScale().set(0.1f, 0.1f, (float)length);
        display.setTransformation(transformation);
        MineUtil.setDisposableEntity((Entity)display);
        return display;
    }

    public static boolean linesCross2D(Location a1, Location b1, Location a2, Location b2) {
        return Device.intersects2D(a1.getX(), a1.getZ(), b1.getX(), b1.getZ(), a2.getX(), a2.getZ(), b2.getX(), b2.getZ());
    }

    public static boolean intersects2D(double x1, double z1, double x2, double z2, double x3, double z3, double x4, double z4) {
        return Device.ccw(x1, z1, x3, z3, x4, z4) != Device.ccw(x2, z2, x3, z3, x4, z4) && Device.ccw(x1, z1, x2, z2, x3, z3) != Device.ccw(x1, z1, x2, z2, x4, z4);
    }

    private static boolean ccw(double x1, double z1, double x2, double z2, double x3, double z3) {
        return (z3 - z1) * (x2 - x1) > (z2 - z1) * (x3 - x1);
    }

    public static boolean areCardinallyAligned(Location loc1, Location loc2, double threshold) {
        if (!loc1.getWorld().equals(loc2.getWorld())) {
            return false;
        }
        double dx = Math.abs(loc1.getX() - loc2.getX());
        double dz = Math.abs(loc1.getZ() - loc2.getZ());
        if (dx <= threshold) {
            return true;
        }
        return dz <= threshold;
    }

    public static boolean isNorthSouthAligned(Location loc1, Location loc2, double threshold) {
        return Math.abs(loc1.getX() - loc2.getX()) <= threshold;
    }

    public static boolean isEastWestAligned(Location loc1, Location loc2, double threshold) {
        return Math.abs(loc1.getZ() - loc2.getZ()) <= threshold;
    }

    public Location getDisplayLocation() {
        return this.getLocation().add(0.5, 1.002, 0.5);
    }

    public void handleDisplay() {
        if (!MineMain.prettyDevices) {
            return;
        }
        if (TUMaths.isPlayerNearby(this.getLocationREADONLY(), Device.getDeviceHeadViewDistance())) {
            this.spawnLinkedDisplay();
        } else {
            this.removeLinkedDisplay();
        }
    }

    public void spawnLinkedDisplay() {
        if (this.linkedDisplay == null || this.linkedDisplay != null && this.linkedDisplay.isDead()) {
            ItemStack displayStack = this.getDisplayStack();
            if (displayStack == null) {
                return;
            }
            double rand = TUMaths.rollRange(0.001, 1.0E-5);
            Location loc = this.getDisplayLocation().add(0.0, rand, 0.0);
            if (this.displayYScaleShift < 0.0f) {
                loc.setY(loc.getY() + (double)(this.displayYScaleShift / 2.0f));
            }
            this.rotateDisplay(loc);
            ItemDisplay display = (ItemDisplay)loc.getWorld().spawn(loc, ItemDisplay.class);
            MineUtil.setDisposableEntity((Entity)display);
            Transformation form = display.getTransformation();
            form.getScale().set(2.01 + rand, 2.01 + rand, 2.01 + rand);
            form.getScale().set(form.getScale().x, form.getScale().y + this.displayYScaleShift, form.getScale().z);
            display.setTransformation(form);
            display.setBrightness(new Display.Brightness(15, 15));
            if (this.tempDisplayStack == null) {
                display.setItemStack(this.getDisplayStack());
            } else {
                display.setItemStack(this.tempDisplayStack);
            }
            this.linkedDisplay = display;
        }
    }

    public void rotateDisplay(Location loc) {
        if (this.getLocation().getBlock().getBlockData() instanceof Directional) {
            int rotateAmount = this.displayRotationOffset;
            if (!this.displayLockedHorizontal) {
                if (this.getFacing().equals((Object)BlockFace.UP)) {
                    loc.setPitch((float)(90 + this.displayYawOffset));
                    return;
                }
                if (this.getFacing().equals((Object)BlockFace.DOWN)) {
                    loc.setPitch((float)(-90 + this.displayYawOffset));
                    return;
                }
            }
            if (this.getFacing().equals((Object)BlockFace.EAST)) {
                rotateAmount += 90;
            }
            if (this.getFacing().equals((Object)BlockFace.SOUTH)) {
                rotateAmount += 180;
            }
            if (this.getFacing().equals((Object)BlockFace.WEST)) {
                rotateAmount += 270;
            }
            loc.setYaw((float)rotateAmount);
        } else {
            loc.setPitch((float)this.displayYawOffset);
            loc.setYaw((float)this.displayRotationOffset);
        }
    }

    public void removeLinkedDisplay() {
        if (this.linkedDisplay != null) {
            this.linkedDisplay.remove();
            this.linkedDisplay = null;
        }
    }

    public String getDisplayStackString() {
        return this.displayStackString;
    }

    public void setDisplayStackString(ItemStack stack) {
        this.displayStackString = TUItems.createStackString(stack);
    }

    public ItemStack getDisplayStack() {
        if (this.getDisplayStackString() != null) {
            return TUItems.createStackFromString(this.getDisplayStackString(), true);
        }
        return null;
    }

    public void updateDisplayStack(ItemStack stack) {
        this.tempDisplayStack = stack;
        if (this.linkedDisplay != null) {
            this.linkedDisplay.setItemStack(stack);
        }
    }

    public ItemStack getInputStack(ItemStack reference) {
        for (ItemStack stack : this.getInputItems()) {
            if (!reference.isSimilar(stack)) continue;
            return stack;
        }
        return null;
    }

    public String getHeadDevValue() {
        return this.headDevValue;
    }

    public void setHeadDevValue(String headDevValue) {
        this.headDevValue = headDevValue;
    }

    public void updateDeviceHeadItem() {
        String headVal = MineItems.devValueForDevices.get(this.deviceName);
        if (headVal != null) {
            this.setHeadDevValue(MineItems.devValueForDevices.get(this.deviceName));
        }
    }

    public static int getDeviceHeadViewDistance() {
        if (MineMain.deviceHeadDistance > MineMain.chunkViewDistance) {
            return MineMain.chunkViewDistance;
        }
        return MineMain.deviceHeadDistance;
    }

    private void handleTextDisplay() {
        CrudeAssembler assembler;
        if (!MinetorioListener.isPlayerNearbyOPT(this.getLocationREADONLY(), 16.0)) {
            this.removeTextDisplay();
            return;
        }
        if (this instanceof BiterNest) {
            return;
        }
        if (this instanceof PowerPylon) {
            return;
        }
        Device device = this;
        if (device instanceof CrudeAssembler && (assembler = (CrudeAssembler)device).getName().equals("Crude Assembler")) {
            return;
        }
        String message = null;
        if (this.getGrid() == null) {
            message = String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "\ud83d\udd0c";
        }
        if (this.getGrid() != null && !this.isPowered()) {
            message = String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "\u26a1";
        }
        if (message == null) {
            this.removeTextDisplay();
        } else {
            this.spawnTextDisplay(message);
        }
    }

    private void spawnTextDisplay(String message) {
        if (this.textLocation == null) {
            this.textLocation = this.getLocation().add(0.5, 1.25, 0.5);
        }
        if (this.textDisplay == null) {
            this.textDisplay = (TextDisplay)this.getLocationREADONLY().getWorld().spawn(this.textLocation, TextDisplay.class);
            MineUtil.setDisposableEntity((Entity)this.textDisplay);
            this.textDisplay.setCustomNameVisible(true);
            this.textDisplay.setAlignment(TextDisplay.TextAlignment.CENTER);
            this.textDisplay.setDefaultBackground(true);
            this.textDisplay.setBackgroundColor(Color.fromARGB((int)0, (int)255, (int)255, (int)255));
            this.textDisplay.setViewRange(1.0f);
        }
        this.textDisplay.setCustomName(message);
    }

    private void removeTextDisplay() {
        if (this.textDisplay != null) {
            this.textDisplay.remove();
            this.textDisplay = null;
        }
    }

    public static enum LiquidType {
        WATER("WATER", 0),
        OIL("OIL", 1),
        STEAM("STEAM", 2),
        HEAVYOIL("HEAVYOIL", 3),
        LIGHTOIL("LIGHTOIL", 4),
        PETROL("PETROL", 5),
        LUBRICANT("LUBRICANT", 6),
        SULFURIC_ACID("SULFURIC_ACID", 7);


        private LiquidType(String name, int ordinal) {
        }
    }

    public static enum PoweredState {
        ON,
        OFF_BATTERY_MONITOR,
        OFF_MANUAL,
        OFF_BREAKER;

    }

    public static enum VisualType {
        DISPLAY,
        ITEM,
        NONE;

    }
}

