/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Manufactoring;

import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.MineMain;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Powerable;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;

public class AutoTimer
extends Device {
    private static final long serialVersionUID = 7571974070728037011L;
    private transient Item item = null;
    private int timer = 0;

    public AutoTimer(Location loc) {
        super(loc);
        this.setMaterial("BAMBOO_SLAB");
        this.deviceName = "Auto Timer";
        this.setActionTimer(1);
        this.setGridRange(5);
        this.setUseUI(true);
        this.setRefreshInv(false);
        this.setIdlePower(1);
        this.setActionPower(2);
        this.useAutoSlots();
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Pulses adject observers when timer hits zero.");
        lore.add("- Timer is based on input slots.");
        lore.add("- Each item is 1 second to the timer.");
        lore.add("- Minimum time is 1 second.");
        lore.add("- This only works when chunks are loaded.");
        return lore;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.CLOCK, 0.5);
    }

    @Override
    public void cleanup() {
        if (this.item != null) {
            this.item.remove();
        }
    }

    @Override
    public void action() {
        if (this.isPowered()) {
            this.updateUI();
            if (this.getOutputSlot() == -1) {
                this.setFailReason(" No output space");
                return;
            }
            if (this.timer > 0) {
                --this.timer;
            }
            if (this.timer == 0) {
                ArrayList<Block> nearby = new ArrayList<Block>();
                nearby.add(this.getLocation().getBlock().getRelative(BlockFace.NORTH));
                nearby.add(this.getLocation().getBlock().getRelative(BlockFace.SOUTH));
                nearby.add(this.getLocation().getBlock().getRelative(BlockFace.EAST));
                nearby.add(this.getLocation().getBlock().getRelative(BlockFace.WEST));
                for (final Block block : nearby) {
                    if (!(block.getBlockData() instanceof Powerable) || !block.getType().equals((Object)Material.OBSERVER)) continue;
                    final Powerable wire = (Powerable)block.getBlockData();
                    wire.setPowered(true);
                    block.setBlockData((BlockData)wire);
                    Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                        @Override
                        public void run() {
                            wire.setPowered(false);
                            block.setBlockData((BlockData)wire);
                        }
                    }, 10L);
                    this.setConsumingPower(true);
                }
                this.timer = -1;
            } else if (this.timer == -1) {
                this.setFailReason(" On Timer..");
            }
            if (this.timer == -1) {
                boolean playSound = false;
                Sound sound = Sound.BLOCK_FIRE_AMBIENT;
                if (TUMaths.isPlayerNearby(this.getLocation(), MineMain.chunkViewDistance)) {
                    ArrayList<ItemStack> stacks = this.getInputItems();
                    if (stacks.size() > 0) {
                        int seconds = 0;
                        for (ItemStack stack : stacks) {
                            seconds += stack.getAmount();
                        }
                        this.timer = seconds;
                    } else {
                        this.setFailReason(" No timer, add item(s).");
                    }
                }
                if (playSound && TUMaths.isPlayerNearby(this.getLocation(), MineMain.nearDistance)) {
                    this.getLocation().getWorld().playSound(this.getLocation(), sound, 1.0f, 1.0f);
                }
            }
        }
    }

    @Override
    public ArrayList<String> extraInfoLore() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(String.valueOf(ChatColor.GOLD) + " Timer: " + String.valueOf(ChatColor.WHITE) + this.timer);
        return lore;
    }
}

