/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Manufactoring;

import com.MT.triggersUtility.TUInterface.TUIComponent;
import com.MT.triggersUtility.TUInterface.TUInterfaceScrolling;
import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Liquids.LiquidUtil;
import com.MT.xxxtrigger50xxx.Devices.Liquids.Pipe;
import com.MT.xxxtrigger50xxx.Devices.Liquids.PipeLine;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;

public class OilRefinery
extends Device {
    private static final long serialVersionUID = 7571974070728037015L;
    private String recipe = "Oil Cracking";
    private static ItemStack coal = new ItemStack(Material.COAL);
    private static ItemStack charcoal = new ItemStack(Material.CHARCOAL);
    private transient HashSet<Device> connectedDeviceCache = null;

    public OilRefinery(Location loc) {
        super(loc);
        this.setMaterial("LOOM");
        this.deviceName = "Oil Refinery";
        this.setActionTimer(1);
        this.setGridRange(5);
        this.setUseUI(true);
        this.setRefreshInv(false);
        this.setIdlePower(3);
        this.setActionPower(5);
        this.useAutoSlots();
        this.setStoreForm(false);
        this.addLiquidType(Device.LiquidType.WATER, 1000);
        this.addLiquidType(Device.LiquidType.OIL, 1000);
        this.addLiquidType(Device.LiquidType.HEAVYOIL, 1000);
        this.addLiquidType(Device.LiquidType.LIGHTOIL, 1000);
        this.addLiquidType(Device.LiquidType.PETROL, 1000);
        this.addLiquidType(Device.LiquidType.LUBRICANT, 1000);
        this.addLiquidType(Device.LiquidType.SULFURIC_ACID, 1000);
        this.setPollutionGen(30);
        this.displayRotationOffset = 90;
        this.updateDeviceHeadItem();
    }

    @Override
    public int getGridScore() {
        return 3;
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Used to convert liquids into other liquids.");
        return lore;
    }

    public String getRecipeName() {
        return this.recipe;
    }

    @Override
    public void updateUI() {
        int i = 9;
        while (i <= 17) {
            this.getInventory().setItem(i, MainMenu.createGoldPane());
            ++i;
        }
        int connections = 0;
        if (this.getGrid() != null) {
            connections = this.getGrid().gridSize();
        }
        ArrayList<String> lore = TUItems.basicLore(MineUtil.colon(" Grid Connections", "" + connections));
        Device.LiquidType inputType = this.getInputLiquid();
        String input = "OIL";
        String recipeType = "Oil Cracking";
        if (inputType != null) {
            input = inputType.toString();
        }
        boolean needsWater = false;
        if ((inputType == null || inputType != null && inputType.equals((Object)Device.LiquidType.OIL)) && !this.getRecipeName().equals("Basic Oil Cracking")) {
            lore.add(MineUtil.colon(" Oil", String.valueOf(this.getStoredLiquid(Device.LiquidType.OIL))));
            lore.add(MineUtil.colon(" Heavy Oil", String.valueOf(this.getStoredLiquid(Device.LiquidType.HEAVYOIL))));
            lore.add(MineUtil.colon(" Light Oil", String.valueOf(this.getStoredLiquid(Device.LiquidType.LIGHTOIL))));
            lore.add(MineUtil.colon(" Petroleum", String.valueOf(this.getStoredLiquid(Device.LiquidType.PETROL))));
        }
        if (this.getRecipeName().equals("Basic Oil Cracking")) {
            recipeType = "Basic Oil Cracking";
            lore.add(MineUtil.colon(" Oil", String.valueOf(this.getStoredLiquid(Device.LiquidType.OIL))));
            lore.add(MineUtil.colon(" Petroleum", String.valueOf(this.getStoredLiquid(Device.LiquidType.PETROL))));
        }
        if (this.getRecipeName().equals("Heavy Oil Cracking")) {
            needsWater = true;
            recipeType = "Heavy Oil Cracking";
            lore.add(MineUtil.colon(" Water", String.valueOf(this.getStoredLiquid(Device.LiquidType.WATER))));
            lore.add(MineUtil.colon(" Heavy Oil", String.valueOf(this.getStoredLiquid(Device.LiquidType.HEAVYOIL))));
            lore.add(MineUtil.colon(" Light Oil", String.valueOf(this.getStoredLiquid(Device.LiquidType.LIGHTOIL))));
        }
        if (this.getRecipeName().equals("Light Oil Cracking")) {
            needsWater = true;
            recipeType = "Light Oil Cracking";
            lore.add(MineUtil.colon(" Water", String.valueOf(this.getStoredLiquid(Device.LiquidType.WATER))));
            lore.add(MineUtil.colon(" Light Oil", String.valueOf(this.getStoredLiquid(Device.LiquidType.LIGHTOIL))));
            lore.add(MineUtil.colon(" Petroleum", String.valueOf(this.getStoredLiquid(Device.LiquidType.PETROL))));
        }
        if (this.getRecipeName().equals("Lubricant")) {
            recipeType = "Lubricant";
            lore.add(MineUtil.colon(" Heavy Oil", String.valueOf(this.getStoredLiquid(Device.LiquidType.HEAVYOIL))));
            lore.add(MineUtil.colon(" Lubricant", String.valueOf(this.getStoredLiquid(Device.LiquidType.LUBRICANT))));
        }
        if (this.getRecipeName().equals("Sulfuric Acid")) {
            recipeType = "Sulfuric Acid";
            lore.add(MineUtil.colon(" Water", String.valueOf(this.getStoredLiquid(Device.LiquidType.WATER))));
            lore.add(MineUtil.colon(" Sulfuric Acid", String.valueOf(this.getStoredLiquid(Device.LiquidType.SULFURIC_ACID))));
        }
        if (this.getRecipeName().equals("Coal Liquefaction")) {
            recipeType = "Coal Liquefaction";
            lore.add(MineUtil.colon(" Water", String.valueOf(this.getStoredLiquid(Device.LiquidType.WATER))));
            lore.add(MineUtil.colon(" Oil", String.valueOf(this.getStoredLiquid(Device.LiquidType.OIL))));
        }
        lore.add(MineUtil.colon(" Input Liquid", input));
        if (needsWater) {
            lore.add(MineUtil.colon(" Input Liquid 2", "Water"));
        }
        lore.add(MineUtil.colon(" Recipe", recipeType));
        if (!this.getFailReason().equals("None")) {
            lore.add(String.valueOf(ChatColor.RED) + " - " + this.getFailReason());
        }
        ItemStack stack = TUItems.setModelData(TUItems.createItem(Material.REDSTONE_LAMP, String.valueOf(MineItems.whiteBold()) + "Device Information", lore), 9523);
        this.getInventory().setItem(13, stack);
    }

    @Override
    public void onUIClick(InventoryClickEvent event) {
        this.openRecipeSelector((Player)event.getWhoClicked());
        ((Player)event.getWhoClicked()).playSound((Entity)((Player)event.getWhoClicked()), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
    }

    @Override
    public void action() {
        for (Block block : TUMaths.getNearbyBlocks6Sided(this.getLocation().getBlock())) {
            PipeLine.pipeLineCheck(block);
        }
        if (this.isPowered()) {
            boolean failed = false;
            boolean playSound = false;
            boolean playerNear = TUMaths.isPlayerNearby(this.getLocation(), MineMain.farDistance);
            if (this.getGrid().hasPower(this.getActionPower())) {
                boolean consume = false;
                String craftingRecipeName = this.getRecipeName();
                if (craftingRecipeName == null) {
                    craftingRecipeName = "Oil Cracking";
                }
                if (craftingRecipeName.equals("Oil Cracking")) {
                    if (this.getStoredLiquid(Device.LiquidType.OIL) >= 10) {
                        if (this.getStoredLiquid(Device.LiquidType.LIGHTOIL) < 990 && this.getStoredLiquid(Device.LiquidType.HEAVYOIL) < 990 && this.getStoredLiquid(Device.LiquidType.PETROL) < 990) {
                            this.setStoredLiquid(Device.LiquidType.OIL, this.getStoredLiquid(Device.LiquidType.OIL) - 10);
                            this.setStoredLiquid(Device.LiquidType.PETROL, this.getStoredLiquid(Device.LiquidType.PETROL) + 10);
                            this.setStoredLiquid(Device.LiquidType.HEAVYOIL, this.getStoredLiquid(Device.LiquidType.HEAVYOIL) + 10);
                            this.setStoredLiquid(Device.LiquidType.LIGHTOIL, this.getStoredLiquid(Device.LiquidType.LIGHTOIL) + 10);
                            this.getGrid().logLiquid(Device.LiquidType.OIL, -10);
                            this.getGrid().logLiquid(Device.LiquidType.PETROL, 10);
                            this.getGrid().logLiquid(Device.LiquidType.HEAVYOIL, 10);
                            this.getGrid().logLiquid(Device.LiquidType.LIGHTOIL, 10);
                            consume = true;
                        } else {
                            if (this.getStoredLiquid(Device.LiquidType.PETROL) < 990) {
                                this.setFailReason("No space for petrol output.");
                            }
                            if (this.getStoredLiquid(Device.LiquidType.HEAVYOIL) < 990) {
                                this.setFailReason("No space for heavy oil output.");
                            }
                            if (this.getStoredLiquid(Device.LiquidType.LIGHTOIL) < 990) {
                                this.setFailReason("No space for light oil output.");
                            }
                            failed = true;
                        }
                    } else {
                        this.setFailReason("Need 10 Oil");
                        failed = true;
                    }
                }
                if (craftingRecipeName.equals("Lubricant")) {
                    if (this.getStoredLiquid(Device.LiquidType.HEAVYOIL) >= 10) {
                        if (this.getStoredLiquid(Device.LiquidType.LUBRICANT) <= 990) {
                            this.setStoredLiquid(Device.LiquidType.HEAVYOIL, this.getStoredLiquid(Device.LiquidType.HEAVYOIL) - 10);
                            this.setStoredLiquid(Device.LiquidType.LUBRICANT, this.getStoredLiquid(Device.LiquidType.LUBRICANT) + 10);
                            this.getGrid().logLiquid(Device.LiquidType.LUBRICANT, 10);
                            this.getGrid().logLiquid(Device.LiquidType.HEAVYOIL, -10);
                            consume = true;
                        } else {
                            this.setFailReason("No space for lubricant output.");
                            failed = true;
                        }
                    } else {
                        this.setFailReason("Need 10 heavy oil");
                        failed = true;
                    }
                }
                if (craftingRecipeName.equals("Basic Oil Cracking")) {
                    if (this.getStoredLiquid(Device.LiquidType.OIL) >= 10) {
                        if (this.getStoredLiquid(Device.LiquidType.PETROL) <= 980) {
                            this.setStoredLiquid(Device.LiquidType.OIL, this.getStoredLiquid(Device.LiquidType.OIL) - 10);
                            this.setStoredLiquid(Device.LiquidType.PETROL, this.getStoredLiquid(Device.LiquidType.PETROL) + 20);
                            this.getGrid().logLiquid(Device.LiquidType.PETROL, 20);
                            this.getGrid().logLiquid(Device.LiquidType.OIL, -10);
                            consume = true;
                        } else {
                            this.setFailReason("No space for light oil output.");
                            failed = true;
                        }
                    } else {
                        this.setFailReason("Need 10 Oil");
                        failed = true;
                    }
                }
                if (craftingRecipeName.equals("Heavy Oil Cracking")) {
                    if (this.getStoredLiquid(Device.LiquidType.WATER) >= 10) {
                        if (this.getStoredLiquid(Device.LiquidType.HEAVYOIL) >= 10) {
                            if (this.getStoredLiquid(Device.LiquidType.LIGHTOIL) <= 980) {
                                this.setStoredLiquid(Device.LiquidType.HEAVYOIL, this.getStoredLiquid(Device.LiquidType.HEAVYOIL) - 10);
                                this.setStoredLiquid(Device.LiquidType.WATER, this.getStoredLiquid(Device.LiquidType.WATER) - 10);
                                this.setStoredLiquid(Device.LiquidType.LIGHTOIL, this.getStoredLiquid(Device.LiquidType.LIGHTOIL) + 20);
                                this.getGrid().logLiquid(Device.LiquidType.HEAVYOIL, -10);
                                this.getGrid().logLiquid(Device.LiquidType.WATER, -10);
                                this.getGrid().logLiquid(Device.LiquidType.LIGHTOIL, 20);
                                consume = true;
                            } else {
                                this.setFailReason("No space for light oil output.");
                                failed = true;
                            }
                        } else {
                            this.setFailReason("Need 10 heavy oil");
                            failed = true;
                        }
                    } else {
                        this.setFailReason("Need 10 Water");
                        failed = true;
                    }
                }
                if (craftingRecipeName.equals("Light Oil Cracking")) {
                    if (this.getStoredLiquid(Device.LiquidType.WATER) >= 10) {
                        if (this.getStoredLiquid(Device.LiquidType.LIGHTOIL) >= 10) {
                            if (this.getStoredLiquid(Device.LiquidType.PETROL) <= 900) {
                                this.setStoredLiquid(Device.LiquidType.LIGHTOIL, this.getStoredLiquid(Device.LiquidType.LIGHTOIL) - 10);
                                this.setStoredLiquid(Device.LiquidType.WATER, this.getStoredLiquid(Device.LiquidType.WATER) - 10);
                                this.setStoredLiquid(Device.LiquidType.PETROL, this.getStoredLiquid(Device.LiquidType.PETROL) + 10);
                                this.getGrid().logLiquid(Device.LiquidType.LIGHTOIL, -10);
                                this.getGrid().logLiquid(Device.LiquidType.WATER, -10);
                                this.getGrid().logLiquid(Device.LiquidType.PETROL, 20);
                                consume = true;
                            } else {
                                this.setFailReason("No space for petrol output.");
                                failed = true;
                            }
                        } else {
                            this.setFailReason("Need 10 light oil");
                            failed = true;
                        }
                    } else {
                        this.setFailReason("Need 10 Water");
                        failed = true;
                    }
                }
                if (craftingRecipeName.equals("Sulfuric Acid")) {
                    if (this.getStoredLiquid(Device.LiquidType.WATER) >= 10) {
                        if (this.getStoredLiquid(Device.LiquidType.SULFURIC_ACID) <= 900) {
                            ItemStack sulfurStack = null;
                            ItemStack ironPlateStack = null;
                            for (ItemStack item : this.getInputItems()) {
                                if (sulfurStack == null && MineItems.getIndustrialItem("Sulfur").isSimilar(item)) {
                                    sulfurStack = item;
                                }
                                if (ironPlateStack == null && MineItems.getIndustrialItem("Iron Plate").isSimilar(item)) {
                                    ironPlateStack = item;
                                }
                                if (sulfurStack != null && ironPlateStack != null) break;
                            }
                            if (sulfurStack == null) {
                                this.setFailReason("Need Sulfur");
                                failed = true;
                            }
                            if (ironPlateStack == null) {
                                this.setFailReason("Need Iron Plate");
                                failed = true;
                            }
                            if (sulfurStack != null && ironPlateStack != null) {
                                this.setStoredLiquid(Device.LiquidType.WATER, this.getStoredLiquid(Device.LiquidType.WATER) - 10);
                                sulfurStack.setAmount(sulfurStack.getAmount() - 1);
                                ironPlateStack.setAmount(ironPlateStack.getAmount() - 1);
                                this.setStoredLiquid(Device.LiquidType.SULFURIC_ACID, this.getStoredLiquid(Device.LiquidType.SULFURIC_ACID) + 100);
                                this.getGrid().logLiquid(Device.LiquidType.WATER, -10);
                                this.getGrid().logLiquid(Device.LiquidType.SULFURIC_ACID, 100);
                                consume = true;
                            }
                        } else {
                            this.setFailReason("No space for sulfuric acid output.");
                            failed = true;
                        }
                    } else {
                        this.setFailReason("Need 10 Water");
                        failed = true;
                    }
                }
                if (craftingRecipeName.equals("Coal Liquefaction")) {
                    if (this.getStoredLiquid(Device.LiquidType.WATER) >= 50) {
                        if (this.getStoredLiquid(Device.LiquidType.OIL) <= 200) {
                            ItemStack coalStack = null;
                            for (ItemStack item : this.getInputItems()) {
                                if (coalStack == null && (coal.isSimilar(item) || charcoal.isSimilar(item))) {
                                    coalStack = item;
                                }
                                if (coalStack != null) break;
                            }
                            if (coalStack == null) {
                                this.setFailReason("Need Coal / Charcoal");
                                failed = true;
                            }
                            if (coalStack != null) {
                                this.setStoredLiquid(Device.LiquidType.WATER, this.getStoredLiquid(Device.LiquidType.WATER) - 50);
                                coalStack.setAmount(coalStack.getAmount() - 1);
                                this.setStoredLiquid(Device.LiquidType.OIL, this.getStoredLiquid(Device.LiquidType.OIL) + 200);
                                consume = true;
                                this.getGrid().logLiquid(Device.LiquidType.WATER, -50);
                                this.getGrid().logLiquid(Device.LiquidType.OIL, 200);
                            }
                        } else {
                            this.setFailReason("No space for oil output.");
                            failed = true;
                        }
                    } else {
                        this.setFailReason("Need 50 Water");
                        failed = true;
                    }
                }
                HashSet<Device> devices = new HashSet<Device>();
                boolean liquidGiven = false;
                if (this.moveLiquid(Device.LiquidType.OIL, devices)) {
                    liquidGiven = true;
                }
                if (this.moveLiquid(Device.LiquidType.HEAVYOIL, devices)) {
                    liquidGiven = true;
                }
                if (this.moveLiquid(Device.LiquidType.LIGHTOIL, devices)) {
                    liquidGiven = true;
                }
                if (this.moveLiquid(Device.LiquidType.PETROL, devices)) {
                    liquidGiven = true;
                }
                if (this.moveLiquid(Device.LiquidType.LUBRICANT, devices)) {
                    liquidGiven = true;
                }
                if (this.moveLiquid(Device.LiquidType.SULFURIC_ACID, devices)) {
                    liquidGiven = true;
                }
                if (consume) {
                    this.getGrid().consumePower(this, this.getActionPower());
                    this.setConsumingPower(true);
                    playSound = true;
                }
                if (liquidGiven) {
                    for (Block block : TUMaths.getNearbyBlocks6Sided(this.getLocation().getBlock())) {
                        if (!Pipe.isPipe(block)) continue;
                        Pipe pipe = (Pipe)((MetadataValue)block.getMetadata("MT-Pipe").get(0)).value();
                        pipe.getLine().addLiquidType(Device.LiquidType.STEAM);
                        pipe.getLine().decorTickPipeLine();
                    }
                }
            } else {
                this.setFailReason("Not enough power for action.");
                failed = true;
            }
            if (playerNear) {
                if (playSound && TUMaths.isPlayerNearby(this.getLocation(), MineMain.closeDistance)) {
                    this.getLocation().getWorld().playSound(this.getLocation(), Sound.BLOCK_BUBBLE_COLUMN_UPWARDS_AMBIENT, 0.3f, 0.7f);
                }
                if (failed) {
                    this.spawnInactiveParticles();
                }
            }
        }
    }

    private boolean moveLiquid(Device.LiquidType type, HashSet<Device> devices) {
        if (this.getStoredLiquid(type) == 0) {
            return false;
        }
        if (TUMaths.isPlayerNearby(this.getLocation(), 64.0) || this.connectedDeviceCache == null) {
            this.connectedDeviceCache = LiquidUtil.getConnectedDevices(this.getLocation().getBlock(), type);
        }
        devices.clear();
        devices.addAll(this.connectedDeviceCache);
        for (Device device : new ArrayList<Device>(devices)) {
            OilRefinery or;
            if (!(device instanceof OilRefinery) || (or = (OilRefinery)device).getInputLiquid() == null || or.getInputLiquid().equals((Object)type)) continue;
            devices.remove(device);
        }
        boolean liquidGiven = false;
        if (devices.size() > 0) {
            int baseSteamEach = this.getStoredLiquid(type) / devices.size();
            for (Device device2 : devices) {
                boolean skip = false;
                if (device2.getStoredLiquid(type) >= device2.getMaxLiquid(type)) continue;
                int liquidNeeded = device2.getMaxLiquid(type) - device2.getStoredLiquid(type);
                if (liquidNeeded > baseSteamEach) {
                    device2.addLiquid(type, baseSteamEach);
                    this.setStoredLiquid(type, this.getStoredLiquid(type) - baseSteamEach);
                } else {
                    device2.addLiquid(type, liquidNeeded);
                    this.setStoredLiquid(type, this.getStoredLiquid(type) - liquidNeeded);
                }
                liquidGiven = true;
            }
        }
        return liquidGiven;
    }

    public Device.LiquidType getInputLiquid() {
        if (this.recipe == null || this.recipe.equals("Oil Cracking") || this.recipe.equals("Basic Oil Cracking")) {
            return Device.LiquidType.OIL;
        }
        if (this.recipe.equals("Heavy Oil Cracking")) {
            return Device.LiquidType.HEAVYOIL;
        }
        if (this.recipe.equals("Light Oil Cracking")) {
            return Device.LiquidType.LIGHTOIL;
        }
        if (this.recipe.equals("Lubricant")) {
            return Device.LiquidType.HEAVYOIL;
        }
        if (this.recipe.equals("Sulfuric Acid") || this.recipe.equals("Coal Liquefaction")) {
            return Device.LiquidType.WATER;
        }
        return null;
    }

    public void openRecipeSelector(Player player) {
        ItemStack pane = MainMenu.createGoldPane();
        ArrayList<String> oilRecipes = new ArrayList<String>();
        oilRecipes.add("Oil Cracking");
        oilRecipes.add("Basic Oil Cracking");
        oilRecipes.add("Heavy Oil Cracking");
        oilRecipes.add("Light Oil Cracking");
        oilRecipes.add("Lubricant");
        oilRecipes.add("Sulfuric Acid");
        oilRecipes.add("Coal Liquefaction");
        HashMap stacks = new HashMap();
        class LeaderScroller
        extends TUInterfaceScrolling {
            private final /* synthetic */ ArrayList val$oilRecipes;
            private final /* synthetic */ HashMap val$stacks;

            public LeaderScroller(String name, int rows, ArrayList arrayList, HashMap hashMap) {
                this.val$oilRecipes = arrayList;
                this.val$stacks = hashMap;
                super(name, rows);
            }

            @Override
            public ItemStack defineScrolling(int i) {
                if (this.val$oilRecipes.size() > i) {
                    String recipe = (String)this.val$oilRecipes.get(i);
                    ArrayList<String> lore = OilRefinery.this.recipeLore(recipe);
                    lore.add(MineUtil.colon("Left Click", "Select Recipe"));
                    ItemStack stack = TUItems.createItem(Material.WATER_BUCKET, MineItems.goldBold() + recipe, lore);
                    this.val$stacks.put(i, recipe);
                    return stack;
                }
                return null;
            }

            @Override
            public void scrollingActionClick(Player player, ItemStack item, InventoryClickEvent event) {
                if (this.val$stacks.containsKey(event.getSlot())) {
                    String recipe;
                    OilRefinery.this.recipe = recipe = (String)this.val$stacks.get(event.getSlot());
                    player.openInventory(OilRefinery.this.getInventory());
                    player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                }
            }
        }
        LeaderScroller face = new LeaderScroller(ChatColor.GOLD + ChatColor.BOLD + "Recipe Selector", 6, oilRecipes, stacks);
        face.addComponent(MineUtil.createInfoComponent(53, "You can select any recipe for an item you have unlocked otherwise if it's not unlocked it will appear as black concrete."));
        int i = 45;
        while (i <= 53) {
            if (i != 47 && i != 51 && i != 49 && i != 53) {
                face.addComponent(new TUIComponent(i, pane));
            }
            ++i;
        }
        ArrayList<Integer> scrollingSlots = new ArrayList<Integer>();
        int j = 0;
        while (j <= 44) {
            scrollingSlots.add(j);
            ++j;
        }
        face.setScrollingSlots(scrollingSlots);
        class LeftScroll
        extends TUIComponent {
            public LeftScroll(int slot, ItemStack linkStack) {
                super(slot, linkStack);
            }

            @Override
            public void onLeftClick(Player player) {
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            }
        }
        LeftScroll leftScroller = new LeftScroll(47, MineUtil.getLeftScollingStack());
        class RightScroll
        extends TUIComponent {
            public RightScroll(int slot, ItemStack linkStack) {
                super(slot, linkStack);
            }

            @Override
            public void onLeftClick(Player player) {
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            }
        }
        RightScroll rightScroller = new RightScroll(51, MineUtil.getRightScrollingStack());
        class ReturnButton
        extends TUIComponent {
            public ReturnButton(int slot, ItemStack linkStack) {
                super(slot, linkStack);
            }

            @Override
            public void onLeftClick(Player player) {
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                player.openInventory(OilRefinery.this.getInventory());
            }
        }
        ReturnButton returnButt = new ReturnButton(49, MainMenu.createReturnArrow());
        face.addComponent(returnButt);
        face.addComponent(leftScroller);
        face.addComponent(rightScroller);
        face.setLeftComp(leftScroller);
        face.setRightComp(rightScroller);
        face.updateScrolling();
        face.openInterface(player);
    }

    private ArrayList<String> recipeLore(String recipe) {
        ArrayList<String> lore = new ArrayList<String>();
        if (recipe.equals("Oil Cracking")) {
            lore.add(String.valueOf(ChatColor.RED) + "- 10 Oil");
            lore.add(String.valueOf(ChatColor.GREEN) + "+ 10 Petroleum");
            lore.add(String.valueOf(ChatColor.GREEN) + "+ 10 Heavy Oil");
            lore.add(String.valueOf(ChatColor.GREEN) + "+ 10 Light Oil");
        }
        if (recipe.equals("Basic Oil Cracking")) {
            lore.add(String.valueOf(ChatColor.RED) + "- 10 Oil");
            lore.add(String.valueOf(ChatColor.GREEN) + "+ 20 Petroleum");
        }
        if (recipe.equals("Heavy Oil Cracking")) {
            lore.add(String.valueOf(ChatColor.RED) + "- 10 Heavy Oil");
            lore.add(String.valueOf(ChatColor.RED) + "- 10 Water");
            lore.add(String.valueOf(ChatColor.GREEN) + "+ 20 Light Oil");
        }
        if (recipe.equals("Light Oil Cracking")) {
            lore.add(String.valueOf(ChatColor.RED) + "- 10 Light Oil");
            lore.add(String.valueOf(ChatColor.RED) + "- 10 Water");
            lore.add(String.valueOf(ChatColor.GREEN) + "+ 10 Petroleum");
        }
        if (recipe.equals("Lubricant")) {
            lore.add(String.valueOf(ChatColor.RED) + "- 10 Heavy Oil");
            lore.add(String.valueOf(ChatColor.GREEN) + "+ 10 Lubricant");
        }
        if (recipe.equals("Sulfuric Acid")) {
            lore.add(String.valueOf(ChatColor.RED) + "- 10 Water");
            lore.add(String.valueOf(ChatColor.RED) + "- 1 Sulfur");
            lore.add(String.valueOf(ChatColor.RED) + "- 1 Iron Plate");
            lore.add(String.valueOf(ChatColor.GREEN) + "+ 100 Sulfuric Acid");
        }
        if (recipe.equals("Coal Liquefaction")) {
            lore.add(String.valueOf(ChatColor.RED) + "- 50 Water");
            lore.add(String.valueOf(ChatColor.RED) + "- 1 Coal");
            lore.add(String.valueOf(ChatColor.GREEN) + "+ 200 Oil");
        }
        return lore;
    }
}

