/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Producers;

import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.inventory.ItemStack;

public class ExperienceSynthesizer
extends Device {
    private static final long serialVersionUID = 4211610198705429712L;
    private static String classSpacedNamed = "Experience Synthesizer";
    private double exp = 0.0;
    private double lastEXP = 0.0;

    public ExperienceSynthesizer(Location loc) {
        super(loc);
        this.setMaterial("PRISMARINE_BRICK_SLAB");
        this.deviceName = classSpacedNamed;
        this.setIdlePower(1);
        this.setActionTimer(1);
        this.setActionPower(10);
        this.setPollutionGen(2);
        this.setUseUI(true);
        this.useAutoSlots();
        this.useAutoUI();
    }

    @Override
    public int getGridScore() {
        return 4;
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(String.valueOf(MineItems.descColor) + "- Extracts experience from input items.");
        lore.add(String.valueOf(MineItems.descColor) + "- Uses glass bottles from inputs to make exp bottles.");
        return lore;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
    }

    @Override
    public ArrayList<String> extraInfoLore() {
        return TUItems.basicLore(MineUtil.colon(" Stored EXP", TUMaths.roundDouble(this.exp, 3) + "/7.1"), MineUtil.colon(" Last Extracted", "" + TUMaths.roundDouble(this.lastEXP, 3)));
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.EXPERIENCE_BOTTLE, 0.5);
    }

    @Override
    public void action() {
        if (this.isPowered() && this.getGrid().hasPower(this.getActionPower())) {
            boolean extracted = false;
            ItemStack glassBottle = null;
            for (ItemStack item : this.getInputItems()) {
                double gained;
                if (item.getType().equals((Object)Material.GLASS_BOTTLE)) {
                    glassBottle = item;
                    continue;
                }
                if (!(this.exp < 7.1)) continue;
                extracted = true;
                this.lastEXP = gained = ExperienceSynthesizer.getExperience(item);
                this.exp += this.lastEXP;
                item.setAmount(item.getAmount() - 1);
                if (!MinetorioListener.isPlayerNearbyOPT(this.getLocation(), 8.0)) break;
                this.getLocation().getWorld().playSound(this.getLocation(), Sound.BLOCK_ENCHANTMENT_TABLE_USE, 0.5f, 2.0f);
                break;
            }
            if (!extracted) {
                if (glassBottle != null) {
                    if (this.getOutputSlot() != -1) {
                        if (this.exp >= 7.1) {
                            this.exp -= 7.1;
                            glassBottle.setAmount(glassBottle.getAmount() - 1);
                            this.getInventory().setItem(this.getOutputSlot(), new ItemStack(Material.EXPERIENCE_BOTTLE));
                            if (MinetorioListener.isPlayerNearbyOPT(this.getLocation(), 8.0)) {
                                this.getLocation().getWorld().playSound(this.getLocation(), Sound.BLOCK_ENCHANTMENT_TABLE_USE, 0.5f, 1.8f);
                            }
                        } else {
                            this.setFailReason("Need at least 7.1 stored EXP");
                        }
                    } else {
                        this.setFailReason("No output slot");
                    }
                } else if (this.exp >= 7.1) {
                    this.setFailReason("Missing glass bottle");
                } else {
                    this.setFailReason("Nothing to extract");
                }
            }
        }
    }

    public static double getExperience(ItemStack stack) {
        if (!MineItems.isMinetorioItem(stack)) {
            Material material = stack.getType();
            if (material.equals((Object)Material.REDSTONE)) {
                return 0.1;
            }
            if (material.equals((Object)Material.LAPIS_LAZULI)) {
                return 0.25;
            }
            if (material.equals((Object)Material.AMETHYST_SHARD)) {
                return 1.0;
            }
            if (material.equals((Object)Material.SPIDER_EYE) || material.equals((Object)Material.ENDER_PEARL) || material.equals((Object)Material.BONE) || material.equals((Object)Material.ROTTEN_FLESH) || material.equals((Object)Material.SLIME_BALL) || material.equals((Object)Material.MAGMA_CREAM)) {
                return 0.2;
            }
        }
        return 0.01;
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, ExperienceSynthesizer.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.AUTOMATION, new ExperienceSynthesizer(null).getDeviceStack(), false);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(MineItems.getIndustrialItem("Electronic Circuit", 3));
        ings.add(new ItemStack(Material.LAPIS_BLOCK, 2));
        ings.add(new ItemStack(Material.REDSTONE_BLOCK));
        RecipeUtils.addDefaultRecipe(new ExperienceSynthesizer(null).getDeviceStack(), ings, MTRecipe.RecipeType.BASIC, true);
    }
}

