/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Spaceship;

import com.MT.triggersUtility.TUItems;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.inventory.ItemStack;

public class Observatory
extends Device {
    private static final long serialVersionUID = 5264544813018558811L;
    private static String classSpacedNamed = "Observatory";
    private int planetTicks = 0;

    public Observatory(Location loc) {
        super(loc);
        this.setMaterial("END_STONE_BRICK_SLAB");
        this.deviceName = classSpacedNamed;
        this.setActionTimer(1);
        this.setOpenable(true);
        this.setStoreForm(true);
        this.setIdlePower(1);
        this.setActionPower(10);
        this.setUseUI(true);
        this.useAutoSlots();
        this.useAutoUI();
        this.updateDeviceHeadItem();
        this.displayYawOffset = 90;
        this.lockRotation = true;
    }

    @Override
    public Location getDisplayLocation() {
        return this.getLocation().add(0.5, 0.502, 1.001);
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Produces space science packs.");
        lore.add("- Requires a spy glass to produce.");
        lore.add("- Very slow production on planets.");
        return lore;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
        ItemStack stack = this.createInfoIcon();
        if (!this.getLocationREADONLY().getWorld().getName().equals("MT_world_space")) {
            TUItems.addLore(stack, MineUtil.colon(" Progress", this.planetTicks + "%"));
        }
        this.getInventory().setItem(13, stack);
    }

    @Override
    public void action() {
        if (this.getGrid() == null) {
            return;
        }
        if (this.getOutputSlot() == -1) {
            this.setFailReason("Missing output slot");
            return;
        }
        ItemStack stack = this.getInputStack(new ItemStack(Material.SPYGLASS));
        if (stack != null) {
            boolean canProduce = false;
            if (!this.getLocationREADONLY().getWorld().getName().equals("MT_world_space")) {
                ++this.planetTicks;
                if (MinetorioListener.isPlayerNearbyOPT(this.getLocation(), 6.0)) {
                    this.getLocationREADONLY().getWorld().playSound(this.getLocationREADONLY(), Sound.ITEM_BOOK_PAGE_TURN, 0.5f, 2.0f);
                }
                if (this.planetTicks >= 100) {
                    canProduce = true;
                }
            } else {
                canProduce = true;
            }
            if (canProduce) {
                stack.setAmount(stack.getAmount() - 1);
                this.getInventory().setItem(this.getOutputSlot(), MineItems.getIndustrialItem("Space Science Pack"));
                if (MinetorioListener.isPlayerNearbyOPT(this.getLocation(), 6.0)) {
                    this.getLocationREADONLY().getWorld().playSound(this.getLocationREADONLY(), Sound.ITEM_BOOK_PAGE_TURN, 0.5f, 1.0f);
                }
            }
        } else {
            this.setFailReason("Missing spyglass");
            return;
        }
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, Observatory.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.MANUFACTORING, new Observatory(null).getDeviceStack(), false);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(MineItems.getIndustrialItem("Electronic Circuit", 2));
        ings.add(MineItems.getIndustrialItem("Steel Plate", 5));
        ings.add(MineItems.getIndustrialItem("Processing Unit"));
        RecipeUtils.addDefaultRecipe(new Observatory(null).getDeviceStack(), ings, MTRecipe.RecipeType.ADVANCED, true);
    }

    @Override
    public int getGridScore() {
        return 10;
    }
}

