/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Utility;

import com.MT.triggersUtility.ChatInput;
import com.MT.triggersUtility.TUInterface.TUInventory;
import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Utility.Exporter;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.LocaleUtil;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class Importer
extends Device {
    private static final long serialVersionUID = -3143549696045319402L;
    private static String classSpacedNamed = "Importer";
    private double funds;
    private double buyPrice;
    private String buyItem;
    private boolean infiniteFunds = false;
    public static HashSet<Importer> importers = new HashSet();
    public static int taxDistanceAmount = 1000;
    public static double flatTax = 0.02;

    public Importer(Location loc) {
        super(loc);
        this.setMaterial("FLETCHING_TABLE");
        this.deviceName = classSpacedNamed;
        this.setActionTimer(1);
        this.setGridRange(5);
        this.setUseUI(true);
        this.setRefreshInv(false);
        this.setIdlePower(1);
        this.setActionPower(5);
        ArrayList<Integer> inputs = new ArrayList<Integer>();
        int i = 27;
        while (i <= 53) {
            inputs.add(i);
            ++i;
        }
        ArrayList<Integer> click = new ArrayList<Integer>(inputs);
        click.add(15);
        this.setClickableSlots(click);
        this.setOutputSlots(inputs);
        this.setStoreForm(true);
        this.standardMoverBehavior = true;
        this.updateDeviceHeadItem();
    }

    @Override
    public ArrayList<String> stackDescription() {
        return new ArrayList<String>();
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.HOPPER, 1.0);
    }

    @Override
    public void postCreate(boolean first) {
        importers.add(this);
    }

    @Override
    public void cleanup() {
        importers.remove(this);
    }

    @Override
    public void updateUI() {
        int i = 0;
        while (i <= 8) {
            this.getInventory().setItem(i, MainMenu.createGoldPane());
            if (i + 9 != 11 && i + 9 != 13 && i + 9 != 15) {
                this.getInventory().setItem(i + 9, MainMenu.createGoldPane());
            }
            this.getInventory().setItem(i + 18, MainMenu.createGoldPane());
            ++i;
        }
        ItemStack stack = TUItems.createItem(Material.REDSTONE_LAMP, MineItems.whiteBold() + "Import Information");
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(MineUtil.colon(" Funds", "" + this.funds));
        lore.add(" ");
        lore.add(MineUtil.colon(" " + LocaleUtil.uiText("General_Left_Click"), "Collect Funds"));
        lore.add(MineUtil.colon(" " + LocaleUtil.uiText("General_Right_Click"), "Add Funds"));
        lore.add(" ");
        if (this.getInventory().getItem(15) == null) {
            lore.addAll(MineUtil.wrapText("Place the item you want to buy in the open slot to the right of this!", 45, ChatColor.RED, 1));
        } else {
            double lowest = -1.0;
            double average = 0.0;
            double taxAverage = 0.0;
            int total = 0;
            for (Exporter export : this.getExporters()) {
                if (lowest == -1.0) {
                    lowest = export.getPrice() + Importer.getTax(this, export);
                } else if (lowest > export.getPrice() + Importer.getTax(this, export)) {
                    lowest = export.getPrice() + Importer.getTax(this, export);
                }
                average += export.getPrice() + Importer.getTax(this, export);
                ++total;
                taxAverage += Importer.getTax(this, export);
            }
            average = TUMaths.roundDouble(average / (double)total, 2);
            taxAverage = TUMaths.roundDouble(taxAverage / (double)total, 2);
            if (lowest == -1.0) {
                lowest = 0.0;
            }
            lore.add(" " + MineItems.whiteBold() + "Market Information");
            lore.add(MineUtil.colon("  Lowest Price", "$" + lowest + String.valueOf(ChatColor.GRAY) + " (Tax Included)"));
            lore.add(MineUtil.colon("  Average Price", "$" + average + String.valueOf(ChatColor.GRAY) + " (Tax Included)"));
            lore.add(MineUtil.colon("  Average Tax", "$" + taxAverage));
            lore.add(MineUtil.colon("  Exporters", "" + total));
        }
        if (!this.getFailReason().equals("None")) {
            lore.add(" ");
            lore.add(" " + String.valueOf(ChatColor.RED) + this.getFailReason());
        }
        TUItems.addLore(stack, lore);
        this.getInventory().setItem(13, stack);
        ArrayList<String> setLore = new ArrayList<String>();
        setLore.add(MineUtil.colon(" Buy Price", "" + this.buyPrice));
        setLore.add(MineUtil.colon(" " + LocaleUtil.uiText("General_Left_Click"), "Set Price"));
        setLore.add(" ");
        setLore.addAll(MineUtil.wrapText("The buy price is the max you will pay for an item. The price of the item is set by the exporter, however there is a tax for the distance. The longer the distance the greater the tax. The buyer pays the tax, however the buyer will buy the lowest offer first.", 45, ChatColor.WHITE, 1));
        ItemStack settings = TUItems.createItem(Material.COMPARATOR, MineItems.whiteBold() + "Buy Settings", setLore);
        this.getInventory().setItem(11, settings);
    }

    @Override
    public void action() {
        if (this.getGrid() != null && this.getGrid().hasPower(this.getActionPower())) {
            if (this.getOutputSlot() == -1) {
                this.setFailReason("No Output Space");
                return;
            }
            if (this.getFunds() == 0.0) {
                this.setFailReason("No funds available");
                return;
            }
            if (this.getTargetItem() == null) {
                this.setFailReason("No set item");
                return;
            }
            ArrayList<Exporter> valid = new ArrayList<Exporter>();
            for (Exporter exporter : this.getExporters()) {
                if (exporter.getPrice() + Importer.getTax(this, exporter) > this.getBuyPrice() || exporter.getPrice() + Importer.getTax(this, exporter) > this.getFunds()) continue;
                valid.add(exporter);
            }
            if (valid.size() > 0) {
                Collections.shuffle(valid);
                Exporter lowest = null;
                for (Exporter exp : valid) {
                    if (lowest == null) {
                        lowest = exp;
                        continue;
                    }
                    if (!(lowest.getPrice() + Importer.getTax(this, lowest) > exp.getPrice() + Importer.getTax(this, exp))) continue;
                    lowest = exp;
                }
                int i = 0;
                while (i <= 1) {
                    Exporter exporter = lowest;
                    ItemStack exportStack = exporter.getInputStack(this.getTargetItem());
                    if (!(exporter.getPrice() + Importer.getTax(this, exporter) > this.getFunds())) {
                        if (exportStack == null) break;
                        ItemStack stack = exportStack.clone();
                        stack.setAmount(1);
                        exportStack.setAmount(exportStack.getAmount() - 1);
                        if (!exporter.infiniteFunds) {
                            exporter.setFunds(TUMaths.roundDouble(exporter.getFunds() + exporter.getPrice(), 2));
                        }
                        if (!this.infiniteFunds) {
                            this.setFunds(TUMaths.roundDouble(this.getFunds() - (exporter.getPrice() + Importer.getTax(this, exporter)), 2));
                        }
                        this.getInventory().setItem(this.getOutputSlot(), stack);
                    }
                    ++i;
                }
            } else {
                this.setFailReason("No eligible exporters");
            }
        } else {
            this.setFailReason("Not Enough Power");
        }
    }

    public static double getTaxPercent(Importer importer, Exporter exporter) {
        int distance = TUMaths.get2DManhattanDistance(exporter.getLocationREADONLY(), importer.getLocationREADONLY());
        double distanceTax = (double)distance * 1.0 / (double)taxDistanceAmount;
        distanceTax = TUMaths.roundDouble(distanceTax * 0.01, 2);
        double totalTaxPCT = flatTax + distanceTax;
        return totalTaxPCT;
    }

    public static double getTax(Importer importer, Exporter exporter) {
        return TUMaths.roundDouble(exporter.getPrice() * Importer.getTaxPercent(importer, exporter), 2);
    }

    private ArrayList<Exporter> getExporters() {
        ArrayList<Exporter> exporters = new ArrayList<Exporter>();
        for (Exporter exporter : Exporter.exporters) {
            if (!exporter.getLocationREADONLY().getWorld().equals(this.getLocationREADONLY().getWorld()) || exporter.getPlacerUUID() == this.getPlacerUUID() || exporter.getInputStack(this.getTargetItem()) == null || exporter.getPrice() == 0.0) continue;
            exporters.add(exporter);
        }
        return exporters;
    }

    public ItemStack getTargetItem() {
        return this.getInventory().getItem(15);
    }

    @Override
    public void recreateInv() {
        this.inv = TUInventory.createInventory(MineItems.uiTitle() + this.deviceName, 6, this.deviceName);
    }

    @Override
    public void onUIClick(InventoryClickEvent event) {
        com.MT.triggersUtility.ChatInput input;
        Player player = (Player)event.getWhoClicked();
        if (event.getSlot() == 13) {
            if (event.isLeftClick()) {
                if (this.funds > 0.0) {
                    MineMain.getEconomy().depositPlayer((OfflinePlayer)player, this.funds);
                    MineUtil.sendMessage(player, LocaleUtil.messageText("Importer_Collect").replace("%funds%", "" + this.funds));
                    this.funds = 0.0;
                }
                return;
            }
            if (event.isRightClick()) {
                class ChatInput
                extends com.MT.triggersUtility.ChatInput {
                    private final /* synthetic */ Player val$player;

                    public ChatInput(String startMessage, boolean numbersonly, Player player) {
                        this.val$player = player;
                        super(startMessage, numbersonly);
                        this.setIgnorePeriod(true);
                    }

                    @Override
                    public void inputAction(String message) {
                        double amount = Double.valueOf(message);
                        amount = TUMaths.roundDouble(amount, 2);
                        if (MineMain.getEconomy().getBalance((OfflinePlayer)this.val$player) >= amount) {
                            MineMain.getEconomy().withdrawPlayer((OfflinePlayer)this.val$player, amount);
                            MineUtil.sendMessage(this.val$player, LocaleUtil.messageText("Importer_Added").replace("%amount%", "" + amount));
                            Importer.this.funds += amount;
                        } else {
                            MineUtil.sendWarning(this.val$player, LocaleUtil.messageText("Importer_No_Money"));
                        }
                        Importer.this.updateUI();
                        this.val$player.openInventory(Importer.this.getInventory());
                    }
                }
                input = new ChatInput("Enter the amount you would like to deposit now!", false, player);
                input.start(player);
            }
            player.closeInventory();
        }
        if (event.getSlot() == 11) {
            if (event.isLeftClick()) {
                class ChatInput
                extends com.MT.triggersUtility.ChatInput {
                    private final /* synthetic */ Player val$player;

                    public ChatInput(String startMessage, boolean numbersonly, Player player) {
                        this.val$player = player;
                        super(startMessage, numbersonly);
                        this.setIgnorePeriod(true);
                    }

                    @Override
                    public void inputAction(String message) {
                        double amount = Double.valueOf(message);
                        Importer.this.buyPrice = amount = TUMaths.roundDouble(amount, 2);
                        MineUtil.sendMessage(this.val$player, LocaleUtil.messageText("Importer_Price_Updated").replace("%amount%", "" + amount));
                        Importer.this.updateUI();
                        this.val$player.openInventory(Importer.this.getInventory());
                    }
                }
                input = new ChatInput(LocaleUtil.messageText("Importer_Input_Message"), false, player);
                input.start(player);
            }
            player.closeInventory();
        }
    }

    @Override
    public boolean onWireRightClick(PlayerInteractEvent event) {
        if (!event.getPlayer().isOp()) {
            return false;
        }
        this.infiniteFunds = !this.infiniteFunds;
        MineUtil.sendMessage(event.getPlayer(), "Infinite Funds " + this.infiniteFunds);
        return true;
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, Importer.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.LOGISTICS, new Importer(null).getDeviceStack(), false);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(MineItems.getIndustrialItem("Iron Plate", 3));
        ings.add(MineItems.getIndustrialItem("Electronic Circuit", 3));
        RecipeUtils.addDefaultRecipe(new Importer(null).getDeviceStack(), ings, MTRecipe.RecipeType.BASIC, false);
    }

    public double getFunds() {
        return this.funds;
    }

    public void setFunds(double funds) {
        this.funds = funds;
    }

    public double getBuyPrice() {
        return this.buyPrice;
    }

    public void setBuyPrice(double buyPrice) {
        this.buyPrice = buyPrice;
    }

    public String getBuyItem() {
        return this.buyItem;
    }

    public void setBuyItem(String buyItem) {
        this.buyItem = buyItem;
    }
}

