/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Utility;

import com.MT.triggersUtility.Saveable;
import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Battery2;
import com.MT.xxxtrigger50xxx.Devices.Generators.GeothermalGenerator;
import com.MT.xxxtrigger50xxx.Devices.Generators.SolarPanel;
import com.MT.xxxtrigger50xxx.Devices.Generators.TidalGenerator;
import com.MT.xxxtrigger50xxx.Devices.Generators.WindTurbine;
import com.MT.xxxtrigger50xxx.Devices.Liquids.Boiler;
import com.MT.xxxtrigger50xxx.Devices.Manufactoring.AdvancedAssembler;
import com.MT.xxxtrigger50xxx.Devices.Manufactoring.BasicAssembler;
import com.MT.xxxtrigger50xxx.Devices.Manufactoring.Crafter2;
import com.MT.xxxtrigger50xxx.Devices.Manufactoring.OilRefinery;
import com.MT.xxxtrigger50xxx.Devices.PowerPylon;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.Technology.ResearchLab;
import java.util.ArrayList;
import java.util.HashSet;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;

public class TradeBeaconRecipe
extends Saveable {
    public static ArrayList<TradeBeaconRecipe> tradesBeaconRecipes = new ArrayList();
    private static final long serialVersionUID = -8805417880387931915L;
    private String recipeName;
    private String techNeeded;
    private int minScore = 0;
    private int minTrades = 0;
    private int maxTrades = 0;
    private String ing1;
    private String ing2;
    private String result;
    private ShipType type;

    public TradeBeaconRecipe(String recipeName, String tech, int minScore, ItemStack stack1, ItemStack stack2, ItemStack result, ShipType type, int minTrades, int maxTrades) {
        super("Trade Beacon Recipes", recipeName);
        this.recipeName = recipeName;
        if (stack1 != null) {
            this.ing1 = TUItems.createStackString(stack1);
        }
        if (stack2 != null) {
            this.ing2 = TUItems.createStackString(stack2);
        }
        this.result = TUItems.createStackString(result);
        this.minScore = minScore;
        this.type = type;
        this.minTrades = minTrades;
        this.maxTrades = maxTrades;
        this.techNeeded = tech;
        tradesBeaconRecipes.add(this);
        this.save();
    }

    @Override
    public void onCreate(boolean isFirstTime) {
        if (!tradesBeaconRecipes.contains(this)) {
            tradesBeaconRecipes.add(this);
        }
    }

    public MerchantRecipe getRecipe() {
        MerchantRecipe recipe = new MerchantRecipe(TUItems.createStackFromString(this.result), TUMaths.rollRange(this.minTrades, this.maxTrades));
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        if (this.ing1 != null) {
            ings.add(TUItems.createStackFromString(this.ing1));
        }
        if (this.ing2 != null) {
            ings.add(TUItems.createStackFromString(this.ing2));
        }
        recipe.setIngredients(ings);
        return recipe;
    }

    public String getRecipeName() {
        return this.recipeName;
    }

    public ShipType getShipType() {
        return this.type;
    }

    public int getMinScore() {
        return this.minScore;
    }

    public String getTechNeeded() {
        return this.techNeeded;
    }

    public static void populateDefaultTradeRecipes() {
        ItemStack spaceJerky = TUItems.createItem(Material.COOKED_RABBIT, String.valueOf(ChatColor.WHITE) + "Space Jerky");
        spaceJerky.setAmount(4);
        ItemStack goldBar = new ItemStack(Material.GOLD_INGOT);
        ItemStack automationScience = MineItems.getIndustrialItem("Automation Science Pack");
        ItemStack logiScience = MineItems.getIndustrialItem("Logistic Science Pack");
        TradeBeaconRecipe.populateDefaultRecipe("A. Jerky Trade", 0, goldBar, null, spaceJerky, ShipType.ANY, 1, 3);
        TradeBeaconRecipe.populateDefaultRecipe("In. Battery 4 Gold", 0, new ItemStack(Material.GOLD_INGOT, 4), null, new Battery2(null).getDeviceStack(), ShipType.INDUSTRIAL, 1, 3);
        TradeBeaconRecipe.populateDefaultRecipe("In. Pylon 4 Gold", 0, new ItemStack(Material.GOLD_INGOT, 3), null, new PowerPylon(null).getDeviceStack(), ShipType.INDUSTRIAL, 1, 3);
        TradeBeaconRecipe.populateDefaultRecipe("In. Solar 4 Gold", 0, new ItemStack(Material.GOLD_INGOT, 5), null, new SolarPanel(null).getDeviceStack(), ShipType.INDUSTRIAL, 1, 2);
        TradeBeaconRecipe.populateDefaultRecipe("In. Wind 4 Gold", 0, new ItemStack(Material.GOLD_INGOT, 5), null, new WindTurbine(null).getDeviceStack(), ShipType.INDUSTRIAL, 1, 2);
        TradeBeaconRecipe.populateDefaultRecipe("In. Tidal 4 Gold", 0, new ItemStack(Material.GOLD_INGOT, 5), null, new TidalGenerator(null).getDeviceStack(), ShipType.INDUSTRIAL, 1, 2);
        TradeBeaconRecipe.populateDefaultRecipe("In. Geo 4 Gold", 0, new ItemStack(Material.GOLD_INGOT, 5), null, new GeothermalGenerator(null).getDeviceStack(), ShipType.INDUSTRIAL, 1, 2);
        TradeBeaconRecipe.populateDefaultRecipe("In. Boiler 4 Gold", 50, new ItemStack(Material.GOLD_INGOT, 10), null, new Boiler(null).getDeviceStack(), ShipType.INDUSTRIAL, 1, 1);
        TradeBeaconRecipe.populateDefaultRecipe("In. Crafter 4 Gold", 20, new ItemStack(Material.GOLD_INGOT, 9), null, new Crafter2(null).getDeviceStack(), ShipType.INDUSTRIAL, 1, 2);
        TradeBeaconRecipe.populateDefaultRecipe("In. Basic 4 Gold", 20, new ItemStack(Material.GOLD_INGOT, 9), null, new BasicAssembler(null).getDeviceStack(), ShipType.INDUSTRIAL, 1, 2);
        TradeBeaconRecipe.populateDefaultRecipe("In. Advanced 4 Gold", 50, new ItemStack(Material.GOLD_INGOT, 16), null, new AdvancedAssembler(null).getDeviceStack(), ShipType.INDUSTRIAL, 1, 2);
        TradeBeaconRecipe.populateDefaultRecipe("In. Refinery 4 Gold", 75, new ItemStack(Material.GOLD_INGOT, 24), null, new OilRefinery(null).getDeviceStack(), ShipType.INDUSTRIAL, 1, 2);
        TradeBeaconRecipe.populateDefaultRecipe("Si. Research Lab", 0, automationScience, null, new ResearchLab(null).getDeviceStack(), ShipType.SCIENCE, 1, 2);
        TradeBeaconRecipe.populateDefaultRecipe("Si. Auto 4 Plates", 0, automationScience, null, MineItems.getIndustrialItem("Iron Plate", 4), ShipType.SCIENCE, 2, 4);
        TradeBeaconRecipe.populateDefaultRecipe("Si. Auto 4 C.Plates", 0, automationScience, null, MineItems.getIndustrialItem("Copper Plate", 4), ShipType.SCIENCE, 2, 4);
        TradeBeaconRecipe.populateDefaultRecipe("Si. Auto 4 Gear", 20, automationScience, null, MineItems.getIndustrialItem("Iron Gear Wheel", 4), ShipType.SCIENCE, 2, 4);
        TradeBeaconRecipe.populateDefaultRecipe("Si. Auto 4 Wire", 20, automationScience, null, MineItems.getIndustrialItem("Copper Cable", 4), ShipType.SCIENCE, 2, 4);
        TradeBeaconRecipe.populateDefaultRecipe("Si. Logi 4 Electronic", 20, logiScience, null, MineItems.getIndustrialItem("Electronic Circuit", 4), ShipType.SCIENCE, 1, 4);
        TradeBeaconRecipe.populateDefaultRecipe("Si. Logi 4 Steel", 75, logiScience, null, MineItems.getIndustrialItem("Steel Plate", 4), ShipType.SCIENCE, 1, 4);
        TradeBeaconRecipe.populateDefaultRecipe("Si. Logi 4 Advanced Circuit", 100, logiScience, null, MineItems.getIndustrialItem("Advanced Circuit", 3), ShipType.SCIENCE, 2, 4);
        TradeBeaconRecipe.populateDefaultRecipe("Si. Logi 4 Plastic Bar", 50, logiScience, null, MineItems.getIndustrialItem("Plastic Bar", 4), ShipType.SCIENCE, 2, 4);
        TradeBeaconRecipe.populateDefaultRecipe("Si. Bread 4 Automation", 0, new ItemStack(Material.BREAD), null, MineItems.getIndustrialItem("Automation Science Pack"), ShipType.SCIENCE, 2, 4);
        TradeBeaconRecipe.populateDefaultRecipe("Si. Mutton 4 Logi", 10, new ItemStack(Material.COOKED_MUTTON), null, MineItems.getIndustrialItem("Logistic Science Pack", 2), ShipType.SCIENCE, 2, 8);
        TradeBeaconRecipe.populateDefaultRecipe("Si. Book 4 Chemical", 100, new ItemStack(Material.BOOK), null, MineItems.getIndustrialItem("Chemical Science Pack", 2), ShipType.SCIENCE, 10, 20);
        TradeBeaconRecipe.populateDefaultRecipe("Si. Cake 4 Utility", 125, new ItemStack(Material.CAKE), null, MineItems.getIndustrialItem("Utility Science Pack", 2), ShipType.SCIENCE, 10, 20);
        TradeBeaconRecipe.populateDefaultRecipe("Mi. Cobble 4 Iron", 0, new ItemStack(Material.COBBLESTONE, 16), null, new ItemStack(Material.RAW_IRON, 2), ShipType.MINING, 16, 32);
        TradeBeaconRecipe.populateDefaultRecipe("Mi. Deepslate 4 Iron", 0, new ItemStack(Material.COBBLED_DEEPSLATE, 12), null, new ItemStack(Material.RAW_IRON, 3), ShipType.MINING, 16, 32);
        TradeBeaconRecipe.populateDefaultRecipe("Mi. Diorite 4 Iron", 0, new ItemStack(Material.DIORITE, 8), null, new ItemStack(Material.RAW_IRON, 2), ShipType.MINING, 16, 32);
        TradeBeaconRecipe.populateDefaultRecipe("Mi. Tuff 4 Copper", 10, new ItemStack(Material.TUFF, 8), null, new ItemStack(Material.RAW_COPPER, 2), ShipType.MINING, 16, 32);
        TradeBeaconRecipe.populateDefaultRecipe("Mi. Cobble 4 Copper", 10, new ItemStack(Material.COBBLESTONE, 16), null, new ItemStack(Material.RAW_COPPER, 3), ShipType.MINING, 16, 32);
        TradeBeaconRecipe.populateDefaultRecipe("Mi. Andesite 4 Copper", 10, new ItemStack(Material.ANDESITE, 8), null, new ItemStack(Material.RAW_COPPER, 2), ShipType.MINING, 16, 32);
        TradeBeaconRecipe.populateDefaultRecipe("Mi. Granite 4 Gold", 20, new ItemStack(Material.GRANITE, 16), null, new ItemStack(Material.RAW_GOLD), ShipType.MINING, 16, 32);
        TradeBeaconRecipe.populateDefaultRecipe("Mi. Calcite 4 Gold", 20, new ItemStack(Material.CALCITE, 8), null, new ItemStack(Material.RAW_GOLD), ShipType.MINING, 16, 32);
        TradeBeaconRecipe.populateDefaultRecipe("Mi. Gold 4 Andesite", 30, goldBar, null, new ItemStack(Material.ANDESITE, 16), ShipType.MINING, 2, 4);
        TradeBeaconRecipe.populateDefaultRecipe("Mi. Gold 4 Granite", 30, goldBar, null, new ItemStack(Material.GRANITE, 16), ShipType.MINING, 2, 4);
        TradeBeaconRecipe.populateDefaultRecipe("Mi. Gold 4 Diorite", 30, goldBar, null, new ItemStack(Material.DIORITE, 16), ShipType.MINING, 2, 4);
    }

    private static void populateDefaultRecipe(String recipeName, int minScore, ItemStack stack1, ItemStack stack2, ItemStack result, ShipType type, int minTrade, int maxTrade) {
        for (TradeBeaconRecipe tbr : new HashSet<TradeBeaconRecipe>(tradesBeaconRecipes)) {
            if (!tbr.getRecipeName().equals(recipeName)) continue;
            return;
        }
        new TradeBeaconRecipe(recipeName, null, minScore, stack1, stack2, result, type, minTrade, maxTrade);
    }

    public static ArrayList<TradeBeaconRecipe> getTradeRecipes() {
        return new ArrayList<TradeBeaconRecipe>(tradesBeaconRecipes);
    }

    public static ArrayList<TradeBeaconRecipe> getTradeRecipes(ShipType type) {
        ArrayList<TradeBeaconRecipe> trades = new ArrayList<TradeBeaconRecipe>();
        ArrayList<TradeBeaconRecipe> anyTrades = new ArrayList<TradeBeaconRecipe>();
        ArrayList<TradeBeaconRecipe> normalTrades = new ArrayList<TradeBeaconRecipe>();
        for (TradeBeaconRecipe tbr : new HashSet<TradeBeaconRecipe>(tradesBeaconRecipes)) {
            if (tbr.getShipType().equals((Object)type)) {
                normalTrades.add(tbr);
            }
            if (!tbr.getShipType().equals((Object)ShipType.ANY)) continue;
            anyTrades.add(tbr);
        }
        trades.addAll(anyTrades);
        trades.addAll(normalTrades);
        return trades;
    }

    public static enum ShipType {
        ANY,
        MINING,
        SCIENCE,
        INDUSTRIAL;

    }
}

