/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices;

import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import java.util.HashMap;
import java.util.HashSet;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.BlockInventoryHolder;
import org.bukkit.inventory.DoubleChestInventory;
import org.bukkit.inventory.Inventory;

public class VanillaDevice {
    private static HashMap<Location, VanillaDevice> vanillaDevices = new HashMap();
    private static HashSet<VanillaDevice> imposableDevcies = new HashSet();
    private Inventory inv;
    private Location location;
    private Location chest1;
    private Location chest2;
    private boolean isChest = false;
    private boolean stale = false;

    public static HashSet<VanillaDevice> getAllVanillaDevices() {
        return new HashSet<VanillaDevice>(vanillaDevices.values());
    }

    public static HashSet<VanillaDevice> getImposableVanillaDevices() {
        return new HashSet<VanillaDevice>(imposableDevcies);
    }

    public static boolean isVanillaDevice(Location location) {
        return vanillaDevices.containsKey(location);
    }

    public static void createVanillaDevice(BlockInventoryHolder bih) {
        if (!VanillaDevice.isVanillaDevice(bih.getBlock().getLocation())) {
            vanillaDevices.put(bih.getBlock().getLocation(), new VanillaDevice(bih));
        }
    }

    public static VanillaDevice getVanillaDevice(Location loc) {
        if (VanillaDevice.isVanillaDevice(loc)) {
            return vanillaDevices.get(loc);
        }
        BlockState state = loc.getBlock().getState();
        if (state instanceof BlockInventoryHolder) {
            VanillaDevice.createVanillaDevice((BlockInventoryHolder)state);
        }
        if (!VanillaDevice.isVanillaDevice(loc)) {
            new Exception("Vanilla device could not be created, send this to Methedex / Trigger " + String.valueOf(loc.getBlock().getType()) + " @" + TUMaths.locationString(loc)).printStackTrace();
        }
        return vanillaDevices.get(loc);
    }

    public VanillaDevice(BlockInventoryHolder bih) {
        this.createState(bih);
    }

    public void createState(BlockInventoryHolder bih) {
        this.removeVanillaDevice();
        this.location = bih.getBlock().getLocation();
        this.inv = bih.getInventory();
        this.chest1 = bih.getBlock().getLocation();
        this.isChest = false;
        this.stale = false;
        Inventory inventory = this.inv;
        if (inventory instanceof DoubleChestInventory) {
            DoubleChestInventory dci = (DoubleChestInventory)inventory;
            this.inv = dci;
            this.chest1 = dci.getLeftSide().getLocation();
            this.chest2 = dci.getRightSide().getLocation();
            vanillaDevices.put(this.chest1, this);
            vanillaDevices.put(this.chest2, this);
            this.isChest = true;
        } else {
            this.isChest = bih.getBlock().getType().equals((Object)Material.CHEST);
            vanillaDevices.put(bih.getBlock().getLocation(), this);
        }
        if (!this.isChest) {
            imposableDevcies.add(this);
        }
    }

    public void checkForImposition() {
        if (this.isChest) {
            return;
        }
        if (MinetorioListener.isPlayerNearbyOPT(this.getLocation(), MineMain.chunkViewDistance)) {
            if (this.stale) {
                this.imposeState((BlockInventoryHolder)this.getLocation().getBlock().getState());
            }
        } else {
            this.stale = true;
        }
    }

    public void imposeState(BlockInventoryHolder bih) {
        bih.getInventory().setContents(this.getInventory().getContents());
        this.createState(bih);
    }

    public Inventory getInventory() {
        return this.inv;
    }

    public void removeVanillaDevice() {
        vanillaDevices.remove(this.chest1);
        vanillaDevices.remove(this.chest2);
        vanillaDevices.remove(this.getLocation());
        imposableDevcies.remove(this);
    }

    public Location getLocation() {
        return this.location;
    }
}

